"
GciInterface is obsolete. 
New code should use GsExternalSession or GciTsExternalSession .

GciInterface is a Smalltalk representation for the functions defined
in $GEMSTONE/include/gci.hf .  Using GciInteface a session may
execute GCI functions in another session. 

The other session may be on the same repository or a 
different repository.  The other session is only valid
within the session which created the instance of GciInterface,
and while that instance remains in memory.

Beginning with Gs64 v3.0, instances of GciInterface automatically have
their other session closed when the instance is garbage collected or
when a persistent instance drops out of memory.

The lastResult instVar contains the result of the most recent 
message send or execution, and is set by a various primitives
and is cleared (i.e. set to _remoteNil) by logout and by errors.
The resultIsSpecial instVars is set by the same code which 
sets lastResult .

Operations other than message send or execute return the
receiver if successful, or nil if there was an error.

Constraints:
	sessionId: SmallInteger
	lastResult: Object
	resultIsSpecial: Boolean
	lastError: ErrorDescription
	trace: Boolean
	log: GsFile
	errorClass: Behavior

"
Class {
	#name : 'GciInterface',
	#superclass : 'Object',
	#instVars : [
		'sessionId',
		'lastResult',
		'resultIsSpecial',
		'lastError',
		'trace',
		'log',
		'errorClass'
	],
	#gs_options : [
		'instancesNonPersistent'
	],
	#gs_reservedoop : '118273',
	#category : nil
}

{ #category : 'Instance Creation' }
GciInterface class >> _basicNew [

"creates an instance registered with VM for finalization of cData"

<primitive: 674>
^ self _primitiveFailed: #_basicNew

]

{ #category : 'Prims' }
GciInterface class >> _objectForOop: oop [

"Return the object with the given oop.  If no object exists with this oop,
 return nil."

<primitive: 38>
self _primitiveFailed: #_objectForOop: args: { oop }

]

{ #category : 'Prims' }
GciInterface class >> _oopForObject: anObject [

"Return the oop for the given object."
^ anObject asOop

]

{ #category : 'Prims' }
GciInterface class >> _zeroArgPrim: opcode [

"Primitive dispatch.  Legal values are:
    42: GciInterface (C) | sessions
"

<primitive: 197>

^self _primitiveFailed: #_zeroArgPrim: args: { opcode }

]

{ #category : 'Instance Creation' }
GciInterface class >> basicNew [
"disallowed"

self shouldNotImplement: #basicNew

]

{ #category : 'Instance Creation' }
GciInterface class >> new [

"Create a new initialized instance."

^ self _basicNew initialize.

]

{ #category : 'Instance Creation' }
GciInterface class >> newFromId: id [

| result |

"Create a new initialized instance."

result := self _basicNew initialize.
result _sessionId: id.
^result

]

{ #category : 'Prims' }
GciInterface class >> sessions [

"Return an Array listing all of the active session ids"

^self _zeroArgPrim: 42

]

{ #category : 'Error Handling' }
GciInterface >> _errorLoginFailed [

"Raise an error because an attempt to login failed."

Error signal: 'login failed, ' , lastError message .

]

{ #category : 'Private' }
GciInterface >> _fourArgPrim: opcode with: arg1 with: arg2 with: arg3 with: arg4 [

"Primitive dispatch.  Legal values:
    1: GciInterface | continueWith:replaceTopOfStackWith:isSpecial:flags:
		(sets lastResult instVar)
    2: GciInterface | performTraverse:selector:args:buffer:  (sets lastResult instVar)
"

<primitive: 503>

^self _primitiveFailed: #_fourArgPrim:
      args: { opcode . arg1 . arg2 . arg3 . arg4 }

]

{ #category : 'Private' }
GciInterface >> _oneArgPrim: opcode with: arg [

"Primitive dispatch.  Legal values are:
    16: GciInterface | remoteExecute:   (sets lastResult instVar)
    17: GciInterface | resolveSymbol:
    18: GciInterface | moreTraversal:
    19: GciInterface | getFreeOops:
    20: GciInterface | nbEnd:          (sets lastResult instVar)
    21: GciInterface | clearStack:
    22: GciInterface | nbRemoteExecute:
    23: GciInterface | nbMoreTraversal:
    24: reserved
"

<primitive: 198>

"Error diagnostics"
opcode == 20
  ifTrue: [ "errors in nbEnd:"
    (arg _isInteger)
	ifFalse: [ arg _errorExpectedClass: Integer].
    (arg ~~ 1 and: [arg ~~ 2])
	ifTrue:[arg _error: #rtErrArgOutOfRange args: #(1 2)].
    ].

^self _primitiveFailed: #_oneArgPrim: args: { opcode . arg }

]

{ #category : 'Private' }
GciInterface >> _sessionId: id [

"Set the session id"

sessionId := id

]

{ #category : 'Private' }
GciInterface >> _storeTravPrim: opcode with: arg1 with: arg2 with: arg3 with: arg4 with: arg5
with: arg6 with: arg7 [

"Primitive dispatch.  all set lastResult instVar .
  opcode values:
    0: storeTravPerform:flags:perform:selector:args:alteredObjects:
    1: storeTravExecute:flags:environmentId:execute:alteredObjects:
    2: storeTravPerform:flags:perform:selector:args:alteredObjects:traverseInto:
    3: storeTravExecute:flags:environmentId:execute:alteredObjects:traverseInto:
"

<primitive: 506>

^self _primitiveFailed: #_storeTravPrim:
      args: { opcode . arg1 . arg2 . arg3 . arg4 . arg5 . arg6 . arg7  }

]

{ #category : 'Private' }
GciInterface >> _threeArgPrim: opcode with: arg1 with: arg2 with: arg3 [

"Primitive dispatch.  Legal values:
    2: GciInterface | remotePerform:selector:args:
    3: GciInterface | nbRemotePerform:selector:args:
    4: GciInterface | login:execute:
"

<primitive: 505>

opcode == 3
    ifTrue: [ "diagnostics for nbRemotePerform"
  arg3 size > 20 ifTrue: [arg3 _error: #gciErrArgNotPairs args: #()].
  arg3 size \\ 2 ~~ 0 ifTrue: [arg3 _error: #gciErrArgNotPairs args: #()].
  1 to: arg3 size by: 2 do: [:i |
	(arg3 at: i + 1) class == Boolean ifFalse: [
	    (arg3 at: i + 1) _errorExpectedClass: Boolean].
	(arg3 at: i + 1) ifTrue: [
	  ((arg3 at: i) _isInteger ) ifFalse: [
	    (arg3 at: i) _errorExpectedClass: Integer].
	  ].
	].
  ].
opcode == 4
  ifTrue: [ "errors in login"
    (arg1 isKindOf: GemStoneParameters)
	ifFalse: [ arg1 _errorExpectedClass: GemStoneParameters].
    (arg2 class isBytes)
	ifFalse: [ arg2 _error: #objErrNotByteKind].
    arg3 _validateClass: SmallInteger .
    { arg2 .
      arg1 hostUsername .
      arg1 gemService .
      arg1 gemStoneName .
      arg1 username .
      arg1 password .
      arg1 hostPassword
	 } do: [:each |
      each size > 1024
	ifTrue: [ each _error: #rtErrBadSize args: { 1024 . each size }]].
    ].
^self _primitiveFailed: #_threeArgPrim: args: { opcode . arg1 . arg2 . arg3 }

]

{ #category : 'Private' }
GciInterface >> _twoArgPrim: opcode with: arg1 with: arg2 [

"Primitive dispatch.  Legal values:
    3: GciInterface | storeTrav:flags:  (sets lastResult instVar)
    4: GciInterface | alteredObjects:   (sets lastResult instVar)
    5: GciInterface | step:level:
    6: GciInterface | traverseObjects:buffer:
    7: GciInterface | remoteExecuteTrav:buffer:
    8: unused (formerly GciInterface | login:execute:)
    9: GciInterface | nbLogin:flags:
"

<primitive: 199>

"Error diagnostics"

opcode == 9
  ifTrue: [ "errors in login"
    (arg1 isKindOf: GemStoneParameters)
	ifFalse: [ arg1 _errorExpectedClass: GemStoneParameters].

    { arg1 hostUsername .
      arg1 gemService .
      arg1 gemStoneName .
      arg1 username .
      arg1 password .
      arg1 hostPassword } do: [:each |
        each size > 1024
	ifTrue: [ each _error: #rtErrBadSize args: { 1024 . each size }]
      ].
     arg2 _isSmallInteger ifFalse:[ arg2 _errorExpectedClass: SmallInteger ]
    ].

^self _primitiveFailed: #_twoArgPrim: args: { opcode . arg1 . arg2 }

]

{ #category : 'Private' }
GciInterface >> _zeroArgPrim: opcode [

"Primitive dispatch.  Legal values are:
    32: GciInterface | dirtyObjsInit
    33: GciInterface | logout    (sets lastResult instVar to _remoteNil)
    34: GciInterface | commit
    35: GciInterface | nbCommit
    36: GciInterface | abort
    37: GciInterface | nbAbort
    38: GciInterface | softBreak
    39: GciInterface | callInProgress
    41: GciInterface | notifyHandle
    42: reserved
    43: GciInterface | hardBreak
    44:  _setDynamicClamp (receiver must be a ClampSpecification)

 A clamp installed with  _setDynamicClamp 
"

<primitive: 197>

^self _primitiveFailed: #_zeroArgPrim: args: { opcode }

]

{ #category : 'Public' }
GciInterface >> abort [

"Abort the transaction in the remote repository."

trace
  ifTrue: [ self record: 'abort' ].

^ self _zeroArgPrim: 36

]

{ #category : 'Primitives' }
GciInterface >> alteredObjects: alteredObjArray [

"Invoke the GciAlteredObjs function.

 The function result of GciAlteredObjs is the method result
 and is saved in lastResult. (changed  in v3.0.1) "

| str result trc |

(trc := trace)
  ifTrue: [ str := String new add: 'alteredObjs: '; yourself ].

result :=  self _twoArgPrim: 4 with: alteredObjArray with: nil.
trc ifTrue: [
    str add: ' returned '; add: result asString.
    self record: str
  ].

^ result

]

{ #category : 'Primitives' }
GciInterface >> callInProgress [

"Return whether there is a call in progress in the execution thread in the
remote repository."

trace ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' callInProgress'; yourself)
  ].

^ self _zeroArgPrim: 39

]

{ #category : 'Primitives' }
GciInterface >> clearStack: processOop [

"Clear the stack of Smalltalk execution in the remote repository."

trace ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' clearStack'; yourself)
  ].
^ self _oneArgPrim: 21 with: processOop

]

{ #category : 'Public' }
GciInterface >> commit [

"Commit the transaction in the remote repository."

trace
  ifTrue: [ self record: 'commit' ].

^ self _zeroArgPrim: 34

]

{ #category : 'Primitives' }
GciInterface >> continueWith: processOop
replaceTopOfStackWith: replaceOop
isSpecial: isSpecial
flags: flags [

"Invoke the GciContinueWith function.
If replaceOop == nil and isSpecial is false, then use OOP_ILLEGAL as the
replaceOop (which means the evaluation stack is not changed) .

Returns nil if an error occurs, or the execution result if execution
completes. (change in v3.0.1)"

| str result trc |
(trc := trace) ifTrue: [
    str := String new
	add: 'continueWith ['; add: replaceOop asString; add: '] '; yourself
  ].
result := self _fourArgPrim: 1
    with: processOop
    with: replaceOop
    with: isSpecial
    with: flags.
trc ifTrue: [
    str add: ' returned '; add: result asString.
    self record: str
  ].
^ result

]

{ #category : 'Primitives' }
GciInterface >> dirtyObjsInit [

"Execute GciDirtyObjsInit."

trace
  ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' dirtyObjsInit'; yourself)
  ].

^ self _zeroArgPrim: 32

]

{ #category : 'Tracing' }
GciInterface >> disableTracing [

"Enable tracing of commands issued to the subordinate gem to be logged to
a file."

trace
  ifFalse: [ ^ false ].

trace := false.
log close.
^ false

]

{ #category : 'Tracing' }
GciInterface >> enableFileTracing: filename [

"Enable tracing of commands issued to the subordinate gem to be logged to
a file."

trace
  ifTrue: [ ^ true ].

trace := true.

log := GsFile open: filename mode: 'a'.

log addAll: 'Tracing enabled at ';
  addAll: DateTime now asString; lf; flush.
^ true

]

{ #category : 'Accessing' }
GciInterface >> errorClass [

   "Return the value of the instance variable 'errorClass'."
   ^errorClass

]

{ #category : 'Updating' }
GciInterface >> errorClass: newValue [

   "Modify the value of the instance variable 'errorClass'."
  (newValue isSubclassOf: ErrorDescription)
    ifFalse: [
      self _error: #objErrConstraintViolation
        args: { newValue . ErrorDescription class . newValue class }
    ].
   errorClass := newValue

]

{ #category : 'Accessing' }
GciInterface >> getAndClearLastError [

"Return the value of lastError and clear it."

| result |
result := lastError.
lastError := nil.
^ result

]

{ #category : 'Primitives' }
GciInterface >> getFreeOops: num [

"Return an array of free remote oops from the subordinate gem.
This method will return a maximum of 2000 free oops.  You must
make multiple calls to receive more."

trace ifTrue: [ | str |
    str := String new.
    str add: 'getFreeOops: '; add: num asString.
    self record: str
  ].

^ self _oneArgPrim: 19 with: num

]

{ #category : 'Primitives' }
GciInterface >> hardBreak [

"Send a hard break to interrupt execution in the remote repository."

trace ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' hardBreak'; yourself)
  ].

^ self _zeroArgPrim: 43

]

{ #category : 'Initialization' }
GciInterface >> initialize [

"Initialize the instance variables of the receiver."

trace := false.
sessionId := 0. "GCI_INVALID_SESSION_ID"
errorClass := ErrorDescription.
lastResult := _remoteNil.
^ self

]

{ #category : 'Accessing' }
GciInterface >> lastError [

   "If the most recent remote operation did not succeed due to an error,
    answer an ErrorDescription. Otherwise answer nil."
   ^lastError

]

{ #category : 'Accessing' }
GciInterface >> lastErrorString [
 
   "If the most recent remote operation did not succeed due to an error,
    answer an ErrorDescription. Otherwise answer nil."
   ^ lastError printString

 ]

{ #category : 'Accessing' }
GciInterface >> lastResult [

   "Answer the result of the most recent remote operation.
    This will be a remote oop unless #resultIsSpecial answers true."
   ^lastResult

]

{ #category : 'Accessing' }
GciInterface >> lastResultAsOop [
  "return an Integer , the oop of the last result.
  If last result is undefined,  276 (oop of _remoteNil) is returned"
  | rs |
  (rs := resultIsSpecial) ifNil:[ ^ lastResult asOop ].
  rs == true ifTrue:[ ^ lastResult asOop ].
  ^ lastResult

]

{ #category : 'Accessing' }
GciInterface >> log [

   "Return the value of the instance variable 'log'."
   ^log

]

{ #category : 'Public' }
GciInterface >> login: aGemStoneParameters andExecute: aString ifFailure: aBlock [

"Login to the remote repository using the given parameters.  If login is
successful, return the remote oop of the result of execution of the given
string.  If the login fails or the executed block generates an error (which
in turn will cause the session to be logged out), execute the zero argument
block (if the block is nil, raise an error)."

| str gsName result trc |

aGemStoneParameters remoteRepository == nil
  ifFalse: [ gsName := aGemStoneParameters remoteRepository gemStoneName]
  ifTrue:  [ gsName := aGemStoneParameters gemStoneName].

(trc := trace) ifTrue: [
    str := String new add: 'Logging in to '; add: gsName;
      add: ' as '; add: aGemStoneParameters username; yourself.
    self record: str
  ].

" login and execute some code "
result := self login: aGemStoneParameters execute: aString.

" when successful, result is a remote oop (an Integer) "
result == _remoteNil ifTrue: [
    aBlock == nil
      ifTrue: [ self _errorLoginFailed ]
      ifFalse: [
        ^ aBlock value
      ]
  ].
(trc and: [ aString ~~ nil ])
  ifTrue: [ self record: 'Login successful.'; record: aString ].

^ result

]

{ #category : 'Primitives' }
GciInterface >> login: aGemStoneParameters
execute: aString [

"Login to a GemStone server with the given parameters, and execute
the given string.  The execution string may be nil.  If the result of execution
is _remoteNil, this will immediately logout.  If any error occurs during login
or remote string execution, this will return _remoteNil; otherwise it returns
the remote oop of the result of execution."

^ self _threeArgPrim: 4
    with: aGemStoneParameters
    with: aString
    with: aGemStoneParameters loginFlags

]

{ #category : 'Primitives' }
GciInterface >> login: aGemStoneParameters flags: flagsInt [

"Login to a GemStone server with the given parameters.
  flagsInt should be result of GemStoneParameters >> loginFlags . 
 If successful, returns true ."


^ self _twoArgPrim: 10
    with: aGemStoneParameters
    with: flagsInt

]

{ #category : 'Public' }
GciInterface >> logout [

"Terminate the communication with a subordinate gem."

trace ifTrue: [
    self record: 'Logging out'.
    self disableTracing.
  ].
^ self _zeroArgPrim: 33

]

{ #category : 'Primitives - Trav' }
GciInterface >> moreTraversal: cBuff [

"Continue a traversal from a previous operation.  The returned value will
be a TraversalBuffer.  The argument cBuff should be an instance of
TraversalBuffer"

| result |
trace ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' moreTraversal'; yourself)
  ].
result :=  self _oneArgPrim: 18 with: cBuff.
^ result

]

{ #category : 'Primitives - NB' }
GciInterface >> nbAbort [

"Non-blocking abort of the transaction in the remote repository."

trace
  ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' nbAbort'; yourself)
  ].

^ self _zeroArgPrim: 37

]

{ #category : 'Primitives - NB' }
GciInterface >> nbCommit [

"Non-blocking commit of the transaction in the remote repository."

trace
  ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' nbCommit'; yourself)
  ].

^ self _zeroArgPrim: 35

]

{ #category : 'Primitives - NB' }
GciInterface >> nbEnd: returnType [

"Test the status of a non-blocking call in progress.
The return type indicates if the non-blocking call will return
an OopType (1) or a BoolType (2).

Returns
  -1 if GCI_RESULT_NOT_READY
  0 if GCI_RESULT_PROGRESSED
  1 if GCI_RESULT_READY
  nil if an error occurred

After obtaining GCI_RESULT_READY, send lastResult or lastResultAsOop
to obtain the result.
"

| result str |
result := self _oneArgPrim: 20 with: returnType.
trace ifTrue: [
    str := String new.
    str add: sessionId asString; add: ' NB end - '.

    result == -1
      ifTrue: [ " self record: str , 'GCI_RESULT_NOT_READY' " ]
      ifFalse: [
        result == 0
          ifTrue: [ str add: 'GCI_RESULT_PROGRESSED' ]
          ifFalse: [
            result == 1
              ifTrue: [ str add: 'GCI_RESULT_READY : returned '; add: result asString ]
              ifFalse: [ str add: 'unknown NbEnd result: '; add: result asString ]
          ].
        self record: str
      ]
  ].

^ result

]

{ #category : 'Primitives - NB' }
GciInterface >> nbEndBoolean [

"cover for nbEnd:"

^self nbEnd: 2

]

{ #category : 'Primitives - NB' }
GciInterface >> nbEndOop [

"cover for nbEnd:"

^self nbEnd: 1

]

{ #category : 'Primitives - NB' }
GciInterface >> nbEndTraversal [

"cover for nbEnd:"

^self nbEnd: 2

]

{ #category : 'Primitives' }
GciInterface >> nbLogin: aGemStoneParameters [
  ^ self nbLogin: aGemStoneParameters flags: 0

]

{ #category : 'Primitives' }
GciInterface >> nbLogin: aGemStoneParameters flags: flagsInt [

"Invoke the GciNbLoginEx function.  flagsInt is per GCI_LOGIN_* bits defined
 in gci.ht. GCI_LOGIN_PW_ENCRYPTED and GCI_LOGIN_IS_SUBORDINATE
 are always ORed with the user provided flags before calling GciNbLoginEx."

^ self _twoArgPrim: 9 with: aGemStoneParameters with: flagsInt

]

{ #category : 'Primitives - NB' }
GciInterface >> nbMoreTraversal: cBuff [

"Non-blocking more traversal.
 The argument cBuff should be an instance of TraversalBuffer."

trace
  ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' nbMoreTraversal'; yourself)
  ].

^ self _oneArgPrim: 23 with: cBuff

]

{ #category : 'Primitives - NB' }
GciInterface >> nbRemoteExecute: aString [

"Execute the given string and return the result of execution.
Returns nil if there was an error, else returns receiver.
Use nbEnd* and lastResult methods to obtain the remote result."


trace
  ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' nbRemoteExecute:';
        add: aString; yourself)
  ].

^ self _oneArgPrim: 22 with: aString

]

{ #category : 'Primitives - NB' }
GciInterface >> nbRemotePerform: remoteOop selector: selector args: args [

"Sends the given selector to the object in a remote repository with the given
remote oop.  The arg array is an array of pairs: either a remote oop or special,
and a boolean indicating whether the arg is special or not, TRUE if the arg
is a remote oop, FALSE if it is special.
Returns nil if there was an error, else returns receiver.
Use nbEnd* and lastResult methods to obtain the remote result."

trace
  ifTrue: [
    self record: (String new add: sessionId asString;
      add: ' nbRemotePerform ['; add: remoteOop asString;
      add: '] '; add: selector; yourself)
  ].

^ self _threeArgPrim: 3
    with: remoteOop
    with: selector
    with: args

]

{ #category : 'Primitives' }
GciInterface >> notifyHandle [

"Return an OS handle that can be used in GsSocket to test if this interface
has read activity."

trace ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' notifyHandle'; yourself)
  ].

^ self _zeroArgPrim: 41

]

{ #category : 'Primitives - Trav' }
GciInterface >> performTraverse: remoteOop
selector: selector
args: argsArr
buffer: cBuff [

"Sends the given selector to the object in a remote repository with the given
remote oop.  argsArr  is an Array of pairs: either a remote oop or special,
and a boolean indicating whether the arg is special or not.

The argument cBuff should be an instance of TraversalBuffer."

trace ifTrue: [ | str sz |
    str := String new add: 'Sending ['; add: remoteOop asString;
      add: '] '; add: selector; add: ' '; yourself.
    sz := argsArr size.
    1 to: sz by: 2 do: [ :i |
      (argsArr at: i + 1) ifTrue: [ str add: $~ ].
      str add: (argsArr at: i) asString.
      (i + 1) == sz ifFalse: [ str add: ', ' ]
    ].
    self record: str.
  ].
^ self _fourArgPrim: 2
    with: remoteOop
    with: selector
    with: argsArr
    with: cBuff

]

{ #category : 'Tracing' }
GciInterface >> record: aString [

"Record the given string to the trace log."

log addAll: aString; add: Character lf; flush

]

{ #category : 'Tracing' }
GciInterface >> recordNoLf: aString [

"Record the given string to the trace log with no linefeed at the end."

log addAll: aString; flush

]

{ #category : 'Primitives' }
GciInterface >> remoteExecute: aString [

"Execute the given string and return the result of execution.
The returned value will be a remote oop or a special. Send
#resultIsSpecial to determine which.
If the execution resulted in an error, _remoteNil is returned
and error information can be retrieved via #lastError."

| str result trc |

(trc := trace)
  ifTrue: [ str := String new add: 'Execute: '; add: aString; yourself ].

result :=  self _oneArgPrim: 16 with: aString.
trc ifTrue: [
    str add: ' returned '; add: result asString.
    self record: str
  ].
^ result

]

{ #category : 'Primitives - Trav' }
GciInterface >> remoteExecuteTrav: aString buffer: cBuff [

"Execute the given string and return the result of execution in the given buffer.
 The argument cBuff should be an instance of TraversalBuffer.
 The result of the execution is saved in the instVar lastResult  .
 The method result is cBuff, i.e. the result of doing a traversal on
 the result of the execution. "

trace ifTrue: [ self record: aString ].

^ self _twoArgPrim: 7
    with: aString
    with: cBuff

]

{ #category : 'Primitives' }
GciInterface >> remotePerform: remoteOop selector: selector args: args [

"Sends the given selector to the object in a remote repository with the given
remote oop.  The arg array is an array of pairs: either a remote oop or special,
and a boolean indicating whether the arg is special or not.  The result is a
remoteOop or a special. Send #resultIsSpecial to determine which."

| str result trc |
(trc := trace)
  ifTrue: [
    str := String new add: 'Sending ['; add: remoteOop asString;
      add: '] '; add: selector; yourself
  ].
result := self _threeArgPrim: 2
    with: remoteOop
    with: selector
    with: args.
trc ifTrue: [
    str add: ' returned '; add: result asString.
    self record: str
  ].
^ result

]

{ #category : 'Primitives' }
GciInterface >> resolveSymbol: aSymbol [

"Resolve the given symbol and return the remote oop."

trace ifTrue: [ self record: 'Resolve symbol' , aSymbol ].

^ self _oneArgPrim: 17 with: aSymbol

]

{ #category : 'Accessing' }
GciInterface >> resultIsSpecial [

   "Answer true if the most recent result is a special (immediate) object:
    a SmallInteger, SmallDouble, Boolean, Character, or nil.
    Answer false if the most recent result is a remote oop."
   ^resultIsSpecial

]

{ #category : 'Accessing' }
GciInterface >> sessionId [

   "Return the value of the instance variable 'sessionId'."
   ^sessionId

]

{ #category : 'Primitives' }
GciInterface >> softBreak [

"Send a soft break to interrupt execution in the remote repository."

trace ifTrue: [
    self record:
      (String new add: sessionId asString; add: ' softBreak'; yourself)
  ].

^ self _zeroArgPrim: 38

]

{ #category : 'Primitives' }
GciInterface >> step: processOop level: level [

"Invoke the GciStep function.

 Returns nil if an error occurs, or the execution result if
 execution completes.  If execution completes, saves the
 execution result in lastResult instVar (change in v3.0.1)."

| str result |
trace ifTrue: [
    str := String new add: 'GciStep ';
      add: processOop asString;
      add: ' : ';
      add: level asString;
      yourself
  ].
result :=  self _twoArgPrim: 5 with: processOop with: level.
trace ifTrue: [
    str add: ' returned '; add: result asString.
    self record: str
  ].
^ result

]

{ #category : 'Primitives - Trav' }
GciInterface >> storeTrav: travBuff flags: flags [

"Invoke the store traversal function."

trace
  ifTrue: [ self record: 'GciStoreTrav: ' , flags asString ].

^ self _twoArgPrim: 3 with: travBuff with: flags

]

{ #category : 'Primitives - Trav' }
GciInterface >> storeTravCreate: travBuff [

"Invoke the store traversal function."

^ self storeTrav: travBuff flags: 2

]

{ #category : 'Primitives - Trav' }
GciInterface >> storeTravCreateAndFinishUpdates: travBuff [

"Invoke the store traversal function."

^ self storeTrav: travBuff flags: 10

]

{ #category : 'Primitives - Trav' }
GciInterface >> storeTravExecute: travBuff
flags: flags
environmentId: anEnvironmentId
execute: aString
alteredObjects: alteredObjArray [

"Invoke the store traversal function.

 anEnvironmentId must be a SmallInteger >= 0 and <= 255,
 specifying a compilation environment.

 If execution completes without error, this method
 answers the alteredCompleted boolean, and
 the result of the message send is saved in lastResult instVar.
 If there is an error, this method answers nil and you may send
 #lastError for error information."

| str result trc |
(trc := trace)
  ifTrue: [
    str := String new add: 'GciStoreTravExecute: '; add: aString; yourself
  ].

result := self _storeTravPrim: 1
    with: travBuff
    with: flags
    with: aString
    with: alteredObjArray
    with: anEnvironmentId
    with: nil with: nil .
trc ifTrue: [
    str add: ' lastResult '; add: lastResult asString ;
        add: ' returned '; add: result asString .
    self record: str
  ].
^ result

]

{ #category : 'Primitives - Trav' }
GciInterface >> storeTravExecute: travBuff
flags: flags
environmentId: anEnvironmentId
execute: aString
alteredObjects: alteredObjArray
traverseInto: resBuff [

"Invoke the store traversal function.

 anEnvironmentId must be a SmallInteger >= 0 and <= 255,
 specifying a compilation environment.

 If execution completes without error, this method
 answers the alteredCompleted boolean,
 the result of the message send is saved in lastResult instVar,
 and the result of the message send is traversed into the
 argument resBuff.   resBuff must be instance of TraversalBuffer.

 If there is an error, this method answers nil and you may send
 #lastError for error information."

| str result trc |
(trc := trace)
  ifTrue: [
    str := String new add: 'GciStoreTravExecute: '; add: aString; yourself
  ].

result := self _storeTravPrim: 1
    with: travBuff
    with: flags
    with: aString
    with: alteredObjArray
    with: anEnvironmentId
    with: resBuff with: nil .
trc ifTrue: [
    str add: ' lastResult '; add: lastResult asString ;
        add: ' returned '; add: result asString .
    self record: str
  ].
^ result

]

{ #category : 'Primitives - Trav' }
GciInterface >> storeTravPerform: travBuff
flags: flags
perform: remoteOop
selector: selector
args: args
alteredObjects: alteredObjArray [

"Invoke the GciStoreTravDo() function, sending
 the objects in the given travBuff to the remote
 gem, then sending the message described by
 the given selector and args to the object with
 the given remoteOop.

 The given args must be an Array whose size is
 twice the number of args. At each even index
 must be a Boolean, true if the value at index-1
 is a special, false if the value is a remote oop.

 If execution completes without error, this method
 answers the alteredCompleted boolean, and
 the result of the message send is saved in lastResult instVar.
 If there is an error, this method answers nil and you may send
 #lastError for error information."

| str result trc |

(trc := trace)
  ifTrue: [
    str := String new add: 'GciStoreTravPerform ['; add: remoteOop asString;
      add: '] '; add: selector; yourself
  ].

result := self _storeTravPrim: 0
    with: travBuff
    with: flags
    with: remoteOop
    with: selector
    with: args
    with: alteredObjArray
    with: nil  .
trc ifTrue: [
    str add: ' lastResult '; add: lastResult asString ;
        add: ' returned '; add: result asString .
    self record: str
  ].
^ result

]

{ #category : 'Primitives - Trav' }
GciInterface >> storeTravPerform: travBuff
flags: flags
perform: remoteOop
selector: selector
args: argsArray
alteredObjects: alteredObjArray
traverseInto: resBuff [

"Invoke the GciStoreTravDo() function, sending the objects in
 the given travBuff to the remote gem, then sending the message
 described by the given selector and args to the object with
 the given remoteOop.
 If execution completes without error, this method
 answers the alteredCompleted boolean, and
 the result of the message send is saved in lastResult instVar.
 and the result of the message send is traversed into the
 argument resBuff.   resBuff must be instance of TraversalBuffer.

 The argsArray must be an Array whose size is
 twice the number of args to the selector being performed.
 At each even index must be a Boolean, true if the value at index-1
 is a special, false if the value is a remote oop.

 If there is an error, this method answers nil and you may send
 #lastError for error information."

| str result trc |

(trc := trace)
  ifTrue: [
    str := String new add: 'GciStoreTravPerform ['; add: remoteOop asString;
      add: '] '; add: selector; yourself
  ].

result := self _storeTravPrim: 2
    with: travBuff
    with: flags
    with: remoteOop
    with: selector
    with: argsArray
    with: alteredObjArray
    with: resBuff .
trc ifTrue: [
    str add: ' lastResult '; add: lastResult asString ;
        add: ' returned '; add: result asString .
    self record: str
  ].
^ result

]

{ #category : 'Primitives - Trav' }
GciInterface >> traverseObjects: arrayOfOops buffer: cBuff [

"Return a buffer resulting from traversing the given array of remote oops
using GciClampedTrav().  If there were too many oops, return nil.
The argument cBuff should be an instance of TraversalBuffer."

trace ifTrue: [ | str |
    str := String new.
    str add: 'Traversing '; add: arrayOfOops size asString; add: ' oops'.
    self record: str
  ].

^ self _twoArgPrim: 6 with: arrayOfOops with: cBuff

]
