Extension { #name : 'GsAbstractQueryOptimizer' }

{ #category : 'instance creation' }
GsAbstractQueryOptimizer class >> optimize: aFormula on: anNsc options: aGsQueryOptions [
  ^ self new
    formula: aFormula;
    nsc: anNsc;
    queryOptions: aGsQueryOptions;
    optimize

]

{ #category : 'accessing' }
GsAbstractQueryOptimizer >> collator [
  ^ self formula collator

]

{ #category : 'accessing' }
GsAbstractQueryOptimizer >> formula [
  ^ formula

]

{ #category : 'accessing' }
GsAbstractQueryOptimizer >> formula: aFormula [
  formula := aFormula copy

]

{ #category : 'testing' }
GsAbstractQueryOptimizer >> hasNsc [
  ^ nsc ~~ nil

]

{ #category : 'accessing' }
GsAbstractQueryOptimizer >> nsc [
  ^ nsc

]

{ #category : 'accessing' }
GsAbstractQueryOptimizer >> nsc: anNsc [
  nsc := anNsc

]

{ #category : 'optimizing' }
GsAbstractQueryOptimizer >> optimize [
  self subclassResponsibility: #optimize

]

{ #category : 'accessing' }
GsAbstractQueryOptimizer >> queryOptions [
  ^ queryOptions

]

{ #category : 'accessing' }
GsAbstractQueryOptimizer >> queryOptions: aGsQueryOptions [
  queryOptions := aGsQueryOptions

]
