Extension { #name : 'GsClassicQueryBlockOptimizer' }

{ #category : 'visiting' }
GsClassicQueryBlockOptimizer >> acceptCompoundClause: aCompoundClause [
  "replace conjunctive normal form clauses with optimized equivalent"

  aCompoundClause clause1 isConjunctiveNormalForm
    ifTrue: [
      aCompoundClause
        clause1: (self optimizeConjunctiveNormalClause: aCompoundClause clause1) ].
  aCompoundClause clause2 isConjunctiveNormalForm
    ifTrue: [
      aCompoundClause
        clause2: (self optimizeConjunctiveNormalClause: aCompoundClause clause2) ].
  super acceptCompoundClause: aCompoundClause

]

{ #category : 'visiting' }
GsClassicQueryBlockOptimizer >> acceptUnaryClause: aUnaryClause [
  | clause |
  self queryOptions applyDeMorgansLaws
    ifTrue: [ self applyDeMorgansLaws: aUnaryClause ].
  clause := aUnaryClause clause.
  clause isConjunctiveNormalForm
    ifTrue: [ clause := self optimizeConjunctiveNormalClause: clause ].
  aUnaryClause clause: clause.
  super acceptUnaryClause: aUnaryClause

]

{ #category : 'optimizing' }
GsClassicQueryBlockOptimizer >> applyDeMorgansLaws: aClause [
  ^ aClause applyDeMorgansTransform

]

{ #category : 'optimizing' }
GsClassicQueryBlockOptimizer >> optimize [
  | formulaCopy optimizedFormula |
  formulaCopy := self formula copy.
  optimizedFormula := formulaCopy isConjunctiveNormalForm
    ifTrue: [ self optimizeConjunctiveNormalClause: formulaCopy ]
    ifFalse: [
      self queryOptions applyDeMorgansLaws
        ifTrue: [
          formulaCopy := self applyDeMorgansLaws: formulaCopy.
          formulaCopy isConjunctiveNormalForm
            ifTrue: [ self optimizeConjunctiveNormalClause: formulaCopy ]
            ifFalse: [ self visitFormula: formulaCopy ] ]
        ifFalse: [ self visitFormula: formulaCopy ] ].
  ^ optimizedFormula immediateInvariant

]

{ #category : 'optimizing' }
GsClassicQueryBlockOptimizer >> optimizeConjunctiveNormalClause: aClause [
  ^ (GsClassicConjunctiveClauseOptimizer
    optimize: aClause
    on: self nsc
    options: self queryOptions) copy

]
