Extension { #name : 'GsConjunctiveClauseConjoinSetChecker' }

{ #category : 'instance creation' }
GsConjunctiveClauseConjoinSetChecker class >> check: aFormula on: anNsc [
  ^ self new
    formula: aFormula;
    nsc: anNsc;
    queryOptions: GsQueryOptions default;
    check

]

{ #category : 'private' }
GsConjunctiveClauseConjoinSetChecker >> _errorMalformedQuery: commonPathTerms senderLocationID: senderLocationID [
  | str |
  str := commonPathTerms at: 1.
  2 to: commonPathTerms size do: [ :index | str := str , '.' , (commonPathTerms at: index) ].
  ^ GsMalformedQueryExpressionError
    bug43764MalformedQuery:
      str printString , ' in clause ' , self formula printString
    senderLocationID: senderLocationID

]

{ #category : 'visiting' }
GsConjunctiveClauseConjoinSetChecker >> acceptPredicate: aPredicate [
  "collect all predicates which use comparison operators, are not range predicates and have
   a collection based term"

  (aPredicate usesComparisonOperation not or: [ aPredicate usesRangeOperation ])
    ifTrue: [
      "not exposed to bug43764"
      ^ self ].
  aPredicate _evaluators
    detect: [ :evaluator | evaluator hasCollectionBasedTerm ]
    ifNone: [
      "not exposed to bug43764"
      ^ self ].
  super acceptPredicate: aPredicate

]

{ #category : 'checking' }
GsConjunctiveClauseConjoinSetChecker >> check [
  "collect all predicates which use comparison operators, are not range predicates and have
   a collection based term in common with another predicate"

  | collectionBasedEvaluators commonPathTerms |
  self visitFormula: self formula.
  collectionBasedEvaluators := {}.
  self predicates
    do: [ :predicate |
      collectionBasedEvaluators
        addAll:
          (predicate _evaluators select: [ :each | each hasCollectionBasedTerm ]) ].
  collectionBasedEvaluators size <= 1
    ifTrue: [
      "not exposed"
      ^ self ].
  1 to: collectionBasedEvaluators size do: [ :outerIndex |
    | outerEvaluator |
    outerEvaluator := collectionBasedEvaluators at: outerIndex.
    1 to: collectionBasedEvaluators size do: [ :innerIndex |
      | innerEvaluator |
      innerEvaluator := collectionBasedEvaluators at: innerIndex.
      innerIndex == outerIndex
        ifFalse: [
          "see if there are common terms"
          commonPathTerms := innerEvaluator _commonPathTermsWith: outerEvaluator.
          (commonPathTerms includes: #'*')
            ifTrue: [
              "Cannot evaluate a formula where two conjoined predicates are collection based"
              ^ self
                _errorMalformedQuery: commonPathTerms
                senderLocationID: #'check' ].
          commonPathTerms
            do: [ :term |
              (term includes: $|)
                ifTrue: [
                  "Cannot evaluate a formula where two conjoined predicates are enumerated"
                  ^ self
                    _errorMalformedQuery: commonPathTerms
                    senderLocationID: #'check' ] ] ] ] ]

]
