Extension { #name : 'GsMalformedQueryExpressionError' }

{ #category : 'Instance Creation' }
GsMalformedQueryExpressionError class >> bug43764MalformedQuery: explanation senderLocationID: senderLocationID [
  "Invalid query formulation. Query cannot be properly evaluated ...
   The query must be rewritten."

  "senderLocationID used to identify the method and/or class of the sender to help
   validate test coverage"

  ^ (self new
    bug43764MalformedQuery: explanation;
    reason: senderLocationID) signal

]

{ #category : 'Instance Creation' }
GsMalformedQueryExpressionError class >> bug43764QueryCannotBeAnalyzed: senderLocationID [
  "query may be exposed to bug43764, but the query options applyDeMorgansLaws and consolidateRangePredicates must be set before proper analysis can be done"

  "senderLocationID used to identify the method and/or class of the sender to help
   validate test coverage"

  ^ (self new
    bug43764QueryCannotBeAnalyzed;
    reason: senderLocationID) signal

]

{ #category : 'Instance Creation' }
GsMalformedQueryExpressionError class >> bug43764QueryMustBeOptimized: senderLocationID [
  "Query is not exposed to Bug 43764, but the query must be optimized with the
   appropriate query options to be successfully evaluated"

  "senderLocationID used to identify the method and/or class of the sender to help
   validate test coverage"

  ^ (self new
    bug43764QueryMustBeOptimized;
    reason: senderLocationID) signal

]

{ #category : 'Instance Creation' }
GsMalformedQueryExpressionError class >> collectionIsNotQueryable: explanation senderLocationID: senderLocationID [
  "Collection is not queryable."

  ^ self new
    collectionIsNotQueryable: explanation;
    reason: senderLocationID;
    signal

]

{ #category : 'Instance Creation' }
GsMalformedQueryExpressionError class >> queryIsNotStreamable: explanation senderLocationID: senderLocationID [
  "Query is not streamable."

  "senderLocationID used to identify the method and/or class of the sender to help
   validate test coverage"

  ^ (self new
    queryIsNotStreamable: explanation;
    reason: senderLocationID) signal

]

{ #category : 'Instance Creation' }
GsMalformedQueryExpressionError class >> streamableQueryCannotBeAnalyzed: senderLocationID [
  "cannot determine if query can be streamed, the query options applyDeMorgansLaws and consolidateRangePredicates must be set before proper analysis can be done"

  "senderLocationID used to identify the method and/or class of the sender to help
   validate test coverage"

  ^ (self new
    streamableQueryCannotBeAnalyzed;
    reason: senderLocationID) signal

]

{ #category : 'Instance Creation' }
GsMalformedQueryExpressionError class >> streamableQueryMustBeOptimized: senderLocationID [
  "Query can be streamed, but the query must be optimized with the
   appropriate query options to be successfully evaluated"

  "senderLocationID used to identify the method and/or class of the sender to help
   validate test coverage"

  ^ (self new
    streamableQueryMustBeOptimized;
    reason: senderLocationID) signal

]

{ #category : 'Initialization' }
GsMalformedQueryExpressionError >> bug43764MalformedQuery: explanation [
  "Invalid query formulation. Query cannot be properly evaluated ...
   The query must be rewritten."

  self
    errorCondition: #'bug43764MalformedQuery';
    messageText:
        'Invalid query formulation with conjoined collection based path terms: '
            , explanation
            ,
              ' (#bug43764MalformedQuery). See bugnote: http://gemtalksystems.com/data/bugnotes/43764.html.'

]

{ #category : 'Initialization' }
GsMalformedQueryExpressionError >> bug43764QueryCannotBeAnalyzed [
  "query may be exposed to bug43764, but the query options applyDeMorgansLaws and consolidateRangePredicates must be set before proper analysis can be done"

  self
    errorCondition: #'bug43764QueryCannotBeAnalyzed';
    messageText:
        'Invalid query formulation involving collection based path terms. Query must be  optimized to properly evaluate exposure to Bug 43764. Set the query options applyDeMorgansLaws and consolidateRangePredicates and try again (#bug43764QueryCannotBeAnalyzed). See bugnote: http://gemtalksystems.com/data/bugnotes/43764.html.'

]

{ #category : 'Initialization' }
GsMalformedQueryExpressionError >> bug43764QueryMustBeOptimized [
  "Query is not exposed to Bug 43764, but the query must be optimized with the
   appropriate query options to be successfully evaluated"

  self
    errorCondition: #'bug43764QueryMustBeOptimized';
    messageText:
        'Invalid query formulation involving collection based path terms. If you optimize the query and set the query options applyDeMorgansLaws and consolidateRangePredicates the query can be evaluated successfully (#bug43764QueryMustBeOptimized). See bugnote: http://gemtalksystems.com/data/bugnotes/43764.html.'

]

{ #category : 'Initialization' }
GsMalformedQueryExpressionError >> collectionIsNotQueryable: explanation [
  "Collection is not queryable."

  self
    errorCondition: #'collectionIsNotQueryable';
    messageText:
        'A GsQuery may not be created on an instance of class ' , explanation , '.'
            , ' (#collectionIsNotQueryable).'

]

{ #category : 'Accessing' }
GsMalformedQueryExpressionError >> errorCondition [
  ^ errorCondition

]

{ #category : 'Accessing' }
GsMalformedQueryExpressionError >> errorCondition: aSymbol [
  errorCondition := aSymbol

]

{ #category : 'Initialization' }
GsMalformedQueryExpressionError >> queryIsNotStreamable: explanation [
  "Query is not streamable."

  self
    errorCondition: #'queryIsNotStreamable';
    messageText:
        'Query may not be streamed. '
            , explanation , ' (#queryIsNotStreamable).'

]

{ #category : 'Initialization' }
GsMalformedQueryExpressionError >> streamableQueryCannotBeAnalyzed [
  "cannot determine if query can be streamed, the query options applyDeMorgansLaws and consolidateRangePredicates must be set before proper analysis can be done"

  self
    errorCondition: #'streamableQueryCannotBeAnalyzed';
    messageText:
        'Invalid query formulation involving collection based path terms. Query must be  optimized to properly evaluate whether or not the query is streamable. Set the query options applyDeMorgansLaws and consolidateRangePredicates and try again (#streamableQueryCannotBeAnalyzed).'

]

{ #category : 'Initialization' }
GsMalformedQueryExpressionError >> streamableQueryMustBeOptimized [
  "Query can be streamed, but the query must be optimized with the
   appropriate query options to be successfully evaluated"

  self
    errorCondition: #'streamableQueryMustBeOptimized';
    messageText:
        'Query cannot be streamed as is. If you optimize the query and set the query options applyDeMorgansLaws and consolidateRangePredicates the query can be evaluated successfully (#streamableQueryMustBeOptimized).'

]
