Extension { #name : 'GsPathConstantPredicate' }

{ #category : 'initialization' }
GsPathConstantPredicate >> _fromArray: varsArray terms: termsArray links: linksArray paths: pathsArray startingAt: i [
  self
    path1:
      (self _pathFrom: linksArray paths: pathsArray offset: (termsArray at: i + 6)).
  operator := self operationSelectors at: (termsArray at: i) + 1.
  operator == #'unary'
    ifTrue: [
      "recast predicate to be '== true'"
      operator := #'=='.
      self constant2: true ]
    ifFalse: [ self constant2: (varsArray at: (termsArray at: i + 2)) ]

]

{ #category : 'private' }
GsPathConstantPredicate >> _unsatisfiableQuery [
  GsUnsatisfiableQueryNotification signal.
  ^ nil

]

{ #category : 'transforming' }
GsPathConstantPredicate >> bind: variableName to: value [
  ^ self operator == #'unary'
    ifTrue: [
      | bound |
      bound := self copy.
      bound operand1: (bound operand1 bind: variableName to: value).
      ^ bound immediateInvariant ]
    ifFalse: [ super bind: variableName to: value ]

]

{ #category : 'private' }
GsPathConstantPredicate >> bindEvaluators [
  evaluator1 := self
    _bindEvaluator: nsc
    for: self path
    isRangeEqualityOperation: (self isRangeEqualityOperation: self operator).
  super bindEvaluators

]

{ #category : 'optimizing' }
GsPathConstantPredicate >> canConsolidateEnumeratedWith: secondaryPredicate [
  ^ secondaryPredicate canConsolidateEnumeratedWithPathConstantPredicate: self

]

{ #category : 'optimizing' }
GsPathConstantPredicate >> canConsolidateEnumeratedWithPathConstantPredicate: primaryPredicate [
  | pathTerms primaryPathTerms |
  (primaryPredicate operand1 hasSamePathAs: self operand1)
    ifTrue: [ ^ false ].
  (primaryPredicate isConstantBound and: [ self isConstantBound ])
    ifFalse: [ ^ false ].
  primaryPredicate operator == self operator
    ifFalse: [ ^ false ].
  (primaryPredicate constant _idxForCompareEqualTo: self constant)
    ifFalse: [ ^ false ].
  pathTerms := self _pathTerms.
  primaryPathTerms := primaryPredicate _pathTerms.
  ^ pathTerms size = primaryPathTerms size

]

{ #category : 'optimizing' }
GsPathConstantPredicate >> canConsolidateWith: secondaryPredicate [
  ^ secondaryPredicate canConsolidateWithPathConstantPredicate: self

]

{ #category : 'optimizing' }
GsPathConstantPredicate >> canConsolidateWithPathConstantPredicate: primaryPredicate [
  | op1 op2 |
  (primaryPredicate operand1 hasSamePathAs: self operand1)
    ifFalse: [ ^ false ].
  (primaryPredicate isConstantBound and: [ self isConstantBound ])
    ifFalse: [ ^ false ].
  op1 := primaryPredicate operator.
  op2 := self operator.
  ((op1 == #'>' or: [ op1 == #'>=' ]) and: [ op2 == #'<' or: [ op2 == #'<=' ] ])
    ifTrue: [
      " if first operator is > or >= and last operator is < or <= "
      ^ primaryPredicate constant _idxForCompareLessThanOrEqualTo: self constant ].
  ((op1 == #'<' or: [ op1 == #'<=' ]) and: [ op2 == #'>' or: [ op2 == #'>=' ] ])
    ifTrue: [
      " if first operator is < or <= and last operator is > or >= "
      ^ primaryPredicate constant
        _idxForCompareGreaterThanOrEqualTo: self constant ].
  ^ false

]

{ #category : 'transforming' }
GsPathConstantPredicate >> collapseToRangePredicateForConstantPathPredicate: aConstantPathPredicate [
  (self compatibleRangeOperatorsFor: aConstantPathPredicate operator)
    ifFalse: [ ^ super collapseToRangePredicateForConstantPathPredicate: aConstantPathPredicate ].
  ^ GsRangeQueryPredicate
    operand: aConstantPathPredicate operand1 copy
    operator: aConstantPathPredicate operator
    path: self path
    operator: self operator
    operand: self operand2 copy

]

{ #category : 'transforming' }
GsPathConstantPredicate >> collapseToRangePredicateForPathConstantPredicate: aPathConstantPredicate [
  (self compatibleInverseRangeOperatorsFor: aPathConstantPredicate operator)
    ifFalse: [ ^ super collapseToRangePredicateForPathConstantPredicate: aPathConstantPredicate ].
  ^ GsRangeQueryPredicate
    operand: aPathConstantPredicate operand2 copy
    operator: (self inverseOperatorFor: aPathConstantPredicate operator)
    path: self path
    operator: self operator
    operand: self operand2 copy

]

{ #category : 'transforming' }
GsPathConstantPredicate >> collapseToRangePredicateIfPossible: aPathXPredicate [
  ^ aPathXPredicate collapseToRangePredicateForPathConstantPredicate: self

]

{ #category : 'transforming' }
GsPathConstantPredicate >> consolidateEnumeratedWith: secondaryPredicate [
  "caller must ensure that canConsolidateEnumeratedWith: has already been called"

  | pathTerms secondaryPathTerms candidateOperand1 candidatePathString |
  pathTerms := self _pathTerms.
  secondaryPathTerms := secondaryPredicate _pathTerms.
  candidatePathString := 'each'.
  1 to: pathTerms size do: [ :i |
    | primaryTerm secondaryTerm |
    primaryTerm := pathTerms at: i.
    secondaryTerm := secondaryPathTerms at: i.
    primaryTerm = secondaryTerm
      ifTrue: [ candidatePathString := candidatePathString , '.' , primaryTerm ]
      ifFalse: [
        primaryTerm > secondaryTerm
          ifTrue: [
            | swap |
            swap := primaryTerm.
            primaryTerm := secondaryTerm.
            secondaryTerm := swap ].
        candidatePathString := candidatePathString , '.' , primaryTerm , '|'
          , secondaryTerm ] ].
  candidateOperand1 := GsQueryPathReferenceAssociation
    newWithKey: candidatePathString
    value: nil.
  ^ GsPathConstantPredicate
    operand: candidateOperand1
    operator: operator
    operand: operand2

]

{ #category : 'transforming' }
GsPathConstantPredicate >> consolidateWith: secondaryPredicate [
  (secondaryPredicate canConsolidateWithPathConstantPredicate: self)
    ifFalse: [
      self
        error:
          'Cannot consolidate ' , self printString , ' with '
            , secondaryPredicate printString ].
  (self compatibleInverseRangeOperatorsFor: secondaryPredicate operator)
    ifFalse: [ self error: 'fail safe test failed' ].
  ^ (self operator == #'>' or: [ self operator == #'>=' ])
    ifTrue: [
      GsRangeQueryPredicate
        operand: self operand2 copy
        operator: (self inverseOperatorFor: self operator)
        path: self path
        operator: secondaryPredicate operator
        operand: secondaryPredicate operand2 copy ]
    ifFalse: [
      GsRangeQueryPredicate
        operand: secondaryPredicate operand2 copy
        operator:
          (secondaryPredicate inverseOperatorFor: secondaryPredicate operator)
        path: self path
        operator: self operator
        operand: self operand2 copy ]

]

{ #category : 'accessing' }
GsPathConstantPredicate >> constant [
  ^ self operand2 _idxValue

]

{ #category : 'querying' }
GsPathConstantPredicate >> executeAndDo: aBlock [
  ^ self executeAndDo: aBlock using: self operator

]

{ #category : 'querying-private' }
GsPathConstantPredicate >> executeAndDo: aBlock using: anOperator [
  | queryEvaluator |
  queryEvaluator := self evaluator1 asQueryEvaluator.
  queryEvaluator doBlock: aBlock.
  ^ self executeClauseUsing: anOperator queryEvaluator: queryEvaluator

]

{ #category : 'querying-private' }
GsPathConstantPredicate >> executeClause [
  ^ self executeClauseUsing: self operator

]

{ #category : 'querying-private' }
GsPathConstantPredicate >> executeClauseNegated [
  ^ self executeClauseUsing: self operatorNegated

]

{ #category : 'querying-private' }
GsPathConstantPredicate >> executeClauseUsing: anOperator [
  | queryEvaluator |
  queryEvaluator := self evaluator1 asQueryEvaluator.
  ^ self executeClauseUsing: anOperator queryEvaluator: queryEvaluator

]

{ #category : 'querying-private' }
GsPathConstantPredicate >> executeClauseUsing: anOperator queryEvaluator: queryEvaluator [
  | theOperator theConstant |
  theOperator := anOperator.
  theConstant := self constant.
  theOperator == #'unary'
    ifTrue: [
      theOperator := #'=='.
      theConstant := true ].
  theOperator == #'unaryNot'
    ifTrue: [
      theOperator := #'~~'.
      theConstant := true ].
  self _check: self evaluator1 compare: theOperator value: theConstant.
  (theOperator == #'<' or: [ theOperator == #'<=' ])
    ifTrue: [
      (theConstant == nil and: [ theOperator == #'<=' ])
        ifTrue: [ ^ queryEvaluator findAllValuesEqualTo: nil ]
        ifFalse: [
          ^ queryEvaluator
            findAllValuesLessThanKey: theConstant
            andEquals: theOperator == #'<=' ] ].
  (theOperator == #'>' or: [ theOperator == #'>=' ])
    ifTrue: [
      (theConstant == nil and: [ theOperator == #'>=' ])
        ifTrue: [ ^ queryEvaluator findAllValuesEqualTo: nil ]
        ifFalse: [
          ^ queryEvaluator
            findAllValuesGreaterThanKey: theConstant
            andEquals: theOperator == #'>=' ] ].
  theOperator == #'='
    ifTrue: [ ^ queryEvaluator findAllValuesEqualTo: theConstant ].
  theOperator == #'~='
    ifTrue: [ ^ queryEvaluator findAllValuesNotEqualTo: theConstant ].
  theOperator == #'=='
    ifTrue: [ ^ queryEvaluator findAllValuesIdenticalTo: theConstant ].
  theOperator == #'~~'
    ifTrue: [ ^ queryEvaluator findAllValuesNotIdenticalTo: theConstant ]

]

{ #category : 'querying-private' }
GsPathConstantPredicate >> executeNegatedAndDo: aBlock [
  ^ self executeAndDo: aBlock using: self operatorNegated

]

{ #category : 'testing' }
GsPathConstantPredicate >> isConstantBound [
  (self operator == #'unary' or: [ self operator == #'unaryNot' ])
    ifTrue: [ ^ false ].
  ^ self operand2 isBound

]

{ #category : 'querying-private' }
GsPathConstantPredicate >> lastElementValue: anObject [
  "anObject is the value obtained by traversing path terms to the last value ... analgous to the last element class"

  | theOperator theConstant |
  theOperator := self operator.
  theConstant := self constant.
  theOperator == #'unary'
    ifTrue: [
      theOperator := #'=='.
      theConstant := true ].
  theOperator == #'unaryNot'
    ifTrue: [
      theOperator := #'~~'.
      theConstant := true ].
  ^ anObject
    perform: (self comparisonSelectorFor: theOperator)
    with: theConstant

]

{ #category : 'testing' }
GsPathConstantPredicate >> operand1IsPath [
  ^ true

]

{ #category : 'querying-private' }
GsPathConstantPredicate >> prepareForExecution [
  "Return an object equivalent to the receiver that is prepared for execution within
   the context of a block."

  | ans |
  ans := GsPreparedPathConstantPredicate new
    path1: operand1;
    operator: operator;
    constant2: self constant;
    _nsc: nsc collator: collator;
    evaluator1: evaluator1;
    prepare.
  ^ans

]

{ #category : 'printing' }
GsPathConstantPredicate >> printOn: aStream [
  self operator ~~ #'unary'
    ifTrue: [ ^ super printOn: aStream ].
  aStream nextPutAll: '( ' , self operand1 key asString , ' )'

]

{ #category : 'accessing' }
GsPathConstantPredicate >> rawPath [
  ^ self operand1

]

{ #category : 'optimizing' }
GsPathConstantPredicate >> redundantDisjunctivePredicateBetween: secondaryPredicate [
  ^ secondaryPredicate redundantDisjunctivePredicateBetweenPathConstant: self

]

{ #category : 'optimizing' }
GsPathConstantPredicate >> redundantDisjunctivePredicateBetweenPathConstant: primaryPredicate [
  | op1 op2 |
  (primaryPredicate operand1 hasSamePathAs: self operand1)
    ifFalse: [ ^ nil ].
  (primaryPredicate isConstantBound and: [ self isConstantBound ])
    ifFalse: [ ^ nil ].
  (primaryPredicate constant == nil or: [ self constant == nil ])
    ifTrue: [ ^ nil ].
  op1 := primaryPredicate operator.
  op2 := self operator.
  op1 == op2
    ifTrue: [
      " operators are the same "
      (op1 == #'<' or: [ op1 == #'<=' ])
        ifTrue: [
          " operator: < or <= "
          " choose largest value "
          ^ (primaryPredicate constant _idxForCompareLessThan: self constant)
            ifTrue: [ primaryPredicate ]
            ifFalse: [ self ] ].
      (op1 == #'>' or: [ op1 == #'>=' ])
        ifTrue: [
          " operator: > or >= "
          " choose smallest value "
          ^ (primaryPredicate constant _idxForCompareGreaterThan: self constant)
            ifTrue: [ primaryPredicate ]
            ifFalse: [ self ] ].
      (op1 == #'=' or: [ op1 == #'~=' ])
        ifTrue: [
          " operator: = or ~="
          ^ (primaryPredicate constant _idxForCompareEqualTo: self constant)
            ifTrue: [ self ]
            ifFalse: [ nil ] ].
      (op1 == #'==' or: [ op1 == #'~~' ])
        ifTrue: [
          " operator: == or ~~"
          ^ primaryPredicate constant == self constant
            ifTrue: [ self ]
            ifFalse: [ nil ] ] ]
    ifFalse: [
      " operators are different "
      ((op1 == #'<' and: [ op2 == #'<=' ])
        or: [ op1 == #'<=' and: [ op2 == #'<' ] ])
        ifTrue: [
          " op1: < and op2: <= "
          " op1: <= and op2: < "
          " choose largest value "
          ^ (primaryPredicate constant _idxForCompareLessThan: self constant)
            ifTrue: [ primaryPredicate ]
            ifFalse: [
              (primaryPredicate constant _idxForCompareGreaterThan: self constant)
                ifTrue: [ self ]
                ifFalse: [
                  " operands are = "
                  op1 == #'<'
                    ifTrue: [ primaryPredicate ]
                    ifFalse: [ self ] ] ] ].
      ((op1 == #'>' and: [ op2 == #'>=' ])
        or: [ op1 == #'>=' and: [ op2 == #'>' ] ])
        ifTrue: [
          " op1: > and op2: >= "
          " op1: >= and op2: > "
          " choose largest value "
          ^ (primaryPredicate constant _idxForCompareGreaterThan: self constant)
            ifTrue: [ primaryPredicate ]
            ifFalse: [
              (primaryPredicate constant _idxForCompareLessThan: self constant)
                ifTrue: [ self ]
                ifFalse: [
                  " operands are = "
                  op1 == #'>'
                    ifTrue: [ primaryPredicate ]
                    ifFalse: [ self ] ] ] ].
      ((op1 == #'=' and: [ op2 == #'==' ])
        or: [ op1 == #'==' and: [ op2 == #'=' ] ])
        ifTrue: [
          " op1: = and op2: == "
          " op1: == and op2: = "
          ^ primaryPredicate constant == self constant
            ifTrue: [
              op2 == #'=='
                ifTrue: [ primaryPredicate ]
                ifFalse: [ self ] ]
            ifFalse: [ nil ] ].
      ((op1 == #'==' and: [ op2 == #'~~' ])
        or: [ op1 == #'~~' and: [ op2 == #'==' ] ])
        ifTrue: [
          " op1: == and op2: ~~ "
          " op1: ~~ and op2: == "
          ^ primaryPredicate constant == self constant
            ifTrue: [ self _unsatisfiableQuery ]
            ifFalse: [ self _unsatisfiableQuery ] ].
      (op1 == #'=' or: [ op1 == #'==' ])
        ifTrue: [
          " op1: = or op1: =="
          op2 == #'<'
            ifTrue: [
              " op2: < "
              ^ (primaryPredicate constant _idxForCompareLessThan: self constant)
                ifTrue: [ primaryPredicate ]
                ifFalse: [ nil ] ].
          op2 == #'<='
            ifTrue: [
              " op2: <= "
              ^ (primaryPredicate constant
                _idxForCompareLessThanOrEqualTo: self constant)
                ifTrue: [ primaryPredicate ]
                ifFalse: [ nil ] ].
          op2 == #'>'
            ifTrue: [
              " op2: > "
              ^ (primaryPredicate constant
                _idxForCompareGreaterThan: self constant)
                ifTrue: [ primaryPredicate ]
                ifFalse: [ nil ] ].
          op2 == #'>='
            ifTrue: [
              " op2: >= "
              ^ (primaryPredicate constant
                _idxForCompareGreaterThanOrEqualTo: self constant)
                ifTrue: [ primaryPredicate ]
                ifFalse: [ nil ] ].
          op2 == #'~='
            ifTrue: [
              " op2: ~= "
              ^ (primaryPredicate constant _idxForCompareEqualTo: self constant)
                ifTrue: [ self _unsatisfiableQuery ]
                ifFalse: [ self _unsatisfiableQuery ] ] ].
      (op2 == #'=' or: [ op2 == #'==' ])
        ifTrue: [
          " op2: = or op2: =="
          op1 == #'<'
            ifTrue: [
              " op1: < "
              ^ (self constant _idxForCompareLessThan: primaryPredicate constant)
                ifTrue: [ self ]
                ifFalse: [ nil ] ].
          op1 == #'<='
            ifTrue: [
              " op1: <= "
              ^ (self constant
                _idxForCompareLessThanOrEqualTo: primaryPredicate constant)
                ifTrue: [ self ]
                ifFalse: [ nil ] ].
          op1 == #'>'
            ifTrue: [
              " op1: > "
              ^ (self constant
                _idxForCompareGreaterThan: primaryPredicate constant)
                ifTrue: [ self ]
                ifFalse: [ nil ] ].
          op1 == #'>='
            ifTrue: [
              " op1: >= "
              ^ (self constant
                _idxForCompareGreaterThanOrEqualTo: primaryPredicate constant)
                ifTrue: [ self ]
                ifFalse: [ nil ] ].
          op1 == #'~='
            ifTrue: [
              " op1: ~= "
              ^ (self constant _idxForCompareEqualTo: primaryPredicate constant)
                ifTrue: [ self _unsatisfiableQuery ]
                ifFalse: [ self _unsatisfiableQuery ] ] ] ].
  ^ nil

]

{ #category : 'optimizing' }
GsPathConstantPredicate >> redundantPredicateBetween: secondaryPredicate [
  ^ secondaryPredicate redundantPredicateBetweenPathConstant: self

]

{ #category : 'optimizing' }
GsPathConstantPredicate >> redundantPredicateBetweenPathConstant: primaryPredicate [
  | op1 op2 |
  (primaryPredicate operand1 hasSamePathAs: self operand1)
    ifTrue: [
      primaryPredicate operand1 hasEnumeratedTerm
        ifTrue: [ ^ nil ] ]
    ifFalse: [ ^ nil ].
  (primaryPredicate isConstantBound and: [ self isConstantBound ])
    ifFalse: [ ^ nil ].
  (primaryPredicate constant == nil or: [ self constant == nil ])
    ifTrue: [ ^ nil ].
  op1 := primaryPredicate operator.
  op2 := self operator.
  op1 == op2
    ifTrue: [
      " operators are the same "
      (op1 == #'<' or: [ op1 == #'<=' ])
        ifTrue: [
          " operator: < or <= "
          " choose smallest value "
          ^ (primaryPredicate constant _idxForCompareLessThan: self constant)
            ifTrue: [ self ]
            ifFalse: [ primaryPredicate ] ].
      (op1 == #'>' or: [ op1 == #'>=' ])
        ifTrue: [
          " operator: > or >= "
          " choose largest value "
          ^ (primaryPredicate constant _idxForCompareGreaterThan: self constant)
            ifTrue: [ self ]
            ifFalse: [ primaryPredicate ] ].
      op1 == #'='
        ifTrue: [
          " operator: = "
          ^ (primaryPredicate constant _idxForCompareEqualTo: self constant)
            ifTrue: [ self ]
            ifFalse: [ self _unsatisfiableQuery ] ].
      op1 == #'~='
        ifTrue: [
          " operator: = "
          ^ (primaryPredicate constant _idxForCompareEqualTo: self constant)
            ifTrue: [ self ]
            ifFalse: [ nil ] ].
      op1 == #'=='
        ifTrue: [
          " operator: == "
          ^ primaryPredicate constant == self constant
            ifTrue: [ self ]
            ifFalse: [ self _unsatisfiableQuery ] ].
      op1 == #'~~'
        ifTrue: [
          " operator: == "
          ^ primaryPredicate constant == self constant
            ifTrue: [ self ]
            ifFalse: [ nil ] ] ]
    ifFalse: [
      " operators are different "
      ((op1 == #'<' and: [ op2 == #'<=' ])
        or: [ op1 == #'<=' and: [ op2 == #'<' ] ])
        ifTrue: [
          " op1: < and op2: <= "
          " op1: <= and op2: < "
          " choose smallest value "
          ^ (primaryPredicate constant _idxForCompareLessThan: self constant)
            ifTrue: [ self ]
            ifFalse: [
              (primaryPredicate constant _idxForCompareGreaterThan: self constant)
                ifTrue: [ primaryPredicate ]
                ifFalse: [
                  " operands are = "
                  op1 == #'<'
                    ifTrue: [ self ]
                    ifFalse: [ primaryPredicate ] ] ] ].
      ((op1 == #'>' and: [ op2 == #'>=' ])
        or: [ op1 == #'>=' and: [ op2 == #'>' ] ])
        ifTrue: [
          " op1: > and op2: >= "
          " op1: >= and op2: > "
          " choose largest value "
          ^ (primaryPredicate constant _idxForCompareGreaterThan: self constant)
            ifTrue: [ self ]
            ifFalse: [
              (primaryPredicate constant _idxForCompareLessThan: self constant)
                ifTrue: [ primaryPredicate ]
                ifFalse: [
                  " operands are = "
                  op1 == #'>'
                    ifTrue: [ self ]
                    ifFalse: [ primaryPredicate ] ] ] ].
      ((op1 == #'=' and: [ op2 == #'==' ])
        or: [ op1 == #'==' and: [ op2 == #'=' ] ])
        ifTrue: [
          " op1: = and op2: == "
          " op1: == and op2: = "
          ^ primaryPredicate constant == self constant
            ifTrue: [
              op2 == #'=='
                ifTrue: [ primaryPredicate ]
                ifFalse: [ self ] ]
            ifFalse: [ self _unsatisfiableQuery ] ].
      ((op1 == #'==' and: [ op2 == #'~~' ])
        or: [ op1 == #'~~' and: [ op2 == #'==' ] ])
        ifTrue: [
          " op1: == and op2: ~~ "
          " op1: ~~ and op2: == "
          ^ primaryPredicate constant == self constant
            ifTrue: [ self _unsatisfiableQuery ]
            ifFalse: [
              op1 == #'=='
                ifTrue: [ self ]
                ifFalse: [ primaryPredicate ] ] ].
      (op1 == #'=' or: [ op1 == #'==' ])
        ifTrue: [
          " op1: = or op1: =="
          op2 == #'<'
            ifTrue: [
              " op2: < "
              ^ (primaryPredicate constant _idxForCompareLessThan: self constant)
                ifTrue: [ self ]
                ifFalse: [ self _unsatisfiableQuery ] ].
          op2 == #'<='
            ifTrue: [
              " op2: <= "
              ^ (primaryPredicate constant
                _idxForCompareLessThanOrEqualTo: self constant)
                ifTrue: [ self ]
                ifFalse: [ self _unsatisfiableQuery ] ].
          op2 == #'>'
            ifTrue: [
              " op2: > "
              ^ (primaryPredicate constant
                _idxForCompareGreaterThan: self constant)
                ifTrue: [ self ]
                ifFalse: [ self _unsatisfiableQuery ] ].
          op2 == #'>='
            ifTrue: [
              " op2: >= "
              ^ (primaryPredicate constant
                _idxForCompareGreaterThanOrEqualTo: self constant)
                ifTrue: [ self ]
                ifFalse: [ self _unsatisfiableQuery ] ].
          op2 == #'~='
            ifTrue: [
              " op2: ~= "
              ^ (primaryPredicate constant _idxForCompareEqualTo: self constant)
                ifTrue: [ self _unsatisfiableQuery ]
                ifFalse: [ self ] ] ].
      (op2 == #'=' or: [ op2 == #'==' ])
        ifTrue: [
          " op2: = or op2: =="
          op1 == #'<'
            ifTrue: [
              " op1: < "
              ^ (self constant _idxForCompareLessThan: primaryPredicate constant)
                ifTrue: [ primaryPredicate ]
                ifFalse: [ self _unsatisfiableQuery ] ].
          op1 == #'<='
            ifTrue: [
              " op1: <= "
              ^ (self constant
                _idxForCompareLessThanOrEqualTo: primaryPredicate constant)
                ifTrue: [ primaryPredicate ]
                ifFalse: [ self _unsatisfiableQuery ] ].
          op1 == #'>'
            ifTrue: [
              " op1: > "
              ^ (self constant
                _idxForCompareGreaterThan: primaryPredicate constant)
                ifTrue: [ primaryPredicate ]
                ifFalse: [ self _unsatisfiableQuery ] ].
          op1 == #'>='
            ifTrue: [
              " op1: >= "
              ^ (self constant
                _idxForCompareGreaterThanOrEqualTo: primaryPredicate constant)
                ifTrue: [ primaryPredicate ]
                ifFalse: [ self _unsatisfiableQuery ] ].
          op1 == #'~='
            ifTrue: [
              " op1: ~= "
              ^ (self constant _idxForCompareEqualTo: primaryPredicate constant)
                ifTrue: [ self _unsatisfiableQuery ]
                ifFalse: [ primaryPredicate ] ] ] ].
  ^ nil

]
