Extension { #name : 'GsPreparedRangeQueryPredicate' }

{ #category : 'querying-private' }
GsPreparedRangeQueryPredicate >> elementValue: anObject [
  "the pathTerms in the query will use anObject as the starting point ... analagous to an object in the nsc that is bound to a query"

  "with a set-valued path term, we may get multiple evaluations of the block ... a value along the path will result in no evaluation of the block"

  preparedEvaluator
    traverse: anObject
    cachedOffsets: cachedOffsets
    cachedClasses: cachedClasses
    do: [ :resolvedObject | (preparedConstant1 perform: preparedOperator1 with: resolvedObject)
    & (resolvedObject perform: preparedOperator2 with: preparedConstant2)
        ifTrue: [ ^ true ] ].
  ^ false

]

{ #category : 'private' }
GsPreparedRangeQueryPredicate >> prepare [
  "cache all of the objects needed for repeated evaluation within a loop"

  | ivOffsetCache |
  self evaluator optimizingComparison
    ifTrue: [ self isNormal
        ifTrue: [ preparedOperator1 := self operator1.
          preparedOperator2 := self operator2 ]
        ifFalse: [ preparedOperator1 := self inverseOperatorFor: self operator1.
          preparedOperator2 := self inverseOperatorFor: self operator2 ] ]
    ifFalse: [ self isNormal
        ifTrue: [ preparedOperator1 := self comparisonSelectorFor: self operator1.
          preparedOperator2 := self comparisonSelectorFor: self operator2 ]
        ifFalse: [ preparedOperator1 := self
            comparisonSelectorFor: (self inverseOperatorFor: self operator1).
          preparedOperator2 := self
            comparisonSelectorFor: (self inverseOperatorFor: self operator2) ] ].
  preparedConstant1 := self constant1.
  preparedConstant2 := self constant2.
  preparedEvaluator := self elementValueEvaluator.
  preparedEvaluatorSize := preparedEvaluator size.
  ivOffsetCache := preparedEvaluator _createIvOffsetCache.
  cachedClasses := ivOffsetCache at: 1.
  cachedOffsets := ivOffsetCache at: 2

]
