Extension { #name : 'GsQueryGrammar' }

{ #category : 'instance creation' }
GsQueryGrammar class >> parseFormula: aString [
  ^ self new parseFormula: aString

]

{ #category : 'instance creation' }
GsQueryGrammar class >> parseFormula: aString onError: aBlock [
  ^ self new parseFormula: aString onError: aBlock

]

{ #category : 'grammar-messages' }
GsQueryGrammar >> andBlock [
  ^ [ :predicate1 :operator :predicate2 |
  {predicate1.
  operator.
  predicate2} ]

]

{ #category : 'grammar-literals' }
GsQueryGrammar >> arrayItem [
  ^ literal / symbolLiteralArray / arrayLiteralArray / byteLiteralArray

]

{ #category : 'grammar-literals' }
GsQueryGrammar >> arrayLiteral [
  ^ '#(' asParser queryToken , arrayItem star , $) asParser queryToken

]

{ #category : 'grammar-literals' }
GsQueryGrammar >> arrayLiteralArray [
  ^ $( asParser queryToken , arrayItem star , $) asParser queryToken

]

{ #category : 'primitives' }
GsQueryGrammar >> binary [
	^ (PPPredicateObjectParser anyOf: '!%&*+,-/<=>?@\|~') plus

]

{ #category : 'grammar-literals' }
GsQueryGrammar >> byteLiteral [
  ^ '#[' asParser queryToken , numberLiteral star , $] asParser queryToken

]

{ #category : 'grammar-literals' }
GsQueryGrammar >> byteLiteralArray [
  ^ $[ asParser queryToken , numberLiteral star , $] asParser queryToken

]

{ #category : 'primitives' }
GsQueryGrammar >> char [
	^ $$ asParser , #any asParser

]

{ #category : 'grammar-literals' }
GsQueryGrammar >> charLiteral [
	^ charToken

]

{ #category : 'token' }
GsQueryGrammar >> charToken [
  ^ char queryToken

]

{ #category : 'grammar-messages' }
GsQueryGrammar >> expression [
  | exp |
  exp := PPExpressionParser new.
  exp term: parenExpression / parenPredicate.
  exp
    group: [ :g |
          g
            postfix:
              (notToken
                handleGsQueryErrorMessage: '$|, $&, or not expected'
                nestMessages: false)
            do: self notBlock ];
    group: [ :g |
          g left: $| asParser token trim do: self orBlock.
          g left: $& asParser token trim do: self andBlock ].
  ^ predicateExpression / exp

]

{ #category : 'grammar-literals' }
GsQueryGrammar >> falseLiteral [
	^ falseToken

]

{ #category : 'token' }
GsQueryGrammar >> falseToken [
  ^ ('false' asParser , #'word' asParser not) queryToken

]

{ #category : 'primitives' }
GsQueryGrammar >> identifier [
  ^ (PPPredicateObjectParser
    on: [ :each | each isLetter or: [ each == $_ ] ]
    message: 'letter expected')
    ,
      (PPPredicateObjectParser
        on: [ :each | each isAlphaNumeric or: [ each == $_ ] ]
        message: 'letter or digit expected') star

]

{ #category : 'token' }
GsQueryGrammar >> identifierToken [
  ^ primaryIdentifier queryToken

]

{ #category : 'grammar' }
GsQueryGrammar >> literal [
  ^ numberLiteral / stringLiteral / charLiteral / arrayLiteral / byteLiteral
    / symbolLiteral / nilLiteral / trueLiteral / falseLiteral

]

{ #category : 'grammar-literals' }
GsQueryGrammar >> nilLiteral [
	^ nilToken

]

{ #category : 'token' }
GsQueryGrammar >> nilToken [
  ^ ('nil' asParser , #'word' asParser not) queryToken

]

{ #category : 'primitives' }
GsQueryGrammar >> not [
  ^ 'not' asParser , #'word' asParser not

]

{ #category : 'grammar-messages' }
GsQueryGrammar >> notBlock [
  ^ [ :a :b |
  {a.
  b} ]

]

{ #category : 'grammar-messages' }
GsQueryGrammar >> notMessage [
  ^ notToken ==> [ :node | { { node } . { } } ]

]

{ #category : 'token' }
GsQueryGrammar >> notToken [
  ^ not queryToken

]

{ #category : 'primitives' }
GsQueryGrammar >> number [
  ^ ($- asParser optional , #'digit' asParser) and
    ,
      [ :stream |
      [ Number fromStream: stream ]
        on: Error
        do: [ :err | PPFailure message: err messageText at: stream position ] ]
        asParser

]

{ #category : 'grammar-literals' }
GsQueryGrammar >> numberLiteral [
	^ numberToken

]

{ #category : 'token' }
GsQueryGrammar >> numberToken [
  ^ number queryToken

]

{ #category : 'grammar-messages' }
GsQueryGrammar >> orBlock [
  ^ [ :predicate1 :operator :predicate2 |
  {predicate1.
  {{{operator}.
  {predicate2}}}} ]

]

{ #category : 'grammar-literals' }
GsQueryGrammar >> parenExpression [
  ^ $( asParser queryToken , expression , $) asParser queryToken

]

{ #category : 'grammar-literals' }
GsQueryGrammar >> parenPredicate [
  ^ $( asParser queryToken , predicateExpression , $) asParser queryToken

]

{ #category : 'parsing' }
GsQueryGrammar >> parseFormula: aString [
  ^ self
    parseFormula: aString
    onError: [ :msg :pos | GsQueryParseError signal: msg , ' at position ' , pos printString position: pos ]

]

{ #category : 'parsing' }
GsQueryGrammar >> parseFormula: aString onError: aBlock [
  ^ self start parse: aString onError: aBlock

]

{ #category : 'grammar-messages' }
GsQueryGrammar >> path [
  ^ primaryIdentifier , ($. asParser , identifier) plus

]

{ #category : 'grammar-messages' }
GsQueryGrammar >> pathToken [
  ^ path queryToken

]

{ #category : 'grammar-messages' }
GsQueryGrammar >> predicateExpression [
  ^ rangePredicateExpression / simplePredicateExpression

]

{ #category : 'grammar-messages' }
GsQueryGrammar >> predicateMessage [
  ^ ((relopToken
    handleGsQueryErrorMessage: 'relational operator expected'
    nestMessages: false) , primary)
    ==> [ :nodes |
      {{(nodes first)}.
      {(nodes at: 2)}} ]

]

{ #category : 'grammar' }
GsQueryGrammar >> primary [
  ^ queryPathToken / pathToken / literal / variable
    handleGsQueryErrorMessage: 'queryPath, path, literal or variable expected'
    nestMessages: false

]

{ #category : 'grammar' }
GsQueryGrammar >> primaryIdentifier [
  ^ 'each' asParser not , identifier

]

{ #category : 'grammar-messages' }
GsQueryGrammar >> queryPath [
  ^ 'each' asParser
    ,
      ($. asParser
        ,
          (('#' asParser , identifier) / (identifier , '|' asParser , identifier)
            / identifier)
        ,
          ($. asParser
            ,
              (('#' asParser , identifier) / (identifier , '|' asParser , identifier)
                / '*' asParser / identifier))
            star
        min: 0)

]

{ #category : 'grammar-messages' }
GsQueryGrammar >> queryPathToken [
  ^ queryPath queryToken

]

{ #category : 'grammar-messages' }
GsQueryGrammar >> rangePredicateExpression [
  ^ rangePrimary
    ,
      (relopToken
        handleGsQueryErrorMessage: 'relational operator expected'
        nestMessages: false)
    , queryPathToken
    ,
      (relopToken
        handleGsQueryErrorMessage: 'relational operator expected'
        nestMessages: false)
    , rangePrimary

]

{ #category : 'grammar' }
GsQueryGrammar >> rangePrimary [
  ^ pathToken / literal / variable
    handleGsQueryErrorMessage: 'path, literal or variable expected'
    nestMessages: false

]

{ #category : 'primitives' }
GsQueryGrammar >> relop [
  ^ '<=' asParser / '<' asParser / '>=' asParser / '>' asParser / '==' asParser
    / '=' asParser / '~=' asParser / '~~' asParser

]

{ #category : 'token' }
GsQueryGrammar >> relopToken [
  ^ relop queryToken

]

{ #category : 'grammar-messages' }
GsQueryGrammar >> simplePredicateExpression [
  ^ primary , (predicateMessage min: 0 max: 1)

]

{ #category : 'primitives' }
GsQueryGrammar >> start [
  "Default start production."

  ^ expression end handleGsQueryErrorMessage: 'invalid query expression'

]

{ #category : 'primitives' }
GsQueryGrammar >> string [
	^ $' asParser , ('''''' asParser / $' asParser negate) star , $' asParser

]

{ #category : 'grammar-literals' }
GsQueryGrammar >> stringLiteral [
	^ stringToken

]

{ #category : 'token' }
GsQueryGrammar >> stringToken [
  ^ string queryToken

]

{ #category : 'primitives' }
GsQueryGrammar >> symbol [
  ^ identifier / binary / string

]

{ #category : 'grammar-literals' }
GsQueryGrammar >> symbolLiteral [
  ^ ($# asParser queryToken plus , symbol queryToken)
    ==> [ :tokens | tokens first copyWith: tokens last ]

]

{ #category : 'grammar-literals' }
GsQueryGrammar >> symbolLiteralArray [
  ^ symbol queryToken

]

{ #category : 'grammar-literals' }
GsQueryGrammar >> trueLiteral [
	^ trueToken

]

{ #category : 'token' }
GsQueryGrammar >> trueToken [
  ^ ('true' asParser , #'word' asParser not) queryToken

]

{ #category : 'grammar' }
GsQueryGrammar >> variable [
	^ identifierToken

]
