Extension { #name : 'GsQueryLiteralArray' }

{ #category : 'accessing' }
GsQueryLiteralArray >> _idxValue [
  | array |
  array := (isByteArray
    ifTrue: [ ByteArray ]
    ifFalse: [ Array ]) new: contents size.
  1 to: contents size do: [ :index | array at: index put: (contents at: index) _idxValue ].
  ^ array

]

{ #category : 'converting' }
GsQueryLiteralArray >> asFormula [
  self errorConstantPredicateMustBeBoolean

]

{ #category : 'accessing' }
GsQueryLiteralArray >> contents [
  ^ contents

]

{ #category : 'accessing' }
GsQueryLiteralArray >> contents: anArray [
  contents := anArray

]

{ #category : 'accessing' }
GsQueryLiteralArray >> isByteArray [
  ^ isByteArray

]

{ #category : 'accessing' }
GsQueryLiteralArray >> isByteArray: aBool [
  isByteArray := aBool

]

{ #category : 'accessing' }
GsQueryLiteralArray >> valuePrintOn: aStream [
  isByteArray
    ifTrue: [ aStream nextPutAll: '#[ ' ]
    ifFalse: [ aStream nextPutAll: '#( ' ].
  1 to: contents size do: [ :index |
    (contents at: index) valuePrintOn: aStream.
    aStream space ].
  isByteArray
    ifTrue: [ aStream nextPutAll: ']' ]
    ifFalse: [ aStream nextPutAll: ')' ]

]
