Extension { #name : 'GsSingleRefPathFinderForObject' }

{ #category : 'Instance Creation' }
GsSingleRefPathFinderForObject class >> newForSearchObject: anObject refPathFinder: aFinder [

|result|
result := self new.
result initializeForSearchObject: anObject refPathFinder: aFinder.
^ result

]

{ #category : 'Results' }
GsSingleRefPathFinderForObject >> buildPathToDefaultLimitSet [

^ self buildPathToDefaultLimitSetStartingAt: refPathFinder limitObjects size

]

{ #category : 'Results' }
GsSingleRefPathFinderForObject >> buildPathToDefaultLimitSetStartingAt: index [

"Build the reference path going from an object referenced by a descendant of
 the default limit set up to an object in the default limit set."

| result childObj limitObjsArray |
result := Array new.
childObj := limitOopsFound peek.
"Caller will add the first object in limitOopsFound to the path.  Do not do it here."
limitObjsArray := refPathFinder limitObjects.
(index - 1) downTo: 1 do:[:n| | parent bm |
  bm := limitObjsArray at: n.
  parent := bm primFirstObjectThatReferences: childObj.
  parent ifNil:[
    "This should never happen"
    self halt:
     'Logic error: no references to child object found in set of limit object descendants'].
  result add: parent.
  childObj := parent.
].
^ result reverse

]

{ #category : 'Results' }
GsSingleRefPathFinderForObject >> buildReferencePath [

| result nextObject index done|

(isDead or:[ completed not]) ifTrue:[ ^ Array new ].

result := self buildPathToDefaultLimitSet .
index := parentBitmaps size.
nextObject := limitOopsFound peek.
done := nextObject == nil.
[done] whileFalse:[ |nextObjectChildren childrenInPath intersection|
  result add: nextObject.
  nextObjectChildren := (GsBitmap with: nextObject) primReferencedObjects.
  childrenInPath := parentBitmaps at: index.
  intersection := nextObjectChildren * childrenInPath.
  intersection isEmpty ifTrue:[ self halt: 'unexpected empty intersection'].
  done := intersection includes: searchOop.
  nextObject := intersection peek.
  index := index - 1.
].
result add: searchOop.
^ result

]

{ #category : 'Results' }
GsSingleRefPathFinderForObject >> buildResultObject [

resultObject == nil
  ifTrue:[
    resultObject := GsSingleRefPathResult
         newForSearchObject: searchOop
         isDead: isDead
         path: self buildReferencePath].
^ resultObject

]

{ #category : 'Logging' }
GsSingleRefPathFinderForObject >> buildSummaryHeader [

| msg |
msg := String withAll: '   Summary for search oop '.
msg
addAll: searchOop asOop asString;
add: Character lf.
^msg

]

{ #category : 'Scanning' }
GsSingleRefPathFinderForObject >> childrenToFind [

"Answer a GsBitmap of the children to search for in the next scan, or nil if
 the scan is finished"

^ completed ifTrue:[nil] ifFalse:[ parentBitmaps last].

]

{ #category : 'Accessing' }
GsSingleRefPathFinderForObject >> completed [
^completed

]

{ #category : 'Updating' }
GsSingleRefPathFinderForObject >> completed: newValue [
completed := newValue

]

{ #category : 'Scanning' }
GsSingleRefPathFinderForObject >> handleLimitSetDescendantsWithSearchObject [

| limitObjectsArray |
limitObjectsArray := refPathFinder limitObjects.
2 to: limitObjectsArray size do:[:n |
  ((limitObjectsArray at: n) includes: searchOop) ifTrue:[ | path |
    limitOopsFound := GsBitmap with: searchOop.
    path := self buildPathToDefaultLimitSetStartingAt: n.
    path add: searchOop.
    resultObject := GsSingleRefPathResult
       newForSearchObject: searchOop
       isDead: false
       path: path.
    self setReferencePathFound.
    ^self]
].
^self

]

{ #category : 'Initialization' }
GsSingleRefPathFinderForObject >> initializeForSearchObject: anObject refPathFinder: finderObj [

completed := false.
isDead := false.
refPathFinder := finderObj.
limitOopsFound := nil.
searchOopsUnion := GsBitmap new.
searchOop := anObject.
parentBitmaps := Array with: (GsBitmap with: anObject).
^ self

]

{ #category : 'Accessing' }
GsSingleRefPathFinderForObject >> isDead [
^isDead

]

{ #category : 'Updating' }
GsSingleRefPathFinderForObject >> isDead: newValue [
isDead := newValue

]

{ #category : 'Accessing' }
GsSingleRefPathFinderForObject >> limitObjects [

^ refPathFinder limitObjects last.

]

{ #category : 'Accessing' }
GsSingleRefPathFinderForObject >> limitOopsFound [
^limitOopsFound

]

{ #category : 'Updating' }
GsSingleRefPathFinderForObject >> limitOopsFound: newValue [
limitOopsFound := newValue

]

{ #category : 'Logging' }
GsSingleRefPathFinderForObject >> logReferencePath [

refPathFinder printToLog
   ifTrue:[ self buildResultObject logReferencePath ]


]

{ #category : 'Accessing' }
GsSingleRefPathFinderForObject >> parentBitmaps [
^parentBitmaps

]

{ #category : 'Updating' }
GsSingleRefPathFinderForObject >> parentBitmaps: newValue [
parentBitmaps := newValue

]

{ #category : 'Logging' }
GsSingleRefPathFinderForObject >> printScanCompleted [

refPathFinder printToLog ifTrue:[| msg |
  msg := self buildSummaryHeader.
  msg addAll: '      scan completed'.
  isDead ifTrue: [msg addAll: ' (object is dead)'].
  msg add: Character lf.
  GsFile gciLogServer: msg]

]

{ #category : 'Logging' }
GsSingleRefPathFinderForObject >> printScanSummary: parentOops [

refPathFinder printToLog ifTrue:[
  | msg numSeen numLimit scanCompleted oopIsDead parentsCopy |
  msg := self buildSummaryHeader.
  numLimit := parentOops intersectSize: self limitObjects.
  numSeen := parentOops intersectSize: searchOopsUnion.
  msg
    addAll: '      ';
    addAll: self childrenToFind size asString;
    addAll: ' child oops are referenced by ';
    addAll: parentOops size asString;
    addAll: ' parent oops (';
    addAll: numSeen asString;
    addAll: ' were already seen and ';
    addAll: numLimit asString;
    addAll: ' are limit objects)';
    add: Character lf.
  parentsCopy := parentOops copy.
  parentsCopy removeAll: self limitObjects.
  parentsCopy removeAll: searchOopsUnion.
  scanCompleted := parentsCopy isEmpty or:[numLimit > 0].
  parentsCopy removeAll .
  scanCompleted
    ifTrue:[
      oopIsDead := numLimit == 0.
      msg addAll: '      *** Scan completed ***'.
      oopIsDead ifTrue: [msg addAll: ' (object is dead)'].
      msg addAll: ' Total time is ';
      addAll: self totalTime asString;
      addAll: ' seconds' ;
      add: Character lf].
  GsFile gciLogServer: msg]


]

{ #category : 'Scanning' }
GsSingleRefPathFinderForObject >> processResultsOfScan: parentOopsBm [

|limitOops|
self printScanSummary: parentOopsBm .
parentOopsBm removeAll: searchOopsUnion. "remove ones we've already seen"
parentOopsBm isEmpty
  ifTrue:[ ^ self setObjectIsDead ].

limitOops := parentOopsBm * self limitObjects .
limitOops isEmpty
ifTrue:[ parentBitmaps add: parentOopsBm]
ifFalse:[
  limitOopsFound := limitOops.
  self setReferencePathFound .
].
^ self

]

{ #category : 'Accessing' }
GsSingleRefPathFinderForObject >> refPathFinder [
^refPathFinder

]

{ #category : 'Updating' }
GsSingleRefPathFinderForObject >> refPathFinder: newValue [
refPathFinder := newValue

]

{ #category : 'Accessing' }
GsSingleRefPathFinderForObject >> resultObject [
^resultObject

]

{ #category : 'Updating' }
GsSingleRefPathFinderForObject >> resultObject: newValue [
resultObject := newValue

]

{ #category : 'Accessing' }
GsSingleRefPathFinderForObject >> searchOop [
^searchOop

]

{ #category : 'Updating' }
GsSingleRefPathFinderForObject >> searchOop: newValue [
searchOop := newValue

]

{ #category : 'Accessing' }
GsSingleRefPathFinderForObject >> searchOopsUnion [
^searchOopsUnion

]

{ #category : 'Updating' }
GsSingleRefPathFinderForObject >> searchOopsUnion: newValue [
searchOopsUnion := newValue

]

{ #category : 'Updating' }
GsSingleRefPathFinderForObject >> setObjectIsDead [

completed := true. "no unique parents found.  object is dead"
isDead := true.
refPathFinder completedOneSearch.
^ self

]

{ #category : 'Updating' }
GsSingleRefPathFinderForObject >> setReferencePathFound [

completed := true.
refPathFinder completedOneSearch.
self logReferencePath.
^ self

]

{ #category : 'Logging' }
GsSingleRefPathFinderForObject >> totalTime [

^System timeGmt2005 - refPathFinder scanStartTime

]

{ #category : 'Scanning' }
GsSingleRefPathFinderForObject >> updateSearchOopsUnion [

"Add parent objects found in the previous scan to searchOopsUnion"
completed ifFalse:[ searchOopsUnion addAll: parentBitmaps last].

]
