Extension { #name : 'GsStreamableConjunctiveClauseChecker' }

{ #category : 'instance creation' }
GsStreamableConjunctiveClauseChecker class >> check: aFormula on: anNsc [
  ^ self new
    formula: aFormula;
    nsc: anNsc;
    queryOptions: GsQueryOptions default;
    check

]

{ #category : 'visiting' }
GsStreamableConjunctiveClauseChecker >> acceptPredicate: aPredicate [
  "streamable predicate:
  1. path-constant predicate (i.e., not path-path predicate)
  2. RangeEqualityIndex evaluator ... (not really valid for GsQuery, but could defer
     readstream on PathEvaluator if too much implementation involved)
  3. use range or equality operation for legacy indexes (#== or #~~ or #~= not allowed)
  4. use range, equality or identity operations for btree plus indexes (#~~ or #~= not allowed)
"

  aPredicate isPathPath
    ifTrue: [
      ^ GsMalformedQueryExpressionError
        queryIsNotStreamable:
          'Query with path-path predicate: ' , aPredicate printString printString
            , ' is not streamable.'
        senderLocationID: #'acceptPredicate:' ].
  aPredicate isConstantConstant
    ifTrue: [
      ^ GsMalformedQueryExpressionError
        queryIsNotStreamable:
          'Query with constant-constant predicate: ' , aPredicate printString printString
            , ' is not streamable.'
        senderLocationID: #'acceptPredicate:' ].
  aPredicate usesPathEvaluator
    ifTrue: [
      ^ GsMalformedQueryExpressionError
        queryIsNotStreamable:
          'Predicate: ' , aPredicate printString printString
            , ' must use an equality index or a  btreePlus identity index.'
        senderLocationID: #'acceptPredicate:' ].
  (aPredicate _evaluatorCanStreamQueries
    and: [
      aPredicate usesIdenticalToOperation
        or: [ aPredicate usesEqualOperation or: [ aPredicate usesComparisonOperation ] ] ])
    ifFalse: [
      ^ GsMalformedQueryExpressionError
        queryIsNotStreamable:
          'Predicate: ' , aPredicate printString printString
            ,
              ' must use an equality (#= #==) or comparison operator (#<= #< #> #>=).'
        senderLocationID: #'acceptPredicate:' ].
  super acceptPredicate: aPredicate

]

{ #category : 'checking' }
GsStreamableConjunctiveClauseChecker >> check [
  "streamable predicate:
  1. path-constant predicate (i.e., not path-path predicate)
  2. RangeEqualityIndex evaluator ... (not really valid for GsQuery, but could defer
     readstream on PathEvaluator if too much implementation involved)
  3. use range or equality operation for legacy indexes (#== or #~~ or #~= not allowed)
  4. use range, equality or identity operations for btree plus indexes (#~~ or #~= not allowed)
  5. 1 predicate (range predicate allowed)
"

  self visitFormula: self formula.
  self predicates size > 1
    ifTrue: [
      ^ GsMalformedQueryExpressionError
        queryIsNotStreamable:
          'Clause ' , self formula printString printString
            , ' must have a single predicate'
        senderLocationID: #'acceptPredicate:' ]

]
