Extension { #name : 'GsStreamableQueryChecker' }

{ #category : 'instance creation' }
GsStreamableQueryChecker class >> check: aFormula on: anNsc [
  ^ self new
    formula: aFormula;
    nsc: anNsc;
    queryOptions: GsQueryOptions default;
    check

]

{ #category : 'checking' }
GsStreamableQueryChecker >> check [
  self formula isConjunctiveNormalForm
    ifTrue: [ self checkConjunctiveClause: self formula ]
    ifFalse: [
      "If clause is not in conjunctive normal form,  applyDeMorgansLaws has not been applied to transform the formula. Cannot properly determine whether or not a readStream can be used if applyDeMorgansLaws and consolidateRangePredicates options not set."
      (queryOptions applyDeMorgansLaws and: [ queryOptions consolidateRangePredicates ])
        ifTrue: [
          GsMalformedQueryExpressionError
            queryIsNotStreamable:
              'Clause ' , self formula printString printString,
              ' must have a single predicate and this clause cannot be reduced to a single predicate by the query optimizer.'
        senderLocationID: #'check' ]
        ifFalse: [ GsMalformedQueryExpressionError streamableQueryCannotBeAnalyzed: #'check' ] ]

]

{ #category : 'checking' }
GsStreamableQueryChecker >> checkConjunctiveClause: aClause [
  GsStreamableConjunctiveClauseChecker check: aClause on: self nsc

]
