"
GsX509ExternalSession is a variant of GsExternalSession which uses an X509 certificate as
login credentials rather than a user id and password.

Example:

| p s |
p := GemStoneX509Parameters
      newFromPemFilesWithNetldiPort: '54321'
      netldiHost: 'localhost'
      certificate: 'DataCurator.chain.pem'
      caCertificate: 'stoneCA-gs64stone.cert.pem'
      privateKey: 'DataCurator.privkey.pem' .
s := GsX509ExternalSession newWithX509Parameters: p.
s login .


"
Class {
	#name : 'GsX509ExternalSession',
	#superclass : 'GsExternalSession',
	#instVars : [
		'username'
	],
	#category : 'X509'
}

{ #category : 'Instance Creation' }
GsX509ExternalSession class >> gemNRS: gemNRS stoneNRS: stoneNRS username: aUsername password: aPassword [

"Disallowed"

self shouldNotImplement: #gemNRS:stoneNRS:username:password:

]

{ #category : 'Instance Creation' }
GsX509ExternalSession class >> gemNRS: gemNRS stoneNRS: stoneNRS username: gsUsername password: gsPassword hostUsername: hostUsername hostPassword: hostPassword [

"Disallowed"

self shouldNotImplement: #gemNRS:stoneNRS:username:password:hostUsername:hostPassword:

]

{ #category : 'Instance Creation' }
GsX509ExternalSession class >> newDefault [

self shouldNotImplement: #newDefault

]

{ #category : 'Instance Creation' }
GsX509ExternalSession class >> newWithX509Parameters: aGemStoneX509Parameters [

self gciLibrary .
^ self new initializeWithX509Parameters: aGemStoneX509Parameters

]

{ #category : 'Private' }
GsX509ExternalSession >> _gemHost [

^ parameters netldiHost

]

{ #category : 'Parameters' }
GsX509ExternalSession >> gemNRS: anNRS [

  self shouldNotImplement: #gemNRS:

]

{ #category : 'Parameters' }
GsX509ExternalSession >> hostPassword: aString [

  self shouldNotImplement: #hostPassword:

]

{ #category : 'Parameters' }
GsX509ExternalSession >> hostUsername: aString [

  self shouldNotImplement: #hostUsername:

]

{ #category : 'Private' }
GsX509ExternalSession >> initialize [

^ self initializeWithX509Parameters: GemStoneX509Parameters new

]

{ #category : 'Private' }
GsX509ExternalSession >> initializeDefaultResources [

self shouldNotImplement: #initializeDefaultResources

]

{ #category : 'Private' }
GsX509ExternalSession >> initializeWithX509Parameters: aGemStoneX509Parameters [

	gciErrSType := self class gciErrSTypeClass new.
	parameters := aGemStoneX509Parameters .
	self loggingToServer.

]

{ #category : 'Public' }
GsX509ExternalSession >> login [

	| result lib |
	stoneSessionId ifNotNil: [
		ImproperOperation signal: 'Stone session ' , stoneSessionId printString ,
			' already associated with this GsX509ExternalSession!'.
	].

  lib := self _gciLibrary .
       result := lib GciX509Login_: parameters asGciX509LoginArg .
	0 == result ifTrue: [
    self _signalIfError: lib .
		self error: 'Login failed for unknown reason!'.
	].
	gciSessionId := self _gciLibrary GciGetSessionId.
  self _postLogin: lib  .
  username := self executeString:'System myUserProfile userId' .
	self log: 'GsX509ExternalSession login: ' , self _describe.

]

{ #category : 'Parameters' }
GsX509ExternalSession >> password: aString [
  self shouldNotImplement: #password:

]

{ #category : 'Parameters' }
GsX509ExternalSession >> stoneNRS: anNRS [

  self shouldNotImplement: #stoneNRS:

]

{ #category : 'Parameters' }
GsX509ExternalSession >> username [
  ^ username

]

{ #category : 'Parameters' }
GsX509ExternalSession >> username: aString [

 self shouldNotImplement: #username:

]
