"
A hash tree dictionary tree walker is dbTransient and specialized for use
as part of a TreeDictionary.
"
Class {
	#name : 'HtDictionaryTreeWalker',
	#superclass : 'HtTreeWalker',
	#gs_options : [
		'dbTransient'
	],
	#category : 'HashTree-Core'
}

{ #category : 'private-updating' }
HtDictionaryTreeWalker >> searchInternalNode: node isFinalSibling: nodeIsFinal forAt: key withHash: hash put: aValue [
	| child childIndex maxIndex nextHash newChildNode |
	childIndex := node lowestChildIndexForHash: hash.
	nextHash := hash.
	maxIndex := node maxChildIndex.
	newChildNode := nil.
	[ nextHash = hash and: [ childIndex <= maxIndex and: [ found not ] ] ]
		whileTrue: [ 
			child := node at: childIndex.
			nextHash := node at: childIndex + 1.

			newChildNode := self
				searchNode: child
				isFinalSibling: (nodeIsFinal and: [ nextHash > hash ])
				forAt: key
				withHash: hash
				put: aValue.
			childIndex := childIndex + 2 ].
	nodeIsFinal
		ifFalse: [ ^ nil ].
	newChildNode ifNil: [ ^ nil ].
	node insertChildNode: newChildNode atIndex: childIndex.
	^ node isFull
		ifTrue: [ node split ]
		ifFalse: [ nil ]
]

{ #category : 'private-query' }
HtDictionaryTreeWalker >> searchLeafNode: node forValueAt: key withHash: hash [

	| index |
	index := node indexForKey: key withHash: hash.
	(node at: index) == nil ifFalse: [
		found := true.
		value := node at: index + 1 ]
]

{ #category : 'private-updating' }
HtDictionaryTreeWalker >> searchLeafNode: node isFinalSibling: nodeIsFinal forAt: key withHash: hash put: aValue [

	| index |
	index := node indexForKey: key withHash: hash.
	(node at: index) ifNotNil: [
		found := true.
		node at: index + 1 put: aValue.
		^ nil ].

	"If key is not yet found and I'm the last leaf to be searched, add the key/value pair."
	nodeIsFinal ifFalse: [ ^ nil ].
	node addKey: key value: aValue atKeyIndex: index.
	^ node isFull
		  ifTrue: [ node split ]
		  ifFalse: [ nil ]
]

{ #category : 'private-removing' }
HtDictionaryTreeWalker >> searchLeafNode: node isFinalSibling: nodeIsFinal forRemoveKey: key withHash: hash [
	| index |
	index := node indexForKey: key withHash: hash.
	(node at: index)
		ifNotNil: [ 
			found := true.
			value := node at: index + 1.
			node removeKeyAt: index ].
	^ node percentFull
]

{ #category : 'private-updating' }
HtDictionaryTreeWalker >> searchNode: node isFinalSibling: nodeIsFinal forAt: key withHash: hash put: aValue [

	^ node isLeaf
		  ifTrue: [
			  self
				  searchLeafNode: node
				  isFinalSibling: nodeIsFinal
				  forAt: key
				  withHash: hash
				  put: aValue ]
		  ifFalse: [
			  self
				  searchInternalNode: node
				  isFinalSibling: nodeIsFinal
				  forAt: key
				  withHash: hash
				  put: aValue ]
]

{ #category : 'public' }
HtDictionaryTreeWalker >> searchTree: rootNode at: key withHash: hash put: aValue [
	"Root node has no siblings, so is always the final sibling."

	| newNode |
	found := false.
	newNode := self
		searchNode: rootNode
		isFinalSibling: true
		forAt: key
		withHash: hash
		put: aValue.
	found := false.
	^ newNode
]
