Extension { #name : 'IndexDictionaryEntryHolder' }

{ #category : 'Instance Creation' }
IndexDictionaryEntryHolder class >> new [

"Returns a new instance of the receiver."

^ (super new: 2001) initialize

]

{ #category : 'Updating' }
IndexDictionaryEntryHolder >> addKey: aKey value: aValue term: pathTerm from: array at: index [

"Adds the given triplet to the receiver."

" see if the receiver is getting too large "
offset > 2001
  ifTrue: [ | newOne |

    " see if we've linked too many together "
    count == 10
      ifTrue: [
        " cause index dictionary to be updated "
        self update.
        self at: 1 put: aKey.
        self at: 2 put: aValue.
        self at: 3 put: pathTerm.
        offset := 4.
        link := nil.
        ^ self
      ].

    " create a new holder and link it to this one "
    newOne := self class new.
    newOne addKey: aKey value: aValue term: pathTerm from: array at: index.
    newOne link: self.
    newOne indexDictionary: indexDictionary.
    newOne count: count + 1.
    array at: index put: newOne.
    ^ newOne
  ].
self at: offset put: aKey.
self at: offset + 1 put: aValue.
self at: offset + 2 put: pathTerm.
offset := offset + 3.

]

{ #category : 'Updating' }
IndexDictionaryEntryHolder >> count: aValue [

"Sets the value of the 'count' instance variable."

count := aValue

]

{ #category : 'Updating' }
IndexDictionaryEntryHolder >> indexDictionary: aValue [

"Sets the value of the 'indexDictionary' instance variable."

indexDictionary := aValue

]

{ #category : 'Initialization' }
IndexDictionaryEntryHolder >> initialize [

"Initializes the receiver."

offset := 1.
count := 1.

]

{ #category : 'Updating' }
IndexDictionaryEntryHolder >> link: aValue [

"Sets the value of the 'link' instance variable."

link := aValue

]

{ #category : 'Updating' }
IndexDictionaryEntryHolder >> update [

"Updates the given index dictionary with all entries in the receiver."

" indicate that it is ok to update the dictionary "
indexDictionary okToUpdate: true.
1 to: offset - 1 by: 3 do: [ :i |
  indexDictionary _at: (self at: i)
    put: (self at: i + 1)
    term: (self at: i + 2)
    logging: false
].
link ~~ nil
  ifTrue: [ link update ].
" indicate that it is not ok to update the dictionary "
indexDictionary okToUpdate: false.

]
