"
JsonPetitParser is the class named JsonParser in earlier versions, using PetitParser. 
This has been replaced by a smaller, faster recursive decent parser implementation 
that now uses the name JsonParser. 
Subclasses of JsonParser from previous releases may need to be modified to be subclasses 
of JsonPetitParser.

JsonPetitParser is deprecated.


https://www.json.org/

json
    element

value
    object
    array
    string
    number
    ""true""
    ""false""
    ""null""

object
    '{' ws '}'
    '{' members '}'

members
    member
    member ',' members

member
    ws string ws ':' element

array
    '[' ws ']'
    '[' elements ']'

elements
    element
    element ',' elements

element
    ws value ws

string
    '""' characters '""'

characters
    """"
    character characters

character
    '0020' . '10ffff' - '""' - '\'
    '\' escape

escape
    '""'
    '\'
    '/'
    'b'
    'n'
    'r'
    't'
    'u' hex hex hex hex

hex
    digit
    'A' . 'F'
    'a' . 'f'

number
    int frac exp

int
    digit
    onenine digits
    '-' digit
    '-' onenine digits

digits
    digit
    digit digits

digit
    '0'
    onenine

onenine
    '1' . '9'

frac
    """"
    '.' digits

exp
    """"
    'E' sign digits
    'e' sign digits

sign
    """"
    '+'
    '-'

ws
    """"
    '0009' ws
    '000a' ws
    '000d' ws
    '0020' ws
"
Class {
	#name : 'JsonPetitParser',
	#superclass : 'PPCompositeParser',
	#instVars : [
		'array',
		'character',
		'element',
		'elements',
		'escape',
		'exp',
		'frac',
		'int',
		'json',
		'member',
		'members',
		'number',
		'object',
		'sign',
		'string',
		'value'
	],
	#category : 'Kernel'
}

{ #category : 'other' }
JsonPetitParser >> array [

	^((	$[ asParser , #space asParser star , $] asParser) 	==> [:tokens | #()])
	| ((	$[ asParser , elements , $] asParser) 					==> [:tokens | tokens at: 2])

]

{ #category : 'other' }
JsonPetitParser >> character [

	^(($\ asParser , escape) 											==> [:tokens | tokens at: 2])
	| (($" asParser not , $\ asParser not , #any asParser) 	==> [:tokens | tokens at: 3])

]

{ #category : 'other' }
JsonPetitParser >> element [

	^value trim

]

{ #category : 'other' }
JsonPetitParser >> elements [

	^(element , ($, asParser , elements) star) ==> [:tokens |
		(tokens at: 2) isEmpty
			ifTrue: [Array with: (tokens at: 1)]
			ifFalse: [(Array with: (tokens at: 1)) , (((tokens at: 2) at: 1) at: 2)]]

]

{ #category : 'other' }
JsonPetitParser >> escape [

	^$" asParser
	| $\ asParser
	| $/ asParser
	| ($b asParser ==> [:tokens | Character codePoint: 8])
	| ($n asParser ==> [:tokens | Character lf])
	| ($r asParser ==> [:tokens | Character cr])
	| ($t asParser ==> [:tokens | Character tab])
	| (($u asParser , (#hex asParser times: 4) flatten) ==> [:tokens | Character codePoint: ('16r' , (tokens at: 2)) asNumber])

]

{ #category : 'other' }
JsonPetitParser >> exp [

	^(($E asParser | $e asParser) , sign optional , #digit asParser plus) flatten

]

{ #category : 'other' }
JsonPetitParser >> frac [

	^($. asParser , #digit asParser plus flatten) ==> [:tokens | '.' , tokens last]

]

{ #category : 'other' }
JsonPetitParser >> int [

	^(sign optional , #digit asParser plus) flatten

]

{ #category : 'other' }
JsonPetitParser >> json [

	^element

]

{ #category : 'other' }
JsonPetitParser >> member [

	^(string trim , $: asParser , element) ==> [:tokens | (tokens at: 1) -> (tokens at: 3)]

]

{ #category : 'other' }
JsonPetitParser >> members [

	^(member , ($, asParser , members) star) ==> [:tokens |
		| assoc more |
		assoc := tokens at: 1.
		more := tokens at: 2.
		more isEmpty ifTrue: [
			Dictionary with: assoc
		] ifFalse: [
			((more at: 1) at: 2)	"ignore the comma"
				add: assoc;
				yourself.
		].
	]

]

{ #category : 'other' }
JsonPetitParser >> number [

	^(int , frac optional , exp optional) ==> [:tokens | ((tokens at: 1) , ((tokens at: 2) ifNil: ['']) , ((tokens at: 3) ifNil: [''])) asNumber]

]

{ #category : 'other' }
JsonPetitParser >> object [

	^((	${ asParser , #space asParser star , $} asParser) 	==> [:tokens | Dictionary new])
	| ((	${ asParser , members , $} asParser) 					==> [:tokens | tokens at: 2])

]

{ #category : 'other' }
JsonPetitParser >> sign [

	^$+ asParser
	| $- asParser

]

{ #category : 'other' }
JsonPetitParser >> start [

	^json

]

{ #category : 'other' }
JsonPetitParser >> string [

	^($" asParser , character star , $" asParser) ==> [:tokens | String withAll: (tokens at: 2)]

]

{ #category : 'other' }
JsonPetitParser >> value [

	^(array
	| object
	| string
	| ('true' asParser ==> [:tokens | true])
	| ('false' asParser ==> [:tokens | false])
	| ('null' asParser ==> [:tokens | nil])
	| number) memoized

]
