Extension { #name : 'OptionalPathTerm' }

{ #category : 'Traversing' }
OptionalPathTerm >> _getNextObjectForTraversal: anObject [
  " get the next object along the path "

  | ivOffset nextObj |
  ivOffset := anObject _findIVOffsetForPathTerm: self.
  ivOffset == nil
    ifTrue: [ nextObj := nil ]
    ifFalse: [ nextObj := anObject instVarAt: ivOffset ].
  ^ nextObj

]

{ #category : 'Private' }
OptionalPathTerm >> _mapInfoOrErrorForMissingIvOffset: anObject [
  "If missing path slots are tolerated, return an empty MappingInfo. Otherwise
   return an error array"

  ^ self _mappingInfoClass new pathTerm: self

]

{ #category : 'Accessing' }
OptionalPathTerm >> _nextObjectFor: anObject [
  "Returns the object at the instance variable that corresponds to the receiver
 path term."

  | ivOffset |
  ivOffset := self _ivOffsetFor: anObject.
  ivOffset ifNil: [ ^ nil ].
  ^ self _nextObjectFor: anObject atInstVar: ivOffset

]

{ #category : 'Audit' }
OptionalPathTerm >> auditDepListFor: obj index: indexObj on: aString [
  "Obsolete...use PathTerm>>auditDepListFor:index:on:optionalSentinel: instead"

  self shouldNotImplement: #'auditDepListFor:index:on:'

]

{ #category : 'Testing' }
OptionalPathTerm >> isOptionalTerm [
  ^ true

]

{ #category : 'Accessing' }
OptionalPathTerm >> requirePathTerms [
  "If missing path slots are tolerated, answer false"

  ^ false

]

{ #category : 'Testing' }
OptionalPathTerm >> termsRequired [
  "Answer true if receiver requires that instance variables of indexed objects are present "

  ^ false

]
