Extension { #name : 'PPActionParser' }

{ #category : 'instance creation' }
PPActionParser class >> on: aParser block: aBlock [
	^ (self on: aParser) setBlock: aBlock

]

{ #category : 'accessing' }
PPActionParser >> block [
	"Answer the action block of the receiver."

	^ block

]

{ #category : 'parsing' }
PPActionParser >> parseOn: aPPContext [
	| element |
	^ (element := parser parseOn: aPPContext) isPetitFailure
		ifFalse: [ block value: element ]
		ifTrue: [ element ]

]

{ #category : 'initialization' }
PPActionParser >> setBlock: aBlockOrSymbol [

	block := aBlockOrSymbol isSymbol
				ifFalse: [aBlockOrSymbol]
				ifTrue: [[:arg | arg perform: aBlockOrSymbol]]

]
