Extension { #name : 'RcRangeEqualityIndex' }

{ #category : 'Instance Creation' }
RcRangeEqualityIndex class >> newWithLastElementClass: aClass [

"Create a new instance and initialize its B-tree root."

| newOne |
newOne := super new.
newOne lastElementClass: aClass.
newOne btreeRoot: aClass rcBtreeLeafNodeClass new.
^ newOne

]

{ #category : 'Updating' }
RcRangeEqualityIndex >> _btreeAt: aKey put: aValue logging: aBoolean [


        ^self _btreeAt: aKey put: aValue logging: aBoolean selectiveAbortSet: nil

]

{ #category : 'Updating' }
RcRangeEqualityIndex >> _btreeAt: aKey put: aValue logging: aBoolean selectiveAbortSet: selectiveAbortSetOrNil [
  "Insert the key/value pair into the root B-tree node.  Must check to see if a
 split occurred.  If so, create a new root node and put the old root and the
 new split node into the new root."

  | returnNode node |
  returnNode := btreeRoot
    btreeAt: aKey
    put: aValue
    for: self
    selectiveAbortSet: selectiveAbortSetOrNil.	" see if a split occurred "
  returnNode == btreeRoot
    ifFalse: [
      " returnNode is the second half of the split "
      selectiveAbortSetOrNil ~~ nil
        ifTrue: [ selectiveAbortSetOrNil add: returnNode ].
      System _addRootObjectToRcReadSet: returnNode.
      System redoLog addConflictObject: returnNode for: self.
      node := btreeRoot parentNodeClass new.	" create the new parent node "
      node
        objectSecurityPolicy: btreeRoot objectSecurityPolicy;
        collator: btreeRoot collator.
      node lastValue: returnNode lastValue.
      node
        _insertKey: (btreeRoot _at: btreeRoot _lastKeyIndex)
        value: btreeRoot
        atIndex: 1.	" insert the first half (the original root) "
      node
        _insertKey: (returnNode _at: returnNode _lastKeyIndex)
        value: returnNode
        atIndex: node entrySize + 1.	" insert the second half "
      selectiveAbortSetOrNil ~~ nil
        ifTrue: [ selectiveAbortSetOrNil add: node ].
      System _addRootObjectToRcReadSet: node.
      System redoLog addConflictObject: node for: self.
      btreeRoot := node ].
  System _addRootObjectToRcReadSet: self.
  aBoolean
    ifTrue: [ self _logBtreeAt: aKey put: aValue ].
  ^ true

]

{ #category : 'Updating' }
RcRangeEqualityIndex >> _btreeRemoveKey: aKey value: aValue logging: aBoolean [

        ^self  _btreeRemoveKey: aKey value: aValue logging: aBoolean selectiveAbortSet: nil

]

{ #category : 'Updating' }
RcRangeEqualityIndex >> _btreeRemoveKey: aKey value: aValue logging: aBoolean selectiveAbortSet: selectiveAbortSetOrNil [

"Removes the key and value from the B-tree root node.  Must check to see if
 a merge occurred in the root such that the root only contains a single
 entry.  If so, make the single entry the new root.  Returns whether the
 removal occurred."

(btreeRoot removeKey: aKey value: aValue for: self selectiveAbortSet: selectiveAbortSetOrNil)
    ifTrue: [
        ((btreeRoot numElements == 1) and: [ btreeRoot isLeaf not ] )
            ifTrue: [ btreeRoot := btreeRoot at: (btreeRoot _lastKeyIndex - 1) ].
          System _addRootObjectToRcReadSet: self.
        aBoolean
          ifTrue: [
            self _logBtreeRemoveKey: aKey value: aValue.
          ].
        ^ true
    ]
    ifFalse: [ ^ false ].

]

{ #category : 'Private' }
RcRangeEqualityIndex >> _logBtreeAt: aKey put: aValue [

"Create a log entry for adding the given key/value."

| logEntry |
logEntry := LogEntry new.
logEntry receiver: self selector: #_btreeAt:put:logging:selectiveAbortSet: 
           argArray: { aKey . aValue . false . nil }.
System redoLog addLogEntry: logEntry

]

{ #category : 'Private' }
RcRangeEqualityIndex >> _logBtreeRemoveKey: aKey value: aValue [

"Create a log entry for removing the given key/value."

| logEntry |
logEntry := LogEntry new.
logEntry receiver: self selector: #_btreeRemoveKey:value:logging:selectiveAbortSet:
           argArray: { aKey . aValue . false . nil }.
System redoLog addLogEntry: logEntry

]

{ #category : 'Private' }
RcRangeEqualityIndex >> _resolveRcConflictsWith: conflictObjects [

"A logical write-write conflict has occurred on the receiver.  The objects that
 had the actual physical write-write conflicts are in the conflictObjects
 Array.  Selectively abort the receiver and then attempt to replay the
 operations maintained in the System redo log.  Returns true if all the
 operations could be replayed; otherwise returns false."

"inline implementation of _abortAndReplay: to abort old btrees before
 replaying log entries."

| redoLog logEntries selectiveAbortSet |
redoLog := System _redoLog.

" if no log entries to replay, then we're done "
redoLog == nil ifTrue: [ ^ false ].
logEntries := redoLog getLogEntriesFor: self .
logEntries == nil ifTrue:[ ^ false ].

" cannot perform selective abort if receiver has a dependency tag "
self _hasDependencyList ifTrue: [ ^ false ].

" explicitly abort the btrees that made up original changes, since we need to abort entire tree, before replaying, since
  nodes may split differently."
selectiveAbortSet := IdentitySet new.
1 to: conflictObjects size do:[ :j | | co |
  co := conflictObjects at: j.
  co _selectiveAbort.
  selectiveAbortSet add: co.
].

"abort all of the btree nodes involved in the transaction"
redoLog conflictObjects keysAndValuesDo:[ :conflictObject :redoObject |
  redoObject == self
        ifTrue: [
                conflictObject _selectiveAbort.
                selectiveAbortSet add: conflictObject ].
].

" refresh the state of the receiver "
self _selectiveAbort.

" replay all operations on the receiver"
1 to: logEntries size do:[:j | | logEnt |
  logEnt := logEntries at: j .
  logEnt argArray at: 4 put: selectiveAbortSet. "install the selectiveAbortSet into the #selectiveAbortSet arg slot"
  logEnt redo ifFalse:[
    ^ false  "redo failed, cannot commit"
  ].
].
^ true

]

{ #category : 'Converting' }
RcRangeEqualityIndex >> _unicodeIndexSpecificationClass [
  ^ RcUnicodeIndexSpecification

]

{ #category : 'Converting' }
RcRangeEqualityIndex >> asIndexSpecification [
  (RangeEqualityIndex _isUnicodeLastElementClass: self lastElementClass)
    ifTrue: [ ^ self asUnicodeIndexSpecification ].
  ^ (RcEqualityIndexSpecification
    path: self pathComponentsString
    lastElementClass: self lastElementClass)
    requirePathTerms: self termsRequired;
    legacyIndex: true;
    yourself

]

{ #category : 'Updating' }
RcRangeEqualityIndex >> btreeAt: aKey put: aValue [
  "Insert the key/value pair into the root B-tree node.  Must check to see if a
 split occurred.  If so, create a new root node and put the old root and the
 new split node into the new root."

  (self _canCompareWith: aKey)
    ifFalse: [
      ^ (ImproperOperation new
        _number:
            (ErrorSymbols at: #'rtErrRangeEqualityIndexInvalidClassKindForBtree');
        args: { aKey class. self lastPathTerm name. self lastElementClassDescription}) signal ].
  self _btreeAt: aKey put: aValue logging: true

]

{ #category : 'Updating' }
RcRangeEqualityIndex >> btreeRemoveKey: aKey value: aValue [

"Removes the key and value from the B-tree root node.  Must check to see if
 a merge occurred in the root such that the root only contains a single
 entry.  If so, make the single entry the new root.  Returns whether the
 removal occurred."

^ self _btreeRemoveKey: aKey value: aValue logging: true

]

{ #category : 'Testing' }
RcRangeEqualityIndex >> isReducedConflictIndex [
  "answer true if the receiver supports reduced conflict operations"

  ^ true

]
