Extension { #name : 'SetValuedPathEvaluator' }

{ #category : 'Testing' }
SetValuedPathEvaluator >> hasSetValuedTerm [
  "Returns true if the path has a term that indicates a set-valued instance
 variable."

  ^ true

]

{ #category : 'Testing' }
SetValuedPathEvaluator >> isIndexOnNscElements [
  "Returns whether the receiver is a path directly on the elements of an NSC
 (either the root NSC or a set-valued instance variable along the path)."

  ^ (self at: self size) = #'*'

]

{ #category : 'Traversing' }
SetValuedPathEvaluator >> traverse: anObject startingAt: offset do: aBlock [
  "Traverse the sub-objects of anObject, using the path names of the receiver
 starting at the path name at the given offset.  For each object at the end of
 the traversal, evaluate the given block."

  | nextObj ivOffset pathName nscOffset sz |
  (nil == anObject _and: [ self isIndexOnNscElements not ])
    ifTrue: [ ^ self ].
  nextObj := anObject.
  sz := self size.
  offset to: sz do: [ :i |
    nil == nextObj
      ifTrue: [ ^ self ].
    pathName := self at: i.
    pathName = #'*'
      ifTrue: [
        " if indexing over a set-valued instance variable "
        nscOffset := i + 1.
        nextObj
          do: [ :obj |
            " for each object in the collection-valued instance variable "
            " make recursive call "
            self traverse: obj startingAt: nscOffset do: aBlock ].
        ^ self ]
      ifFalse: [
        " get the next object along the path "
        ivOffset := nextObj class _idxIvOffsetOf: pathName.
        ivOffset == nil
          ifTrue: [ nextObj := nil ]
          ifFalse: [ nextObj := nextObj instVarAt: ivOffset ].
        (nil == nextObj _and: [ i ~= sz ])
          ifTrue: [ ^ self ] ] ].
  ^ aBlock value: nextObj

]

{ #category : 'Traversing' }
SetValuedPathEvaluator >> traverse: anObject startingAt: offset into: resultSet [
  "Traverse the sub-objects of all the objects in the NSC, using the path names
 of the receiver starting at the path term at the given offset.  Add each
 object at the end of the traversal to the result set.  Returns the result
 set."

  | nextObj ivOffset pathName nscOffset sz |
  (nil == anObject _and: [ self isIndexOnNscElements not ])
    ifTrue: [ ^ resultSet ].
  nextObj := anObject.
  sz := self size.
  offset to: sz do: [ :i |
    pathName := self at: i.
    pathName = #'*'
      ifTrue: [
        " if indexing over a set-valued instance variable "
        nscOffset := i + 1.
        nextObj
          do: [ :obj |
            " for each object in the set-valued instance variable "
            " make recursive call "
            self traverse: obj startingAt: nscOffset into: resultSet ].
        ^ resultSet ]
      ifFalse: [
        " get the next object along the path "
        nil == nextObj
          ifTrue: [ ^ resultSet ].
        ivOffset := nextObj class _idxIvOffsetOf: pathName.
        ivOffset == nil
          ifTrue: [
            nextObj _errorInvalidOffset: pathName.
            nextObj := nil ]
          ifFalse: [ nextObj := nextObj instVarAt: ivOffset ] ].
    (nil == nextObj _and: [ i ~= sz ])
      ifTrue: [ ^ resultSet ] ].
  resultSet add: nextObj.
  ^ resultSet

]
