Extension { #name : 'String' }

{ #category : 'Indexing Support' }
String >> _equals: argString collator: anIcuCollator useMinSize: aFalse [

"Returns true if argString compares equals to the receiver using anIcuCollator
 and if argString is not a Symbol, otherwise returns false "
<primitive: 991>
anIcuCollator ifNil:[ (System __sessionStateAt: 20) ifNil:[
  ^ self _equals: argString collator: IcuCollator default useMinSize: aFalse ]
] ifNotNil:[  anIcuCollator _validateClass: IcuCollator ].
(argString isKindOf: CharacterCollection) ifTrue:[ ^ argString = self ].
^ false

]

{ #category : 'Private' }
String >> _findStringNocase: subString startingAt: startIndex collator: anIcuCollator [

"searches using a copy of anIcuCollator set to TERTIARY matches, and
 using an ICU StringSearch "
<primitive: 944>
subString _validateClasses: { String .  Utf8 } .
startIndex _validateClass: SmallInteger .
(startIndex < 1) | (startIndex > self size)
  ifTrue: [ ^ self _error: #objErrBadOffsetIncomplete args: { startIndex } ].
^ self _primitiveFailed: #_findStringNocase:startingAt:collator:
       args: { subString . startIndex . anIcuCollator }

]

{ #category : 'New Indexing Comparison' }
String >> _idxUnicodeCompareEqualTo: aCharCollection [

"This comparison operation is used for the indexing subsystem to
 determine an ordering for insertion into indexing objects and for
 doing indexing subsystem comparisons.

 This method behaves the same as the = method, except that
 it returns true if the argument is nil."

  aCharCollection ifNil: [ ^ false ].
  aCharCollection isUnicodeString ifFalse: [ "not Unicode"
     aCharCollection _isSymbol ifTrue:[ ^ false ] .
  ].
  ^ (self
    compareTo: aCharCollection
    collator: nil
    useMinSize: 900) == 0

]

{ #category : 'New Indexing Comparison' }
String >> _idxUnicodeCompareGreaterThan: aCharCollection [

"This comparison operation is used for the indexing subsystem to
 determine an ordering for insertion into indexing objects and for
 doing indexing subsystem comparisons.

 This method collates the same as the > method, except that
 it returns true if the argument is nil."

aCharCollection ifNil: [ ^ true ].
^ (self
    compareTo: aCharCollection
    collator: nil
    useMinSize: 900) == 1

]

{ #category : 'New Indexing Comparison' }
String >> _idxUnicodeCompareLessThan: aCharCollection [

"This comparison operation is used for the indexing subsystem to
 determine an ordering for insertion into indexing objects and for
 doing indexing subsystem comparisons.

 This method collates the same as the < method, except that
 it returns false if the argument is nil."

 aCharCollection ifNil:[ ^ false ].
 ^ (self
    compareTo: aCharCollection
    collator: nil
    useMinSize: 900) == -1

]

{ #category : 'Comparing' }
String >> _unicodeEqual: argString [
  "Compares receiver to argument using  IcuCollator default."

^ self _equals: argString collator: nil useMinSize: false

]

{ #category : 'Comparing' }
String >> _unicodeGreaterThan: argString [
  "Compares receiver to argument using  IcuCollator default."
  ^ (self compareTo: argString collator: nil useMinSize: false) > 0

]

{ #category : 'Comparing' }
String >> _unicodeLessThan: argString [
  "Compares receiver to argument using  IcuCollator default."
  ^ (self compareTo: argString collator: nil useMinSize: false) < 0

]

{ #category : 'Converting' }
String >> asFoldcase [

" Returns the result of UncodeString::foldCase( U_FOLD_CASE_DEFAULT)."

<primitive: 973>
^ self _primitiveFailed: #asFoldcase

]

{ #category : 'Converting' }
String >> asLowercaseForLocale: anIcuLocale [

"Returns the result of  UncodeString::toLower(anIcuLocale).
 See also String >> asLowercase"

<primitive: 971>
^ self _primitiveFailed: #asLowercaseForLocale: args: { anIcuLocale }

]

{ #category : 'Converting' }
String >> asTitlecase [

  ^ self asTitlecaseForLocale: IcuLocale default

]

{ #category : 'Converting' }
String >> asTitlecaseForLocale: anIcuLocale [

"Returns the result of
 UncodeString::toTitle(BreakIterator::createTitleInstance(anIcuLocale)"

<primitive: 972>
^ self _primitiveFailed: #asTitlecaseForLocale: args: { anIcuLocale }

]

{ #category : 'Converting' }
String >> asUppercaseForLocale: anIcuLocale [

"Returns the result of  UncodeString::toUpper(anIcuLocale).
 See also String >> asUppercase"

<primitive: 970>
self _primitiveFailed: #asUppercaseForLocale: args: { anIcuLocale }

]

{ #category : 'Indexing Support' }
String >> compareTo: argString collator: anIcuCollator useMinSize: aMinSize [

"Returns -1, 0 or 1,  when receiver is less than,
 equal to, or greater than argString .
 argString must be a String, MultiByteString, or a Utf8.
 anIcuCollator == nil is interpreted as   IcuCollator default .

 If aMinSize == false, normal comparision is done.

 If aMinSize==true, compare stops at (self size min: argString size),
 which is Squeak semantics for comparison.

 If aMinSize is a SmallInteger >= 1, compare stops at
   aMinSize min: (self size min: argString size) ."
<primitive: 977>
anIcuCollator ifNil:[
  (System __sessionStateAt: 20) ifNil:[
    ^ self compareTo: argString collator: IcuCollator default useMinSize: aMinSize ]
] ifNotNil:[ anIcuCollator _validateClass: IcuCollator ].
aMinSize _validateClasses: { Boolean . SmallInteger }.
argString _validateClasses: { String . Utf8 }.
^ self _primitiveFailed: #compareTo:collator:useMinSize:
        args: { argString . anIcuCollator . aMinSize }

]

{ #category : 'Indexing Support' }
String >> sortKeyForCollator: anIcuCollator [

"Returns a ByteArray which is the sort key for the
 receiver produced by the specified IcuCollator.

 Calls Collator::getSortKey in coll.h of libicu."

<primitive: 975>
anIcuCollator _validateClass: IcuCollator .
^ self _primitiveFailed: #sortKeyForCollator: args: { anIcuCollator }

]

{ #category : 'Streams' }
String >> readStream [
  ^ ReadByteStream on: self 
]

