Extension { #name : 'System' }

{ #category : 'Private - Hidden Set Support' }
System class >> _add: anObject to: hiddenSetSpecifier [

"Will be deprecated, new code should use GsBitmaps"

^ self add: anObject toHiddenSet: hiddenSetSpecifier 

]

{ #category : 'Private Gci Set Support' }
System class >> _add: anObject toGciSet: hiddenSetSpecifier [

" needs a comment "

<primitive: 155>
hiddenSetSpecifier _validateClass: SmallInteger .
(hiddenSetSpecifier < 39 or:[ hiddenSetSpecifier > 40]) ifTrue:[
  hiddenSetSpecifier _error: #rtErrArgOutOfRange args:{ 39 . 40 }
].
self _primitiveFailed: #_add:toGciSet:
     args: { anObject . hiddenSetSpecifier } .
self _uncontinuableError

]

{ #category : 'Private - Hidden Set Support' }
System class >> _addAll: anArray to: hiddenSetSpecifier [

"Will be deprecated, new code should use GsBitmaps"

^ self addAll: anArray toHiddenSet: hiddenSetSpecifier

]

{ #category : 'Private Gci Set Support' }
System class >> _addAll: anArray toGciSet: hiddenSetSpecifier [

<primitive: 156>
hiddenSetSpecifier _validateClass: SmallInteger .
(hiddenSetSpecifier < 39 or:[ hiddenSetSpecifier > 40]) ifTrue:[
  hiddenSetSpecifier _error: #rtErrArgOutOfRange args:{ 39 . 40 }
].
anArray _validateClass: Array .
self _primitiveFailed: #_addAll:toGciSet:
     args: { anArray . hiddenSetSpecifier } .
self _uncontinuableError

]

{ #category : 'Private' }
System class >> _allErrorMessagesReport [

"Private."

| errorSymbolsArray symsWithNoMsg msgsWithNoSym report line errMsgsArray
  firstNil last k |

errorSymbolsArray  := { }  .
ErrorSymbols keysAndValuesDo:[:aSym :aNum |
  aNum > errorSymbolsArray size ifTrue:[ errorSymbolsArray size: aNum ].
  (errorSymbolsArray at: aNum) ifNotNil:[
    self _halt:'Duplicate symbol for error number ' , aNum asString .
  ].
  errorSymbolsArray at: aNum put: aSym .
].
errMsgsArray := GemStoneError at: #English .
msgsWithNoSym := String new .
symsWithNoMsg := String new .
(report := String new) lf .

report add:'ERROR MESSAGES STORED IN THE REPOSITORY:'; lf; lf .
1 to: errorSymbolsArray size do:[:j | | msgParts aSym |
  aSym := errorSymbolsArray at: j .
  msgParts := errMsgsArray at: j .
  aSym ifNil:[
    msgParts ifNotNil:[
       msgsWithNoSym addAll: '*** No error symbol for error number ';
		addAll: j asString; lf .
    ]
  ] ifNotNil:[
    msgParts ifNil:[
       symsWithNoMsg addAll: '*** No message for error symbol #';
		addAll: aSym quoted; lf .
    ] ifNotNil:[
       line := j asString.
       line addAll: ', #' ; addAll: aSym; addAll: ' :  ' ;
            addAll: (self _messageForErrorNum: j)  .
       report addAll: (line _wrapTo: 80 indentingWith: '    '); lf .
     ]
  ].
].

report lf ; add:
'Error mapping to Ansi Exception classes,
message text is generated during Exception signaling.' ; lf .
1 to: errorSymbolsArray size do:[:m |
  (errorSymbolsArray at: m) ifNil:[
    (LegacyErrNumMap at: m) ifNotNil:[:elem |
      elem _isArray ifTrue:[
        (elem size == 3 ifTrue:[ { elem at: 1 } ] ifFalse:[ elem at: 4 ])
          do:[:cls | report add:'  '; add: m asString ; add: ' --> ' ; add: cls name ; lf ]
      ]
    ]
  ]
].

report lf ; add:
'ERROR MESSAGES FROM errmsg.c, TEXT FROM errmsg.ht '; lf ;
add: '  (Repository message followed by errmsg.ht message, if any)'; lf; lf .

1 to: errorSymbolsArray size do:[:j | | msgFN |
  (errorSymbolsArray at: j) ifNotNil:[ :aSym |
    (self _internalMessageForErrorNum: j) ifNotNil:[ :internalMsg |
      msgFN := self _messageForErrorNum: j .
      msgFN ifNil:[ msgFN := 'NO MESSAGE FOR NUMBER ' , j asString ].
      (line := j asString) add: ', #' ; add: aSym; add: ' :  ' ;
           add: msgFN ; lf ; add: internalMsg .
      report add: (line _wrapTo: 80 indentingWith: '    '); lf; lf.
    ].
  ].
].

report lf ; add:'UNUSED ERROR NUMBERS:'; lf .
firstNil := 1 .
k := 1.
last := errorSymbolsArray size .
[k < last] whileTrue:[
  [ (errorSymbolsArray at: k) == nil and:[k < last] ] whileTrue:[ k := k + 1 ].
  k > firstNil ifTrue:[
    report add: firstNil asString ; add: ' to: ';
		add: (k - 1) asString; lf .
  ] ifFalse:[
    report add: firstNil asString; lf .
  ].
  firstNil := nil .
  [ (errorSymbolsArray at: k) ~~ nil and:[k < last] ] whileTrue:[ k := k + 1 ].
  firstNil := k .
].

report lf .
msgsWithNoSym size ~~ 0
  ifTrue:[ report add: msgsWithNoSym ]
  ifFalse:[ report add:'No messages found without an error symbol.'].
report lf .
symsWithNoMsg size ~~ 0
  ifTrue:[ report add: symsWithNoMsg ]
  ifFalse:[ report add: 'No error symbols found without a message.'].
report lf .
^ report

]

{ #category : 'Private' }
System class >> _conflictsReport: aBoolean withDetails: detailsBool [

"Returns an Array describing conflicts or success of the last attempted commit.
 If aBoolean true, include conflict sets even if commit result read-only or success.

 First element of the Array is a symbol describing the commit status.

 If detailsBool == false
   Second element is nil .
   Remaining elements of the Array are one or more triples
      conflictKindSymbol .  Array of objects in conflict .  nil

 If  detailsBool == true   and
 (self gemConfigurationAt: #GemCommitConflictDetails) == true
 then
   Second element is a DateAndTime of the attempted commit.
   Remaining elements of the Array are one or more triples
     conflictKindSymbol .  Array of objects in conflict .  SessionsArray

   A SessionsArray is composed of one or more pairs
     String describing the session
     Array of objects written by that session .
"
| status res detailedConflicts |

status := self _commitResult + 2  .
res :=  { }  .
res add: ( #( #readOnly  		"must agree with _commitResult method"
		 #success
		 #rcFailure
	         #dependencyFailure
                 #failure
		 #retryFailure
                 #commitDisallowed
                 #retryLimitExceeded
		 #symbolFailure
		 #lockFailure
		 ) at:  status )  .

( detailsBool and:[ self _gemCommitConflictDetails > 0 and:[ status >= 1 ]]) ifTrue:[
  detailedConflicts := self _detailedConflicts .
].
detailedConflicts ifNotNil:[ | timeStr |
  (detailedConflicts at: 1) ifNotNil:[:tm |
     timeStr := (DateAndTime posixSeconds: tm asFloat / 1000 offset: nil) asStringMs
  ] ifNil:[
     timeStr := DateAndTime now asString .
  ].
  res add: 'Attempt to commit at: ', timeStr ,
           ' previousViewCr ', (detailedConflicts at:2) asString  .
] ifNil:[ res add: nil ].

(status > 2 or:[ aBoolean]) ifTrue:[
  | blk blk3 wwConflicts rcReadSet rcObject sess rcRetryFailureReason rcRetryFailureDescription |

  blk := [ :key :setNum | | anArr |
     ((self hiddenSetSize: setNum) > 0 or:[ key == #RcReadSet ]) ifTrue:[
        res add: key ; add:( anArr:= self hiddenSetAsArray: setNum) .
        res add: nil . "never any session details for these keys"
     ].
     anArr .
  ].
  blk3 := [ :key :setNum :details | | anArr |
     (self hiddenSetSize: setNum) > 0 ifTrue:[ | sesArray |
        res add: key ; add:( anArr:= self hiddenSetAsArray: setNum) .
        sesArray := nil . "Pairs of commitDescrString  { objs }"
        details ifNotNil:[  | dOfs |
          dOfs :=  setNum == 15 ifTrue:[ 4 "w-w"] ifFalse:[ 5 "w-dep" ].
          3 to: details size do:[:dx | | dElem ww str tim |
            dElem := details at: dx .
            (ww := dElem atOrNil: dOfs ) ifNotNil:[
              (str := 'session ' copy) add: (dElem at: 1) asString .
              tim := DateAndTime posixSeconds:(dElem at: 2) asFloat / 1000 offset: nil .
              str add: ' at '; add: tim asStringMs ;
                  add: ' userId ';
                  add: ((dElem at: 3) ifNil:[ 'unknown'] ifNotNil:[:up | up userId ]);
                  add: ' crPage ', (dElem at: 6) asString .
              sesArray ifNil:[ sesArray := { } ].
              sesArray add: str ; add: ww .
            ]
          ].
        ].
        res add: sesArray .
     ].
     anArr .
  ].

  blk value:#'Read-Write' value: 13 . "StrongRead - Write conflicts"
  wwConflicts := blk3 value:#'Write-Write' value: 15 value: detailedConflicts  .

  rcReadSet := blk value:#'RcReadSet' value: 7 .
  (wwConflicts size ~~ 0 and:[rcReadSet size ~~ 0]) ifTrue:[
    res add:#'WriteWrite_minusRcReadSet' ;
      add:(Array withAll:(IdentitySet withAll: wwConflicts) - (IdentitySet withAll: rcReadSet));
      add: nil. "RcReadSet is for this session only, never other sessions info"
  ].
  blk3 value: #'Write-Dependency' value: 16 value: detailedConflicts .
  blk value: #'Write-ReadLock' value: 17 .
  blk value: #'Write-WriteLock' value: 18 .
  rcObject := self rcValueCacheAt: #'Rc-Retry-Failure' for: self otherwise: nil.
  rcObject ifNotNil:[
      res add: #'Rc-Retry-Failure' ; add: { rcObject }; add: nil .

  rcRetryFailureReason := self rcValueCacheAt: #'Rc-Retry-Failure-Reason' for: self otherwise: nil.
  rcRetryFailureReason ifNotNil:[
      res add: #'Rc-Retry-Failure-Reason' ; add: { rcRetryFailureReason } ; add: nil ].
  rcRetryFailureDescription := self rcValueCacheAt: #'Rc-Retry-Failure-Description' for: self otherwise: nil.
  rcRetryFailureDescription ifNotNil:[
      res add: #'Rc-Retry-Failure-Description' ; add: { rcRetryFailureDescription } ; add: nil ]
  ].
  sess := self rcValueCacheAt: #'Synchronized-Commit' for: self otherwise: nil.
  sess ifNotNil: [
      res add: #'Synchronized-Commit' ; add: { sess }; add: nil .
  ].
].
^ res

]

{ #category : 'Debugging Support' }
System class >> _disableTraceNewPomObjs [
"Causes the system to discontinue adding newly committed objects
 to hidden set SaveWriteSetUnion immediately after they are committed.  Does not
 modify the state of hidden set SaveWriteSetUnion."
^ self _zeroArgPrim: 76

]

{ #category : 'Debugging Support' }
System class >> _disableTraceObjectsRead [

"Disables tracing of object read-faults , if it is enabled, and flushes
 any remaining trace buffers into hidden set ObjectsRead
 Returns the size of hidden set ObjectsRead after flushing the buffers.

 If tracing of object read-faults was not enabled, returns 0 ."


^ self _zeroArgPrim: 97

]

{ #category : 'Debugging Support' }
System class >> _disableTracePagesAccessed [

"Disables tracing of page read accesses  , if it is enabled, and flushes
 any remaining trace buffers into hidden set 5.
 Returns the size of hidden set 5 after flushing the buffers.

 If tracing of page read accesses was not enabled, returns 0 ."


^ self _zeroArgPrim: 128

]

{ #category : 'Debugging Support' }
System class >> _enableTraceNewPomObjs [
"Causes all newly committed objects to be added to hidden set SaveWriteSetUnion
 immediately after they are committed.  Also causes hidden set SaveWriteSetUnion
 to be cleared if tracing was previously disabled when this method
 is called."
^ self _zeroArgPrim: 75

]

{ #category : 'Debugging Support' }
System class >> _enableTraceObjectsRead [

"Enables tracing of object read-faults, i.e. committed objects that are copied
 into the VM's memory.   Cancels any previous _enableTracePagesRead ,
 only one of _enableTraceObjectsRead or _enableTracePagesRead can be active
 at a time.

 Object read-faults are accumulated in internal buffers, which
 are flushed to hidden set ObjectsRead each time the PomGenScavCount
 statistic increments.
 Use the method _updateObjectsRead to explicitly flush buffers into
 hidden set ObjectsRead.

 If tracing was previously enabled, this method clears hidden set ObjectsRead.

 Note that hidden set ObjectsRead is an identity set, and if the same object
 is read multiple times during an interval defined by _enableTraceObjectsRead,
 _disableTraceObjectsRead, due to wraparound of the memory area holding
 committed objects , that object will only show up once in the set .
 Changes in the statistic ObjectsRead  can be compared to changes in the
 set size to detect multiple reads of objects.
 Also note the statistic ObjectsRefreshed , which represents re-reads
 of objects to obtain new views after crossing transaction boundaries;
 re-reads.

 Hidden set ObjectsRead is in C heap memory ; this process could run out of C heap memory
 if this tracing is left enabled for a very long time on a large repository.
 Memory consumption varys from approximately 8 bytes per object for small sets
 to 1 bit per object for sets spanning the entire shared object table.

 Returns self."

^ self _zeroArgPrim: 99

]

{ #category : 'Debugging Support' }
System class >> _enableTracePagesAccessed [

"Enables tracing of page read accesses.
 A  'page read access'  is a page in the shared cache which was accessed
 the data source to satisfy an object read-fault .  Page accesses for
 object table lookups are not included.

 Cancels any previous _enableTraceObjectsRead , only one of
 _enableTraceObjectsRead or _enableTracePagesAccessed can be active at a time.

 PageIds of pages accessed are accumulated in internal buffers, which
 are flushed to hidden set 5  approximately every 200 page read accesses.
 Use the method _updatePagesAccessed to explicitly flush buffers into
 hidden set 5 .

 If tracing was previously enabled, this method clears hidden set 5 .

 Note that hidden set 5 is an identity set, and if the same page
 is read multiple times during an interval defined by _enableTracePagesAccessed,
 _disableTracePagesAccessed, that page will only show up once in the set .

 Hidden set 5 is in C heap memory ; this process could run out of C heap memory
 if this tracing is left enabled for a very long time on a large repository.
 Memory consumption varys from approximately 8 bytes per page for small sets
 to 1 bit per page for sets spanning the entire shared object table.

 Returns self."

^ self _zeroArgPrim: 125

]

{ #category : 'Private Gci Set Support' }
System class >> _gciDirtyInit: hiddenSetSpecifier [

"Enable GCI tracking of dirty objects.
   hiddenSetSpecifier = 22, equivalent to GciDirtyObjsInit()
 Other values of hiddenSetSpecifier are not allowed."

<primitive: 164>
hiddenSetSpecifier _validateClass: SmallInteger .
hiddenSetSpecifier = 22 ifFalse:[
  hiddenSetSpecifier _error: #rtErrArgOutOfRange args:{ 22 . 22 }
].
self _primitiveFailed: #_gciDirtyInit: args: { hiddenSetSpecifier } .
self _uncontinuableError

]

{ #category : 'Private Gci Set Support' }
System class >> _getAndClearGciDirtySet: hiddenSetSpecifier into: anArray [

<primitive: 162>
hiddenSetSpecifier _validateClass: SmallInteger .
hiddenSetSpecifier = 22 ifFalse:[
  hiddenSetSpecifier _error: #rtErrArgOutOfRange args:{ 22 . 22 }
].
anArray ~~ nil ifTrue:[ anArray _validateClass: Array ].
self _primitiveFailed: #_getAndClearGciDirtySet:into:
     args: { hiddenSetSpecifier . anArray } .
self _uncontinuableError

]

{ #category : 'Private' }
System class >> _readWriteConflicts_or_writeDepConflicts [
  "Returns a Boolean , true if either read-write or write-dependency conflicts exist"
  ^ self _zeroArgPrim: 208 .
]

{ #category : 'Reduced Conflict Support' }
System class >> _getRedoAndConflictObjects [

"Builds a list of objects that need to be scanned because they need to
 have conflicts resolved.  If the result array is empty, then the transaction
 has conflicts that cannot be resolved because we should only get here if
 some Rc conflicts have been detected."

  | wwConflicts redoLog result |

" if there are read-write and write-read conflicts, we cannot resolve them "
"check for #'Read-Write' , i.e. strongRead-write conflicts "

self _readWriteConflicts_or_writeDepConflicts ifTrue:[
  "Either ReadWriteConflicts or WriteDependencyConflicts , replay not possible"
  ^ nil .
].

wwConflicts := (GsBitmap _newForHiddenSetId: WriteWriteConflicts_id) asArray.
wwConflicts size == 0 ifTrue: [
  "expected to find write-write conflicts to resolve, so fail"
  ^ nil
].

result := { } .
redoLog := self _redoLog.
redoLog ifNil:[
  " no redo log, treat objects themselves as the one on which conflicts
        must be resolved "
  1 to: wwConflicts size do: [ :i | | conflictObject |
    conflictObject := wwConflicts at: i.
    result add: conflictObject ; add: { conflictObject }.
  ].
] ifNotNil:[ | conflictObject |
  1 to: wwConflicts size do: [ :i | | redoObject |
    conflictObject := wwConflicts at: i.

    " get the object that has to be replayed due to this conflict "
    redoObject := redoLog getRedoObjectForConflictingObject: conflictObject.
    redoObject ifNil:[
      conflictObject isInternalObject ifTrue:[
        "a leaf node that will be taken care of by replay of a parent"
      ] ifFalse:[ "RcPipe component or similar"
        (result includesIdentical: redoObject) ifFalse:[
          result add: conflictObject ; add: { conflictObject }.
        ]
      ].
    ] ifNotNil:[  | idx |
      (idx := result indexOfIdentical: redoObject) ~~ 0 ifTrue: [
        (result at: idx + 1) add: conflictObject.
      ] ifFalse:[
        result add: redoObject ; add: { conflictObject }.
      ].
    ].
  ].
].
^ result

]

{ #category : 'Private - Hidden Set Support' }
System class >> _hiddenSetAsArray: hiddenSetSpecifier [

"Will be deprecated, new code should use GsBitmaps"

^ self hiddenSetAsArray: hiddenSetSpecifier

]

{ #category : 'Private - Hidden Set Support' }
System class >> _hiddenSetEnumerate: hiddenSetSpecifier limit: maxResultSize [

"Will be deprecated, new code should use GsBitmaps"

^ self hiddenSetEnumerate: hiddenSetSpecifier limit: maxResultSize

]

{ #category : 'Private - Hidden Set Support' }
System class >> _hiddenSetEnumerateAsInts: hiddenSetSpecifier limit: maxResultSize [

"Will be deprecated, new code should use GsBitmaps"

^ self hiddenSetEnumerateAsInts: hiddenSetSpecifier limit: maxResultSize

]

{ #category : 'Private - Hidden Set Support' }
System class >> _hiddenSetReinit: hiddenSetSpecifier [

"Will be deprecated, new code should use GsBitmaps"

^ self hiddenSetReinit: hiddenSetSpecifier

]

{ #category : 'Private - Hidden Set Support' }
System class >> _hiddenSetSize: hiddenSetSpecifier [

"Will be deprecated, new code should use GsBitmaps"

^ self hiddenSetSize: hiddenSetSpecifier

]

{ #category : 'Legacy Hidden Set Support' }
System class >> _loadOrStoreHiddenSet: hiddenSetSpecifier toOrFromFile: aString opCode: anOpCode [

"Performs hidden set to bitmap file operations.

 ONLY supports hiddenSetSpecifiesrs from GsBitmap as Symbols

 If anOpCode is zero, read the given bitmap file into the given hidden set.
 The file must exist and be readable by the gem process.  hiddenSetSpecifier
 must be the index of a hidden set that is modifiable by customers.
 This check is bypassed if the session is logged in as SystemUser.  Extreme
 caution should be used in this case.
 Be sure to call (GsBitmap newForHiddenSet: hiddenSetSpecifier) removeAll
   first to ensure the hidden set is empty.

 If anOpCode is one, then the given hidden set is written to the specified
 bitmap file.  The file must not already exist and the path to the file must
 be in a directory which is writable by the process.  Any valid hidden set
 specifier may be used in this case.

 If anOpCode is two, then the file is assumed to be a sorted bitmap file
 of objects produced by one of the Repository>>listInstancesInPageOrder:
 methods.  The objects are loaded into the given hidden set, but the ordering
 by page ID is lost because hidden sets are always ordered by object ID.
 No validation of the object IDs is done by this load.

 Returns true if successful, false if an error occurred.  Additional error
 information may be written stderr for the process (either the terminal
 or the gem log file)."

| bitmap |
aString _validateKindOfClass: String.
anOpCode _validateClass: SmallInteger.

bitmap := GsBitmap newForHiddenSet: hiddenSetSpecifier.
anOpCode = 0 ifTrue: [ bitmap readFromFile: aString. ^ true ].
anOpCode = 1 ifTrue: [ bitmap writeToFile: aString. ^ true ].

anOpCode > 1 ifTrue: [ Error signal:'opCode ' , anOpCode asString , ' not supported' ].

]

{ #category : 'Private - Hidden Set Support' }
System class >> _performSetArithmeticOnHiddenSets: first and: second storeResultsInto: third opCode: anOpCode [

"Will be deprecated, new code should use GsBitmaps"

"Perform a set arithmetic operation on the hidden sets with the specifiers
 given by first and second and possiblly store the results into third.
 The behavior of this primitive is as follows:

 opCode 	Operation	 Result stored in third
 =================================================================
 0		Add		 Not used, third expected to be 0.
 1		Subtract	 Not used, third expected to be 0.
 2		Union 		 result of the union
 3		Difference	 result of difference
 4		Clear from start Not used
 5		Clear from end   Not used
 6		Compare          Not used
 =================================================================
"

(anOpCode == 0) ifTrue: [ ^ self addHiddenSet: first to: second ].
(anOpCode == 1) ifTrue: [ ^ self removeContentsOfHiddenSet: first from: second ].
(anOpCode == 2) ifTrue: [ ^ self computeUnionOfHiddenSet: first and: second into: third ].
(anOpCode == 3) ifTrue: [ ^ self computeDifferenceOfHiddenSet: first and: second into: third ].
(anOpCode == 4) ifTrue: [ ^ self removeFirst: second objectsFromHiddenSet: first ].
(anOpCode == 5) ifTrue: [ ^ self truncateHiddenSet: first toSize: second ].
(anOpCode == 6) ifTrue: [ ^ self compareHiddenSet: first to: second ].

]

{ #category : 'Private - Hidden Set Support' }
System class >> _primHiddenSetEnumerate: hiddenSetSpecifier limit: maxResultSize storeAsInts: aBool [

"Will be deprecated, new code should use GsBitmaps"

aBool ifTrue: [ ^ self hiddenSetEnumerateAsInts: hiddenSetSpecifier limit: maxResultSize ]
      ifFalse: [ ^ self hiddenSetEnumerate: hiddenSetSpecifier limit: maxResultSize ]

]

{ #category : 'Private - Hidden Set Support' }
System class >> _remove: anObject from: hiddenSetSpecifier [

"Will be deprecated, new code should use GsBitmaps"

^ self remove: anObject fromHiddenSet: hiddenSetSpecifier

]

{ #category : 'Private Gci Set Support' }
System class >> _remove: anObject fromGciSet: hiddenSetSpecifier [

<primitive: 157>
hiddenSetSpecifier _validateClass: SmallInteger .
(hiddenSetSpecifier < 39 or:[ hiddenSetSpecifier > 40]) ifTrue:[
  hiddenSetSpecifier _error: #rtErrArgOutOfRange args:{ 39 . 40 }
].
self _primitiveFailed: #_remove:fromGciSet:
     args: { anObject . hiddenSetSpecifier } .
self _uncontinuableError

]

{ #category : 'Private - Hidden Set Support' }
System class >> _removeAll: anArray from: hiddenSetSpecifier [

"Will be deprecated, new code should use GsBitmaps"

^ self removeAll: anArray fromHiddenSet: hiddenSetSpecifier

]

{ #category : 'Private Gci Set Support' }
System class >> _removeAll: anArray fromGciSet: hiddenSetSpecifier [

<primitive: 158>
hiddenSetSpecifier _validateClass: SmallInteger .
(hiddenSetSpecifier < 39 or:[ hiddenSetSpecifier > 40]) ifTrue:[
  hiddenSetSpecifier _error: #rtErrArgOutOfRange args:{ 39 . 40 }
].
anArray _validateClass: Array .
self _primitiveFailed: #_removeAll:fromGciSet:
     args: { anArray . hiddenSetSpecifier } .
self _uncontinuableError

]

{ #category : 'Debugging Support' }
System class >> _resumeTraceObjectsRead [

"Resumes tracing of object read-faults .
 Generates an error if hidden set ObjectsRead was most recently intialized by
 a _enableTracePagesAccessed .

 Same as _enableTraceObjectsRead, but does not clear hidden set ObjectsRead .
 If tracing of object read-faults was already enabled, flushes the
 trace buffers into hidden set ObjectsRead.

 Returns the current size of hidden set ObjectsRead."

^ self _zeroArgPrim: 98

]

{ #category : 'Debugging Support' }
System class >> _resumeTracePagesAccessed [

"Resumes tracing of page read accesses.
 Generates an error if hidden set 5 was most recently intialized by
 a _enableTraceReadFaults .

 Same as _enableTracePagesAccessed, but does not clear hidden set 5 .
 If tracing of page read accesses was already enabled, flushes the
 trace buffers into hidden set 5 .

 Returns the current size of hidden set 5."

^ self _zeroArgPrim:126

]

{ #category : 'Private - Hidden Set Support' }
System class >> _testIf: anObject isIn: hiddenSetSpecifier [

"Will be deprecated, new code should use GsBitmaps"

^ self testIf: anObject isInHiddenSet: hiddenSetSpecifier

]

{ #category : 'Notification' }
System class >> _updateNotifySet: aCollection add: aBoolean [

"Update the notify set by adding or removing the elements of the anArray to or
 from the set.  If aBoolean is true, the elements are added, otherwise they are
 removed."

<primitive: 363>
| anArray |
anArray := aCollection asArray.
anArray == aCollection ifFalse:[
  ^ self _updateNotifySet: anArray add: aBoolean
  ] .
aCollection _validateClasses: { Array . IdentityBag }.
self _primitiveFailed: #_updateNotifySet:add:
     args: { aCollection . aBoolean } .
self _uncontinuableError

]

{ #category : 'Debugging Support' }
System class >> _updateObjectsRead [

"If tracing of object read-faults has been enabled by executing
 _enableTraceObjectsRead , flushes internal tracing buffers into
 hidden set ObjectsRead.
 Returns the size of hidden set ObjectsRead, after flushing the buffers.

 If tracing of object read-faults is not enabled,
 or is currently disabled via _disableTraceObjectsRead , returns 0 ."

^ self _zeroArgPrim: 96

]

{ #category : 'Debugging Support' }
System class >> _updatePagesAccessed [

"If tracing of page read accesses has been enabled by executing
 _enableTracePagesAccessed ,   flushes internal tracing buffers into
 hidden set 5 .
 Returns the size of hidden set 5, after flushing the buffers.

 If tracing of page read accesses not enabled,
 or is currently disabled via _disableTracePagesAccessed, returns 0 ."


^ self _zeroArgPrim: 12

]

{ #category : 'Private - Hidden Set Support' }
System class >> _writeHiddenSet: hsId toPageOrderFile: aString maxBufferSizeMb: mb [

"Will be deprecated, new code should use GsBitmaps"

"Writes the object IDs for objects contained in the given hidden set to a
 file in page ID order.

 The hsid argument must be a SmallInteger indicating a hidden set id.
 See the method System>>HiddenSetSpecifiers for a list of (System) hidden 
 set identifiers. The hidden set is not modified by this method.  It is an
 error if the hidden set is empty.

 aString must be the full path to a new file on the gem's host system
 which will be created by this method.  It is an error if the file
 already exists.

 This method creates a temporary memory buffer used to sort objects by page ID.
 The mb argument specifies the maximum number of megabytes of memory to request
 from the operating system.  A value of 0 means the amount of memory to request
 is not limited.  Negative values are not allowed.

 The contents of the result file are guaranteed to be in page-order if,
 and only if the method was able to acquire enough memory to sort the entire
 hidden set by page ID.  Less than the optimial amount of memory may be
 available because of limits imposed by the mb argument, or the operating
 system.  In such cases where the optimal amount of memory is not available,
 the method will still succeed, however only parts of the result file
 will be in page order.   Methods that read page-ordered files (see list
 below) will still operate correctly on files with multiple page-ordered
 sections.  The optimal memory buffer size is approximately 10 bytes per
 object ID contained in the hidden set.

 The result file size will be approximately 5 bytes for each object in the
 hidden set, plus 24 bytes.  For example: for a hidden set which contains
 10 million objects, this method will generate a file approximately
 50 megabytes in size.

 The result file may be accessed using the following methods:
   System>>readHiddenSet: hiddenSetSpecifier fromSortedFile: aString
   Repository>>openPageOrderOopFile: aString
   Repository>>readObjectsFromFileWithId: aSmallInt startingAt: startIndex
               upTo: endIndex into: anArray
   Repository>>numberOfObjectsInPageOrderOopFileWithId: aSmallInt
   Repository>>closePageOrderOopFileWithId: aSmallInt
   Repository>>auditPageOrderOopFileWithId: aSmallInt

 Returns an Array with elements as follows:
  1 - the number of objects written to the file.
  2 - the number of sections in the file ordered by page ID.  This element
      will be 1 if the optimal amount of memory was available, or greater
      than 1 if not."


<primitive: 1022>
hsId _validateClass: SmallInteger .
mb _validateClass: SmallInteger .
aString _validateKindOfClass: String .
^ self _primitiveFailed: #writeHiddenSet:toPageOrderFile:maxBufferSizeMb:
       args: { hsId . aString . mb }

]

{ #category : 'Gci Set Support' }
System class >> add: anObject toGciSet: hiddenSetSpecifier [

"Add the specified object to a GCI hidden set, where
   hiddenSetSpecifier = 39 specifies PureExportSet
 Other values of hiddenSetSpecifier are not allowed.
 Has no effect if anObject is a special object.

 If hiddenSetSpecifier = 39 and a userAction is
 active an error is generated, since the PureExportSet
 cannot be modified from within a user action."

^ self _add: anObject toGciSet: hiddenSetSpecifier

]

{ #category : 'Legacy Hidden Set Support' }
System class >> add: anObject toHiddenSet: hiddenSetSpecifier [

"Will be deprecated, new code should use GsBitmaps"

"Adds anObject to the hiddenSet."

(GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: hiddenSetSpecifier)) add: anObject.
^self

]

{ #category : 'Gci Set Support' }
System class >> addAll: anArray toGciSet: hiddenSetSpecifier [

"Add contents of anArray to a GCI hidden set, where
   hiddenSetSpecifier = 39 specifies PureExportSet
 Other values of hiddenSetSpecifier are not allowed.

 If hiddenSetSpecifier = 39 and a userAction is
 active an error is generated, since the PureExportSet
 cannot be modified from within a user action."

^ self _addAll: anArray toGciSet: hiddenSetSpecifier

]

{ #category : 'Legacy Hidden Set Support' }
System class >> addAll: anArray toHiddenSet: hiddenSetSpecifier [

"Will be deprecated, new code should use GsBitmaps"

"Adds contents of anArray to the hiddenSet (anArray itself is not added to
 hiddenSet). Should only be used with public hidden sets 41-45."

^ (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: hiddenSetSpecifier)) addAll: anArray

]

{ #category : 'Private' }
System class >> _addAll: aCollection toReleaseLocksSetId: anId [

"Add each element of aCollection to the commit-or-abort release locks set.
 If an element of aCollection is not locked by the current session, then
 it is not added to the set."

| ary sessLocks argSet locksSet |
ary := aCollection .
ary _isArray ifFalse:[ ary := Array withAll: aCollection].
(argSet := GsBitmap new) addAll: aCollection .
sessLocks := System sessionLocks .
(locksSet := GsBitmap new) addAll: (sessLocks at: 1 "read locks") .
locksSet addAll: (sessLocks at: 2) "write locks" .
argSet := argSet intersect: locksSet .
(GsBitmap _newForHiddenSetId: anId) addAll: argSet .
^self

]

{ #category : 'Releasing Locks' }
System class >> addAllToCommitOrAbortReleaseLocksSet: aCollection [

"Add each element of aCollection to the commit-or-abort release locks set.
 If an element of aCollection is not locked by the current session, then
 it is not added to the set."

^ self _addAll: aCollection toReleaseLocksSetId: CommitOrAbortReleaseLocksSet_id
]

{ #category : 'Releasing Locks' }
System class >> addAllToCommitReleaseLocksSet: aCollection [

"Add each element of aCollection to the commit release locks set.  If an
 element of aCollection is not locked by the current session, then that
 element is not added to the set."
^ self _addAll: aCollection toReleaseLocksSetId: CommitReleaseLocksSet_id
]

{ #category : 'Notification' }
System class >> addAllToNotifySet: aCollection [

"Add all the elements of aCollection to the notify set.  Special objects and
 uncommitted objects are not permitted, since neither of these can be modified
 by other sessions."

self _updateNotifySet: aCollection add: true

]

{ #category : 'Legacy Hidden Set Support' }
System class >> addHiddenSet: first to: second [

"Will be deprecated, new code should use GsBitmaps"

"Add all the objects in hidden set first to hidden set second.  Returns the
 number of objects added to second hidden set that were not already present.
 Should only be used with a second set that is public, sets 41-45.
 User must have permission to modify the second hidden set or be SystemUser."

^(GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: first)) addAll:
        (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: second))

]

{ #category : 'Releasing Locks' }
System class >> addToCommitOrAbortReleaseLocksSet: anObject [

"Add anObject to to the commit-or-abort release locks set.  If anObject
 is not locked by the current session, then it is not added to the set."

((self myLockKind: anObject) == #none )
  ifFalse: [ GsBitmap _hiddenSetId: CommitOrAbortReleaseLocksSet_id add: anObject].
^self

]

{ #category : 'Releasing Locks' }
System class >> addToCommitReleaseLocksSet: anObject [

"Add anObject to the commit release locks set.  If anObject is not locked
 by the current session, then it is not added to the set."

((self myLockKind: anObject) == #none )
  ifFalse:[ GsBitmap _hiddenSetId: CommitReleaseLocksSet_id add: anObject].
^self

]

{ #category : 'Notification' }
System class >> addToNotifySet: anObject [

"Add anObject to the notify set.  The argument anObject cannot be a special
 object nor an uncommitted object, since neither can be modified by other
 sessions."

self _updateNotifySet: { anObject }  add: true

]

{ #category : 'Cache Statistics' }
System class >> cacheStatisticsDescriptionForPageManager [

"Returns an Array of Strings describing cache statistics applicable to the stone's page manager thread."

^ self _zeroArgPrim: 4128

]

{ #category : 'Releasing Locks' }
System class >> clearCommitOrAbortReleaseLocksSet [

"Remove all objects from the commit-or-abort release locks set."

GsBitmap _clearHiddenSetId: CommitOrAbortReleaseLocksSet_id .
^self

]

{ #category : 'Releasing Locks' }
System class >> clearCommitReleaseLocksSet [

"Remove all objects from the commit release locks set."

  GsBitmap _clearHiddenSetId: CommitReleaseLocksSet_id  .
]

{ #category : 'Notification' }
System class >> clearNotifySet [

 GsBitmap _clearHiddenSetId: NotifySet_id 

]

{ #category : 'Releasing Locks' }
System class >> commitOrAbortReleaseLocksSetIncludes: anObject [

"Returns true if anObject is in the commit-or-abort release locks set.
 Returns false otherwise."

^(GsBitmap _newForHiddenSetId: CommitOrAbortReleaseLocksSet_id ) includes: anObject

]

{ #category : 'Releasing Locks' }
System class >> commitReleaseLocksSetIncludes: anObject [

"Returns true if anObject is in the commit release locks set.
 Returns false otherwise."

^(GsBitmap _newForHiddenSetId: CommitReleaseLocksSet_id ) includes: anObject

]

{ #category : 'Legacy Hidden Set Support' }
System class >> compareHiddenSet: first to: second [

"Will be deprecated, new code should use GsBitmaps"

"Compares two hidden sets to determine if they contain the same objects.
 Returns true if the hidden set contents are identical.  Otherwise returns
 false.  Neither hidden set is modified."

 | bm1 bm2 |
 bm1 := (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: first)).
 bm2 := (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: second)).
^ bm1 equals: bm2

]

{ #category : 'Legacy Hidden Set Support' }
System class >> computeDifferenceOfHiddenSet: first and: second into: third [

"Will be deprecated, new code should use GsBitmaps"

"Add every object to the third hidden set that is in the first and but not the second hidden
 set.  Returns the number of elements added to the third hidden set.
 Should only be used with a third set that is public, sets 41-45.
 User must have permission to modify the third hidden set or be SystemUser."

| bm1 bm2 bm3 |
 bm1 := (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: first)).
 bm2 := (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: second)).
 bm3 := (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: third)).
^ bm3 addAll: (bm1 difference: bm2).

]

{ #category : 'Legacy Hidden Set Support' }
System class >> computeUnionOfHiddenSet: first and: second into: third [

"Will be deprecated, new code should use GsBitmaps"

"Add every object to the third hidden set that is in both the first and second hidden
 sets.  Returns the number of elements added to the third hidden set.
 Should only be used with a third set that is public, sets 41-45.
 User must have permission to modify the third hidden set or be SystemUser."

 | bm1 bm2 bm3 |
 bm1 := (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: first)).
 bm2 := (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: second)).
 bm3 := (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: third)).
^ bm3 addAll: (bm1 intersect: bm2).

]

{ #category : 'Notification' }
System class >> disableSignaledObjectsError [

"Disable the generation of an error when a member of the notify set
 is added to the signaled objects set."

self _updateSignalErrorStatus: 1 toState: false

]

{ #category : 'Notification' }
System class >> enableSignaledObjectsError [

"Enable the signalling of an ObjectsCommittedNotification exception when
 a member of the notify set is added to the signaled objects set.
 When a ObjectsCommittedNotification is signalled, further signalling
 is disabled to allow the exception handler to run without receiving
 another signal.  Therefore, the handler for ObjectsCommittedNotification
 should itself send enableSignaledObjectsError"

self _updateSignalErrorStatus: 1 toState: true

]

{ #category : 'Gci Set Support' }
System class >> getAndClearGciDirtySet: hiddenSetSpecifier into: anArray [

"Destructively enumerate a GCI hidden set, where
   anInt = 22  specifies ExportedDirtyObjs
 Other values of hiddenSetSpecifier are not allowed .

 Corresponding gciDirtyObjsInit must have been
 sent once during the session before this method can be used.  It is
 intended that either this method or Gci calls be used to enumerate
 these hidden sets, not both within one session.

 If the specified set is empty the result is nil.
 Otherwise the result is an Array containing up to the first 2034 elements
 of the hidden set, and those element are cleared from the hidden
 set prior to return from the primitive.   If the set contains
 more than 2034 elements, repeated invocation of this method
 is needed to enumerate the set completely.

 anArray may be nil in which case the result is a newly created Array.
 If anArray is non-nil it is used as the result and is grown as needed.

 For most efficient enumeration use this style:
   [ | arr |
     arr := self _getAndClearGciDirtySet:22 into: arr .
     1 to: arr size do:[:j | |aDirtyObj|
       aDirtyObj := arr at: j .
       aDirtyObj applicationHandleDirtyObj  .
     ].
     arr size == 0 .
   ] untilTrue .
 "
^ self _getAndClearGciDirtySet: hiddenSetSpecifier into: anArray

]

{ #category : 'Legacy Hidden Set Support' }
System class >> hiddenSet: hiddenSetSpecifier do: aBlock [

"Will be deprecated, new code should use GsBitmaps"

"Executes the one argument block aBlock for each argument
 in the specified hidden set.  Does a destructive enumerate
 of the hidden set.
 Should only be used with public hidden sets 41-45.
 Returns the number of objects enumerated."

 | bm count |
 bm := (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: hiddenSetSpecifier)).
 count := bm do: aBlock.
 bm removeAll.
 ^ count

]

{ #category : 'Legacy Hidden Set Support' }
System class >> hiddenSetAsArray: hiddenSetSpecifier [

"Will be deprecated, new code should use GsBitmaps"

"Returns an Array containing the contents of the hiddenSet."

^ (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: hiddenSetSpecifier)) asArray

]

{ #category : 'Legacy Hidden Set Support' }
System class >> hiddenSetEnumerate: hiddenSetSpecifier limit: maxResultSize [

"Will be deprecated, new code should use GsBitmaps"

"Returns an Array containing the first maxResultSize objects
 in the hiddenSet.  If the hidden set contains fewer than
 maxResultSize elements, returns an array containing
 the contents of the hiddenSet. If maxResultSize = 0, the result
 will contain all elements of the hidden set.

 All of the returned elements are removed from the hidden set.
 Should only be used with public hidden sets 41-45."

  | bm arr |
  bm := (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: hiddenSetSpecifier)).
  arr := bm enumerateWithLimit: maxResultSize startingAfter: 0.
  bm removeAll: arr.
^arr

]

{ #category : 'Legacy Hidden Set Support' }
System class >> hiddenSetEnumerateAsInts: hiddenSetSpecifier limit: maxResultSize [

"Will be deprecated, new code should use GsBitmaps"

"Returns an Array containing the numeric object identifiers of the
 first maxResultSize objects in the hiddenSet.  If the hidden set
 contains fewer than maxResultSize elements, returns an array containing
 the contents of the hiddenSet.  If maxResultSize = 0, the result will
 contain all elements of the hidden set.

 All of the returned elements are removed from the hidden set.
 Should only be used with public hidden sets 41-45."

  | bm arr arr1|
  bm := (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: hiddenSetSpecifier)).
  arr := bm enumerateAsOopsWithLimit: maxResultSize startingAfter: 0.
  arr1 := bm enumerateWithLimit: maxResultSize startingAfter: 0.
  bm removeAll: arr1.
^arr

]

{ #category : 'Legacy Hidden Set Support' }
System class >> hiddenSetReinit: hiddenSetSpecifier [

"Will be deprecated, new code should use GsBitmaps"

"Reinitializes the hiddenSet to empty.
 Should only be used with public hidden sets 41-45."

^ (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: hiddenSetSpecifier)) removeAll

]

{ #category : 'Legacy Hidden Set Support' }
System class >> hiddenSetSize: hiddenSetSpecifier [

"Will be deprecated, new code should use GsBitmaps"

" Returns the number of elments in the hiddenSet."

^ (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: hiddenSetSpecifier)) size

]

{ #category : 'Legacy Hidden Set Support' }
System class >> HiddenSetSpecifiers [

"Returns a list of the System hidden set specifiers ordered by index. 
 Note that the new public hidden set specifiers in GsBitmap have different 
 indexes; see GsBitmap hiddenSetSpecifiers. The GsBitmap indexes are accessible 
 in System class variables.

 Hidden sets with index 41 through 45 are for customer use and may be freely 
 modified using methods in this category.

 Other hidden sets are used internally by the system.  Many of them may only 
 be modifed by SystemUser; others may be accessed using specific public 
 protocol. Modifying internal hidden sets improperly may result in gem 
 and/or stone crashes and could potentially corrupt the database."

^#(
" 1"   'ListInstancesResult'
" 2"   'Reserved for GemStone Indexing maintenance'
" 3"   'RemovedDepMapEntries'
" 4"   'SaveNewPomObjs' "See method #_enableTraceNewPomObjs"
" 5"   'ObjectsRead'    "See method #_enableTraceObjectsRead"
" 6"   'Reserved for GemStone'
" 7"   'RcReadSet'
" 8"   'DepMapWriteSet'
" 9"   'PomWriteSet'  "Empty except after flush for commit, so only useful
                       after you get a transaction conflict."
"10"   'SaveDepMapChangedObjs'
"11"   'SaveWriteSetUnion'
"12"   'SaveWrittenObjs'
"13"   'ReadWriteConflicts'  "StrongRead-Write conflicts "
"14"   'SaveDepMapChangedUnion'
"15"   'WriteWriteConflicts'
"16"   'WriteDependencyConflicts'
"17"   'WriteReadLockConflicts'
"18"   'WriteWriteLockConflicts'
"19"   'Reserved for GemStone'
"20"   'AllocatedGciOops'
"21"   'Reserved for GemStone'
"22"   'ExportedDirtyObjs'
"23"   'TrackedDirtyObjs_NotImplemented'
"24"   'enumeration of ReferencedSet'
"25"   'NotifySet'
"26"   'Reserved1' "used in Conversion"
"27"   'Reserved2' "used in managing depList weak references"
"28"   'Reserved3' "used in object inventory"
"29"   'CommitReleaseLocksSet'
"30"   'CommitOrAbortReleaseLocksSet'
"31"   'Reserved for GemStone'
"32"   'Reserved for GemStone'
"33"   'Reserved for GemStone'
"34"   'GcCandidates'
"35"   'Unused'
"36"   'WriteLockWriteSubset'
"37"   'NewDataPages'
"38"   'StrongReadSet'
"39"   'PureExportSet'
"40"   'GciTrackedObjs_NotImplemented'
"41"   'Customer1'
"42"   'Customer2'
"43"   'Customer3'
"44"   'Customer4'
"45"   'Customer5'
)

]

{ #category : 'Notification' }
System class >> notifySet [

"Returns an Array of the objects that were registered for notification."

^(GsBitmap _newForHiddenSetId: NotifySet_id ) asArray

]

{ #category : 'Cache Statistics' }
System class >> pageManagerCacheStatistics [
"Return the cache statistics for the page manager thread if this session is located on
 the same host as the stone process.

 Only cache statistics applicable to the page manager thread are returned.
 Per-process host statistics are not included, see hostStatisticsForProcess: <pid>.
 The description of these statistics can be determined by evaluating:
   'System cacheStatisticsDescriptionForPageManger'

 nil is returned if the stone is not running the session's host."


| slot |
^ ((slot := self pageManagerProcessSlot) == -1)
	ifTrue:[ nil ] "not on stone host"
	ifFalse:[ self cacheStatisticsAt: slot ]

]

{ #category : 'Cache Statistics' }
System class >> pageManagerCacheStatisticWithName: aString [

"Return the value of the cache stat with the given name, which must match an
 element of the Array returned by the #cacheStatisticsDescription method
 applicable to the page manager thead.  The UserTime and SysTime statistics cannot
 be accessed using this method.

 Returns nil if a statistic matching aString was not found for the page manager.

 This method may be used on hosts remote from the stone process."

^ self _cacheStatWithName: aString opCode: 128

]

{ #category : 'Cache Statistics' }
System class >> pageManagerProcessSlot [

"Answer the cache slot for the page manager thread or -1 if the slot was not found.
Page manager exists only on the shared page cache used by the stone process."

^ self sessionIsOnStoneHost ifTrue:[ self _zeroArgPrim: 189 ] ifFalse:[ -1 ]

]

{ #category : 'Legacy Hidden Set Support' }
System class >> readHiddenSet: hiddenSetSpecifier fromFile: aString [

"Will be deprecated, new code should use GsBitmaps"

"Format of the file has changed between Gs64 v3.4 and v3.5.

 Read the contents of the specified bitmap file into the designated hidden
 set.  The file must exist and  be readable by the gem process.
 Should only be used with public hidden sets 41-45.
 Call System class >> hiddenSetReinit: first to ensure the hidden set is empty.
 Returns true if successful, false if an error occurred.  Additional error
 information may be written to stderr for the process (either the terminal
 or the gem log file)."

 | bm |
 bm := (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: hiddenSetSpecifier)).
 (bm isEmpty) ifFalse: [ ^ self _error: #rtErrInvalidArgument args: { 'hidden set is not empty' } ].
 bm readFromFile: aString.
 ^true

]

{ #category : 'Legacy Hidden Set Support' }
System class >> readHiddenSet: hiddenSetSpecifier fromSortedFile: aString [

"hiddenSetSpecifier must be a Symbol per GsBitmap class >> hiddenSetSpecifiers .
 Format of the file has changed between Gs64 v3.4 and v3.5 .

 Read the contents of the specified sorted bitmap file into the designated
 hidden set. The file must exist and  be readable by the gem process.
 Should only be used with public hidden sets 41-45.
 Call System class >> hiddenSetReinit: first to ensure the hidden set is empty.
 The file is assumed to be a sorted bitmap file of objects produced by one
 of the Repository>>listInstancesInPageOrder: methods.  The objects are
 loaded into the given hidden set, but the ordering  by page ID is lost
 because hidden sets are always ordered by object ID.  No validation of the
 object IDs is done by this load.

 Returns true if successful, false if an error occurred.  Additional error
 information may be written stderr for the process (either the terminal
 or the gem log file)."

hiddenSetSpecifier _isSymbol ifFalse:[
  Error signal:'Argument must conform to GsBitmap class >> hiddenSetSpecifiers'.
 ].
^self _loadOrStoreHiddenSet: hiddenSetSpecifier toOrFromFile: aString opCode: 2

]

{ #category : 'Gci Set Support' }
System class >> remove: anObject fromGciSet: hiddenSetSpecifier [

"Remove the specified object from a GCI hidden set, where
   hiddenSetSpecifier = 39 specifies PureExportSet
 Other values of hiddenSetSpecifier are not allowed.
 Has no effect if anObject is a special object.

 If hiddenSetSpecifier = 39 and a userAction is
 active an error is generated, since the PureExportSet
 cannot be modified from within a user action."

^ self _remove: anObject fromGciSet: hiddenSetSpecifier

]

{ #category : 'Legacy Hidden Set Support' }
System class >> remove: anObject fromHiddenSet: hiddenSetSpecifier [

"Will be deprecated, new code should use GsBitmaps"

"Removes anObject from the hiddenSet.  Do nothing if anObject is not in
 the hidden set.

 Should only be used with public hidden sets 41-45."

| bm |
  bm := (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: hiddenSetSpecifier)).
  (bm includes: anObject) ifTrue: [ bm remove: anObject ].
^ self

]

{ #category : 'Gci Set Support' }
System class >> removeAll: anArray fromGciSet: hiddenSetSpecifier [

"Remove contents of anArray from a GCI hidden set, where
   hiddenSetSpecifier = 39  specifies PureExportSet
 Other values of hiddenSetSpecifier are not allowed.

 If the argument anArray == true, all objects in
 the specified set are removed from that set .

 If hiddenSetSpecifier = 39 and a userAction is
 active an error is generated, since the PureExportSet
 cannot be modified from within a user action."

^ self _removeAll: anArray fromGciSet: hiddenSetSpecifier

]

{ #category : 'Legacy Hidden Set Support' }
System class >> removeAll: anArray fromHiddenSet: hiddenSetSpecifier [

"Will be deprecated, new code should use GsBitmaps"

"Removes the contents of anArray from the hiddenSet (anArray itself is not
 removed from  the hiddenSet).  Objects in the array which are not in the
 hidden set are ignored. Returns a SmallInteger or LargeInteger indicating
 the number of elements successfully removed from the hidden set.

 Should only be used with public hidden sets 41-45."

^ (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: hiddenSetSpecifier)) removeAll: anArray

]

{ #category : 'Releasing Locks' }
System class >> removeAllFromCommitOrAbortReleaseLocksSet: aCollection [

"Remove all the elements of aCollection from the commit-or-abort release
 locks set.  If an element of aCollection is not a member of the set,
 it is ignored."

 | ary |
 ary := aCollection .
 aCollection _isArray ifFalse:[ ary := Array withAll: aCollection ].
 (GsBitmap _newForHiddenSetId: CommitOrAbortReleaseLocksSet_id) removeAll: ary .
 ^self
]

{ #category : 'Releasing Locks' }
System class >> removeAllFromCommitReleaseLocksSet: aCollection [

"Remove all elements of aCollection from the commit release locks set.
 If an element of aCollection is not a member of the set, it is ignored."

 | ary |
 ary := aCollection .
 aCollection _isArray ifFalse:[ ary := Array withAll: aCollection ].
 (GsBitmap _newForHiddenSetId: CommitReleaseLocksSet_id) removeAll: ary .
 ^self

]

{ #category : 'Notification' }
System class >> removeAllFromNotifySet: aCollection [

"Removes all elements of aCollection from the notify set.  Does not generate an
 error if any of the elements are not in the notify set."

self _updateNotifySet: aCollection add: false

]

{ #category : 'Legacy Hidden Set Support' }
System class >> removeContentsOfHiddenSet: first from: second [

"Will be deprecated, new code should use GsBitmaps"

"Remove all objects in the first hidden set from the second hidden set second.
 Returns the number of objects removed from second hidden set.
 Should only be used with a second set that is public, sets 41-45.
 User must have permission to modify the second hidden set or be SystemUser."

 | bm1 bm2 |
 bm1 := (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: first)).
 bm2 := (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: second)).
^ bm2 removeAll: bm1

]

{ #category : 'Legacy Hidden Set Support' }
System class >> removeFirst: count objectsFromHiddenSet: hiddenSetSpecifier [

"Will be deprecated, new code should use GsBitmaps"

"Remove the first count objects from the given hidden set.  Objects are removed from
 the beginning, going from lowest to highest object ID.

 Returns the number of objects removed from the hidden set.
 Should only be used with a third set that is public, sets 41-45.
 User must have permission to modify the third hidden set or be SystemUser."

^ ((GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: hiddenSetSpecifier)) removeFirst: count) size

]

{ #category : 'Releasing Locks' }
System class >> removeFromCommitOrAbortReleaseLocksSet: anObject [

"Remove anObject from the commit-or-abort release locks set.  If anObject
 is not a member of the set, do nothing."

(GsBitmap _newForHiddenSetId: CommitOrAbortReleaseLocksSet_id ) _remove: anObject

]

{ #category : 'Releasing Locks' }
System class >> removeFromCommitReleaseLocksSet: anObject [

"Remove anObject from the commit release locks set.  If anObject is
 not a member of the set, do nothing."

(GsBitmap _newForHiddenSetId: CommitReleaseLocksSet_id) _remove: anObject

]

{ #category : 'Notification' }
System class >> removeFromNotifySet: anObject [

"Removes anObject from the notify set.  Does not generate an error if anObject
 is not in the notify set."

self _updateNotifySet: { anObject } add: false

]

{ #category : 'Online Backup Support' }
System class >> resumeCommits [

    "For use after suspendCommitsForFailover or _suspendCommitsForDebug,
     Resumes commits on a master stone and restarts reclaim gems.
     Returns a DateAndTime representation of the time
     at which commits were suspended (the failover timestamp) .

     Restoring a backup file or   startstone -R
     also have the effect of resuming commits.

     Requires SystemControl privilege."
  | ts |
  ts := self _zeroArgPrim: 156 .
  ts == 0 ifTrue:[ Error signal:'Commits have not been suspended' ].
  ^ DateAndTime posixSeconds: ts offset: Duration zero .

]

{ #category : 'Notification' }
System class >> signaledObjects [

"Returns an Array containing the objects that have been signaled since the last
 time this method was executed.  The elements in the Array are a subset of the
 notify set.  Clear the set of signaled objects."

<primitive: 365>
self _primitiveFailed: #signaledObjects .
self _uncontinuableError

]

{ #category : 'Notification' }
System class >> signaledObjectsErrorStatus [

"Returns true to indicate that the system generates errors when objects are
 added to the signaled objects set.  Returns false otherwise."

^self _signalErrorStatus: 1

]

{ #category : 'Online Backup Support' }
System class >> suspendCommitsForFailover [
   "Not recommended for use as of Gs64 v3.7.0, signals an Error.

    For use on the master system of a hotstandby pair.
    Suspends commits, starts a checkpoint,
    and waits for completion of the checkpoint.
    Returns a DateAndTime representation of the failover timestamp.
    After this method returns, the master stone may then be shutdown , or
    commits can be resumed with System(C)>>resumeCommits .

    Requires SystemControl privilege.
    If the repository is in restore mode, signals an error, and has no effect.

    While commits are suspended,
      attempts to commit will signal an Exception ,

      reclaim activity is suspended (reclaim gems are stopped)

      markForCollection will signal an Exception when it attempts
      to acquire the gcLock ,

      epochGc will be suspended .

    The state of commits being suspended on a stone will survive shutdown or crash
    and restart of that stone, however the suspendCommits operation is not replayed
    by replay of tranlogs.

    When continuous restore reads a checkpoint containing a failover timestamp
    and the failover timestamp represents a time after the time at which
    the slave stone last started,  continuous restore will stop.
    If the failover timestamp is before the time at which
    the slave stone last started, continuous restore will continue replay
    of the transaction logs.
    The failover timestamp is printed to the slave stone's log,
    and will be returned from restoreStatus  method on the slave system.

    Failover timestamps will be printed to the logsender and logreceiver
    log files when they are read or written by those processes.

    failOverToSlave and suspendCommitsForFailover are mutually exclusive.
    suspendCommitsForFailover is to be used when you want the master system
    to continue running as the master , and the slave system to stop
    restore from tranlogs at the last commit preceding suspendCommitsForFailover .

    failOverToSlave is to be used when you want the master role to move
    to the other system.
"

  Error signal: 'suspendCommitsForFailover strongly discouraged, use Repository>>failOverToSlave'.
  "OLD CODE
  | ts |
  ts := self _zeroArgPrim: 155 .
  ^ DateAndTime posixSeconds: ts offset: Duration zero .
  "
]

{ #category : 'Private' }
System class >> _suspendCommitsForDebug [
  "Suspends commits for the purpose of debugging the repository state.
   Subsequent attempts to commit in any session will signal an error.
   Use resumeCommits to cancel the effect of _suspendCommitsForDebug .
  "
  | ts |
  ts := self _zeroArgPrim: 198 .
  ^ DateAndTime posixSeconds: ts offset: Duration zero .
]

{ #category : 'Legacy Hidden Set Support' }
System class >> testIf: anObject isInHiddenSet: hiddenSetSpecifier [

"Will be deprecated, new code should use GsBitmaps"

"Returns true if anObject is in the hiddenSet, false otherwise."

^ (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: hiddenSetSpecifier)) includes: anObject

]

{ #category : 'Legacy Hidden Set Support' }
System class >> truncateHiddenSet: hiddenSetSpecifier toSize: newSize [

"Will be deprecated, new code should use GsBitmaps"

"Truncate the given hidden set by removing objects from the end of the set until it reaches a
 size of newSize.  Objects are removed in order, going from highest to lowest object ID.

 Returns the number of objects removed from the hidden set.
 Should only be used with a third set that is public, sets 41-45.
 User must have permission to modify the third hidden set or be SystemUser."

 | bm bmSize count |
 bm := (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: hiddenSetSpecifier)).
 bmSize := bm size.
 count := bmSize - newSize.
 (count <= 0) ifTrue: [ count := 0].
 bm removeLast: count.
^count

]

{ #category : 'Legacy Hidden Set Support' }
System class >> writeHiddenSet: hiddenSetSpecifier toFile: aString [

"Will be deprecated, new code should use GsBitmaps"

"Format of the file has changed between Gs64 v3.4 and v3.5 .

 Write the designated hidden set to the specified bitmap file.  The file
 must not already exist and the path to the file must be in a directory
 which is writable by the process.  Any valid hidden set specifier may be
 used.

 Returns true if successful, false if an error occurred.  Additional error
 information may be written stderr for the process (either the terminal
 or the gem log file)."

 (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: hiddenSetSpecifier)) writeToFile: aString.
^ true

]

{ #category : 'Legacy Hidden Set Support' }
System class >> writeHiddenSet: hsId toPageOrderFile: aString maxBufferSizeMb: mb [

"Will be deprecated, new code should use GsBitmaps"

"Writes the object IDs for objects contained in the given hidden set to a
 file in page ID order.

 If this session contains uncommitted changes to the repository, the method
 signals a error: #rtErrAbortWouldLoseData, to indicate that data could be lost.
 Otherwise it puts the session into auto-begin transaction mode and aborts."

| bm arr |

self needsCommit
  ifTrue: [ self _error: #rtErrAbortWouldLoseData ] .

 bm := (GsBitmap newForHiddenSet: (GsBitmap hiddenSetIdAsSymbol: hsId)).
 arr := Array with: (bm writeToFileInPageOrder: aString).
 arr add: 1.
^arr

]

{ #category : 'Cache Statistics' }
System class >> cacheStatisticsDescriptionForGemThreads [

"Returns an Array of Strings describing cache statistics applicable to threads
 started by gems for certain repository-wide operations such as markForCollection,
 full backup, etc."

^ self _zeroArgPrim: 4512

]

{ #category : 'Debugging Support' }
System class >> waitForDebug [
  ^ self _waitForDebug: false
]

{ #category : 'Debugging Support' }
System class >> waitForDebugWithAbort [
  ^ self _waitForDebug: true
]

{ #category : 'Debugging Support' }
System class >> _waitForDebug: withAbortBool [
  | msg |
  "An application should execute this method when it wants to wait for
   for a topaz -r to attach with DEBUGGEM.
   In an interactive topaz -l,  this method signals a Break and neither the waiting logic
   nor the commands after DEBUGGEM apply.

  __sessionStateAt: 26 states  
      nil default, 
      1 attach seen,   (topaz -r LOGOUT , DETACH set this state also)
      2 resume (topaz -r staying attached with RESUME, STEP, CONTINUE)
      3 ExitClientError (topaz -r did KILL)
    In the topaz -r after DEBUGGEM,
      LOGOUT or other loss of connection makes no change, and you can reattach with DEBUGGEM .
  "
  GsFile stdoutServer isTerminal ifTrue:[
    ^ Break new details:'System class >> waitForDebug invoked in interactive topaz -l'; signalToGci.
  ].
  self listenForDebugConnection . 
  msg := 'Waiting for a topaz -r to attach with DEBUGGEM to process ', System gemProcessId asString .
  msg lf .
  GsFile stdoutServer nextPutAll: msg; flush.
  GsFile gciLogServer: msg .
  [ "wait for a topaz -r to attach "
    [ (System __sessionStateAt: 26) == nil ] whileTrue:[
      System _sleepMs: 250 .  "avoid causing a GsProcess switch"
      withAbortBool ifTrue:[ System abortTransaction ].
    ].
  ] on: Break do:[:ex | "topaz -r has attached with DEBUGGEM"
    System __sessionStateAt: 26 put: 1  .
  ].
  Break signalToGci .   "signal to GCI of the the topaz -r "
  [ (System __sessionStateAt: 26) == 1 ] whileTrue:[  "wait here if the topaz -r did DETACH"
    System _sleepMs: 250 .  "avoid causing a GsProcess switch"
  ] .
  (System __sessionStateAt: 26) ifNotNil:[:v | 
     v >= 3 ifTrue:[ ExitClientError signal:'kill from topaz -r (debuggem)' status: 2 ].
  ].
]

{ #category : 'Private' }
System class >> _warmSymbolsFrom: startBucket to: endBucket [
  "Fault in all Symbols in specified buckets of AllSymbols"
  | allSyms |
  allSyms := Object objectForOop: 240385 .
  startBucket to: endBucket do:[:n | | bucket |
    bucket := allSyms _at: n . 
    1 to: bucket size do:[:j | | aSym |
      aSym := bucket _at: j .   
    ].
    System abortTransaction .
  ].
  ^ true
]

{ #category : 'Clustering' }
System class >> warmAllSymbols: numSessions [
  "Warm AllSymbols, using the same login parameters as the current session.
   Note that this requires the current user's password be set to swordfish."
  ^ self warmAllSymbols: numSessions parameters: GemStoneParameters newDefault
]

{ #category : 'Clustering' }
System class >> warmAllSymbols: numSessions parameters: aGemStoneParameters [
  "Warm AllSymbols, using numSessions slave sessions to do the warming.
   Example
      | p | p := GemStoneParameters newDefault .
      p password: 'myGemStonePassword' ;   hostPassword:'mypassword' .
      System warmAllSymbols: 5 parameters: p
  "
  | sessions |
  sessions := { } .
  [ | aSess allSyms tableSize ofs bucketsPerSess |
    numSessions timesRepeat:[ | sess |
      (sess := GsTsExternalSession newDefault) parameters: aGemStoneParameters; login  .
      sessions add: sess . 
      GsFile gciLogServer:'started slave gem ', sess gemProcessId asString .
    ].
    allSyms := Object objectForOop: 240385 .
    tableSize := allSyms tableSize .
    bucketsPerSess := tableSize // numSessions .
    ofs := 1 .
    1 to: numSessions - 1 do:[:n| | sess limit |
      sess := sessions at: n .
      limit := ofs + bucketsPerSess .
      sess forkString: 'System _warmSymbolsFrom: ', ofs asString, ' to: ', (limit - 1) asString .
      ofs := limit .
    ]. 
    sessions last forkString:'System _warmSymbolsFrom: ', ofs asString, ' to: ', tableSize asString .
    aSess := sessions first .
    [ aSess isReadReady ] whileFalse:[
      Delay waitForSeconds: 1 .
      System abortTransaction
    ].
    sessions do:[:sess | | res |
      res := sess waitForResult; lastResult .
      res == true ifFalse:[ Error signal:'bad result' , res asString ].
    ] 
  ] ensure:[
    sessions do:[:sess | sess nbLogout ].
  ]
]

{ #category : 'Debugging Support' }
System class >> cancelWaitForDebug [
  "For use in a topaz -r attached with DEBUGGEM .
   Then upon topaz CONTINUE or after LOGOUT or DETACH,
   the debugged session will return from System class >> waitForDebug.
   and keep executing."

  self deprecated: 'Deprecated v3.7.2; this method is no longer neccessary'.

  System __sessionStateAt: 26 put: 2
]

