Extension { #name : 'JISString' }

{ #category : 'Formatting' }
JISString class >> charSize [

"Returns the number of bytes that make up a character"
^2

]

{ #category : 'Formatting' }
JISString >> charSize [

"Returns the number of bytes that make up a character"
^2

]

{ #category : 'Accessing' }
JISString >> codePointAt: anIndex [

"Returns the JIS code point at anIndex."

| highByte lowByte offset |

offset := anIndex + anIndex  .
lowByte := self _basicAt: offset .
highByte := self _basicAt: offset - 1 .
 ^ (highByte * 256) + lowByte

]


{ #category : 'Accessing' }
JISString >> size [

"Returns the size of the receiver in Characters."

^ self _basicSize // 2

]


