Extension { #name : 'ObsoleteSymbolSet' }

{ #category : 'Repository Conversion' }
ObsoleteSymbolSet class >> _correspondingNewClass [

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteSymbolSet)
  ifTrue: [ ^ SymbolSet ].

^ self.

]

{ #category : 'Adding' }
ObsoleteSymbolSet >> _addSymbol: aSymbol [

"Obsolete, provided for compatibility.
 Same functionality as IdentitySet | add: "

^ self add: aSymbol

]

{ #category : 'Accessing' }
ObsoleteSymbolSet >> _returnValueOf: anObject [

"Returns the element of the receiver whose value is the same as the argument.
 If the argument is not equal to any value in the receiver, then add the
 argument to the receiver."

|symbolizedObject|

symbolizedObject := anObject asObsoleteSymbol.
self add: symbolizedObject.
^ symbolizedObject

]

{ #category : 'Repository Conversion' }
ObsoleteSymbolSet >> convertToSymbolSet [

"Private. Changes the receiver from being an instance of ObsoleteSymbolSet to
 an instance of SymbolSet. Used in Repository Conversion."

<primitive: 487>
self _primitiveFailed: #convertToSymbolSet

]

{ #category : 'Repository Conversion' }
ObsoleteSymbolSet >> rehashForConversion [

"Private. Rebuilds an NSC to fix up internal sort order of the elements.
 Returns the receiver."

| contentClassSet |

contentClassSet := IdentitySet new.
self do: [ :anElement |
  contentClassSet add: (anElement class)
  ].

(contentClassSet includes: ObsoleteSymbol)
  ifFalse: [ self convertToSymbolSet ].

^ self.

]
