Extension { #name : 'SimpleBlock' }

{ #category : 'Disassembly' }
SimpleBlock class >> _cost [

^ 1


]

{ #category : 'Accessing' }
SimpleBlock >> _sourceString [

"Return a string that will create a block similar to the receiver when
 the string is compiled."

| result |
(result := '^ ' copy )
   addAll: ( method _sourceString copyFrom: firstSourceOffset to: lastSourceOffset  ) .
^result

]

{ #category : 'Testing' }
SimpleBlock >> isSimple [

"Return true.  The receiver is a simple block."

^ true

]

{ #category : 'Block Evaluation' }
SimpleBlock >> value [

"Return the value of the receiver evaluated with no arguments.
 If the block expects any arguments, an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"

]

{ #category : 'Block Evaluation' }
SimpleBlock >> value: anObject [

"Return the value of the receiver evaluated with anObject as its argument.  If
 the block expects a different number of arguments, an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"

]

{ #category : 'Block Evaluation' }
SimpleBlock >> value: firstObject value: secondObject [

"Return the value of the receiver evaluated with the two objects as its
 arguments.  If the block expects a different number of arguments, an error is
 generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"

]

{ #category : 'Block Evaluation' }
SimpleBlock >> value: firstObject value: secondObject value: thirdObject [

"Return the value of the receiver evaluated with the three objects as its
 arguments.  If the block expects a different number of arguments, an error is
 generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"

]

{ #category : 'Block Evaluation' }
SimpleBlock >> value: first value: second value: third value: fourth [

"Return the value of the receiver evaluated with the four objects as
 its arguments.  If the block expects a different number of arguments,
 an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"

]

{ #category : 'Block Evaluation' }
SimpleBlock >> value: first value: second value: third value: fourth value: fifth [

"Return the value of the receiver evaluated with the five objects as
 its arguments.  If the block expects a different number of arguments,
 an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"

]

{ #category : 'Block Evaluation' }
SimpleBlock >> valueWithArguments: argList [

"Return the value of the receiver evaluated with the elements of the Array
 argList as arguments.  If the block expects a different number of arguments,
 an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"

]
