Extension { #name : 'GsComGotoNode' }

{ #category : 'Instance creation' }
GsComGotoNode class >> _basicNew [
"create an instance registered with VM for finalization of cData"

<primitive: 674>
self _primitiveFailed: #_basicNew

]

{ #category : 'Instance creation' }
GsComGotoNode class >> new [
  ^ self _basicNew initialize

]

{ #category : 'Instance Initialization' }
GsComGotoNode >> argNode: anIrNode [
  argNode := anIrNode

]

{ #category : 'Instance Initialization' }
GsComGotoNode >> initialize [
  kind := COMPAR_GOTO_NODE .

]

{ #category : 'Instance Initialization' }
GsComGotoNode >> localRubyBreak: aLabelNode [
  targetKind :=  COM_GOTO_BREAK.
  target := aLabelNode .
  argForValue :=  true

]

{ #category : 'Instance Initialization' }
GsComGotoNode >> localRubyNext: aLabelNode argForValue: aBoolean [
  targetKind := COM_GOTO_NEXT .
  target := aLabelNode  .
  argForValue := aBoolean

]

{ #category : 'Instance Initialization' }
GsComGotoNode >> localRubyRedo: aLabelNode [
  targetKind := COM_GOTO_REDO .
  target := aLabelNode  .
  argForValue := false

]

{ #category : 'Instance Initialization' }
GsComGotoNode >> nonLocalRubyNext [
  "target left as nil"
  targetKind := COM_GOTO_NEXT .
  argForValue := true

]

{ #category : 'Instance Initialization' }
GsComGotoNode >> nonLocalRubyRedo [
  "target left as nil"
  targetKind := COM_GOTO_REDO .
  argForValue := false

]

{ #category : 'Printing' }
GsComGotoNode >> printFormattedOn: aStream [
  super printOn: aStream .
  aStream print:' target objId:' int: target asOop ; cr ;
    nextPutAll: ' kind:' ; nextPutAll:
         ( #( #next #redo #retry #break ) at: targetKind) ;
    print: ' argForValue:' bool: argForValue ; cr ;
    nextPutAll: '    argNode:' .
  argNode ifNil:[ aStream nextPutAll:'nil' ]
       ifNotNil:[ argNode printFormattedOn: aStream  ].
  aStream nextPut: $) ; cr .

]
