Extension { #name : 'GsComLoopNode' }

{ #category : 'Instance creation' }
GsComLoopNode class >> new [
  ^ self _basicNew initialize

]

{ #category : 'Instance Initialization' }
GsComLoopNode >> breakLabel: aLabelNode [
  breakLabel := aLabelNode

]

{ #category : 'Instance Initialization' }
GsComLoopNode >> initialize [
  kind := COMPAR_LOOP_NODE .

]

{ #category : 'Instance Initialization' }
GsComLoopNode >> iterResult: aLiteralNode [
  iterResult := aLiteralNode

]

{ #category : 'Printing' }
GsComLoopNode >> printFormattedOn: aStream [
  super printOn: aStream .
  aStream nextPutAll:' send: '; indentMore ; cr .
     send printFormattedOn: aStream.
  aStream  indentLess ; cr ;
     nextPutAll:' label: ' .
  breakLabel printFormattedOn: aStream.
  iterResult ifNotNil:[
    aStream nextPutAll:' iterResult: ' .
    iterResult printFormattedOn: aStream.
  ].
  aStream nextPut: $) ; cr .

]

{ #category : 'Instance Initialization' }
GsComLoopNode >> send: aSendNode [
  send := aSendNode

]
