Extension { #name : 'GsComSelectorLeaf' }

{ #category : 'Initialization' }
GsComSelectorLeaf class >> _initializeSpecialSelectors [
  | specSendsDict specialISAdict objectSpecSends data |

  " syms are the ruby or Smalltalk selectors that will be sent for
    the specified bytecodes.  comparse.c takes care of
    optimizations for Smalltalk sends of those bytecodes, when compiling
    Smalltalk source. "

  "each triple  in data Array is
       1. selector to be optimized
                   (either a Ruby or Smalltalk selector from AST to IR phase)
       2. special send bytecode to use ,
       3. class on which special send is defined
       4. environment in which selector is a special send on Object,
           nil means all environments.
   special sends not defined on class Object get a send-site cache
   during bytecode generation and may fall back to real method"
  		"ruby_selector_suffix dependent"
  data := {
  { #'+#1__' . Bc_SEND_SPECIAL_PLUS_u1_u32 . SmallInteger . 1 } .   "for Ruby"
  { #'-#1__' . Bc_SEND_SPECIAL_MINUS_u1_u32 . SmallInteger . 1 } .
  { #'*#1__' . Bc_SEND_SPECIAL_MULTIPLY_u1_u32 . SmallInteger . 1 } .
  { #'>=#1__' . Bc_SEND_SPECIAL_GTE_u1_u32 . SmallInteger . 1 } .
  { #'<=#1__' . Bc_SEND_SPECIAL_Lte_u1_u32 . SmallInteger . 1 } .
  { #'<#1__'  . Bc_SEND_SPECIAL_LT_u1_u32 . SmallInteger . 1 } .

  { #'+' . Bc_SEND_SPECIAL_PLUS_u1_u32 . SmallInteger . 0 } .   "for Smalltalk"
  { #'-' . Bc_SEND_SPECIAL_MINUS_u1_u32 . SmallInteger . 0 } .
  { #'*' . Bc_SEND_SPECIAL_MULTIPLY_u1_u32 . SmallInteger . 0 } .
  { #'>=' . Bc_SEND_SPECIAL_GTE_u1_u32 . SmallInteger . 0 } .
  { #'<=' . Bc_SEND_SPECIAL_Lte_u1_u32 . SmallInteger . 0 } .
  { #'<'  . Bc_SEND_SPECIAL_LT_u1_u32 . SmallInteger . 0 } .

  { #'==' . Bc_SEND_SPECIAL_EQEQ . Object .   0 } .
  { #'~~' . Bc_SEND_SPECIAL_NENE . Object .   0  } .

  { #'_equal?#1__' . Bc_SEND_SPECIAL_EQEQ . Object . 1 } .  "Ruby identity compare"
  { #'_not_equal?#1__' . Bc_SEND_SPECIAL_NENE . Object . 1 } .  "Ruby identity compare"
  " any call variation with & does not use  Bc_SEND_CALL (1.8.7) "
  { #'_isInteger#0__' . Bc_SEND_SPECIAL_IS_INTEGER . Object . 1 } .
  { #'_isSmallInteger#0__' . Bc_SEND_SPECIAL_IS_SMALLINT . Object . 1 } .
  { #'_isFixnum#0__' . Bc_SEND_SPECIAL_IS_SMALLINT . Object . 1 } .
  { #'_isNumeric#0__' . Bc_SEND_SPECIAL_IS_NUMBER . Object . 1 } .
  { #'_isFloat#0__' . Bc_SEND_SPECIAL_IS_FLOAT . Object . 1 } .
  { #'_isSymbol#0__' . Bc_SEND_SPECIAL_IS_SYMBOL . Object . 1 } .
  { #'_isExecBlock#0__' . Bc_SEND_SPECIAL_IS_ExecBlock . Object . 1 } .
  { #'_isBlock#0__' . Bc_SEND_SPECIAL_IS_ExecBlock . Object . 1 } .
  { #'_isArray#0__' . Bc_SEND_SPECIAL_IS_Array . Object . 1 } .
  { #'_isStringOrSymbol#0__' . Bc_SEND_SPECIAL_IS_OneByteString . Object . 1 } . "used in Ruby"
  { #'_isRange#0__' . Bc_SEND_SPECIAL_IS_Range . Object } .

  { #_stringCharSize  . Bc_SEND_SPECIAL_stringCharSize . Object  . 0 } . 
  { #_isOneByteString . Bc_SEND_SPECIAL_IS_OneByteString . Object . 0 } . "used in Smalltalk"
  { #_isExceptionClass . Bc_SEND_SPECIAL_IS_ExceptionClass . Object . 0 } .
  { #_isNumber . Bc_SEND_SPECIAL_IS_NUMBER . Object . 0 } .
  { #_isScaledDecimal . Bc_SEND_SPECIAL_IS_ScaledDecimal . Object . 0 } . "Smalltalk"
  { #_isInteger . Bc_SEND_SPECIAL_IS_INTEGER . Object . 0 } .
  { #_isSmallInteger . Bc_SEND_SPECIAL_IS_SMALLINT . Object . 0 } .
  { #_isFloat . Bc_SEND_SPECIAL_IS_FLOAT . Object . 0 } .
  { #_isSymbol . Bc_SEND_SPECIAL_IS_SYMBOL . Object . 0 } .
  { #_isExecBlock  . Bc_SEND_SPECIAL_IS_ExecBlock . Object . 0 } .
  { #_isArray . Bc_SEND_SPECIAL_IS_Array . Object . 0 } .
  { #_isRange . Bc_SEND_SPECIAL_IS_Range . Object } .
  { #isNil . Bc_IS_NIL . Object } .
  { #notNil . Bc_NOT_NIL . Object } .
  { #yourself . Bc_SEND_yourself . Object }

  }.
  objectSpecSends := IdentityKeyValueDictionary new .
  specSendsDict := IdentityKeyValueDictionary new .
  data do:[:triple | | sym bc cls |
    sym := triple at: 1 . bc := triple at: 2 .  cls := triple at: 3 .
    specSendsDict at: sym put: { bc . cls } .
    cls == Object ifTrue:[ | env |
      env := triple atOrNil: 4 .
      env ifNil:[ env := -1 ].
      objectSpecSends at: sym put: env .
    ].
  ].
  objectSpecSends immediateInvariant .
  specSendsDict immediateInvariant .

  specialISAdict := IdentityKeyValueDictionary new .
  specialISAdict   "env 0 selectors used in Ruby coerce_to logic"
        at: Symbol put: #( _isSymbol Symbol ) ;
        at: SmallInteger put: #(  _isSmallInteger  Fixnum ) ;
        at: Float put: #(  _isFloat  Float ) ;
        at: Integer put: #(  _isInteger  Integer ) ;
        at: Number put: #(  _isNumber  Number ) ;
        at: ExecBlock put: #(  _isExecBlock  ExecBlock ) ;
        at: Array put: #(  _isArray  Array ) ;
        at: String put: #(  _isRubyString  String ) ;
        at: Range put: #(  _isRange  Range )  .
  specialISAdict immediateInvariant .

  #( #SpecialSendsDict #SpecialISAselectors #SpecialObjectSends ) do:[:sym|
    self _removeClassVar: sym ifAbsent:[].
  ].
  self  _addInvariantClassVar: #SpecialSendsDict value: specSendsDict ;
    _addInvariantClassVar: #SpecialISAselectors value: specialISAdict ;
    _addInvariantClassVar: #SpecialObjectSends value: objectSpecSends .
]

{ #category : 'Accessing' }
GsComSelectorLeaf class >> classToISAselector: aClass [
  "Return the special selector to use in optimizing Ruby coerce_to
   for coercion to aClass .  Return nil if aClass does not have
   a special _is*  selector. "
  | val |
  val := SpecialISAselectors at: aClass otherwise: nil .
  val ifNotNil: [ val := val at: 1 ] .
  ^ val

]

{ #category : 'Accessing' }
GsComSelectorLeaf class >> classToRubyClassName: aClass [
  "Return the ruby class name to use in optimizing Ruby coerce_to
   for coercion to aClass .  Return nil if aClass does not have
   a special _is*  selector. "
  | val |
  val := SpecialISAselectors at: aClass otherwise: nil .
  ^ val  ifNil: [ aClass name ]
      ifNotNil: [ val at: 2 ] .

]

{ #category : 'Initialization' }
GsComSelectorLeaf class >> newSelector: aSymbol env: envId [
  "For Smalltalk this should normally be invoked via
   GsComSendNode>>stSelector: and envId should be zero regardless
   of the environment of the GsComMethNode method being generated."
  | entry |
  entry :=  SpecialSendsDict at: aSymbol otherwise: nil .
  entry ifNil:[
    ^ aSymbol " a non-optimized send"
  ] ifNotNil:[ | entryEnv |
    entryEnv := entry atOrNil: 4 .
    (entryEnv ~~ nil and:[ entryEnv ~~ envId]) ifTrue:[
       ^ aSymbol "not optimized in this environment"
    ].
    ^ self _basicNew _init: entry sym: aSymbol
  ]

]

{ #category : 'Initialization' }
GsComSelectorLeaf class >> reimplementationAllowed: aSymbol inEnv: anInt [
  "returns true if reimplementation is allowed in specified environmentId"
| env |
env := SpecialObjectSends at: aSymbol otherwise: nil .
env ifNotNil:[
  env < 0 ifTrue:[ ^ false "disallowed in all environments"].
  ^ anInt ~~ env
].
^ true

]

{ #category : 'Initialization' }
GsComSelectorLeaf class >> selectorForSuper: aSymbol [
  "cannot optimize a send to super "
  ^ aSymbol

]

{ #category : 'Initialization' }
GsComSelectorLeaf >> _init: specialSendsEntry sym: aSymbol [
  kind := COMPAR_SELECTOR_LEAF .
  selector := aSymbol .
  specialOpcode := specialSendsEntry at: 1 .
  specialSendClass := specialSendsEntry at: 2 .
  ^ self

]

{ #category : 'Printing' }
GsComSelectorLeaf >> printFormattedOn: aStream [

  super printOn: aStream .
  aStream nextPutAll: selector printString ;
      print: ' specialOpcode:' int: specialOpcode ;
      nextPutAll: ' specialSendClass:' ;
      nextPutAll:(specialSendClass ~~ nil ifTrue:[ specialSendClass name] ifFalse:['nil']) ;
      nextPut: $) .

]

{ #category : 'Accessing' }
GsComSelectorLeaf >> selector [
  ^ selector

]

{ #category : 'Instance Initialization' }
GsComSelectorLeaf >> setIRnodeKind [

]
