"
A GsComBlockNode represents a block within a method. It may be
 either a real block or a block that will be inlined by the parser.

   lexLevel, a SmallInteger > 0, lexical level of the block within the
                source of the home method, without regard to inlining.
   lastSrcOffset,  end of the source for the block within the method,
          a byteOffset if srcOffset is non-nil, otherwise a line number.
   blkKind, a SmallInteger,  a ComBlockEKind ,
     0 normal block, 1 Smalltalk select:{} block;  always 0 for Ruby .
   args, each element is a GsComVarLeaf
   lastArgInfo , a SmallInteger
   temps, an Array , each element is a GsComVarLeaf
   statements ,an Array or OrderedCollection ,  the body of the block
   terms  , an Array, used only with blkKind==1 .


"
Class {
	#name : 'GsComBlockNode',
	#superclass : 'GsCompilerIRNode',
	#instVars : [
		'lexLevel',
		'lastSrcOffset',
		'blkKind',
		'args',
		'lastArgInfo',
		'temps',
		'statements',
		'terms'
	],
	#classVars : [
		'HasBlockArg_mask',
		'LastArgInfo_mask',
		'LastArgStar_mask',
		'NoDeclaredArgs_mask'
	],
	#gs_reservedoop : '241921',
	#category : nil
}
