"
A GsComMethNode represents a single method in the Smalltalk sense.
 It can be an anonymous method, as for a  doit .  For each GsComMethNode,
 A GsComMethNode is the root node of the IR graph for each invocation of
 the code generator .
 The generator emits one or more instances of GsNMethod, one for the
 home method of this node, and one for any non-inlined blocks within the method.
 The instVars are

    selector, a Symbol , or nil for an anonymous method.
    theClass, a Behavior, class in which method is to be an instanceMethod,
                may be nil for an anonymous method.  Note generator does not
                install method in method dictionary.
    arguments, an Array , each element is a GsComVarLeaf
    temps    , an Array , each element is a GsComVarLeaf
    body     , an Array , each element is a GsCompilerIRNode for a statement
    methInfo , a SmallInteger , 0 for a ruby method .
        bit masks of the fields are
            requiresVc 16rFF (not used by smalltalk, 0=no, 1=yes,
              2=force all temps to be allocated in Vc, and copy all args to VC)
            protectedType 16rFF00 (Smalltalk base image code security)
            primNumber 16rFFFF0000 (short, a Smalltalk primitive number)
    rubyInfo , a SmallInteger
        bit masks of the fields are  (per comparse.ht)
		envId        16rFF default env for sends in this method
		isRuby      16r100 (1 in Ruby, 0 in smalltalk)
		isPrivate   16r200
		isProtected 16r400
		isEval      16r800
          lineNumBias 16rFFFFFF000
          isBridge   16r1000000000
                   16rFF0000000000  defaultReturnArgNumber (1-based)
        If isBridge bit is true, then a bridge method is generated,
        and except for sends of variants of #call within bridge methods for
        ExecBlock, all message sends other than to super will use SEND_CURRENT
        bytecode.
        If defaultReturnArgNumber is non zero, then default return value
        is that argument instead of value of the last statement.

    rubyOptArgsBits, a SmallInteger ,  used to hold sourceOffset of
        the primitive bytecode or start of non-primitive method .

    nonBridgeSelector,   a Symbol or nil,

    source, a String, the source code for the method, to be saved in the
          debug information for the generated method.

    fileName, a String, name of a Ruby source file , or nil.

    endSrcOffset,  1-based, if non-nil defines the end srcOffset within a Ruby
       source file for this method, and beginning source offset
       defined by this nodes"" srcOffset maybe > 1 , and sourceString
       is expected to be for an entire file.

    lineNumber is one-based .
      For Smalltalk IR trees generated by comparse.c , lineNumber is
      for use in debugging the compiler, and debug info is generated from
      the srcOffset only.
      For Ruby IR trees ,
      lineNumber in a GsComMethNode is used to generate a comment
      in the source string for the method about where in the source file
      it came from.  The sourceString in the GsComMethNode may be a source
      string for an entire file, and the generator will carve out of that source
      string the bytes from MethNode.srcOffset to methNode.endSrcOffset ,
      and append a comment with  methNode.lineNumber and methNode.fileName
      to the end of the carved out string.

"
Class {
	#name : 'GsComMethNode',
	#superclass : 'GsCompilerIRNode',
	#instVars : [
		'fileName',
		'endSrcOffset',
		'nonBridgeSelector',
		'selector',
		'theClass',
		'arguments',
		'temps',
		'body',
		'methInfo',
		'rubyInfo',
		'source',
		'rubyOptArgsBits'
	],
	#classVars : [
		'DefaultReturnArgNum_mask',
		'DefaultReturnArgNum_shift',
		'Env_mask',
		'GEN_MAX_RubyFixedArgs',
		'IsBridge_mask',
		'IsPrivate_mask',
		'IsProtected_mask',
		'IsRubyEval_mask',
		'LineNumberBias_mask',
		'Ruby_mask'
	],
	#gs_reservedoop : '243457',
	#category : nil
}
