"
 A GsComSelectorLeaf represents the selector used in a message send.
  instVars are
    selector,  a Symbol
    specialOpcode , a SmallInteger
    specialSendClass , a Behavior

  If specialOpcode is non-zero the send may be optimizable
  to a special bytecode.  We could have the generator (comgen.c) make
  this determination; currently  the parser determines what is optimizable.
  example:    ==  sent to any Smalltalk object is a special bytecode ,
                not a normal send .

  The parser is disallowing redefinition of some methods in the base
  Smalltalk classes if you are not logged into the Repository as SystemUser .

  Some selector leafs may be initialized at start of parsing and kept
  in a dictionary of special sends, etc.
  These instances will have srcOffset == 1.

  For the optimizable sends,  specialSendClass
    can be Object  for a send such as     ==
    can be  ExecBlock  for sends like   value:
    can be SmallInteger for  sends like    +     , etc .
  otherwise specialSendClass is nil .

  The Smalltalk parser uses a dictionary with keys being
  special selectors, and values being instances of GsComSelectorLeaf
  for the special sends .

  A Smalltalk parser as a minimum should generate selector leafs with
  nonzero specialOpcode as follows
  selector  specialSendClass  specialOpcode
    ==       Object           Bc_SEND_SPECIAL_EQEQ
    ~~       Object           Bc_SEND_SPECIAL_NENE
    +        SmallInteger     Bc_SEND_SPECIAL_PLUS_u1_u32
    -        SmallInteger     Bc_SEND_SPECIAL_MINUS_u1_u32
    *        SmallInteger     Bc_SEND_SPECIAL_MULTIPLY_u1_u32
    bitAnd:  SmallInteger     Bc_SEND_SPECIAL_bitAnd_u1_u32
    bitXor:  SmallInteger     Bc_SEND_SPECIAL_bitXor_u1_u32

  Sends of 0 to 5 arg value(s) to ExecBlocks are optimizable as
    value
    ...
    value:value:value:value:value:
              ExecBlock       Bc_SEND_VALUE_u1_u32

   The following special selectors are also of interest to
   a Smalltalk parser
    isKindOf:        Object   Bc_SEND_SPECIAL_ISKINDOF
    _isSmallInteger  Object   Bc_SEND_SPECIAL_IS_SMALLINT
    _isSymbol  	     Object   Bc_SEND_SPECIAL_IS_SYMBOL
    _isInteger       Object   Bc_SEND_SPECIAL_IS_INTEGER
    _isNumber        Object   Bc_SEND_SPECIAL_IS_NUMBER
    _isFloat         Object   Bc_SEND_SPECIAL_IS_FLOAT
    _isScaledDecimal Object   Bc_SEND_SPECIAL_IS_ScaledDecimal
    _isExceptionClass Object  Bc_SEND_SPECIAL_IS_ExceptionClass
    _isExecBlock     Object   Bc_SEND_SPECIAL_IS_ExecBlock
    _isArray         Object   Bc_SEND_SPECIAL_IS_Array
    _isOneByteString Object   Bc_SEND_SPECIAL_IS_OneByteString
    _stringCharSize  Object   Bc_SEND_SPECIAL_stringCharSize

   The following special selectors should only be used in
   the base image .
   __inProtectedMode  Bc_SEND_SPECIAL_IN_PROTECTED
   _leaveProtectedMode  Bc_EXIT_PROTECTED_MODE
   _gsReturnNoResult  Bc_RETURN_NOTHING
   _gsReturnNothingEnableEvents Bc_RETURN_NOTHNG_ENABLE_EVENTS

   There are a few other special selectors of interest to a Ruby parser.

"
Class {
	#name : 'GsComSelectorLeaf',
	#superclass : 'GsCompilerIRNode',
	#instVars : [
		'selector',
		'specialOpcode',
		'specialSendClass'
	],
	#classVars : [
		'SpecialISAselectors',
		'SpecialObjectSends',
		'SpecialSendsDict'
	],
	#gs_reservedoop : '244225',
	#category : nil
}
