"
 A  GsComSendNode represents a message send, instVars are:

    rcvr,    a non-leaf GsCompilerIRNode , the receiver expression,
              can be nil if this GsComSendNode is part of a cascade .
    selLeaf,  a Symbol or a  GsComSelectorLeaf
    arguments, an Array , each element
                is the non-leaf GsCompilerIRNode for an argument expression
    controlOp, a SmallInteger , a ComParCtlOpEType
    envFlags,  a SmallInteger
       bits 16rFF  - message send environmentId 0..255 (0 for Smalltalk, 1 for Ruby)
           16r100  -  during args evaluation, evaluate last arg first (ruby block_pass)
          16r1000  -  bypass ruby method protection checks for this send
         16r10000  - environmentId is from an @rubyN:

    If envFlags specifies message send environment == 1 and
    the parent GsComMethNode.rubyInfo has isRuby == 1,
    then the GsComMethNode.environment is used as the actual environmentId
    for the send.

    controlOp is used to trigger the optimization of certain kinds of
    blocks as in-line code,  and to convert certain sends like ifTrue:
    to a special branch bytecode . It must be specified by the parser,
    or installed by executing GsComSendNode >> optimizeIfPossible
    after the GsComSendNode is fully initialized.

    The symbolic names of ComParCtlOpEType are available as
    class variables in GsCompilerIRNode .
    typedef enum { /* from comparse.ht*/
      COMPAR_NO_OPTIMIZATION = 0,
      COMPAR__IF_TRUE = 1,
      COMPAR__IF_FALSE = 2,
      COMPAR_IF_TRUE_IF_FALSE = 3,
      COMPAR_IF_FALSE_IF_TRUE = 4,
      COMPAR_underscOR_SELECTOR_unused = 5,
      COMPAR_underscAND_SELECTOR_unused = 6,
      COMPAR_OR_SELECTOR = 7,          // or:
      COMPAR_AND_SELECTOR = 8,         // and:
      COMPAR_WHILE_FALSE = 9,
      COMPAR_WHILE_TRUE = 10,
      COMPAR_UNTIL_FALSE = 11,
      COMPAR_UNTIL_TRUE = 12,
      COMPAR_TO_DO = 13,
      COMPAR_TO_BY_DO = 14,
      COMPAR_TIMES_REPEAT = 15,
      COMPAR__DOWNTO_DO = 16,
      COMPAR__DOWNTO_BY_DO = 17,
      COMPAR_FOREVER_repeat = 18,
      COMPAR_IF_NIL_IF_NOTNIL = 19,
      COMPAR_IF_NOTNIL_IF_NIL = 20,
      COMPAR_IF_NIL = 21,
      COMPAR_IF_NOT_NIL = 22,
      COMPAR_UNTIL_FALS_COLON = 23,
      COMPAR_UNTIL_TRU_COLON = 24
    }   ComParCtlOpEType;

"
Class {
	#name : 'GsComSendNode',
	#superclass : 'GsCompilerIRNode',
	#instVars : [
		'rcvr',
		'selLeaf',
		'arguments',
		'controlOp',
		'envFlags'
	],
	#classVars : [
		'ATRUBY_MASK',
		'BypassProtection_MASK',
		'ControlOpDict',
		'ENVID_MASK',
		'EvalLastArgFirst_MASK'
	],
	#gs_reservedoop : '242945',
	#category : nil
}
