"
a GsComVarLeaf   represents a method arg or temp, a block arg or temp,
                an instance variable , or a literal variable,
                or a reference to self or super

  varName ,  a Symbol  , the name of the variable
  litVarAssoc , an Association , non-nil only for a literal variable
  varKind    , a SmallInteger, a ComParVarEType
  lexLevel   , a SmallInteger,  the lexical level in terms of block scoping ,
         0 means the home method, 1 is first block level
         parser increments its lexLevel when entering both normal and in-lined blocks

  varOffset  is -1 for a dynamic instVar
                 0 for self or super
                 0 for a literal variable
                 zero-based offset into the instVars for an instance variable,
                 zero-based offset into the method or block args for an arg ,
                 0 for a method or block temp ( generator will assign an offset)

  for a Smalltalk literal variable,  varName is the key in the Association

  The parser is responsible for canonicalizing all references to a given
  arg, temp or instVar  within a method to be references to the same
  GsComVarLeaf.
  Thus multiple GsComVariableNode's may reference a single GsComVarLeaf,
  within a single compilation.

  The symbolic names of ComParVarEType are available as
  class variables in GsCompilerIRNode .
  typedef enum {
    COMPAR_METHOD_TEMP_VAR = 0,
    COMPAR_BLOCK_TEMP_VAR = 1,
    COMPAR_METH_VC_GLOBAL_notUsed = 2,  /* ruby $_ or $~ , not used for Smalltalk */
    COMPAR__INST_VAR = 3,
    COMPAR_LIT_VAR = 4,
    /* COMPAR_LIT_VAR_SPECIAL_LITERAL = 5, obsolete, not supported by code generator*/
    COMPAR_BLOCK_ARG_VAR = 6,
    COMPAR_SELF_VAR = 7,
    COMPAR_SUPER_VAR = 8,
    COMPAR_METHOD_ARG_VAR = 9
  }   ComParVarEType;

"
Class {
	#name : 'GsComVarLeaf',
	#superclass : 'GsCompilerIRNode',
	#instVars : [
		'varName',
		'litVarAssoc',
		'varKind',
		'lexLevel',
		'varOffset'
	],
	#gs_reservedoop : '244481',
	#category : nil
}
