"

 GsCompilerIRNode  is the abstract superclass of all classes used
 to implement nodes of the IR graph which is input to the
 code generator comgen.c  in Gemstone64 v3.0.   The instVars are:

  kind      , a SmallInteger, per ComIRNodeEType
  srcOffset, a SmallInteger , 1-based character position in the source , or nil .
  lineNumber, a SmallInteger, optional 1-based line number in the source,
                              or -1 or nil if unknown
         with Smalltalk parser lineNumber used for debugging compiler and slow filein
         with Ruby parser written in Ruby , lineNumber only used to hold
         starting line of a  GsComMethNode .

  See comments for GsComMethNode for more details on srcOffset and lineNumber.

 In the documentation of subclasses,
    a non-leaf GsCompilerIRNode
 means instance of any subclass
 except GsComLitLeaf, GsComSelectorLeaf, GsComVarLeaf

 The class variables for GsCompilerIRNode include symbolic names
 for the various COMPAR, COM_RTN, and Bc_ constants used in
 instance methods in subclasses.  The class variables are populated
 at server image build by the code in src/bom.c , from constants in
 src/comparse.ht and src/bytecode.ht .

"
Class {
	#name : 'GsCompilerIRNode',
	#superclass : 'Object',
	#instVars : [
		'kind',
		'srcOffset',
		'lineNumber'
	],
	#classVars : [
		'Bc_INVALID_0',
                'Bc_IS_NIL',
                'Bc_NOT_NIL',
		'Bc_SEND_SPECIAL_bitAnd_u1_u32',
		'Bc_SEND_SPECIAL_EQEQ',
		'Bc_SEND_SPECIAL_GTE_u1_u32',
		'Bc_SEND_SPECIAL_ISKINDOF',
		'Bc_SEND_SPECIAL_IS_Array',
		'Bc_SEND_SPECIAL_IS_ExceptionClass',
		'Bc_SEND_SPECIAL_IS_ExecBlock',
		'Bc_SEND_SPECIAL_IS_FLOAT',
		'Bc_SEND_SPECIAL_IS_INTEGER',
		'Bc_SEND_SPECIAL_IS_NUMBER',
		'Bc_SEND_SPECIAL_IS_OneByteString',
		'Bc_SEND_SPECIAL_IS_Range',
		'Bc_SEND_SPECIAL_IS_ScaledDecimal',
		'Bc_SEND_SPECIAL_IS_SMALLINT',
		'Bc_SEND_SPECIAL_IS_SYMBOL',
		'Bc_SEND_SPECIAL_Lte_u1_u32',
		'Bc_SEND_SPECIAL_LT_u1_u32',
		'Bc_SEND_SPECIAL_MINUS_u1_u32',
		'Bc_SEND_SPECIAL_MULTIPLY_u1_u32',
		'Bc_SEND_SPECIAL_NENE',
		'Bc_SEND_SPECIAL_nonZeroGTE_u1_u32',
		'Bc_SEND_SPECIAL_PLUS_u1_u32',
		'Bc_SEND_SPECIAL_stringCharSize',
		'Bc_SEND_VALUE_u1_u32',
                'Bc_SEND_yourself',
		'COMPAR_AND_SELECTOR',
		'COMPAR_ARRAY_BUILDER_NODE',
		'COMPAR_ARRAY_LIT',
		'COMPAR_ASSIGNMENT_NODE',
		'COMPAR_ASSOC_LIT',
		'COMPAR_BLOCK_ARG_VAR',
		'COMPAR_BLOCK_NODE',
		'COMPAR_BLOCK_TEMP_VAR',
		'COMPAR_CASCADE_NODE',
		'COMPAR_CHAR_LIT',
		'COMPAR_DECIMAL_FLT_LIT',
		'COMPAR_FixedPoint_LIT',
		'COMPAR_FLT_LIT',
		'COMPAR_FOREVER_repeat',
		'COMPAR_GOTO_NODE',
		'COMPAR_IF_FALSE_IF_TRUE',
		'COMPAR_IF_NIL',
		'COMPAR_IF_NIL_IF_NOTNIL',
		'COMPAR_IF_NOTNIL_IF_NIL',
		'COMPAR_IF_NOT_NIL',
		'COMPAR_IF_TRUE_IF_FALSE',
		'COMPAR_INT_LIT',
		'COMPAR_LABEL_NODE',
		'COMPAR_LIT_LEAF',
		'COMPAR_LIT_NODE',
		'COMPAR_LIT_VAR',
		'COMPAR_LOOP_NODE',
		'COMPAR_METHOD_ARG_VAR',
		'COMPAR_METHOD_LIT',
		'COMPAR_METHOD_NODE',
		'COMPAR_METHOD_TEMP_VAR',
		'COMPAR_METH_VC_GLOBAL',
		'COMPAR_NO_OPTIMIZATION',
		'COMPAR_OR_SELECTOR',
		'COMPAR_PATH_NODE',
		'COMPAR_RETURN_NODE',
		'COMPAR_RUBY_COPYING_STR_LIT',
		'COMPAR_SCALED_DEC_LIT',
		'COMPAR_SELECTOR_LEAF',
		'COMPAR_SELF_VAR',
		'COMPAR_SEND_NODE',
		'COMPAR_SPECIAL_LIT',
		'COMPAR_STATEMENTS_NODE',
		'COMPAR_STR_LIT',
		'COMPAR_SUPER_VAR',
		'COMPAR_SYM_LIT',
		'COMPAR_TERM_NODE',
		'COMPAR_TIMES_REPEAT',
		'COMPAR_TO_BY_DO',
		'COMPAR_TO_DO',
		'COMPAR_UNTIL_FALSE',
		'COMPAR_UNTIL_FALS_COLON',
		'COMPAR_UNTIL_TRUE',
		'COMPAR_UNTIL_TRU_COLON',
		'COMPAR_VAR_LEAF',
		'COMPAR_VAR_NODE',
		'COMPAR_WHILE_FALSE',
		'COMPAR_WHILE_TRUE',
		'COMPAR__DOWNTO_BY_DO',
		'COMPAR__DOWNTO_DO',
		'COMPAR__IF_FALSE',
		'COMPAR__IF_TRUE',
		'COMPAR__INST_VAR',
		'COM_GOTO_BREAK',
		'COM_GOTO_NEXT',
		'COM_GOTO_REDO',
		'COM_GOTO_RETRY',
		'COM_RTN_FROM_HOME',
		'COM_RTN_NORMAL',
		'COM_RTN_NORMAL_SELF',
		'COM_RUBY_COMPAT_LEVEL'
	],
	#gs_reservedoop : '240897',
	#category : nil
}
