"
 IndentingStream wraps another stream, but indents each line to its indent level.
        This is for pretty-printing nested structures such as ParseNodes.
        New protocol includes #indentMore and #indentLess

"
Class {
	#name : 'IndentingStream',
	#superclass : 'Object',
	#instVars : [
		'indentLevel',
		'stream'
	],
	#category : nil
}

{ #category : 'Instance creation' }
IndentingStream class >> newPrinting [

^ self new stream: (PrintStream on: String new )

]

{ #category : 'Instance creation' }
IndentingStream class >> on: aStream [
  ^self new stream: aStream

]

{ #category : 'Instance creation' }
IndentingStream >> contents [
^ stream contents

]

{ #category : 'Instance creation' }
IndentingStream >> cr [
        stream cr.
        indentLevel timesRepeat: [stream nextPutAll: '  ']

]

{ #category : 'Instance creation' }
IndentingStream >> do: aCollection [
| first idx |
first := true .
self indentMore ; nextPutAll: ' ( '.
idx := 1.
aCollection do:[:aNode|
  first ifFalse:[ self cr ].
  first := false .
  self nextPutAll: idx asString ; nextPut: $: .
  aNode printFormattedOn: self .
  idx := idx + 1 .
].
self indentLess; nextPutAll: ' )'; cr .

]

{ #category : 'Instance creation' }
IndentingStream >> indentLess [
        indentLevel := indentLevel - 1

]

{ #category : 'Instance creation' }
IndentingStream >> indentMore [
        indentLevel := indentLevel + 1

]

{ #category : 'Instance creation' }
IndentingStream >> nextPut: aChar [
  " assume aChar is not  CR "
  stream nextPut: aChar

]

{ #category : 'Instance creation' }
IndentingStream >> nextPutAll: aCollection [
        stream nextPutAll: aCollection

]

{ #category : 'Instance creation' }
IndentingStream >> print: aLabel bool: aBoolean [
  stream nextPutAll: aLabel ; nextPutAll: aBoolean asString

]

{ #category : 'Instance creation' }
IndentingStream >> print: aLabel int: anInteger [
  stream nextPutAll: aLabel ; nextPutAll: anInteger asString

]

{ #category : 'Instance creation' }
IndentingStream >> print: aLabel symbol: aSymbol [
  stream nextPutAll: aLabel ; nextPutAll: aSymbol printString

]

{ #category : 'Instance creation' }
IndentingStream >> space [
   stream space

]

{ #category : 'Instance creation' }
IndentingStream >> stream: aStream [
    indentLevel := 0.
    stream := aStream

]
