"

 AbstractException describes the behavior of class objects that are used to
 create, signal, and select exceptions that exist within a specialization
 hierarchy.

 Beginning with Gemstone64 v3.0,  ANSI and legacy Gemstone
 exception behavior are unified.  The class ExceptionA no longer exists.

 The instance protocol describes the behavior of instances of class AbstractException.
 Typically, actual exceptions used by an application will be either
 direct or indirect subclasses of this class.

 New trappable exception classes should be created as subclasses of Error,
 not of AbstractException.

 Note that instances created within the VM are initialized by VM code, and
 do not execute the initialize methods in the image.  Initializer methods
 in the image are only executed for those instances created by sending
 some sort of signal: or error: message within Smalltalk code.

 The instVar   gsTrappable   has these values
    0 - not trappable by any form of on:do: in Smalltalk code, signalled direct to GCI
    false - signalled via direct send of #defaultAction  .
    true  - trappable
    1       trappable except by onSynchronous:do:  ; exception was
            generated asynchrously (usually a ControlInterrupt)

 The instVar gsDetails holds the ANSI message text, if any.
 The instVar messageText holds the full GemStone error text .

 The exception class hierarchy follows, inst var names in parentheses.
 Unless noted, the default for all classes is
   gsResumable==true, gsTrappable==true .
 If an exception was signaled from within C code of a primtive,
 the instance will have gsResumable==false.

  AbstractException (gsResumable gsTrappable gsNumber
                  currGsHandler gsStack gsReason gsDetails tag messageText args)
    Exception     --Highest class that customer Smalltalk code
                                should ever handle, ANSI Global--
      ControlInterrupt
        Break     -- from GciSoftBreak, ctl-C, etc
        Breakpoint (context stepPoint)
        ClientForwarderSend ([args=arguments] receiver clientObj selector)
        Halt    [gsTrappable==false]
      Error
        CompileError
        EndOfStream
        ExternalError         -- Error from OS
          AwsError
          AzureError
          IOError
            SocketError
              SecureSocketError
              SshSocketError
          SystemCallError  (errno)
	  CryptoError -- Error from OpenSSL crypto library
          PostgresError -- Error from Postgres
        ImproperOperation [ args = object ]  -- Disallowed under the circumstances
          ArgumentError   -- Arg never appropriate for this message
          ArgumentTypeError ( expectedClass actualArg)  -- Class of arg
                                        never acceptable here
          CannotReturn        -- Non-local return attempt
          LookupError  (key) -- A lookup failed (or succeeded) improperly
          OffsetError (maximum actual) -- Array or String at:, at:put: out of bounds
          OutOfRange (minimum maximum actual) -- Numeric range error, or wrong num args
            FloatingPointError
          RegexpError
        IndexingErrorPreventingCommit
        InternalError         -- something that should never happen
          GciTransportError   -- Protocol or other error specific to GCI RPC link
        LockError [ args = object ]
        MigrationError
        NameError (selector)  -- used in Ruby
          MessageNotUnderstood ([args=arguments] envId receiver )  --ANSI Global
        NumericError [ args = object ]
          ZeroDivide  (dividend)       --ANSI Global
        RepositoryError
        SecurityError
        SignalBufferFull
	ThreadError
        TransactionError
        UncontinuableError
        UserDefinedError
      Notification     --ANSI Global
        Admonition
          AlmostOutOfStack [gsTrappable, gsResumable both false if in red zone]
          AlmostOutOfMemory
          RepositoryViewLost
        Deprecated
        FloatingPointException
        InterSessionSignal (sendingSession signal [args = message] )
        ObjectsCommittedNotification
        TerminateProcess
        TransactionBacklog (inTransaction)
        Warning      --ANSI Global
          CompileWarning
      TestFailure
    RubyBreakException  -- used in implementation of Ruby
    RubyThrowException ([args=name] value signalNum) -- used in implementation of Ruby

  See comments for primitive 33 , AbstractException >> defaultAction for
  how instVars of an exception are enumerated in to a GciErrSType.args.

Trappability of errors signaled from with VM

  OBJ_ERR_DOES_NOT_EXIST, OBJ_ERR_CORRUPT_OBJ not trappable in a slow-build vm
  RT_ERR_OBJ_IS_NP  not trappable if TrapAddToClosure enabled

  following signaled from C as not trappable
    RT_ERR_STACK_LIMIT_RED
    GCI_ERR_EXEC_CLIENT_USERACT
    RT_ERR_HARD_BREAK
    RT_ERR_STEP
    RT_ERR_CODE_BREAKPOINT
    RT_ERR_STACK_BREAKPOINT
    RT_ERR_SOFT_BREAK
    RT_ERR_PAUSE

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object

"
Class {
	#name : 'AbstractException',
	#superclass : 'Object',
	#type : 'variable',
	#instVars : [
		'gsResumable',
		'gsTrappable',
		'gsNumber',
		'currGsHandler',
		'gsStack',
		'gsReason',
		'gsDetails',
		'tag',
		'messageText',
		'gsArgs'
	],
	#classVars : [
                'ErrnoTables',
                'ERR_AbstractException',
                'ERR_Admonition',
                'ERR_AlmostOutOfMemory',
                'ERR_AlmostOutOfStack',
                'ERR_ArgumentError',
                'ERR_ArgumentTypeError',
                'ERR_AwsError',
		'ERR_AzureError',
                'ERR_Break',
                'ERR_Breakpoint',
                'ERR_CannotReturn',
                'ERR_ClientForwarderSend',
                'ERR_CompileError',
                'ERR_CompileWarning',
                'ERR_ControlInterrupt',
                'ERR_CryptoError',
                'ERR_Deprecated',
                'ERR_DirectoryDoesNotExist',
                'ERR_DirectoryExists',
                'ERR_DirectoryIsNotEmpty',
                'ERR_DirectoryRequired',
                'ERR_EndOfStream',
                'ERR_Error',
                'ERR_Exception',
                'ERR_ExitClientError',
                'ERR_ExternalError',
                'ERR_FileAlreadyExistsException',
                'ERR_FileAttributeNotSupported',
                'ERR_FileDoesNotExistException',
                'ERR_FileException',
                'ERR_FileExists',
                'ERR_FilePermissionDenied',
                'ERR_FileRequired',
                'ERR_FileSystemError',
                'ERR_FloatingPointError',
                'ERR_FloatingPointException',
                'ERR_FsEACCES',
                'ERR_FsEBADF',
                'ERR_FsEEXIST',
                'ERR_FsEINTR',
                'ERR_FsEINVAL',
                'ERR_FsENOENT',
                'ERR_FsENOMEM',
                'ERR_FsENOSPC',
                'ERR_FsENOTDIR',
                'ERR_FsEROFS',
                'ERR_FsError',
                'ERR_FsFileDescriptorInvalid',
                'ERR_FsUnixError',
                'ERR_GciTransportError',
                'ERR_GsUnsatisfiableQueryNotification',
                'ERR_Halt',
                'ERR_ImproperOperation',
                'ERR_IndexingErrorPreventingCommit',
                'ERR_InternalError',
                'ERR_InterSessionSignal',
                'ERR_IOError',
                'ERR_LargeIntegerOverflow',
                'ERR_LockError',
                'ERR_LookupError',
                'ERR_MessageNotUnderstood',
                'ERR_MigrationError',
                'ERR_NameError',
                'ERR_Notification',
                'ERR_NumericError',
                'ERR_ObjectsCommittedNotification',
                'ERR_OffsetError',
                'ERR_OutOfRange',
                'ERR_PostgresError',
                'ERR_RegexpError',
                'ERR_RepositoryError',
                'ERR_RepositoryViewLost',
                'ERR_ResumableTestFailure',
                'ERR_RubyBreakException',
                'ERR_RubyThrowException',
                'ERR_SecureSocketError',
                'ERR_SecurityError',
                'ERR_SignalBufferFull',
                'ERR_SocketError',
                'ERR_SshSocketError',
                'ERR_SystemCallError',
                'ERR_TerminateProcess',
                'ERR_TestFailure',
                'ERR_ThreadError',
                'ERR_TIMEOUT_INTERRUPT',
                'ERR_TransactionBacklog',
                'ERR_TransactionError',
                'ERR_UncontinuableError',
                'ERR_UserDefinedError',
                'ERR_Warning',
                'ERR_ZeroDivide',
                'ERR_ZnCharacterEncodingError',
                'ERR_ZnError'
	],
	#gs_options : [
		'disallowGciStore'
	],
	#gs_reservedoop : '130305',
	#category : nil
}
