"

An Admonition is a type of Notification that it would be best not to ignore.
While not strictly an Error, it generally indicate that an error is imminent.
For example, AlmostOutOfMemory is an Admonition.

If one has established a generic Error handler, it might be appropriate to
add Admonition to it since the result of an ignored Admonition might make it
impossible to handle the resulting Error. For example:

	[self doSomething] on: Error, Admonition do: [:ex | self recordError: ex].

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object

"
Class {
	#name : 'Admonition',
	#superclass : 'Notification',
	#gs_reservedoop : '150785',
	#category : nil
}
