"
An instance of CByteArray encapsulates allocation of C memory or a reference to C memory.

  instVars
    info , a SmallInteger containing
        gcFree   , 3 bits, mask 16r7
           0 means no memory to free,
           bit 0x1 means call free() when in-memory instance is garbage collected.
           bit 0x2 means the memory has fence words
           bit 0x4 means VM owns the C memory  .
        dead     ,  1 bit, mask 16r8
           application has requested memory be freed .
        sizeBytes,  upper 57  bits

    derivedFrom -  nil or a CByteArray or a CPointer.  If non-nil,
         a CByteArray or CPointer from which this object was derived.
         This object represents a pointer into the body of derivedFrom,
         used to keep the referenced object alive.
         In Ruby, derivedFrom may be an Integer address in which case
         the instance has gcFree==0 and sizeBytes==0.

    referencesTo -  nil or an Array of CByteArrays .
       this object contains C pointers to the bodies of the
       elements of referencesTo.  used to keep referenced
       CByteArrays alive.

    typeSize - a SmallInteger , default value is 1 ,
        not used by Smalltalk code , used by Pointer class  in Ruby

  The methods in category 'Accessing elements' use ZERO BASED offsets
  and support  unaligned accesses are supported.  They will check for
  and generate out-of-bounds errors based in the  sizeBytes of the receiver.

  The 8bit, 16bit, and 32bit accessing methods, when receiver is of size 8 ,
  and zeroBasedOffset == -1 , will  return the specified number of least signifigant
  bits of the receiver , as would have been stored by a function arg
  of type  char* , short*, int*   was used.

"
Class {
	#name : 'CByteArray',
	#superclass : 'Object',
	#instVars : [
		'info',
		'derivedFrom',
		'referencesTo',
		'typeSize'
	],
	#classVars : [
		'AppDeadMask',
		'AutoFree',
		'GcFreeMask',
		'NoFree'
	],
	#gs_options : [
		'disallowGciStore'
	],
	#gs_reservedoop : '134401',
	#category : nil
}
