"
An instance of CCallout represents the information needed to
call a C function using the FFI .

   instVars
     library , a CLibrary, nil, or 1 .  If nil, the function will be
         searched for in the current process using dlsym(RTLD_NEXT) ,
         searching any libraries which were loaded AFTER libgcilnk.so .
         If 1 , the function represents a call into a Ruby C extension,
         and cannot be re-resolved if this CCallout is faulted in.

         If a CLibrary, the specified shared library will be loaded on-demand
         using dlopen() and that library searched using dlsym().
         On some platforms where RTLD_FIRST not available, the whole process
         will be searched if function not found in specified library.

     lastError, normally nil, in an in-memory instance holds the last
        error from the callWith: primitive .

     version( dynamic instVar) nil or a String used as the third arg to dlvsym()

   cData (hidden instVar) , in an in-memory instance contains the result from dlsym().
      and pointers to one or more calloutStub's emitted by the native code generator.

    To avoid repeated calls to dlsym() a committed instance of CFunction
    must be kept in memory (such as by a reference from session state)
    while it is being used.  At the time a dlsym() call is made,
    if library is non-nil that instVar will become a not-stubbable memory
    reference to the CLibrary.

   See comments in CCallout>>callWith: for details on varArgs .

Constraints:
	fName: String
	argTypes: Array
	resultType: Symbol
	cTypes: ByteArray
	argCounts: SmallInteger
	argTypesDict: GsMethodDictionary
	library: CLibrary
	lastError: String
  untaggedEnumsDict: (not used)
"
Class {
	#name : 'CCallout',
	#superclass : 'CFunction',
	#instVars : [
		'library',
		'lastError',
    'untaggedEnumsDict'
	],
	#gs_reservedoop : '146945',
	#category : nil
}
