"
An instance of CCalloutStructs represents the information needed to
call a C function using the FFI .  Instances of CCalloutStructs are
used to make an FFI call when one or more of the result or arguments
to the called function are C structs (or C++ classes) passed by value.
Structs passed or returned by value have type #struct when creating
an instances of CCalloutStructs.  

   instVars

     version, nil or a String used as the third arg to dlvsym()

     structSizes  used by  callWith:structResult:errno:  primitive
        elements are SmallInteger sizes in bytes, or nil
        first element is size of a struct result (or nil if result not a struct)
        second element is size of first arg if that arg is a struct, or nil.
        The value of an argument or result that is a struct 
        must be a kind of CByteArray with matching size .
 
    See comments in CCallout for documentation of inherited instVars.

   An argument or resule of an ffi call that is address of a struct (i.e. type #ptr)
   is not a struct passed by value .
   
   struct results  
     This applies to structs returned by value .
     A struct returned by value is returned in a kind of CByteArray.
     The call must be made via CCalloutStructs>>callWith:structResult:errno: .
     and a sender of that method must allocate the result struct and
     pass it as argument to the structResult:  keyword.

   See comments in CCallout>>callWith: for details on varArgs .

Constraints:
	fName: String
	argTypes: Array
	resultType: Symbol
	cTypes: ByteArray
	argCounts: SmallInteger
	argTypesDict: GsMethodDictionary
	library: CLibrary
  untaggedEnumsDict:  (not used)
	lastError: String
	version: String
  structSizes: Array
"
Class {
	#name : 'CCalloutStructs',
	#superclass : 'CCallout',
	#instVars : [
		'version',
    'structSizes'
	],
	#gs_reservedoop : '161025',
	#category : nil
}
