"

A CZstream encapsulates the state of a zstream from zlib.so ,
and associates that zstream with an IO object.

 InstVars
   buffer - a String < 16K bytes
   bufSize - a SmallInteger
   comprBuffer - a String or ByteArray < 16K bytes
   comprSize - a SmallInteger , only used for output streams
   forWrite  - a Boolean
   ioObj       - an instance of IO (a GsSocket or GsFile)
   errorClass  - a subclass of Exception used to signal errors
   header - gzip header of a file, when reading
   comprOffset a SmallInteger , only used for output streams

   hidden instVar cData is an instance of struct z_stream_s  per zlib.h ,
   which will be automatically freed when this object is GC'ed

Constraints:
	buffer: String
	bufSize: SmallInteger
	comprBuffer: ByteArray
	comprSize: SmallInteger
	forWrite: Boolean
	ioObj: IO
	errorClass: AbstractException
	header: Array
	comprOffset: SmallInteger

"
Class {
	#name : 'CZstream',
	#superclass : 'Object',
	#instVars : [
		'buffer',
		'bufSize',
		'comprBuffer',
		'comprSize',
		'forWrite',
		'ioObj',
		'errorClass',
		'header',
		'comprOffset'
	],
	#classVars : [
		'ComprBufSize',
		'HalfComprBufSize'
	],
	#gs_options : [
		'disallowGciStore'
	],
	#gs_reservedoop : '145153',
	#category : nil
}
