"
Each of the classes in the GemStone kernel inherits some of its behavior from
 Class.

 You may send the messages described here to any of the kernel classes
 (class-defining objects) defined in this manual.  However, you may not send
 these messages to instances of the kernel classes (that is, unless the
 receiver is an instance of Class).

 Consider the following example.  The description of class SmallInteger
 contains two kinds of protocol: instance methods and class methods.  Instance
 methods are understood by SmallIntegers (instances of the class SmallInteger,
 which inherit their protocol from Integer, Number, Magnitude, and Object).
 Class methods are understood by the class-defining object SmallInteger itself
 (which is the single instance of the metaclass ""SmallInteger class"", and
 inherits its protocol from Class, Behavior, and Object).  The messages
 described here (for Class) are understood by SmallInteger; that is, they are
 class methods for the class-defining object), but are not understood by
 instances of SmallInteger.

Constraints:
	superClass: Behavior
	format: SmallInteger
	instVarsInfo: SmallInteger
	instVarNames: Array
	constraints: Object
	classVars: SymbolDictionary
	methDicts: Object
	poolDictionaries: Array
	categorys: Object
	dbTransientMask: SmallInteger
	name: Symbol
	classHistory: ClassHistory
	transientMethDicts: Object
	destClass: Module
	timeStamp: DateTime
	userId: CharacterCollection
	extraDict: SymbolDictionary
	classCategory: CharacterCollection
	subclasses: IdentitySet

--- instVar classCategory
A CharacterCollection that names the category of classes to which this class
 belongs.  Each subclass also belongs to this category, unless the subclass
 overrides it with its own category.  Class categorization can be used by
 browsers and schema design tools.

--- instVar classHistory
The ClassHistory to which the class belongs.  Every class belongs to exactly
 one class history, which tracks its ancestry and assists with changes to its
 structure (schema).  When a new class is created, it is considered to be either
 a new version of an existing class, or else it has no previous history.  A new
 class version becomes the most recent version in an existing ClassHistory.
 Otherwise, a new ClassHistory is created for the new class.

--- instVar destClass
A Class, generally considered to be the next later version of this class.  At
 an appropriate time, it may be desirable or necessary to migrate instances of
 this class to the newer version.  This variable remembers which class the
 instance should migrate to.

 You can mark a Class with a migration destination by sending it the message
 migrateTo:.  When so marked, instances of that Class can be migrated to the
 new Class while maintaining identity.  The destination Class should have the
 method migrateFrom: implemented to define the transformation.  A default
 implementation is provided in Object.

 Migration is triggered manually by sending the message migrate to an instance
 of the Class.  Other protocol for forcing migration is
 Class | migrateInstancesTo: and Repository | migrateInstancesOfClasses:.

--- instVar extraDict
Reserved for internal use by GemTalk Systems

--- instVar name
The class's name for itself; a Symbol of up to 64 Characters.

--- instVar subclasses
An IdentitySet of the subclasses of this class.  This set is only present in
 modifiable classes, and is nil otherwise.

--- instVar timeStamp
A DateTime object that indicates when the class was created.

--- instVar userId
A CharacterCollection that gives the identity of the user that created the class.

--- Category:  Subclass Creation
Every new GemStone Smalltalk class must be a subclass of some other existing
 GemStone Smalltalk class.  To create the new class, you send a subclass
 creation message to its intended superclass.

 The following restrictions apply to creating classes:

 * The new class must be of the same implementation (storage format) as the
   receiver (its superclass), unless the receiver is a non-indexable pointer
   object.  In this case, there are no restrictions if the receiver has no
   instance variables.  If the receiver does have instance variables, the new
   class may not be of special or byte format.
 * The name of a class is a Symbol at most 1024 Characters long.
 * The name of an instance variable is a String at most 64 Characters long.
 * A class contains at most 2030 named instance variables.

 Implementation Format.

 Instance variables may be named or unnamed.  The class definition (often in
 the subclass creation method) explicitly declares the name and number of all
 named instance variables.  This definition must be fixed (class not
 modifiable) before instances of the class can be created.  The class
 definition also implicitly declares unnamed instance variables (if they
 exist), by the choice of implementation format.  Unnamed variables can vary in
 number independently for each instance.  Depending upon format, unnamed
 variables may be indexed (in which case they are accessed by index), or not
 (in which case they are unordered and are accessed associatively, by value).
 Classes in byte format have indexed instance variables that are stored by byte
 for efficiency of storage and access.

 You use different methods to create a byte class, an indexable class, or a
 class of another format.  For each of these possibilities there is a pair of
 standard methods.  Each of these methods provides a full (long) list of
 keywords that permit you to specify a new class fully.  One of them also
 allows you explicitly to specify the new class as a version of an existing
 class, while the other does not.  Additional methods provide selected shorter
 lists of keywords for convenience, and supply default values for some
 arguments.

 Pool dictionaries.

 If you want to add or remove pool dictionaries for the new class at some
 later time, the argument that supplies the Array of pool dictionaries must not
 be an Array literal.  The literal value produces an InvariantArray object,
 which cannot subsequently be modified.

 Dictionary.

 GemStone adds the new class to a dictionary.  The dictionary is typically
 already in the current user's symbol list, but it can be added to the symbol
 list at a later time if it is not already there.  (The symbol list makes the
 class visible to the user.)  The specified dictionary is often UserGlobals,
 but may be Globals if the data curator has authorized the user to modify that
 dictionary.

 Constraints.

 Constraints are not supported as of GemStone/S 64bit v3.4. They may still be
 specified via the old method keywords, but the settings are ignored.

 Invariance.

 The invarBoolean argument of a subclass creation method deals with class-level
 invariance.  When that argument is true, GemStone thereafter forces all
 instances of the new class to become invariant as soon as they are committed
 to GemStone.  That is, invariance applies to all objects of that class.

 If instances of the new class's superclass are invariant, then instances of
 the new class must also be invariant.  In this case, a subclass creation
 method generates an error if the invarBoolean argument is not true.

 Class Modification.

 The modifyBoolean argument of a subclass creation method deals with
 object-level invariance, the ability to modify the object that is the class
 itself.

 Classes are typically not modifiable.  As a result, this argument is generally
 given the value false.  The subclass creation method then makes the new class
 an invariant object, and instances of that class can be created at any time
 after.

 When the modifyBoolean argument is true, the new class is modifiable, not
 invariant.  Its instance variables can be modified.  However,
 no instances of it can yet be created.  Once all desired changes have been
 made, you must send the new class the message immediateInvariant.  That
 message then makes the new class an invariant object, and no further changes
 to it are possible.  However, instances of the class can then be created.

 For more information about invariance at all levels, see the GemStone
 Programming Guide.

 Classes and Schema.

 A class can be viewed as an implementation of a schema, or of part of a
 schema.  In order to define and develop a schema, you may create modifiable
 classes, which remain modifiable until the schema is stable.

 However, it is sometimes also necessary to change schema after classes are no
 longer modifiable, and after instances of them exist.  To accomplish this kind
 of change, you must create new classes to implement the new schema.  However,
 it may be desirable to consider a new class to be a new version of an existing
 class, so that a logical connection between them and their instances can be
 maintained.

 Speaking conceptually, a class history lists all the versions of a class.
 Speaking technically, the objects that are classes do not have versions.
 Versions are represented by the list of classes in a class history.  Every
 class (object) belongs to exactly one class history; therefore, all the
 classes that are listed in a class history share the same class history
 object.

 Subclass methods that have an oldClass argument return oldClass if the
 requested new class would be equivalent to oldClass .
 Otherwise the new class is created as a new version of oldClass,
 and the two classes share the same class history.
 If the oldClass argument is nil, then no equivalence checks are done and
 thew new class gets a new class history.

 When subclass methods that lack the oldClass argument create a new class with
 the same name an existing class in the specified dictionary, then
 the existing class is treated as an ""oldClass"" in the implementation and
 equivalence checks are performed per the above paragraph.

 An oldClass is equivalent to the subclass that would be created using
 the other arguments to a subclass creation method if
     instVar names match exactly ,
   and class instVar names match exactly ,
   and anArrayOfClassVars contains at least all of the classVars in oldClass
     (additional classVars will be added to oldClass if no subclass is created),
   and pool dictionaries match exactly.

  Many of the subclass creation methods have an options: keyword  which takes
  an Array of Symbols containing zero or more of
    #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
    #traverseByCallback #selfCanBeSpecial #logCreation
  and at most one of
     #dbTransient, #instancesNonPersistent, #instancesInvariant .
  If present, #noInheritOptions must be the first element and it causes
  none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
  to be inherited from the superclass, nor copied from the
  current version of the class.
  #selfCanBeSpecial is never inherited and is needed only when modifying
  superclass hierarchy above classes with special format.
  The option #logCreation, if present in the options array, causes logging
  with GsFile(C)>>gciLogSever:  of class creation / equivalence.

  With respect to options and format, oldClass is equivalent if
    The state of format bits dbTransient, and instancesInvariant match exactly ,
    and subclassesDisallowed cannot be set in the new subclass if it not set in oldClass ,
    and modifiable  cannot be set if it is not set in oldClass  ,
    and  (SELF_CAN_BE_SPECIAL, NSC_DUPLICATES, INDEXABLE, IMPLEMENTATION, NO_STRUCT_UPDATE bits)
        of the formats must match exactly.

  If all other equivalence tests pass, the following changes to oldClass may be
  made to match the arguments and avoid creating a new subclass
    instancesNonPersistent may be set in the format of oldClass
    subclassesDisallowed bit may be cleared in format of oldClass
    traverseByCallback bit may be set or cleared in format of oldClass
    oldClass may be changed from modifiable to not modifiable (by sending immediateInvariant)
    classVars may be added to oldClass.

"
Class {
	#name : 'Class',
	#superclass : 'Metaclass3',
	#instVars : [
		'timeStamp',
		'userId',
		'extraDict',
		'classCategory',
		'subclasses'
	],
	#gs_options : [
		'noInheritOptions',
		'subclassesDisallowed'
	],
	#gs_reservedoop : '68609',
	#category : nil
}

{ #category : 'Subclass Creation' }
Class >> subclass: aString instVarNames: anArrayOfInstvarNames classVars: anArrayOfClassVars classInstVars: anArrayOfClassInstVars poolDictionaries: anArrayOfPoolDicts inDictionary: aDictionary newVersionOf: oldClass description: aDescription options: optionsArray [
	"optionsArray is an Array of Symbols containing zero or more of
   #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
   #traverseByCallback #selfCanBeSpecial #logCreation
 and at most one of
   #dbTransient, #instancesNonPersistent, #instancesInvariant
 If present, #noInheritOptions must be the first element and it causes
 none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
 to be inherited from the superclass, nor copied from the
 current version of the class.
 #selfCanBeSpecial is never inherited and is needed only when modifying
 superclass hierarchy above classes with special format.
 The option #logCreation, if present in the options array, causes logging
 with GsFile(C)>>gciLogSever:  of class creation / equivalence.

 Preserve the Rowan packaging of the class if the class is already packaged.

 Returns oldClass if it would be equivalent to the requested new class.
 (See the class comment for Class)."

	^ self
		_rwCreateSubclass: aString
		instVarNames: anArrayOfInstvarNames
		classVars: anArrayOfClassVars
		classInstVars: anArrayOfClassInstVars
		poolDictionaries: anArrayOfPoolDicts
		inDictionary: aDictionary
		newVersionOf: oldClass
		description: aDescription
		options: optionsArray
		ifUnpackagedDo: [ 
			self
				_subclass: aString
				instVarNames: anArrayOfInstvarNames
				classVars: anArrayOfClassVars
				classInstVars: anArrayOfClassInstVars
				poolDictionaries: anArrayOfPoolDicts
				inDictionary: aDictionary
				newVersionOf: oldClass
				description: aDescription
				options: optionsArray ]
]
