"
 FixedPoint was named ScaledDecimal in Gemstone/64 v2.4 and prior versions;
 the name was changed to allow an improved ScaledDecimal implementation. In most 
 cases new development should use ScaledDecimal/SmallScaledDecimal classes, 
 rather than FixedPoint.

 FixedPoint stores numerical values as a rational number, represented by a
 numerator and denominator that are Integers.  Since the numerator and
 denominator can be carried to arbitrary precision, FixedPoint can represent
 any rational number without loss of precision.  It also calculates based upon
 fractional arithmetic, and thus produces numerical results without loss of
 precision.

 FixedPoint also provides for automatic rounding to a fixed precision after
 the decimal point when converting to and from other types, such as String.

 The literal form for a FixedPoint uses $p; for example, 1.23p2, where the
 final digit indicates the scale.

--- instVar denominator
 A positive Integer that represents the denominator of the rational value
 of the instance.

--- instVar numerator
 An Integer that represents the numerator of the rational value of the
 instance.

--- instVar scale
 A non-negative SmallInteger that represents the number of decimal places of
 precision to the right of the decimal point.

"
Class {
	#name : 'FixedPoint',
	#superclass : 'Number',
	#instVars : [
		'numerator',
		'denominator',
		'scale'
	],
	#gs_reservedoop : '102913',
	#category : nil
}
