"
GsCurrentSession provides a public interface to the current GemStone session.
 There is only one instance of GsCurrentSession in each GemStone session.
 The GemStone server creates it automatically when a user logs into GemStone.
 The instance is transient and cannot be accessed after the user logs out of
 GemStone.

Instance variable types:
	sessionSerialNum: SmallInteger
	userProfile: UserProfile
	symbolList: SymbolList
	nativeLanguage: String (obsolete)

 The instVar symbolList is initalized at session login to reference
 the symbolList of the current user's UserProfile. 

 The instVar transientSymbolList, if non-nil, takes precedence over symbolList
 for use in resolving symbols.  transientSymbolList is nil unless one of
    GsCurrentSession >> transientSymbolList
    GsCurrentSession >> transientSymbolList:  
    System class >> refreshTransientSymbolList
 have been executed. Use GsCurrentSession >> _transientSymbolList for direct
 access to the instVar.
"
Class {
	#name : 'GsCurrentSession',
	#superclass : 'GsSession',
	#instVars : [
		'symbolList',
		'nativeLanguage',
        'transientSymbolList'
	],
	#gs_options : [
		'subclassesDisallowed'
	],
	#gs_reservedoop : '103937',
	#category : nil
}
