"
GsMethodDictionary optimizes IdentityKeyValueDictionary for use as method
 dictionaries in classes.  It employs a different internal structure that is
 well-suited for efficient execution in smaller dictionaries.  Changes to
 GsMethodDictionies are protected by the #CodeModification privilege, and
 therefore should not be used in customer applications.  For this purpose,
 you should use the subclass FastIdentityKeyValueDictionary.

 The keys of method dictionaries must be canonical symbols
 (Symbols, DoubleByteSymbols, or QuadByteSymbols).

 Implementation details:
 Within the hash table, entries are of size two and contain key/value pairs:
    aSymbol, aValue
    nil,     SmallInteger - one-based offset of start of collision chain
    nil,     nil          - empty hash slot

 Collisions chains are linked lists within the root object itself, and
 are stored in the area after the hash table.
 Collision list entries are triples (key, value, nextOffset):
    aSymbol, aValue, nextOffset - entry in chain, nextOffset is one-based
    aSymbol, aValue, nil        - end of chain
    nil,     nil,    nextOffset - empty element in collision chain, only
                                  removed by rebuildTable

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger
	valueConstraint: Behavior
	keyConstraint: Behavior

instVar valueConstraint -- The Class that specifies a constraint on the GsMethodDictionary's values.
 If nil, there is no constraint.

instVar keyConstraint -- The Class that specifies a constraint on the GsMethodDictionary's keys.
 If nil, there is no constraint.
"
Class {
	#name : 'GsMethodDictionary',
	#superclass : 'IdentityKeyValueDictionary',
	#instVars : [
		'valueConstraint',
		'keyConstraint'
	],
	#gs_options : [
		'subclassesDisallowed'
	],
	#gs_reservedoop : '99073',
	#category : nil
}
