"

 A GsProcess represents a suspended or active GemStone Smalltalk
 green-thread process.
 The in-memory state of a committed GsProcess is not changed by a transaction abort.

 instVars are:

  stackId - a SmallInteger
     zero-based stackId specifying the stack memory area holding
     the process, or -1 means not in a stack memory area.

  signalTime - used by the scheduler .

 priority_use - a SmallInteger used by the scheduler, bit masks
          16rFFFFFFFFFF    unsigned 40 bit use count, incremented each time
               the process is run or resumed by the scheduler.
      16rFFFF0000000000    unsigned priority in the range of a C ushort.

  uaCount_depth -  a SmallInteger,  with bit masks
            16rFFFFFFFF   stack depth , for a process not in stack memory
      16rFFFFFFF00000000 user action count
     Maybe nil if receiver is running.

  interruptFlag_stEntryCount - a SmallInteger,  with bit masks
          16rFFFFFFFF  stEntryCount
   16rFFFFFFF00000000   interruptFlags

  modeInfo - a SmallInteger, with bit masks (see symbolic definitions ModeInfo_)
                16rFF  envId
              16r0F00  nativeCpuKind, 0..15
              16rF000  nativeStackKind, 0..15
            16rFF0000  breakpointsToIgnore, 0..255
           16r1000000  debuggerEnabled, a boolean
           16r2000000  debuggingInProgress, a boolean
           16r4000000  terminated , a boolean
           16r8000000  terminationStarted , a boolean
          16r10000000  isRubyThread, a boolean
          16r60000000  continuationKind, 1 == continuation, 2 == partial continuation
          16r80000000  forked , a boolean
         16r100000000  partialContinuationLoaded, private boolean for VM
         16r200000000  Gs64 v3.3 version bit.
         16rC00000000  spareBits
       16rFF000000000  OM.reapEventsCount (in a saved stack)
      nativeStackKind  is one of STK_ values from om.hf .
          0 means interpreted , 1 mixed mode, 2 pure native code
      nativeCpuKind is the cpu that created the instance , see GC_GSPROCESS_cpuKind in gcioc.ht .
      debuggingInProgress == 0, debugging or single stepping is completed.
      debuggingInProgress == 1, debugging or single stepping is in progress ;
  breakpoints or single step exceptions are handled by the debugger
        and will not be seen by any user-installed Exception handlers.
      Breakpoints are not supported while executing in native code.
      A process' stack can be converted from native to portable as part
      of a GciContinue or GciStep.

 topFpOffset - a SmallInteger, byte offset from StackLimit back to the topFP,
   for a process not in a stack memory area.

 arStack - a GsStackBuffer, the saved evaluation stack, for a process
   not in a stack memory area.

 breakpointLevel - a SmallInteger  >=0 
   0 = system process (debugged via GCI), 
   1 = application process (debugged via debugger implemented in Smalltalk)
   used by implementation of breakpoints
   When execution encounters a breakpoint bytecode,  if the level of the
   breakpoint is <=  breakpointLevel of the GsProcess, the breakpoint is
   signalled.  A breakpoint with level 0 is always signalled directly to the GCI.
   A breakpoint may optionally include a GsProcess reference; if that reference
   is non-nil,  it must match the current GsProcess otherwise the breakpoint
   is ignored.

   Signalling of single step breakpoints is controlled directly by the value
   of the breakpointLevel instVar .  Single step breakpoints do not have
   a level associated with the individual breakpoints.

 block - an ExecBlock or nil, the block that the GsProcess is to execute.

 args - an Array of arguments for the block, or nil.

 blockResult - result returned by the block of a Smalltalk process
   has value _remoteNil if process has not terminated normally

 clientData - For application use, such as for thread-specific data.

 environment - A Dictionary containing thread-specific values,
   for application usage  with environmentAt:, environmentAt:put: .
   If the process is a Smalltalk continuation and environment is nil,
   then the environment dictionary from the calling process
   is used as the environment dictionary for the resumed continuation.
   Not related to environmentId of message sends.
   For Ruby, the dictionary of thread-local values.

 waitingOn - used by the scheduler, a GsSocket, Semaphore, Delay, or SharedQueue
    which this process is waiting on.

 group - a SmallInteger or RubyThreadGroup representing a process group .

 joiners - nil, or an Array of Delays or Semaphores representing other threads
     waiting in GsProcess>>join:  for this thread to finish.

 msgEnvironmentId - message send environmentId , 0 for default Smalltalk,
                      1 for Ruby .

 signalledException - used in the implementation of Exceptions .

 ioSelectResult - counter representing  executing a GsProcess termination

 stackSerialNum - private, for use by the scheduler and VM only

 dbgFpsCache - for use by  GsProcess>>_frameDescrAt: only, cleared by the VM
        whenever arStack is cleared.

 lastBreakpt - for use by implementation of breakpoints and single step.

Constraints:
  stackId: SmallInteger
  signalTime: SmallInteger
  priority_use: SmallInteger
  uaCount_depth: SmallInteger
  interruptFlag_stEntryCount: SmallInteger
  modeInfo: SmallInteger
  topFpOffset: SmallInteger
  arStack: GsStackBuffer
  breakpointLevel: SmallInteger
  block: ExecBlock
  args: Array
  blockResult: Object
  clientData: Object
  waitingOn: Object
  group: SmallInteger
  environment: AbstractDictionary
  onQueue: Object
  joiners: Object
  msgEnvironmentId: SmallInteger
  signalledException: AbstractException
  ioSelectResult: SmallInteger
  stackSerialNum: SmallInteger
  dbgFpsCache: Array
  lastBreakpt: Array

"
Class {
	#name : 'GsProcess',
	#superclass : 'Object',
	#instVars : [
		'stackId',
		'signalTime',
		'priority_use',
		'uaCount_depth',
		'interruptFlag_stEntryCount',
		'modeInfo',
		'topFpOffset',
		'arStack',
		'breakpointLevel',
		'block',
		'args',
		'blockResult',
		'clientData',
		'waitingOn',
		'group',
		'environment',
		'onQueue',
		'joiners',
		'msgEnvironmentId',
		'signalledException',
		'ioSelectResult',
		'stackSerialNum',
		'dbgFpsCache',
		'lastBreakpt',
		'debugActionBlock',
		'name',
		'startSeconds',
		'parentProcess',
		'ffiErrno'
	],
	#classVars : [
		'FP_codePtr_OFS',
		'FP_lastArg_OFS',
		'FP_markerNil_OFS',
		'FP_MarkerValue_OFS',
		'FP_rtnAddr_OFS',
		'FP_savedFP_OFS',
		'FP_stackTemp0_OFS',
		'FP_VC_OFS',
		'GC_GSPROCESS_cpuKind_interp',
		'MaxProcessStacks',
		'ModeInfo_anyTermination',
		'ModeInfo_breakptsIgnore_mask',
		'ModeInfo_breakptsIgnore_shift',
		'ModeInfo_continuationMask',
		'ModeInfo_continuationShift',
		'ModeInfo_debugEnabled',
		'ModeInfo_debuggingInProgress',
		'ModeInfo_forked',
		'ModeInfo_isContinuation',
		'ModeInfo_isPartialContinuation',
		'ModeInfo_isSuspended',
		'ModeInfo_partialContinuatLoaded',
		'ModeInfo_stackKind_mask',
		'ModeInfo_stackKind_shift',
		'ModeInfo_terminated',
		'ModeInfo_terminationStarted',
		'ModeInfo_threadEnvMask',
		'ModeInfo_v33',
		'OC_GSNMETHOD_FIRST_INSTR_OFFSET',
		'OOP_ENSURE_Mark_NIL',
		'OOP_REENTER_Mark_NIL',
		'OOP_terminationBlockValue_Mark_NIL'
	],
	#gs_options : [
		'disallowGciStore',
		'subclassesDisallowed'
	],
	#gs_reservedoop : '134657',
	#category : nil
}
