"
ScaledDecimal represents a decimal number to a fixed number of fractional digits. This
avoids the rounding issues in flating point numbers. 

ScaledDecimal stores numerical values as a mantissa and scale.
 The scale defines the position of the decimal point.
 The mantissa is an Integer .
 The scale is a SmallInteger >= 0 and <= 30000.
 The represented value is
     mantissa / (10 raisedTo: scale)  .

Creating a ScaledDecimal in the SmallScaledDecimal range will return an instance
of SmallScaledDecimal.

Literal ScaledDecimals can be created using the s notation; for example, 1.53s2. 
The s argument is the scale, and the mantissa is resized appropriately.  

Arithmetic operations between ScaledDecimals result in a ScaledDecimal
with a scale equal to either the receiver or the argument, whichever has the
greater scale. If the answer cannot be exactly represented within the result
scale, the result is rounded to the ScaledDecimal of that scale that is closest
to the precise result. If the precise result is exactly halfway between two
adjacent representable values, the value with an even mantissa is answered.

Numbers with a very large number of decimal digits cannot be represented as
a ScaledDecimal. The total digits (scale plus the number of digits to the left of
the decimal point) may not be more than can be represented by a
LargeInteger. This limit is set by the current implementation to be slightly over
39177 decimal digits. Operations on ScaledDecimals that attempt to create
numbers with more than this many digits will fail with an error.  This includes
intermediate calculations as well as results. Multiplication of ScaledDecimals,
for instance, internally computes an intermediate result with a number of
digits roughly the sum of the receiver's digits and the argument's digits.

Constraints:
	mantissa: Integer
	scale: SmallInteger
"
Class {
	#name : 'ScaledDecimal',
	#superclass : 'Number',
	#instVars : [
		'mantissa',
		'scale'
	],
	#classVars : [
		'MaxScale',
		'TenPowers'
	],
	#gs_options : [
		'selfCanBeSpecial'
	],
	#gs_reservedoop : '146433',
	#category : nil
}
