Class {
	#name : 'GemStoneRowanTool',
	#superclass : 'RwAbstractTool',
	#category : 'GemStone-Rowan-Tools'
}

{ #category : 'commands' }
GemStoneRowanTool class >> image [

	^GsRowanImageTool new
]

{ #category : 'commands' }
GemStoneRowanTool class >> topaz [

	^GsTopazRowanTool new
]

{ #category : 'private' }
GemStoneRowanTool >> _classesIn: symbolDictionary do: aBlock [
	"traverse all classes in the symbol dictionary, once"

	| coveredClasses |
	coveredClasses := IdentitySet new.
	symbolDictionary
		valuesDo: [ :namedClass | 
			(namedClass isKindOf: Class)
				ifTrue: [ 
					(coveredClasses includes: namedClass)
						ifFalse: [ 
							coveredClasses add: namedClass.
							aBlock value: namedClass ] ] ]
]
