!=========================================================================
! Copyright (C) GemTalk Systems 1986-2024.  All Rights Reserved.
!
! Description -  Object audit and garbage collect for use in filein.
!
!=========================================================================

! Start a admin and reclaim Gems so reclaimAll can complete
expectvalue true
run
System startAdminGem.
System stoneConfigurationAt: #StnNumGcReclaimSessions put: 1 .
System startReclaimGem.
true
%

expectvalue true
run
System waitForAllGcGemsToStartForUpToSeconds: 30.
%

time
expectvalue %Repository
run
[
  SystemRepository reclaimAllWait: 300
] on: Error do:[:ex |
  GsFile gciLogServer: 'ERROR at ', DateTime now asStringMs .
  GsFile gciLogServer: 'ERROR: ' , ex asString .
  GsFile gciLogServer: 'Waiting for topaz to attach'.
  [ true ] whileTrue:[ Delay waitForSeconds: 1 ].
]
%
time

expectvalue true
run
SystemRepository fastObjectAuditPartial
%
time

expectvalue true
run
SystemRepository markForCollection
%
! logout to assist SymbolGc
logout
login

time
expectvalue %Repository
run
[
  SystemRepository reclaimAllWait: 300
] on: Error do:[:ex |
  GsFile gciLogServer: 'ERROR at ', DateTime now asStringMs .
  GsFile gciLogServer: 'ERROR: ' , ex asString .
  GsFile gciLogServer: 'Waiting for topaz to attach'.
  [ true ] whileTrue:[ Delay waitForSeconds: 1 ].
]
%
time

run
"See also SymbolGemTest >> auditAllSymbols in tests/ernie"
| all arr x list w y | "method temps chosen to not create additional symbols"
System waitForVoteStateIdle .
all := ((AllUsers userWithId: 'SymbolUser') resolveSymbol: #AllSymbols) value.
1 to: all tableSize do:[:n | | bkt |
  bkt := all _at: n .
  1 to: bkt size - 1 do:[:m | |a b |
    w := (a:=bkt _at: m) codePointCompareTo: (b:=bkt _at: m+1).
    w == -1 ifFalse:[ 
      Error signal:'out of order in bucket ', bkt asOop asString,' ',
             a asOop asString,' ', a printString,' ',
             b asOop asString,' ', b printString.
    ]
  ].
].
arr := { }.
all keysDo:[:x | arr add: x ].
x := IdentitySet withAll: arr.
list := SystemRepository fastListInstances: { Symbol. DoubleByteSymbol. QuadByteSymbol }.
y := IdentitySet withAll:(list at: 1).
y addAll:(list at: 2); addAll:(list at: 3).
w := (x - y) + (y - x) .
w size == 0 ifFalse:[ 
  Error signal:'AllSymbols disagrees with listInstances ', (Array withAll: w) printString
].
(list at:1) do:[:sym |
  (Symbol _existingWithAll: sym asString ) == sym ifFalse:[
     Error signal:'lookup failure ', sym asOop asString,' ', sym printString
  ].
].
^true
%

expectvalue true
run
SystemRepository objectAudit
%
time
