! Copyright (C) GemTalk Systems 1986-2025.  All Rights Reserved.

FILEFORMAT UTF8
! Class Declarations
! Generated file, do not Edit

doit
(GsTestCase
	subclass: 'FsTestCase'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Core';
		immediateInvariant.
true.
%

removeallmethods FsTestCase
removeallclassmethods FsTestCase

doit
(FsTestCase
	subclass: 'FileLocatorTest'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Core';
		comment: 'Part of FileSystem

=========

SUnit test for FileLocator';
		immediateInvariant.
true.
%

removeallmethods FileLocatorTest
removeallclassmethods FileLocatorTest

doit
(FsTestCase
	subclass: 'FileReferenceAttributeTests'
	instVarNames: #(reference afterCreationTime beforeCreationTime)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Attributes';
		comment: 'Part of FileSystem

=========

Try and test file attribute access from FileReference.

As Pharo doesn''t provide a mechanism to set the attributes, pick a few well known files and make sure they have reasonable attributes, e.g. the VM is executable, it isn''t older than when the classes were first created or newer than today, etc.';
		immediateInvariant.
true.
%

removeallmethods FileReferenceAttributeTests
removeallclassmethods FileReferenceAttributeTests

doit
(FsTestCase
	indexableSubclass: 'FileReferenceTest'
	instVarNames: #(sandbox)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Core';
		comment: 'Part of FileSystem

=========

SUnit tests for file reference.

This test case assumes that #tearDown will appropriately cleanup the sandbox directory. Files placed anywhere else should be cleaned up by the test itself.';
		immediateInvariant.
true.
%

removeallmethods FileReferenceTest
removeallclassmethods FileReferenceTest

doit
(FileReferenceTest
	subclass: 'FsDiskFileReferenceTest'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Disk';
		comment: 'Part of FileSystem

=========

Test cases specific to disk-backed FileReferences.';
		immediateInvariant.
true.
%

removeallmethods FsDiskFileReferenceTest
removeallclassmethods FsDiskFileReferenceTest

doit
(FileReferenceTest
	subclass: 'FsMemoryFileReferenceTest'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Memory';
		comment: 'Part of FileSystem

=========

Test cases for memory-backed FileReferences.';
		immediateInvariant.
true.
%

removeallmethods FsMemoryFileReferenceTest
removeallclassmethods FsMemoryFileReferenceTest

doit
(FsTestCase
	subclass: 'FileSystemHandleTest'
	instVarNames: #(filesystem handle reference)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Core';
		comment: 'Part of FileSystem

=========

SUnit tests for FileSystemHandle';
		immediateInvariant.
true.
%

removeallmethods FileSystemHandleTest
removeallclassmethods FileSystemHandleTest

doit
(FileSystemHandleTest
	subclass: 'MemoryHandleTest'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Memory';
		comment: 'Part of FileSystem

=========

SUnit tests for memory handles, the tests may be found in superclass';
		immediateInvariant.
true.
%

removeallmethods MemoryHandleTest
removeallclassmethods MemoryHandleTest

doit
(FsTestCase
	subclass: 'FileSystemResolverTest'
	instVarNames: #(resolver)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Core';
		comment: 'Part of FileSystem

=========

SUnit tests for FileSystemResolver';
		immediateInvariant.
true.
%

removeallmethods FileSystemResolverTest
removeallclassmethods FileSystemResolverTest

doit
(FileSystemResolverTest
	subclass: 'EnvironmentResolverTest'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Core';
		immediateInvariant.
true.
%

removeallmethods EnvironmentResolverTest
removeallclassmethods EnvironmentResolverTest

doit
(FileSystemResolverTest
	subclass: 'PlatformResolverTest'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Core';
		comment: 'Part of FileSystem

=========

SUnit tests for PlatformResolver';
		immediateInvariant.
true.
%

removeallmethods PlatformResolverTest
removeallclassmethods PlatformResolverTest

doit
(FileSystemResolverTest
	subclass: 'SystemResolverTest'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Core';
		comment: 'Part of FileSystem

=========

SUnit tests for SystemResolver';
		immediateInvariant.
true.
%

removeallmethods SystemResolverTest
removeallclassmethods SystemResolverTest

doit
(FsTestCase
	subclass: 'FileSystemTest'
	instVarNames: #(filesystem toDelete)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Core';
		comment: 'Part of FileSystem

=========

I am an abstract file system test. 
I directly test 
- the public interface of a FileSystem using these methods directly
- the FileSystem in general through the operation methods of the FileReference';
		immediateInvariant.
true.
%

removeallmethods FileSystemTest
removeallclassmethods FileSystemTest

doit
(FileSystemTest
	subclass: 'FsDiskFileSystemTest'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Disk';
		comment: 'Part of FileSystem

=========

SUnit tests for the disk filesystem';
		immediateInvariant.
true.
%

removeallmethods FsDiskFileSystemTest
removeallclassmethods FsDiskFileSystemTest

doit
(FileSystemTest
	subclass: 'FsMemoryFileSystemTest'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Memory';
		comment: 'Part of FileSystem

=========

SUnit tests for MemoryFileSystem';
		immediateInvariant.
true.
%

removeallmethods FsMemoryFileSystemTest
removeallclassmethods FsMemoryFileSystemTest

doit
(FsTestCase
	subclass: 'FsBinaryFileStreamTest'
	instVarNames: #(sandbox)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-FileDescriptor-Tests';
		immediateInvariant.
true.
%

removeallmethods FsBinaryFileStreamTest
removeallclassmethods FsBinaryFileStreamTest

doit
(FsTestCase
	subclass: 'FsFileDescriptorRegistryTest'
	instVarNames: #(sandbox)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-FileDescriptor-Tests';
		immediateInvariant.
true.
%

removeallmethods FsFileDescriptorRegistryTest
removeallclassmethods FsFileDescriptorRegistryTest

doit
(FsTestCase
	subclass: 'FsFileDescriptorTest'
	instVarNames: #(stdin stdout stderr)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-FileDescriptor-Tests';
		comment: 'Part of FileSystem

=========

Test cases for FsFileDescriptor';
		immediateInvariant.
true.
%

removeallmethods FsFileDescriptorTest
removeallclassmethods FsFileDescriptorTest

doit
(FsTestCase
	subclass: 'FsGemStoneKernelTests'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-GemStone';
		comment: 'Part of FileSystem

=========

Test cases against various GemStone behaviors.';
		immediateInvariant.
true.
%

removeallmethods FsGemStoneKernelTests
removeallclassmethods FsGemStoneKernelTests

doit
(FsTestCase
	subclass: 'FsIntegerExtensionTestCase'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-GemStone';
		immediateInvariant.
true.
%

removeallmethods FsIntegerExtensionTestCase
removeallclassmethods FsIntegerExtensionTestCase

doit
(FsTestCase
	subclass: 'FsMemoryOpeningOptionsTest'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Memory';
		comment: 'Part of FileSystem

=========

Test Cases for FsMemoryOpeningOptions';
		immediateInvariant.
true.
%

removeallmethods FsMemoryOpeningOptionsTest
removeallclassmethods FsMemoryOpeningOptionsTest

doit
(FsTestCase
	subclass: 'FsUnixFileOpeningOptionsTest'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-FileDescriptor-Tests';
		comment: 'Part of FileSystem

=========

Test cases for FsUnixFileOpeningOptions';
		immediateInvariant.
true.
%

removeallmethods FsUnixFileOpeningOptionsTest
removeallclassmethods FsUnixFileOpeningOptionsTest

doit
(FsTestCase
	subclass: 'FsZincIntegrationTests'
	instVarNames: #(sandbox)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Core';
		comment: 'Part of FileSystem

=========

SUnit tests for random zinc stream integration issues.';
		immediateInvariant.
true.
%

removeallmethods FsZincIntegrationTests
removeallclassmethods FsZincIntegrationTests

doit
(FsZincIntegrationTests
	subclass: 'FsZincDiskIntegrationTests'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Disk';
		comment: 'Part of FileSystem

=========

SUnit tests for random zinc stream integration issues.';
		immediateInvariant.
true.
%

removeallmethods FsZincDiskIntegrationTests
removeallclassmethods FsZincDiskIntegrationTests

doit
(FsZincIntegrationTests
	subclass: 'FsZincInMemoryIntegrationTests'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Memory';
		comment: 'Part of FileSystem

=========

SUnit tests for random zinc stream integration issues.';
		immediateInvariant.
true.
%

removeallmethods FsZincInMemoryIntegrationTests
removeallclassmethods FsZincInMemoryIntegrationTests

doit
(FsTestCase
	indexableSubclass: 'PathTest'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Tests-Core';
		comment: 'Part of FileSystem

=========

SUnit tests for file system paths';
		immediateInvariant.
true.
%

removeallmethods PathTest
removeallclassmethods PathTest

doit
(FsTestCase
	subclass: 'ZnAbstractCharacterEncoderTests'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Tests';
		comment: 'Part of FileSystem

=========

Test cases for character encoding';
		immediateInvariant.
true.
%

removeallmethods ZnAbstractCharacterEncoderTests
removeallclassmethods ZnAbstractCharacterEncoderTests

doit
(ZnAbstractCharacterEncoderTests
	subclass: 'Zn8BITCharacterEncoderTests'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Tests';
		immediateInvariant.
true.
%

removeallmethods Zn8BITCharacterEncoderTests
removeallclassmethods Zn8BITCharacterEncoderTests

doit
(ZnAbstractCharacterEncoderTests
	subclass: 'ZnUTF8CharacterEncoderTests'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Tests';
		immediateInvariant.
true.
%

removeallmethods ZnUTF8CharacterEncoderTests
removeallclassmethods ZnUTF8CharacterEncoderTests

doit
(FsTestCase
	subclass: 'ZnAbstractCharacterStreamTests'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Tests';
		comment: 'Part of FileSystem

=========

Test cases for ZnCharacterStream';
		immediateInvariant.
true.
%

removeallmethods ZnAbstractCharacterStreamTests
removeallclassmethods ZnAbstractCharacterStreamTests

doit
(ZnAbstractCharacterStreamTests
	subclass: 'ZnLegacyCharacterStreamTests'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Tests';
		immediateInvariant.
true.
%

removeallmethods ZnLegacyCharacterStreamTests
removeallclassmethods ZnLegacyCharacterStreamTests

doit
(ZnAbstractCharacterStreamTests
	subclass: 'ZnUnicodeCharacterStreamTests'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Tests';
		immediateInvariant.
true.
%

removeallmethods ZnUnicodeCharacterStreamTests
removeallclassmethods ZnUnicodeCharacterStreamTests

doit
(FsTestCase
	subclass: 'ZnBufferedReadStreamTests'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Tests';
		comment: 'Part of FileSystem

=========

I am ZnBufferedReadStreamTests.';
		immediateInvariant.
true.
%

removeallmethods ZnBufferedReadStreamTests
removeallclassmethods ZnBufferedReadStreamTests

doit
(FsTestCase
	subclass: 'ZnBufferedReadWriteStreamTests'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Tests';
		comment: 'Part of FileSystem

=========

Test cases for ZnBufferedReadWriteStream';
		immediateInvariant.
true.
%

removeallmethods ZnBufferedReadWriteStreamTests
removeallclassmethods ZnBufferedReadWriteStreamTests

doit
(FsTestCase
	subclass: 'ZnBufferedStreamByteTests'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Tests';
		comment: 'Part of FileSystem

=========

Tests for bufferer read/write streams that are assumed to contain bytes.

Right now, integer encoding/decoding

References

https://en.wikipedia.org/wiki/Endianness
https://en.wikipedia.org/wiki/Two%27s_complement';
		immediateInvariant.
true.
%

removeallmethods ZnBufferedStreamByteTests
removeallclassmethods ZnBufferedStreamByteTests

doit
(FsTestCase
	subclass: 'ZnBufferedWriteStreamTests'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Tests';
		comment: 'Part of FileSystem

=========

Test cases for ZnBufferedWriteStream';
		immediateInvariant.
true.
%

removeallmethods ZnBufferedWriteStreamTests
removeallclassmethods ZnBufferedWriteStreamTests

doit
(Object
	subclass: 'FsMockStream'
	instVarNames: #(actionSequence)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Tests';
		comment: 'Part of FileSystem

=========

Mock class used to ensure stream classes are behaving correctly.';
		immediateInvariant.
true.
%

removeallmethods FsMockStream
removeallclassmethods FsMockStream

! Class implementation for 'FsTestCase'

!		Class methods for 'FsTestCase'

category: 'testing'
classmethod: FsTestCase
isAbstract
	^ self name = #FsTestCase
%

category: 'Running'
classmethod: FsTestCase
runEx
	"receiver should be a concrete test case class.
 Use  runExExpectPassed: to avoid error on number of test cases passed."

	^ self runEx: self expectPassed: 1000000	"expect an error"
%

category: 'Running'
classmethod: FsTestCase
runEx: aTestCaseClass
	"Use  runEx:ExpectPassed: to avoid error on number of test cases passed."

	^ self runEx: aTestCaseClass expectPassed: 1000000	"expect an error"
%

category: 'Running'
classmethod: FsTestCase
runEx: aTestCaseClass expectPassed: anInteger
	| results defects str |
	AlmostOutOfMemoryError
		enable;
		threshold: 90.
	results := aTestCaseClass suite run.
	defects := results defects.
	defects size > 0
		ifTrue: [ 
			(str := '=========== Failed test cases' copy) lf.
			defects
				do: [ :each | 
					str
						addAll: each printString;
						lf ].
			str
				add: '===========';
				lf.
			System clientIsRemote
				ifTrue: [ Error signal: str ]
				ifFalse: [ GsFile gciLogServer: str ] ].
	results passedCount < anInteger
		ifTrue: [ 
			Error
				signal:
					'expected passed >= ' , anInteger asString , ' got: ' , results printString ].
	defects size == 0
		ifTrue: [ ^ results printString ]
		ifFalse: [ 
			Error
				signal:
					results passedCount asString , ' test cases passed, Some test cases failed: ' ]
%

! Class implementation for 'FileLocatorTest'

!		Instance methods for 'FileLocatorTest'

category: 'asserting'
method: FileLocatorTest
assert: anObject
isKindOf: aClass

	^self assert: (anObject isKindOf: aClass)
%

category: 'accessing'
method: FileLocatorTest
exampleLocator

	| example |
	example := FileLocator workingDirectory.
	self
		assert: example
		isKindOf: FileLocator.
	^example
%

category: 'compatibility tests'
method: FileLocatorTest
testAsAbsolute
  | locator |
	locator := FileLocator workingDirectory.
	self assert: locator asAbsolute = locator
%

category: 'compatibility tests'
method: FileLocatorTest
testBasename
  | locator |
	locator := FileLocator workingDirectory / 'griffle'.
	self assert: locator basename = 'griffle'
%

category: 'compatibility tests'
method: FileLocatorTest
testCommaAddsExtension
  | locator |
	locator := FileLocator workingDirectory / 'griffle'.
	self assert: (locator , 'plonk') basename = 'griffle.plonk'
%

category: 'compatibility tests'
method: FileLocatorTest
testCommaAddsExtensionAgain
  | locator |
	locator := FileLocator workingDirectory / 'griffle.plonk'.
	self assert: (locator , 'nurp') basename = 'griffle.plonk.nurp'
%

category: 'compatibility tests'
method: FileLocatorTest
testContainsLocator
  | locator |
	locator := FileLocator workingDirectory.
	self assert: (locator contains: locator / 'griffle').
%

category: 'compatibility tests'
method: FileLocatorTest
testContainsPath
  | locator |
	locator := FileLocator workingDirectory.
	self assert: (locator contains: (locator resolve / 'griffle') path).
%

category: 'compatibility tests'
method: FileLocatorTest
testContainsReference
  | locator |
	locator := FileLocator workingDirectory.
	self assert: (locator contains: (locator resolve / 'griffle')).
%

category: 'compatibility tests'
method: FileLocatorTest
testDeviceId
	self
		assert: self exampleLocator deviceId
		isKindOf: Integer
%

category: 'compatibility tests'
method: FileLocatorTest
testEqual
	| a b |
	a := FileLocator workingDirectory.
	b := FileLocator workingDirectory.
	self deny: a == b.
	self assert: a = b.
%

category: 'compatibility tests'
method: FileLocatorTest
testExtension
  | locator |
	locator := FileLocator workingDirectory, 'bak'.
	self assert: (locator basename endsWith: '.bak')
%

category: 'compatibility tests'
method: FileLocatorTest
testFileSystem
  | locator |
	locator := FileLocator workingDirectory.
	self assert: (locator fileSystem isKindOf: FileSystem)
%

category: 'resolution tests'
method: FileLocatorTest
testFromPathIfNone
	| marker path locator |
	marker := Object new.
	path := '/foo' asPath.	
	locator := FileLocator fromPath: path ifNone: [marker].
	self assert: locator identical: marker.
	path := FileLocator temp resolve asPath.
	locator := FileLocator fromPath: path ifNone: [marker].
	self
		assert: locator
		equals: FileLocator temp
%

category: 'compatibility tests'
method: FileLocatorTest
testGid

	self
		assert: self exampleLocator gid
		isKindOf: Integer
%

category: 'compatibility tests'
method: FileLocatorTest
testIfExistsIfAbsent
	| marker file result |
	marker := Object new.
	file := FileLocator workingDirectory / 'ifExists-ifAbsent'.
	file ensureDelete.

	[self deny: file exists.
	result := file ifAbsent: [marker].
	self
		assert: result
		equals: marker.
	result := file ifExists: [marker].
	self
		assert: result
		equals: file.
	result := file
		ifExists: [self assert: false]
		ifAbsent: [marker].
	self
		assert: result
		equals: marker.

	file createFile.
	self assert: file exists.
	result := file ifAbsent: [self assert: false].
	self
		assert: result
		equals: file.
	result := file ifExists: [marker].
	self
		assert: result
		equals: marker.
	result := file
		ifExists: [marker]
		ifAbsent: [self assert: false].
	self
		assert: result
		equals: marker]
	ensure: [file ensureDelete]
%

category: 'compatibility tests'
method: FileLocatorTest
testInode

	| temp |
	temp := FileLocator workingDirectory.
	self
		assert: temp inode
		isKindOf: Integer
%

category: 'compatibility tests'
method: FileLocatorTest
testIsAbsolute
  | locator |
	locator := FileLocator root.
	self assert: locator isAbsolute
%

category: 'compatibility tests'
method: FileLocatorTest
testIsNotRoot
  | locator |
	locator := FileLocator workingDirectory.
	self deny: locator isRoot
%

category: 'compatibility tests'
method: FileLocatorTest
testIsRelative
  | locator |
	locator := FileLocator root.
	self deny: locator isRelative
%

category: 'compatibility tests'
method: FileLocatorTest
testIsRoot
  | locator |
	self deny: FileLocator workingDirectory isRoot.
	self assert: FileLocator root isRoot.

	locator := FileLocator workingDirectory asAbsolute.
	(locator resolve path size) timesRepeat: [locator := locator / '..'].
	self assert: locator canonicalize isRoot.
%

category: 'compatibility tests'
method: FileLocatorTest
testMoveTo
	| old new |
	[
		old := FileLocator workingDirectory / 'testMoveTo_old'.
		old ensureCreateFile.
		
		new := FileLocator workingDirectory / 'testMoveTo_new'.
		old moveTo: new.
		
		self deny: old exists.
		self assert: new exists.
	] ensure: [ 
		old ensureDelete.
		new ensureDelete.
	]
%

category: 'compatibility tests'
method: FileLocatorTest
testNumberOfHardLinks

	| temp |
	temp := FileLocator workingDirectory.
	self assert: temp numberOfHardLinks > 0
%

category: 'compatibility tests'
method: FileLocatorTest
testOriginBasename
  | locator |
	locator := FileLocator workingDirectory.
	self assert: locator basename = FileLocator workingDirectory resolve basename
%

category: 'compatibility tests'
method: FileLocatorTest
testParent
	| parent locator |
	locator := FileLocator workingDirectory.
	parent := locator parent.
	self assert: (parent contains: locator)
%

category: 'resolution tests'
method: FileLocatorTest
testResolveAbsoluteReference
	| result reference locator |
	locator := FileLocator workingDirectory / 'plonk'.
	reference := FileSystem memory / 'griffle'.
	result := locator resolve: reference.
	self assert: result == reference
%

category: 'resolution tests'
method: FileLocatorTest
testResolveCompoundString
	| result compound locator |
	locator := FileLocator workingDirectory / 'plonk'.
	compound := 'griffle', locator fileSystem delimiter asString, 'nurp'.
	result := locator resolve: compound.
	self assert: result class = locator class.
	self assert: result origin = locator origin.
	self assert: result path = ((Path * 'plonk') / 'griffle' / 'nurp')
%

category: 'resolution tests'
method: FileLocatorTest
testResolvePath
	| result path locator |
	locator := FileLocator workingDirectory / 'plonk'.
	result := locator resolve: (Path * 'griffle').
	path := (Path * 'plonk') / 'griffle'.
	self assert: result class = locator class.
	self assert: result origin = locator origin.
	self assert: result path = path.
%

category: 'resolution tests'
method: FileLocatorTest
testResolveRelativeReference
	| result reference locator |
	locator := FileLocator workingDirectory / 'plonk'.
	reference := FileSystem memory * 'griffle'.
	result := locator resolve: reference.
	self assert: result class equals: locator class.
	self assert: result origin equals: locator origin.
	self assert: result path equals: reference path
%

category: 'resolution tests'
method: FileLocatorTest
testResolveString
	| result path locator |
	locator := FileLocator workingDirectory / 'plonk'.
	result := locator resolve: 'griffle'.
	path := (Path * 'plonk') / 'griffle'.
	self assert: result class = locator class.
	self assert: result origin = locator origin.
	self assert: result path = path.
%

category: 'compatibility tests'
method: FileLocatorTest
testSlash

	self
		assert: (FileLocator workingDirectory / 'griffle')
		equals: (FileLocator workingDirectory / 'griffle').
	self
		assert: (FileLocator workingDirectory / '')
		equals: FileLocator workingDirectory
%

category: 'compatibility tests'
method: FileLocatorTest
testTargetPath

	self
		should: [FileLocator workingDirectory targetPath]
		raise: FileAttributeNotSupported
%

category: 'compatibility tests'
method: FileLocatorTest
testUid

	self
		assert: self exampleLocator uid
		isKindOf: Integer
%

category: 'compatibility tests'
method: FileLocatorTest
testWithExtensionAddsExtension
  | locator |
	locator := FileLocator workingDirectory / 'griffle'.
	self assert: (locator withExtension: 'plonk') basename = 'griffle.plonk'
%

category: 'compatibility tests'
method: FileLocatorTest
testWithExtensionReplacesExtension
  | locator |
	locator := FileLocator workingDirectory / 'griffle.nurp'.
	self assert: (locator withExtension: 'plonk') basename = 'griffle.plonk'
%

! Class implementation for 'FileReferenceAttributeTests'

!		Instance methods for 'FileReferenceAttributeTests'

category: 'accessing'
method: FileReferenceAttributeTests
afterCreationTime

	^afterCreationTime
%

category: 'asserting'
method: FileReferenceAttributeTests
assert: middle
between: min
and: max

	^self assert: (middle between: min and: max)
%

category: 'accessing'
method: FileReferenceAttributeTests
beforeCreationTime

	^beforeCreationTime
%

category: 'accessing'
method: FileReferenceAttributeTests
reference

	^reference
%

category: 'testing'
method: FileReferenceAttributeTests
referenceSupportsAtime

	| mountOptions |
	mountOptions :=  System performOnServer: 'mount | grep "^$(df -Pk ''', self reference pathString, ''' | head -n 2 | tail -n 1 | cut -f 1 -d '' '') "'.
	"Including NFS since we do not know the remote mount options."
	^((mountOptions includesString: 'noatime') or: [mountOptions includesString: 'nfs']) not
%

category: 'initializing'
method: FileReferenceAttributeTests
setUp

	| ws bufferedStream |
	reference := FileLocator workingDirectory asFileReference
		/ ('FileAttributesTests-' , GsUuidV4 new asInteger asString , '.txt').
	beforeCreationTime := DateAndTime now.
	self shortDelay.
	ws := reference writeStream.
	bufferedStream := ZnBufferedWriteStream on: ws.
	[ 
	bufferedStream nextPutAll: 'Created by FileAttributesTestsResources>>setUp '.
	beforeCreationTime printOn: bufferedStream ]
		ensure: [ bufferedStream close ].
	self shortDelay.
	afterCreationTime := DateAndTime now
%

category: 'helper methods'
method: FileReferenceAttributeTests
shortDelay

	(Delay forMilliseconds: 10) wait
%

category: 'initializing'
method: FileReferenceAttributeTests
tearDown

	reference delete.
	super tearDown
%

category: 'tests'
method: FileReferenceAttributeTests
testAccessTime

	| initialAccessTime |
	self referenceSupportsAtime "Skip if noatime is configured"
		ifFalse: [^self].
	initialAccessTime := self reference accessTime.
	(Delay forMilliseconds: 10) wait.
	"This dance deals w/ relatime"
	self reference binaryWriteStream nextPutAll: #[1 2 3 4]; close.
	self reference binaryReadStream next: 1; close.
	self assert: self reference accessTime > initialAccessTime
%

category: 'tests'
method: FileReferenceAttributeTests
testCreationTime

	self
		should: [self reference creationTime]
		raise: FileAttributeNotSupported.
%

category: 'tests'
method: FileReferenceAttributeTests
testExists

	self assert: self reference exists
%

category: 'tests'
method: FileReferenceAttributeTests
testFileSize

	self
		assert: self reference size
		equals: 79
%

category: 'tests'
method: FileReferenceAttributeTests
testIsCharacter

	self deny: self reference isCharacter
%

category: 'tests'
method: FileReferenceAttributeTests
testIsDirectory

	self deny: self reference isDirectory.
	self assert: FileLocator workingDirectory isDirectory.
%

category: 'tests'
method: FileReferenceAttributeTests
testIsFile

	self assert: self reference isFile.
	self deny: FileLocator workingDirectory isFile.
%

category: 'tests'
method: FileReferenceAttributeTests
testIsReadable

	self assert: self reference isReadable.
%

category: 'tests'
method: FileReferenceAttributeTests
testIsSymlink

	self deny: self reference isSymlink.
%

category: 'tests'
method: FileReferenceAttributeTests
testIsWriteable

	self assert: self reference isWritable.
%

category: 'tests'
method: FileReferenceAttributeTests
testModificationTime

	self
		assert: self reference modificationTime
		between: self beforeCreationTime
		and: self afterCreationTime.
	self shortDelay.
	self reference binaryWriteStream
		nextPutAll: (ByteArray new: 5);
		close.
	self shortDelay.
	self
		assert: self reference modificationTime
		between: self afterCreationTime
		and: DateAndTime now
%

! Class implementation for 'FileReferenceTest'

!		Class methods for 'FileReferenceTest'

category: 'tesing'
classmethod: FileReferenceTest
isAbstract

	^self == FileReferenceTest
%

category: 'tesing'
classmethod: FileReferenceTest
shouldInheritSelectors

	^true
%

!		Instance methods for 'FileReferenceTest'

category: 'asserting'
method: FileReferenceTest
assert: anObject
identicalTo: bObject

	^self assert: anObject == bObject
%

category: 'asserting'
method: FileReferenceTest
assert: anObject
isKindOf: aClass

	^self assert: (anObject isKindOf: aClass)
%

category: 'support'
method: FileReferenceTest
binaryContentsOf: aReference

	| contents |
	aReference binaryReadStreamDo: [:stream | contents := stream contents].
	^contents
%

category: 'support'
method: FileReferenceTest
createDirectory: aString

	| reference |
	reference := sandbox / aString.
	reference ensureCreateDirectory.
	self assert: reference isDirectory.
	^reference
%

category: 'support'
method: FileReferenceTest
createFile: aString

	^self
		createFile: aString
		contents: self defaultFileContents
%

category: 'support'
method: FileReferenceTest
createFile: aString
contents: contentsString

	| reference |
	reference := sandbox / aString.
	reference parent ensureCreateDirectory.
	reference writeStreamDo: [:stream | stream nextPutAll: contentsString].
	self assert: reference isFile.
	^reference
%

category: 'support'
method: FileReferenceTest
defaultFileContents

	^self class name asString, '>>', self selector asString
%

category: 'asserting'
method: FileReferenceTest
deny: anObject
identicalTo: bObject

	^self deny: anObject == bObject
%

category: 'other'
method: FileReferenceTest
fileSystem

	^sandbox fileSystem
%

category: 'accessing'
method: FileReferenceTest
fsType

	^self fileSystem isDiskFileSystem
		ifTrue: ['disk']
		ifFalse: ['memory'].
%

category: 'accessing'
method: FileReferenceTest
sandboxName
	"name of the sandbox directory"

	^String new, self class name, '-', self selector, '-Sandbox'
%

category: 'tests'
method: FileReferenceTest
testAccessTime
	"See subclass implementations if supported."

	self
		should: [sandbox accessTime]
		raise: FileAttributeNotSupported
%

category: 'tests'
method: FileReferenceTest
testAllChildren
	"allChildren returns all the files and folders recursively nested in a reference"

	| alpha children |
	alpha := self createDirectory: 'alpha'.
	self
		createDirectory: 'alpha/beta';
		createDirectory: 'alpha/beta/delta';
		createDirectory: 'alpha/gamma'.
	children := alpha allChildren.
	"all children returns the nodes: '/alpha', '/alpha/beta',  '/alpha/beta/delta', and '/alpha/gamma'."
	self assert: children size equals: 4.
	children
		do: [ :child | 
			self assert: child class equals: FileReference.
			self assert: (alpha = child or: [ alpha contains: child ]) ].
	self
		assert: (children collect: [ :ea | ea basename ]) asSet
		equals: #('alpha' 'beta' 'gamma' 'delta') asSet
%

category: 'tests'
method: FileReferenceTest
testAllDirectories
	"allDirectories returns all folders recursively nested in a reference"

	| alpha children |
	alpha := self createDirectory: 'alpha'.
	self
		createDirectory: 'alpha/beta';
		createDirectory: 'alpha/beta/delta';
		createDirectory: 'alpha/gamma'.
	children := alpha allDirectories.
	"all children returns the directories: '/alpha', '/alpha/beta', and '/alpha/gamma'."
	self assert: children size equals: 4.
	children
		do: [ :child | 
			self assert: child class equals: FileReference.
			self assert: (alpha = child or: [ alpha contains: child ]) ].
	self
		assert: (children collect: [ :ea | ea basename ]) asSet
		equals: #('alpha' 'beta' 'gamma' 'delta') asSet
%

category: 'tests'
method: FileReferenceTest
testAppendStream

	| ref stream |
	ref := sandbox / 'testAppendStream.file'.
	self deny: ref exists.
	stream := ref appendStream.
	[stream nextPutAll: '1234']
		ensure: [stream close].
	self
		assert: ref contents
		equals: '1234'.
	stream := ref appendStream.
	[stream nextPutAll: '5678']
		ensure: [stream close].
	self
		assert: ref contents
		equals: '12345678'.
%

category: 'tests'
method: FileReferenceTest
testAppendStreamDo

	| ref |
	ref := sandbox / 'testAppendStreamDo.file'.
	self deny: ref exists.
	ref appendStreamDo: [:stream | stream nextPutAll: '1234'].
	self assert: ref exists.
	self
		assert: ref contents
		equals: '1234'.
	ref appendStreamDo: [:stream | stream nextPutAll: '5678'].
	self
		assert: ref contents
		equals: '12345678'
%

category: 'tests'
method: FileReferenceTest
testAppendStreamEncoded

	| ref stream |
	ref := sandbox / 'testAppendStreamEncoded.file'.
	self deny: ref exists.
	stream := ref appendStreamEncoded: 'utf8'.
	[stream nextPutAll: '1234']
		ensure: [stream close].
	self
		assert: (self binaryContentsOf: ref)
		equals: #[49 50 51 52].
	stream := ref appendStreamEncoded: '8bit'.
	[stream nextPutAll: '5678']
		ensure: [stream close].
	self
		assert:(self binaryContentsOf: ref)
		equals: #[49 50 51 52 53 54 55 56].
%

category: 'tests'
method: FileReferenceTest
testAppendStreamEncodedDo

	| ref  |
	ref := sandbox / 'testAppendStreamEncoded.file'.
	self deny: ref exists.
	ref
		appendStreamEncoded: 'utf8'
		do: [:stream | stream nextPutAll: '1234'].
	self
		assert: (self binaryContentsOf: ref)
		equals: #[49 50 51 52].
	ref
		appendStreamEncoded: 'utf8'
		do: [:stream | stream nextPutAll: '5678'].
	self
		assert:(self binaryContentsOf: ref)
		equals: #[49 50 51 52 53 54 55 56].
%

category: 'tests'
method: FileReferenceTest
testAsAbsoluteConverted
	"Converts a relative reference to absolute, and asserts
	that it's absolute and still has the same path."

	| ref absolute absolutePath |
	ref := sandbox / 'plonk'.
	absolute := ref asAbsolute.
	self assert: absolute isAbsolute.
	absolutePath := absolute path.
	self assert: (absolutePath at: absolutePath size) equals: 'plonk'
%

category: 'tests'
method: FileReferenceTest
testAsAbsoluteIdentity
	| ref |
	ref := sandbox / 'plonk'.
	self assert: ref asAbsolute == ref
%

category: 'tests'
method: FileReferenceTest
testAsJson
	"Ensure that a resonable JSON string is generated for instances
	with both AbsolutePath and RelativePath paths."

	| reference expected |
	reference := FileReference
		fileSystem: self fileSystem
		path: Path / 'absolute' / 'path'.
	expected := '{"path":"/absolute/path","filesystem":"', self fsType, '"}'.
	self
		assert: reference asJson
		equals: expected.
	reference := FileReference
		fileSystem: self fileSystem
		path: Path * 'relative' / 'path'.
	expected := '{"path":"relative/path","filesystem":"', self fsType, '"}'.
	self
		assert: reference asJson
		equals: expected
%

category: 'tests'
method: FileReferenceTest
testAsReference
	| ref |
	ref := sandbox / 'plonk'.
	self assert: ref asFileReference == ref
%

category: 'tests'
method: FileReferenceTest
testBaseAndExtension
	| noExtension simpleExtension complexExtension |
	noExtension := sandbox / 'plonk'.
	self assert: noExtension extension equals: ''.

	"We create a reference to the plonk/griffle.taz in the context of filesystem"
	simpleExtension := sandbox / 'plonk' / 'griffle.taz'.
	self assert: simpleExtension base equals: 'griffle'.
	self assert: simpleExtension extension equals: 'taz'.

	"Note that the extension of a complex extension starts after the last extension delimiter"
	complexExtension := sandbox / 'plonk' / 'griffle.taz.txt'.
	self assert: complexExtension base equals: 'griffle.taz'.
	self assert: complexExtension extension equals: 'txt'
%

category: 'tests'
method: FileReferenceTest
testBasename

	| alpha beta gamma |
	alpha := sandbox / 'alpha'.
	beta := alpha / 'beta'.
	gamma := alpha / 'gamma.delta'.
	self
		assert: sandbox basename
		equals: self sandboxName.
	self
		assert: beta basename
		equals: 'beta'.
	self
		assert: gamma basename
		equals: 'gamma.delta'
%

category: 'other'
method: FileReferenceTest
testBasenameWithoutExtension
	
	| alpha beta |
	alpha := sandbox / 'alpha'.
	beta := alpha / 'beta.gamma.delta'.
	self
		assert: alpha basenameWithoutExtension
		equals: 'alpha'.
	self
		assert: (alpha basenameWithoutExtension: 'alpha')
		equals: 'alpha'.
	self
		assert: (alpha basenameWithoutExtension: 'epsilon')
		equals: 'alpha'.
	self
		assert: beta basenameWithoutExtension
		equals: 'beta.gamma'.
	self
		assert: (beta basenameWithoutExtension: 'delta')
		equals: 'beta.gamma'.
	self
		assert: (beta basenameWithoutExtension: 'gamma.delta')
		equals: 'beta'.
	self
		assert: (beta basenameWithoutExtension: 'gamma')
		equals: 'beta.gamma.delta'.
	self
		assert: (beta basenameWithoutExtension: 'epsilon')
		equals: 'beta.gamma.delta'
%

category: 'tests'
method: FileReferenceTest
testBinaryReadStream

	| plonk absent directory |
	plonk := self createFile: 'plonk'.
	plonk binaryReadStream
		ifNil: [self assert: false]
		ifNotNil:
			[:stream |
			[self
				assert: stream contents
				equals: self defaultFileContents encodeAsUTF8 asByteArray]
					ensure: [stream close]].
	absent := sandbox / 'absent'.
	self
		should: [absent readStream]
		raise: FileDoesNotExistException.
	directory := self createDirectory: 'directory'.
	self
		should: [directory readStream]
		raise: FileRequired
%

category: 'tests'
method: FileReferenceTest
testBinaryWriteStream
	"See subclass implementations. Semantics differ to as this reflects Pharo."

	self assert: false
%

category: 'tests'
method: FileReferenceTest
testCanonicalization

	| ref |

	ref := 'a/b/c' asFileReference canonicalize.
	self assert: ref path segments equals: #('a' 'b' 'c').

	ref := '/a/b/c' asFileReference canonicalize.
	self assert: ref path segments equals: #('a' 'b' 'c').

	ref := '../a/b/c' asFileReference canonicalize.
	self assert: ref path segments equals: #('..' 'a' 'b' 'c').

	ref := 'a/b/c/..' asFileReference canonicalize.
	self assert: ref path segments equals: #('a' 'b').

	ref := '/a/b/c/..' asFileReference canonicalize.
	self assert: ref path segments equals: #('a' 'b').

	ref := 'a/b/../c' asFileReference canonicalize.
	self assert: ref path segments equals: #('a' 'c').

	ref := '/a/b/../c' asFileReference canonicalize.
	self assert: ref path segments equals: #('a' 'c').
%

category: 'tests'
method: FileReferenceTest
testChangeTime

	self
		assert: sandbox changeTime
		isKindOf: DateAndTime
%

category: 'tests'
method: FileReferenceTest
testChildDirectories

	| alpha beta gamma delta epsilon |
	alpha := self createDirectory: 'alpha'.
	beta := self createDirectory: 'beta'.
	gamma := self createFile: 'gamma'.
	delta := self createFile: 'delta'.

	"Ensure sending to a directory returns correct results."
	self
		assert: sandbox directories asSet
		equals: {alpha. beta.} asSet.
	
	"Ensure DirectoryDoesNotExist is signaled when the directory does not exist."
	epsilon := sandbox / 'epsilon'.
	self
		should: [epsilon children]
		raise: DirectoryDoesNotExist.

	"Ensure DirectoryRequired is signaled when sent to something that isn't a directory."
	self
		should: [gamma children]
		raise: DirectoryRequired
%

category: 'tests'
method: FileReferenceTest
testChildFiles

	| alpha beta gamma delta epsilon |
	alpha := self createDirectory: 'alpha'.
	beta := self createDirectory: 'beta'.
	gamma := self createFile: 'gamma'.
	delta := self createFile: 'delta'.

	"Ensure sending to a directory returns correct results."
	self
		assert: sandbox files asSet
		equals: {gamma. delta.} asSet.

	"Ensure DirectoryDoesNotExist is signaled when the directory does not exist."
	epsilon := sandbox / 'epsilon'.
	self
		should: [epsilon children]
		raise: DirectoryDoesNotExist.

	"Ensure DirectoryRequired is signaled when sent to something that isn't a directory."
	self
		should: [gamma children]
		raise: DirectoryRequired
%

category: 'tests'
method: FileReferenceTest
testChildren

	| alpha beta gamma epsilon |
	alpha := self createDirectory: 'alpha'.
	beta := self createFile: 'alpha/beta'.
	gamma := self createDirectory: 'alpha/gamma'.
	self createFile: 'alpha/gamma/delta'.

	"Ensure correct set of children is returned."
	self
		assert: alpha children asSet
		equals: { beta. gamma. } asSet.

	"Ensure DirectoryDoesNotExist is signaled when the directory does not exist."
	epsilon := sandbox / 'epsilon'.
	self
		should: [epsilon children]
		raise: DirectoryDoesNotExist.

	"Ensure DirectoryRequired is signaled when sent to something that isn't a directory."
	self
		should: [beta children]
		raise: DirectoryRequired
%

category: 'tests'
method: FileReferenceTest
testCommaAddsExtension

	| justName withExtension doubleExtension |
	justName := sandbox / 'just-name'.
	withExtension := justName , 'extension'.
	doubleExtension := withExtension , 'extension'.
	self
		assert: withExtension basename
		equals: 'just-name.extension'.
	self
		assert: doubleExtension basename
		equals: 'just-name.extension.extension'
%

category: 'tests'
method: FileReferenceTest
testContains

	| alpha beta secondFileSystem secondAlpha locator |
	alpha := self fileSystem root / 'alpha'.
	beta := alpha / 'beta'.
	self
		assert: (alpha contains: beta);
		assert: (alpha contains: beta path);
		deny: (beta contains: alpha);
		deny: (beta contains: alpha path).
	secondFileSystem := FileSystem store: MemoryStore new.
	secondAlpha := secondFileSystem root / 'alpha'.
	self
		deny: (secondAlpha contains: beta);
		assert: (secondAlpha contains: beta path).
	locator := FileLocator workingDirectory.
	self
		assert: (locator resolve parent contains: locator);
		deny: (alpha contains: locator)
%

category: 'tests'
method: FileReferenceTest
testContainsLocator
	| ref |
	ref := FileLocator workingDirectory resolve parent.
	self assert: (ref contains: FileLocator workingDirectory)
%

category: 'tests'
method: FileReferenceTest
testContents

	| contents file |
	contents := 'Hello, Smalltalk!'.
	file := self
		createFile: 'file'
		contents: contents.
	self
		assert: file contents
		equals: contents
%

category: 'tests'
method: FileReferenceTest
testCopyAllTo
	"Ensure #copyAllTo: results in mirroring of directories."

	| source destination |
	self 
		createDirectory: 'alpha';
		createDirectory: 'alpha/beta';
		createFile: 'alpha/theta';
		createFile: 'alpha/beta/gamma';
		createFile: 'alpha/beta/delta';
		createDirectory: 'alpha/epsilon';
		createFile: 'alpha/epsilon/zeta'.
	source := sandbox / 'alpha'.
	destination := sandbox / 'iota'.
	source copyAllTo: destination.
	self
		assert: source isDirectory;
		assert: destination isDirectory;
		assert: (destination / 'beta') isDirectory;
		assert: (destination / 'theta') isFile.
	self
		assert: source allChildren size
		equals: destination allChildren size
%

category: 'tests'
method: FileReferenceTest
testCopyTo

	| src dst |
	src := self
		createFile: 'testCopy-src-file'
		contents: 'This is a file used to test #copyTo:'.
	dst := src parent / 'testCopy-dst-file'.
	self
		assert: src exists;
		deny: dst exists.
	src copyTo: dst.
	self
		assert: src exists;
		assert: dst exists.
	self
		assert: (src binaryReadStreamDo: [:stream | stream contents])
		equals: (dst binaryReadStreamDo: [:stream | stream contents]).
	src delete.
	dst delete.
	src := self createDirectory: 'testCopy-src-directory'.
	dst := src parent / 'testCopy-dst-directory'.
	self
		assert: src exists;
		deny: dst exists.
	src copyTo: dst.
	self
		assert: src exists;
		assert: dst exists;
		assert: dst isDirectory
%

category: 'tests'
method: FileReferenceTest
testCreationTime
	"See subclass implementations if supported."

	self
		should: [sandbox creationTime]
		raise: FileAttributeNotSupported
%

category: 'tests'
method: FileReferenceTest
testDelete

	| file dir dirWithChildren |
	file := self
		createFile: 'testDelete-file'
		contents: 'testDelete file'.
	dir := self createDirectory: 'testDelete-directory'.
	dirWithChildren := self createDirectory: 'testDelete-directory-with-children'.
	self createDirectory: 'testDelete-directory-with-children/child'.
	self
		assert: file exists;
		assert: dir exists;
		deny: dir hasChildren;
		assert: dirWithChildren exists;
		assert: dirWithChildren hasChildren.
	file delete.
	self deny: file exists.
	dir delete.
	self deny: dir exists.
	self
		should: [dirWithChildren delete]
		raise: DirectoryIsNotEmpty.
%

category: 'tests'
method: FileReferenceTest
testDeleteAll
	"Ensure that #delteAll deletes all a folder and all of its transitive contents."

	| alpha beta delta gamma |
	alpha := self createDirectory: 'alpha'.
	beta := self createDirectory: 'alpha/beta'.
	delta := self createDirectory: 'alpha/beta/delta'.
	gamma := self createDirectory: 'alpha/gamma'.
	alpha deleteAll.
	self
		deny: alpha exists;
		deny: beta exists;
		deny: delta exists;
		deny: gamma exists
%

category: 'tests'
method: FileReferenceTest
testDeleteAllChildren
	"Ensure that #delteAllChildren deletes all of its transitive contents but not the folder itself."

	| alpha beta delta gamma |
	alpha := self createDirectory: 'alpha'.
	beta := self createDirectory: 'alpha/beta'.
	delta := self createDirectory: 'alpha/beta/delta'.
	gamma := self createDirectory: 'alpha/gamma'.
	alpha deleteAllChildren.
	self
		assert: alpha exists;
		deny: beta exists;
		deny: delta exists;
		deny: gamma exists
%

category: 'tests'
method: FileReferenceTest
testDeleteIfAbsent

	| wasAbsent alpha |
	wasAbsent := false.
	alpha := self createFile: 'alpha'.
	alpha deleteIfAbsent: [wasAbsent := true].
	self
		deny: wasAbsent;
		deny: alpha exists.
	alpha deleteIfAbsent: [wasAbsent := true].
	self assert: wasAbsent
%

category: 'tests'
method: FileReferenceTest
testDeviceId
	"See subclass implementations if supported."

	self
		should: [sandbox deviceId]
		raise: FileAttributeNotSupported
%

category: 'tests'
method: FileReferenceTest
testDirectoryNames

	| a b directoryNames |
	self
		assert: sandbox directoryNames size
		equals: 0.
	a := self createDirectory: 'a'.
	b := self createDirectory: 'b'.
	directoryNames := sandbox directoryNames.
	self
		assert: directoryNames size
		equals: 2.
	self
		assert: (directoryNames includes: 'a');
		assert: (directoryNames includes: 'b')
%

category: 'tests'
method: FileReferenceTest
testEnsureDelete

	| plonk |
	plonk := self createFile: 'plonk'.
	plonk ensureDelete.
	self deny: plonk exists.
	self
		shouldnt: [plonk ensureDelete]
		raise: Error
%

category: 'tests'
method: FileReferenceTest
testEnsureDeleteAll

	| parent child |
	parent := self createDirectory: 'parent'.
	child := self createFile: 'parent/child'.
	parent ensureDeleteAll.
	self
		deny: parent exists;
		deny: child exists.
	self
		shouldnt: [parent ensureDeleteAll]
		raise: Error
%

category: 'tests'
method: FileReferenceTest
testEnsureDeleteNonEmptyDirectory

	| parent child |
	parent := self createDirectory: 'parent'.
	child := self createFile: 'parent/child'.
	self
		should: [parent ensureDelete]
		raise: DirectoryIsNotEmpty
%

category: 'tests'
method: FileReferenceTest
testEqual

	| alpha alpha2 beta |
	alpha := sandbox / 'alpha'.
	alpha2 := sandbox / 'alpha'.
	beta := alpha / 'beta'.
	self
		deny: alpha
		identicalTo: alpha2.
	self
		assert: alpha
		equals: alpha2.
	self
		deny: alpha
		equals: beta
%

category: 'tests'
method: FileReferenceTest
testEqualityRelativeVsAbsolute

	| f1 f2 |

	f1 := FileLocator workingDirectory / 'pharo-local'.
	f2 := f1 asAbsolute.
	self assert: f1 equals: f2
%

category: 'tests'
method: FileReferenceTest
testExists

	| alpha |
	alpha := sandbox / 'alpha'.
	"Test file"
	self deny: alpha exists.
	alpha createFile.
	self assert: alpha exists.
	alpha delete.
	self deny: alpha exists.
	"Test directory"
	alpha createDirectory.
	self assert: alpha exists.
	alpha delete.
	self deny: alpha exists
%

category: 'tests'
method: FileReferenceTest
testFileNames

	| childA childB fileNames |
	self
		assert: sandbox fileNames size
		equals: 0.
	childA := self createFile: 'childA'.
	childB := self createFile: 'childB'.
	fileNames := sandbox fileNames.
	self
		assert: fileNames size
		equals: 2.
	self
		assert: (fileNames includes: 'childA');
		assert: (fileNames includes: 'childB')
%

category: 'tests'
method: FileReferenceTest
testFileOpeningOptionsClass
	"This test shoud be handled in a subclass"

	self subclassResponsibility
%

category: 'tests'
method: FileReferenceTest
testFullName

	| pathString ref |
	pathString := '/tmp/testFullName'.
	ref := self fileSystem referenceTo: pathString.
	self
		assert: ref fullName
		equals: pathString
%

category: 'tests'
method: FileReferenceTest
testFullPath

	| pathString expectedPath ref |
	pathString := '/tmp/testFullPath'.
	expectedPath := Path from: pathString.
	ref := self fileSystem referenceTo: pathString.
	self
		assert: ref fullPath
		equals: expectedPath
%

category: 'tests'
method: FileReferenceTest
testGid
	"See subclass implementations if supported."

	self
		should: [sandbox gid]
		raise: FileAttributeNotSupported
%

category: 'tests'
method: FileReferenceTest
testHasChildren

	| alpha beta delta gamma |
	alpha := self createDirectory: 'alpha'.
	beta := self createDirectory: 'alpha/beta'.
	delta := self createFile: 'alpha/beta/delta'.
	gamma := self createDirectory: 'alpha/gamma'.
	self
		assert: alpha hasChildren;
		assert: beta hasChildren;
		deny: delta hasChildren;
		deny: gamma hasChildren
%

category: 'tests'
method: FileReferenceTest
testHasDirectories

	| alpha beta delta gamma |
	alpha := self createDirectory: 'alpha'.
	beta := self createDirectory: 'alpha/beta'.
	delta := self createFile: 'alpha/beta/delta'.
	gamma := self createDirectory: 'alpha/gamma'.
	self
		assert: alpha hasDirectories;
		deny: beta hasDirectories;
		deny: delta hasChildren;
		deny: gamma hasChildren
%

category: 'tests'
method: FileReferenceTest
testHasFiles

	| alpha beta delta gamma |
	alpha := self createDirectory: 'alpha'.
	beta := self createDirectory: 'alpha/beta'.
	delta := self createFile: 'alpha/beta/delta'.
	gamma := self createDirectory: 'alpha/gamma'.
	self
		deny: alpha hasFiles;
		assert: beta hasFiles;
		deny: delta hasFiles;
		deny: gamma hasFiles
%

category: 'tests'
method: FileReferenceTest
testHash

	| refA refB |
	refA := sandbox / 'testHash'.
	refB := sandbox / 'testHash'.
	self
		assert: refA hash
		equals: refB hash
%

category: 'tests'
method: FileReferenceTest
testIfExistsIfAbsent

	| marker file result |
	marker := Object new.
	file := sandbox / 'ifExists-ifAbsent'.

	self deny: file exists.
	result := file ifAbsent: [marker].
	self
		assert: result
		equals: marker.
	result := file ifExists: [marker].
	self
		assert: result
		equals: file.
	result := file
		ifExists: [self assert: false]
		ifAbsent: [marker].
	self
		assert: result
		equals: marker.

	file createFile.
	self assert: file exists.
	result := file ifAbsent: [self assert: false].
	self
		assert: result
		equals: file.
	result := file ifExists: [marker].
	self
		assert: result
		equals: marker.
	result := file
		ifExists: [marker]
		ifAbsent: [self assert: false].
	self
		assert: result
		equals: marker
%

category: 'tests'
method: FileReferenceTest
testIndicator

	| referenceToNothing file |
	referenceToNothing := sandbox / 'do-not-create-this-file-or-you-will-break-tests'.
	file := self createFile: 'file'.
	self
		assert: sandbox indicator
		equals: '/'.
	self
		assert: referenceToNothing indicator
		equals: '?'.
	self
		assert: file indicator
		equals: ''
%

category: 'tests'
method: FileReferenceTest
testInode
	"See subclass implementations."

	self
		should: [sandbox inode]
		raise: FileAttributeNotSupported
%

category: 'tests'
method: FileReferenceTest
testIsAbsolute

	self
		assert: (sandbox / 'plonk') isAbsolute;
		deny: (self fileSystem referenceTo: '..') isAbsolute
%

category: 'tests'
method: FileReferenceTest
testIsBlock
	"See subclass implementations."

	self assert: false
%

category: 'tests'
method: FileReferenceTest
testIsCharacter
	"See subclass implementations."

	self assert: false
%

category: 'tests'
method: FileReferenceTest
testIsChildOf

	| alpha beta gamma alphaPath |
	alpha := sandbox / 'alpha'.
	beta := alpha / 'beta'.
	gamma := alpha / 'gamma'.
	alphaPath := alpha path.
	self
		assert: (alpha isChildOf: sandbox);
		deny: (alpha isChildOf: beta);
		assert: (beta isChildOf: alpha);
		deny: (beta isChildOf: sandbox);
		deny: (beta isChildOf: alphaPath);
		deny: (gamma isChildOf: beta);
		deny: (beta isChildOf: gamma)
%

category: 'tests'
method: FileReferenceTest
testIsDirectory

	| doesNotExist file |
	doesNotExist := sandbox / 'do-not-create-or-you-will-break-a-test'.
	file := self createFile: 'file'.
	self
		assert: self fileSystem root isDirectory;
		assert: sandbox isDirectory;
		deny: doesNotExist isDirectory;
		deny: file isDirectory
%

category: 'tests'
method: FileReferenceTest
testIsExecutable
	"See subclass implementations."

	self assert: false
%

category: 'tests'
method: FileReferenceTest
testIsFifo
	"See subclass implementations."

	self assert: false
%

category: 'tests'
method: FileReferenceTest
testIsFile

	| doesNotExist file |
	doesNotExist := sandbox / 'do-not-create-or-you-will-break-a-test'.
	file := self createFile: 'file'.
	self
		deny: self fileSystem root isFile;
		deny: sandbox isFile;
		deny: doesNotExist isFile;
		assert: file isFile
%

category: 'tests'
method: FileReferenceTest
testIsReadable
	"See subclass implementations."

	self assert: false
%

category: 'tests'
method: FileReferenceTest
testIsRegular
	"See subclass implementations."

	self assert: false
%

category: 'tests'
method: FileReferenceTest
testIsRelative

	self
		assert: (self fileSystem referenceTo: '..') isRelative;
		deny: (sandbox / 'plonk') isRelative
%

category: 'tests'
method: FileReferenceTest
testIsRoot

	self
		assert: self fileSystem root isRoot;
		deny: sandbox isRoot
%

category: 'tests'
method: FileReferenceTest
testIsSocket
	"See subclass implementations."

	self assert: false
%

category: 'tests'
method: FileReferenceTest
testIsWritable
	"See subclass implementations."

	self assert: false
%

category: 'tests'
method: FileReferenceTest
testMakeRelative

	| parent child relative |
	parent := sandbox / 'griffle'.
	child := sandbox / 'griffle' / 'plonk' / 'nurb'.
	relative := parent makeRelative: child.
	self assert: relative equals: (Path * 'plonk' / 'nurb')
%

category: 'tests'
method: FileReferenceTest
testModificationTime

	self
		assert: sandbox modificationTime
		isKindOf: DateAndTime
%

category: 'compatibility tests'
method: FileReferenceTest
testNumberOfHardLinks
	"See subclass implementations"

	| file |
	file := self createFile: 'hard-links'.
	self
		should: [file numberOfHardLinks]
		raise: FileAttributeNotSupported
%

category: 'tests'
method: FileReferenceTest
testParent

	| root reference |
	root := self fileSystem root.
	reference := sandbox / 'target'.
	self
		assert: root parent
		equals: root.
	self
		assert: reference parent
		equals: sandbox
%

category: 'tests'
method: FileReferenceTest
testParentUpTo

	| a b c d |
	a := self createDirectory: 'a'.
	b := self createDirectory: 'a/b'.
	c := self createDirectory: 'a/b/c'.
	d := self createFile: 'a/b/c/d'.

	self
		assert: (d parentUpTo: 'a')
		equals: a.
	self
		assert: (b parentUpTo: 'b')
		equals: b.
	self
		assert: (c parentUpTo: 'd')
		equals: self fileSystem root.
%

category: 'tests'
method: FileReferenceTest
testPermissions
	"See subclasses implementations if supported."

	self assert: false
%

category: 'tests'
method: FileReferenceTest
testPosition

	| file binaryStream |
	file := self
		createFile: 'file-size-10'
		contents: '1234567890'.
	binaryStream := file binaryReadStream.
	[binaryStream position: 5.
	self assert: binaryStream next equals: $6 codePoint]
		ensure: [binaryStream close]
%

category: 'tests'
method: FileReferenceTest
testPrintString

	| ref expected |
	ref := FileReference
		fileSystem: self fileSystem
		path: Path / 'absolute' / 'path'.
	expected := 'FileReference ', self fsType, ' @ ''/absolute/path'''.
	self
		assert: ref printString
		equals: expected.

	ref := FileReference
		fileSystem: self fileSystem
		path: Path * 'relative' / 'path'.
	expected := 'FileReference ', self fsType, ' @ ''relative/path'''.
	self
		assert: ref printString
		equals: expected.
%

category: 'tests'
method: FileReferenceTest
testReadStream

	| plonk absent directory |
	plonk := self createFile: 'plonk'.
	plonk readStream
		ifNil: [self assert: false]
		ifNotNil:
			[:stream |
			[self
				assert: stream contents
				equals: self defaultFileContents]
					ensure: [stream close]].
	absent := sandbox / 'absent'.
	self
		should: [absent readStream]
		raise: FileDoesNotExistException.
	directory := self createDirectory: 'directory'.
	self
		should: [directory readStream]
		raise: FileRequired
%

category: 'tests'
method: FileReferenceTest
testReadStreamDo

	| plonk absent directory |
	plonk := self createFile: 'plonk'.
	plonk readStreamDo:
		[:stream |
		self
			assert: stream contents
			equals: self defaultFileContents].
	absent := sandbox / 'absent'.
	self
		should: [absent readStreamDo: [:stream |]]
		raise: FileDoesNotExistException.
	directory := self createDirectory: 'directory'.
	self
		should: [directory readStreamDo: [:stream |]]
		raise: FileRequired
%

category: 'tests'
method: FileReferenceTest
testReadStreamDoIfAbsent

	| plonk doesNotExist result |
	plonk := self createFile: 'plonk'.
	plonk
		readStreamDo:
			[:stream |
			self
				assert: stream contents
				equals: self defaultFileContents]
		ifAbsent: [self assert: false].
	doesNotExist := sandbox / 'does-not-exist'.
	result := doesNotExist
		readStreamDo: [:stream | self assert: false]
		ifAbsent: [#'test-pass-marker'].
	self
		assert: result
		equals: #'test-pass-marker'
%

category: 'tests'
method: FileReferenceTest
testReadStreamIfAbsent

	| plonk absent directory stream executed |
	plonk := self createFile: 'plonk'.
	stream := plonk readStreamIfAbsent: [self assert: false].
	[self
		assert: stream contents
		equals: self defaultFileContents]
			ensure: [stream close].

	absent := sandbox / 'absent'.
	executed := false.
	absent readStreamIfAbsent: [executed := true].
	self assert: executed.

	directory := self createDirectory: 'directory'.
	executed := false.
	directory readStreamIfAbsent: [executed := true].
	self assert: executed
%

category: 'tests'
method: FileReferenceTest
testRelativeTo

	| alpha beta |
	alpha := sandbox / 'alpha'.
	beta := alpha / 'beta'.
	self
		assert: (beta relativeTo: sandbox)
		equals: Path * 'alpha' / 'beta'.
	self
		assert: (beta relativeTo: sandbox path)
		equals: Path * 'alpha' / 'beta'.
	self
		assert: (alpha relativeTo: beta)
		equals: Path * '..'
%

category: 'tests'
method: FileReferenceTest
testRename

	| file alpha beta delta |
	file := self createFile: 'alpha'.
	alpha := sandbox / 'alpha'.
	beta := sandbox / 'beta'.
	delta := self createFile: 'delta'.

	"Valid rename"
	file renameTo: beta basename.
	self
		deny: alpha exists;
		assert: beta exists;
		assert: file exists.
	self
		assert: file basename
		equals: beta basename.

	"Rename to existing file"
	self
		should: [file renameTo: delta basename]
		raise: FileExists
%

category: 'tests'
method: FileReferenceTest
testResolve

	| targetReference absolutePath relativePath absoluteReference relativeReference |
	targetReference := sandbox / 'target'.
	self
		assert: targetReference resolve
		identicalTo: targetReference.
	absolutePath := targetReference absolutePath.
	self
		assert: (sandbox resolve: absolutePath)
		equals: targetReference.
	relativePath := Path * 'target'.
	self
		assert: (sandbox resolve: relativePath)
		equals: targetReference.
	absoluteReference := sandbox / 'target'.
	self
		assert: (sandbox resolve: absoluteReference)
		equals: targetReference.
	relativeReference := self fileSystem referenceTo: relativePath.
	self assert: relativeReference isRelative.
	self
		assert: (sandbox resolve: relativeReference)
		equals: targetReference
%

category: 'tests'
method: FileReferenceTest
testSetAsWorkingDirectory
	"See subclass implementations for supported filesystems"

	self
		should: [sandbox setAsWorkingDirectory]
		raise: FileAttributeNotSupported
%

category: 'tests'
method: FileReferenceTest
testSize

	| file0 file10 |
	file0 := self
		createFile: 'file-size-0'
		contents: ''.
	file10 := self
		createFile: 'file-size-10'
		contents: '1234567890'.
	self
		assert: file0 size
		equals: 0.
	self
		assert: file10 size
		equals: 10
%

category: 'tests'
method: FileReferenceTest
testSlash

	| alpha |
	alpha := sandbox / 'alpha'.
	self
		assert: alpha parent
		equals: sandbox.
	self
		assert: sandbox / ''
		equals: sandbox
%

category: 'compatibility tests'
method: FileReferenceTest
testSymlinkTo
	"Test creating symlinks."
	"Not all FileSystems support symlinks.
	By default we should ensure attempts to create
	symlinks signal an error."

	| target symlink |
	"Existing file"
	target := self
		createFile: 'testSymlinkTo-file'
		contents: 'this is a file'.
	symlink := sandbox / 'testSymlinkTo-file-symlink'.
	self
		should: [symlink symlinkTo: target]
		raise: Error.

	"Existing directory"
	target := self createDirectory: 'testSymlinkTo-directory'.
	symlink := sandbox / 'testSymlinkTo-directory-symlink'.
	self
		should: [symlink symlinkTo: target]
		raise: Error.

	"Target which does not exist."
	target := sandbox / 'creating' / 'this' / 'will' / 'break' / 'testSymlinkTo'.
	symlink := sandbox / 'dne-symlink'.
	self
		should: [symlink symlinkTo: target]
		raise: Error.

	"Ensure an appropropriate error if the symlink location has already exists."
	target := self
		createFile: 'testSymlinkTo-symlink-reference-already-exists'
		contents: 'The symlink reference will already exist'.
	symlink := self
		createFile: 'testSymlinkTo-symlink'
		contents: 'This is already a file.'.
	self
		should: [symlink symlinkTo: target]
		raise: Error
%

category: 'compatibility tests'
method: FileReferenceTest
testTargetPath
	"See subclass implementations"

	| file |
	file := self createFile: 'target-path'.
	self
		should: [file targetPath]
		raise: FileAttributeNotSupported
%

category: 'tests'
method: FileReferenceTest
testTempFilePrefixSuffix
	| fileRef |
	fileRef := FileReference newTempFilePrefix: 'FileReference' suffix: 'Test'.
	self assert: (fileRef isKindOf: FileReference).
	self assert: fileRef exists not.
%

category: 'tests'
method: FileReferenceTest
testUid
	"See subclass implementations if supported."

	self
		should: [sandbox uid]
		raise: FileAttributeNotSupported
%

category: 'tests'
method: FileReferenceTest
testUnicodeFilenames
	"Test various unicode file names"

	| names |
	names := {
		'file'.
		(Character codePoint: 16r263A) asString.
		(Character codePoint: 16r1F600) asString.
	}.
	String isInUnicodeComparisonMode
		ifTrue:
			[names
				add: 'file' asUnicodeString;
				add: (Character codePoint: 16r263A) asUnicodeString;
				add: (Character codePoint: 16r1F600) asUnicodeString].
	names
		do:
			[:name | | ref |
			ref := self
				createFile: name
				contents: name.
			self
				assert: ref exists;
				assert: (sandbox files includes: ref).
			self
				assert: ref basename
				equals: name.
			self
				assert: ref contents
				equals: name.
			ref delete]
%

category: 'tests'
method: FileReferenceTest
testUpToAll

	| testString fileRef |
	testString := 'ße'.
	fileRef := FileReference newTempFilePrefix: 'FileReference' suffix: 'Test'.
	[fileRef
		writeStreamEncoded: 'utf8'
		do: [:stream | stream nextPutAll: testString].
	fileRef readStreamDo: [:stream | self assert: (stream upToAll: 'e') equals: 'ß']]
		ensure: [fileRef ensureDelete]
%

category: 'tests'
method: FileReferenceTest
testWithExtension

	| name withExtension replacedExtension |
	name := sandbox / 'name'.
	withExtension := name withExtension: 'extension'.
	replacedExtension := withExtension withExtension: 'replaced'.
	self
		assert: withExtension
		equals: sandbox / 'name.extension'.
	self
		assert: replacedExtension
		equals: sandbox / 'name.replaced'
%

category: 'tests'
method: FileReferenceTest
testWithoutExtension

	| reference |
	reference := sandbox / 'alpha.beta.gamma'.
	reference := reference withoutExtension.
	self
		assert: reference
		equals: sandbox / 'alpha.beta'.
	reference := reference withoutExtension.
	self
		assert: reference
		equals: sandbox / 'alpha'.
	reference := reference withoutExtension.
	self
		assert: reference
		equals: sandbox / 'alpha'
%

category: 'tests'
method: FileReferenceTest
testWorkingDirectoryParent

	| wd  parent |
	wd := self fileSystem referenceTo: Path workingDirectory.
	parent := wd parent.
	self
		assert: parent
		equals: (self fileSystem referenceTo: Path * '..')
%

category: 'tests'
method: FileReferenceTest
testWriteStream
	"See subclass implementations. Semantics differ between Disk and Memory variants in Pharo."

	self assert: false
%

category: 'tests'
method: FileReferenceTest
testWriteStreamDo

	| file directory |
	file := sandbox / 'file'.
	directory := self createDirectory: 'directory'.

	"Ensure file is created by #writeStreamDo:."
	file writeStreamDo: [:stream | stream nextPutAll: 'abcdef'].
	self assert: file isFile.
	self
		assert: file contents
		equals: 'abcdef'.

	"Ensure #writeStreamDo: send to a directory raises an exception."
	self
		should: [directory writeStreamDo: [:stream | ]]
		raise: FileRequired
%

category: 'tests'
method: FileReferenceTest
testWriteStreamTruncate
	"Ensure truncating a stream removes all contents."

	| file |
	file := self
		createFile: '', self class name, '>>#testTruncatedStream'
		contents: ''.
	file writeStreamDo: [:stream | stream truncate].
	self
		assert: file contents
		equals: ''.
	file writeStreamDo: [:stream | stream nextPutAll: 'hello'; flush; truncate].
	self
		assert: file contents
		equals: ''
%

! Class implementation for 'FsDiskFileReferenceTest'

!		Instance methods for 'FsDiskFileReferenceTest'

category: 'utilities'
method: FsDiskFileReferenceTest
blockDeviceReference
	"Return a reference to a block device."

	| devices |
	devices := #( '/dev/sda' '/dev/disk0' '/dev/nvme0' '/dev/mmcblk0' '/dev/loop0' '/dev/vda' ) collect: [:each | self fileSystem referenceTo: each].
	^devices detect: [:each | each exists] ifNone: [self assert: false]
%

category: 'utilities'
method: FsDiskFileReferenceTest
characterDeviceReference
	"Return a reference to a block device."

	^self fileSystem referenceTo: '/dev/null'
%

category: 'running'
method: FsDiskFileReferenceTest
setUp

	| fileSystem |
	super setUp.
	fileSystem := FileSystem disk.
	sandbox := FileLocator workingDirectory asFileReference / self sandboxName.
	self
		assert: sandbox fileSystem
		equals: fileSystem.
	self deny: sandbox exists.
	sandbox createDirectory
%

category: 'running'
method: FsDiskFileReferenceTest
tearDown

	sandbox deleteAll.
	super tearDown
%

category: 'tests'
method: FsDiskFileReferenceTest
testAccessTime

	self
		assert: sandbox accessTime
		isKindOf: DateAndTime
%

category: 'tests'
method: FsDiskFileReferenceTest
testBinaryWriteStream

	| file directory stream |
	file := sandbox / 'file'.
	directory := self createDirectory: 'directory'.

	"Ensure file is created by #binaryWriteStream."
	stream := file binaryWriteStream.
	stream
		nextPutAll: #[72 101 108 108 111 44 32 70 105 108 101 83 121 115 116 101 109 33];
		flush;
		close.
	self assert: file isFile.
	self
		assert: file contents
		equals: 'Hello, FileSystem!'.

	"Ensure #writeStream begins at start of file and truncates the file."
	stream := file binaryWriteStream.
	stream
		nextPutAll: #[65 66 67];
		flush;
		close.
	self
		assert: file contents
		equals: 'ABClo, FileSystem!'.

	"Ensure #writeStream send to a directory raises an exception."
	self
		should: [directory writeStream]
		raise: FileRequired
%

category: 'tests'
method: FsDiskFileReferenceTest
testCreateDirectoryInReadOnlyDirectory

	| readOnlyDirectory targetDirectory |
	readOnlyDirectory := self createDirectory: 'read-only'.
	targetDirectory := readOnlyDirectory / 'target'.
	readOnlyDirectory permissions: (FileSystemPermission posixPermissions: 8r555).
	self
		should: [targetDirectory createDirectory]
		raise: FilePermissionDenied.
	readOnlyDirectory delete
%

category: 'tests'
method: FsDiskFileReferenceTest
testDeviceId

	self
		assert: sandbox deviceId
		isKindOf: Integer
%

category: 'tests'
method: FsDiskFileReferenceTest
testEnsureDeleteAllDoesNotFollowSymlinks
	"sandbox
		|_targetDirectory
			|_someFile
		|_someDirectory
			|_symlink
	Ensure that when another-directory is send #ensureDeleteAll,
	symlink is deleted. In the process, ensure it does not delete
	symlink-target-directory or some-file."

	| targetDirectory someFile someDirectory symlink |
	targetDirectory := self createDirectory: 'targetDirectory'.
	someFile := self
		createFile: 'targetDirectory/someFile'
		contents: 'someFile contents'.
	someDirectory := self createDirectory: 'someDirectory'.
	symlink := someDirectory / 'symlink'.
	symlink symlinkTo: targetDirectory.
	self
		assert: targetDirectory exists;
		assert: someFile exists;
		assert: someDirectory exists;
		assert: symlink exists.
	someDirectory ensureDeleteAll.
	self
		assert: targetDirectory exists;
		assert: someFile exists;
		deny: someDirectory exists;
		deny: symlink exists.
%

category: 'tests'
method: FsDiskFileReferenceTest
testEnsureSymlinksAreReturnedFromDirectories
	"This test ensures that when a parent directory returns its
	list of directories, the result includes the set of symlinks
	in the directory which refer to directories."

	| targetDirectory symlink directories |
	targetDirectory := sandbox / 'target-directory'.
	targetDirectory ensureCreateDirectory.
	symlink := sandbox / 'symlink'.
	symlink symlinkTo: targetDirectory.
	directories := sandbox directories.
	self
		assert: directories
		includes: targetDirectory.
	self
		assert: directories
		includes: symlink
%

category: 'tests'
method: FsDiskFileReferenceTest
testEnsureSymlinksAreReturnedFromFiles
	"This test ensures that when a parent directory returns its
	list of files, the result includes the set of symlinks in the
	directory which refer to files."

	| targetFile symlink files |
	targetFile := sandbox / 'target-file'.
	targetFile ensureCreateDirectory.
	symlink := sandbox / 'symlink'.
	symlink symlinkTo: targetFile.
	files := sandbox directories.
	self
		assert: files
		includes: targetFile.
	self
		assert: files
		includes: symlink
%

category: 'tests'
method: FsDiskFileReferenceTest
testFileOpeningOptionsClass
	"This test shoud be handled in a subclass"

	| theClass |
	theClass := sandbox fileOpeningOptionsClass.
	self assert: ({FsFileOpeningOptions_Linux_aarch64. FsFileOpeningOptions_Linux_x64. FsFileOpeningOptions_macOS} includes: theClass)
%

category: 'tests'
method: FsDiskFileReferenceTest
testGid

	self
		assert: sandbox gid
		isKindOf: Integer
%

category: 'tests'
method: FsDiskFileReferenceTest
testInode

	self
		assert: sandbox inode
		isKindOf: Integer
%

category: 'tests'
method: FsDiskFileReferenceTest
testIsBlock
	"Several potential block devices are searched to find one.
	It is possble the test could fail because one of these block devices is not available."

	self
		assert: self blockDeviceReference isBlock;
		deny: self characterDeviceReference isBlock;
		deny: ((self createFile: 'not-block') isBlock);
		deny: sandbox isBlock
%

category: 'tests'
method: FsDiskFileReferenceTest
testIsCharacter
	"/dev/null should be on every supported system."

	self
		deny: self blockDeviceReference isCharacter;
		assert: self characterDeviceReference isCharacter;
		deny: ((self createFile: 'not-character') isCharacter);
		deny: sandbox isCharacter
%

category: 'tests'
method: FsDiskFileReferenceTest
testIsExecutable
	"I expect /usr/bin/env to be on every system we support.
	Even non-FHS linux distros like NixOS have this file."

	| exe file |
	exe := self fileSystem referenceTo: '/usr/bin/env'.
	file := self createFile: 'not-executable'.
	self
		assert: exe isExecutable;
		deny: file isExecutable;
		assert: sandbox isExecutable
%

category: 'tests'
method: FsDiskFileReferenceTest
testIsFifo
	"I don't know of a good way to test the positive case.
	I just test the negative cases here."

	self
		deny: self blockDeviceReference isFifo;
		deny: self characterDeviceReference isFifo;
		deny: ((self createFile: 'not-fifo') isFifo);
		deny: sandbox isFifo
%

category: 'tests'
method: FsDiskFileReferenceTest
testIsReadable
	"Ensure #isReadable returns correct results"

	| file permissions |
	file := self
		createFile: 'testIsReadable'
		contents: 'Permissions are tricky.'.
	self assert: file isReadable.

	permissions := FileSystemPermission posixPermissions: 8r000.
	file permissions: permissions.
	self deny: file isReadable.

	permissions := FileSystemPermission posixPermissions: 8r600.
	file permissions: permissions.
	file delete
%

category: 'tests'
method: FsDiskFileReferenceTest
testIsRegular
	"See subclass implementations."

	self
		assert: ((self createFile: 'regular-file') isRegular);
		deny: sandbox isRegular;
		deny: self blockDeviceReference isRegular;
		deny: self characterDeviceReference isRegular
%

category: 'tests'
method: FsDiskFileReferenceTest
testIsSocket
	"I don't know of a good way to test the positive case.
	I just test the negative cases here."

	self
		deny: self blockDeviceReference isSocket;
		deny: self characterDeviceReference isSocket;
		deny: ((self createFile: 'not-fifo') isSocket);
		deny: sandbox isSocket
%

category: 'tests'
method: FsDiskFileReferenceTest
testIsWritable
	"Ensure #isWritable returns correct results"

	| file permissions |
	file := self
		createFile: 'testIsWriteable'
		contents: 'Permissions are tricky.'.
	self assert: file isWritable.

	permissions := FileSystemPermission posixPermissions: 8r000.
	file permissions: permissions.
	self deny: file isWritable.

	permissions := FileSystemPermission posixPermissions: 8r600.
	file permissions: permissions.
	file delete
%

category: 'compatibility tests'
method: FsDiskFileReferenceTest
testNumberOfHardLinks
	"See subclass implementations"

	| file |
	file := self createFile: 'hard-links'.
	self
		assert: file numberOfHardLinks
		equals: 1
%

category: 'tests'
method: FsDiskFileReferenceTest
testPermissions
	"See subclasses implementations if supported."

	| rw rwe original |
	rw := FileSystemPermission posixPermissions: 8r666.
	rwe := FileSystemPermission posixPermissions: 8r777.
	original := sandbox permissions.
	self
		assert: original
		isKindOf: FileSystemPermission.
	sandbox permissions: rw.
	self
		assert: sandbox permissions
		equals: rw.
	sandbox permissions: rwe.
	self
		assert: sandbox permissions
		equals: rwe.
	sandbox permissions: original
%

category: 'tests'
method: FsDiskFileReferenceTest
testSetAsWorkingDirectory

	| diskStore initialWD targetWD file |
	diskStore := FileSystem disk.
	initialWD := diskStore workingDirectory.
	targetWD := sandbox.
	self
		assert: targetWD
		isKindOf: FileReference.
	self
		deny: initialWD
		equals: targetWD.
	[targetWD setAsWorkingDirectory.
	self
		assert: diskStore workingDirectory
		equals: targetWD]
		ensure: [initialWD setAsWorkingDirectory].
	file := self createFile: 'hello-world'.
	self
		should: [file setAsWorkingDirectory]
		raise: DirectoryRequired.
	self
		should: [self characterDeviceReference setAsWorkingDirectory]
		raise: DirectoryRequired.
	self
		should: ['/does/not/exist' asFileReference setAsWorkingDirectory]
		raise: DirectoryDoesNotExist
%

category: 'compatibility tests'
method: FsDiskFileReferenceTest
testSymlinkTo
	"Test creating symlinks."
	"Not all FileSystems support symlinks.
	By default we should ensure attempts to create
	symlinks signal an error."

	| target symlink |
	"Existing file"
	target := self
		createFile: 'testSymlinkTo-file'
		contents: 'this is a file'.
	symlink := sandbox / 'testSymlinkTo-file-symlink'.
	symlink symlinkTo: target.
	self assert: symlink isSymlink.
	self assert: symlink isFile.
	self deny: symlink isDirectory.
	self
		assert: target contents
		equals: symlink contents.

	"Existing directory"
	target := self createDirectory: 'testSymlinkTo-directory'.
	symlink := sandbox / 'testSymlinkTo-directory-symlink'.
	symlink symlinkTo: target.
	self assert: symlink isSymlink.
	self deny: symlink isFile.
	self assert: symlink isDirectory.

	"Target which does not exist."
	target := sandbox / 'creating' / 'this' / 'will' / 'break' / 'testSymlinkTo'.
	symlink := sandbox / 'dne-symlink'.
	symlink symlinkTo: target.
	self assert: symlink isSymlink.
	self deny: symlink isFile.
	self deny: symlink isDirectory.

	"Ensure an appropropriate error if the symlink location has already exists."
	target := self
		createFile: 'testSymlinkTo-symlink-reference-already-exists'
		contents: 'The symlink reference will already exist'.
	symlink := self
		createFile: 'testSymlinkTo-symlink'
		contents: 'This is already a file.'.
	self
		should: [symlink symlinkTo: target]
		raise: FileExists
%

category: 'tests'
method: FsDiskFileReferenceTest
testUid

	self
		assert: sandbox uid
		isKindOf: Integer
%

category: 'tests'
method: FsDiskFileReferenceTest
testWriteStream

	| file directory stream |
	file := sandbox / 'file'.
	directory := self createDirectory: 'directory'.

	"Ensure file is created by #writeStream."
	stream := file writeStream.
	stream
		nextPutAll: 'abcdef';
		flush;
		close.
	self assert: file isFile.
	self
		assert: file contents
		equals: 'abcdef'.

	"Ensure #writeStream begins at start of file."
	"Should the following fails in against the memory file system.
	Should we ensure this behaves the same in all file systems?"
	stream := file writeStream.
	stream
		nextPutAll: '123';
		flush;
		close.
	self
		assert: file contents
		equals: '123def'.

	"Ensure #writeStream send to a directory raises an exception."
	self
		should: [directory writeStream]
		raise: FileRequired
%

! Class implementation for 'FsMemoryFileReferenceTest'

!		Instance methods for 'FsMemoryFileReferenceTest'

category: 'running'
method: FsMemoryFileReferenceTest
setUp

	super setUp.
	sandbox := FileSystem memory root / self sandboxName.
	self deny: sandbox exists.
	sandbox createDirectory
%

category: 'running'
method: FsMemoryFileReferenceTest
tearDown

	sandbox deleteAll.
	super tearDown
%

category: 'tests'
method: FsMemoryFileReferenceTest
testBinaryWriteStream

	| file directory stream |
	file := sandbox / 'file'.
	directory := self createDirectory: 'directory'.

	"Ensure file is created by #binaryWriteStream."
	stream := file binaryWriteStream.
	stream
		nextPutAll: #[72 101 108 108 111 44 32 70 105 108 101 83 121 115 116 101 109 33];
		flush;
		close.
	self assert: file isFile.
	self
		assert: file contents
		equals: 'Hello, FileSystem!'.

	"Ensure #writeStream begins at start of file and truncates the file."
	stream := file binaryWriteStream.
	stream
		nextPutAll: #[65 66 67];
		flush;
		close.
	self
		assert: file contents
		equals: 'ABC'.

	"Ensure #writeStream send to a directory raises an exception."
	self
		should: [directory writeStream]
		raise: FileRequired
%

category: 'tests'
method: FsMemoryFileReferenceTest
testCreationTime

		self
		assert: sandbox creationTime
		isKindOf: DateAndTime
%

category: 'tests'
method: FsMemoryFileReferenceTest
testFileOpeningOptionsClass
	"This test shoud be handled in a subclass"

	self
		assert: sandbox fileOpeningOptionsClass
		equals: FsMemoryFileOpeningOptions
%

category: 'tests'
method: FsMemoryFileReferenceTest
testIsBlock
	"Block devices unsupported"

	self
		deny: sandbox isBlock;
		deny: (self createFile: 'not-block') isBlock
%

category: 'tests'
method: FsMemoryFileReferenceTest
testIsCharacter
	"No support."


	self
		deny: sandbox isCharacter;
		deny: (self createFile: 'not-character') isCharacter
%

category: 'tests'
method: FsMemoryFileReferenceTest
testIsExecutable
	"Directories are executable but files are not."

	self
		assert: sandbox isExecutable;
		deny: (self createFile: 'not-executable') isExecutable
%

category: 'tests'
method: FsMemoryFileReferenceTest
testIsFifo
	"Fifo files unsupported"

	self
		deny: sandbox isFifo;
		deny: (self createFile: 'not-fifo') isBlock
%

category: 'tests'
method: FsMemoryFileReferenceTest
testIsReadable
	"Ensure #isReadable returns correct results"

	| file |
	file := self
		createFile: 'testIsReadable'
		contents: 'Permissions are tricky.'.
	self assert: file isReadable
%

category: 'tests'
method: FsMemoryFileReferenceTest
testIsRegular

	self
		deny: sandbox isRegular;
		assert: (self createFile: 'regular-file') isRegular
%

category: 'tests'
method: FsMemoryFileReferenceTest
testIsSocket
	"Socket files unsupported"

	self
		deny: sandbox isSocket;
		deny: (self createFile: 'not-socket') isSocket
%

category: 'tests'
method: FsMemoryFileReferenceTest
testIsWritable
	"Ensure #isWritable returns correct results"

	| file |
	file := self
		createFile: 'testIsWriteable'
		contents: 'Permissions are tricky.'.
	self assert: file isWritable
%

category: 'tests'
method: FsMemoryFileReferenceTest
testPermissions
	"See subclasses implementations if supported."

	self
		assert: sandbox permissions
		isKindOf: FileSystemPermission.
	self
		should: [sandbox permissions: (FileSystemPermission posixPermissions: 8r777)]
		raise: FileAttributeNotSupported
%

category: 'tests'
method: FsMemoryFileReferenceTest
testWriteStream

	| file directory stream |
	file := sandbox / 'file'.
	directory := self createDirectory: 'directory'.

	"Ensure file is created by #writeStream."
	stream := file writeStream.
	stream
		nextPutAll: 'abcdef';
		flush;
		close.
	self assert: file isFile.
	self
		assert: file contents
		equals: 'abcdef'.

	"Ensure #writeStream begins at start of file."
	"Should the following fails in against the memory file system.
	Should we ensure this behaves the same in all file systems?"
	stream := file writeStream.
	stream
		nextPutAll: '123';
		flush;
		close.
	self
		assert: file contents
		equals: '123'.

	"Ensure #writeStream send to a directory raises an exception."
	self
		should: [directory writeStream]
		raise: FileRequired
%

! Class implementation for 'FileSystemHandleTest'

!		Class methods for 'FileSystemHandleTest'

category: 'testing'
classmethod: FileSystemHandleTest
isAbstract
	^ self name = #FileSystemHandleTest
%

category: 'testing'
classmethod: FileSystemHandleTest
shouldInheritSelectors 
	^ true
%

!		Instance methods for 'FileSystemHandleTest'

category: 'running'
method: FileSystemHandleTest
createFileSystem
	self subclassResponsibility 
%

category: 'running'
method: FileSystemHandleTest
setUp
	super setUp.
	filesystem := self createFileSystem.
	reference := filesystem * 'plonk'.
	handle := reference openWritable: true
%

category: 'running'
method: FileSystemHandleTest
tearDown
	handle ensureClosed.
	reference ensureDelete.
	super tearDown
%

category: 'tests'
method: FileSystemHandleTest
testAt
	handle at: 1 write: (ByteArray with: 3) startingAt: 1 count: 1.
	self assert: (handle at: 1) = 3
%

category: 'tests'
method: FileSystemHandleTest
testAtPut
	| in |
	handle at: 1 put: 3.
	in := ByteArray new: 1.
	handle at: 1 read: in startingAt: 1 count: 1.
	self assert: in first = 3
%

category: 'tests'
method: FileSystemHandleTest
testAtPutBinaryAscii
	handle at: 1 put: 32.
	handle at: 1 put: Character space
%

category: 'tests'
method: FileSystemHandleTest
testAtWriteBinaryAscii
	handle
		at: 1
		write: #[32]
		startingAt: 1
		count: 1.
	handle
		at: 1
		write: (String with: Character space)
		startingAt: 1
		count: 1
%

category: 'tests'
method: FileSystemHandleTest
testClose
	handle close.
	self deny: handle isOpen
	
%

category: 'tests'
method: FileSystemHandleTest
testCreatedOpen
	
	self assert: handle isOpen
%

category: 'tests'
method: FileSystemHandleTest
testEnsureClosed
	handle ensureClosed.
	self deny: handle isOpen.
	handle ensureClosed.
	reference ensureDelete.
	handle reference exists
		ifTrue: [ self error ].
	handle ensureClosed
%

category: 'tests'
method: FileSystemHandleTest
testIO
	| out in |
	out := #(1 2 3) asByteArray.
	in := ByteArray new: 3.
	handle at: 1 write: out startingAt: 1 count: 3.
	handle at: 1 read: in startingAt: 1 count: 3.
	self assert: out = in.
%

category: 'tests'
method: FileSystemHandleTest
testReadBufferTooLarge
	| out in result |
	out := #(1 2 3) asByteArray.
	in := ByteArray new: 5.
	in atAllPut: 9.
	handle at: 1 write: out startingAt: 1 count: 3.
	result := handle at: 1 read: in startingAt: 2 count: 4.
	self assert: result = 3.
	self assert: in = #(9 1 2 3 9) asByteArray.
%

category: 'tests'
method: FileSystemHandleTest
testReadOnly
	handle close.
	handle := reference openWritable: false.
	self 
		should: 
			[ handle 
				at: 1
				write: #(1 2 3 )
				startingAt: 1
				count: 3 ]
		raise: Error
%

category: 'tests'
method: FileSystemHandleTest
testReference
	self assert: handle reference = reference asAbsolute
%

category: 'tests'
method: FileSystemHandleTest
testSizeAfterGrow
	| out |
	out := #(1 2 3) asByteArray.
	handle at: 1 write: out startingAt: 1 count: 3.
	self assert: handle size = 3
%

category: 'tests'
method: FileSystemHandleTest
testSizeNoGrow
	| bytes |
	bytes := #(1 2 3 4) asByteArray.
	handle at: 1 write: bytes startingAt: 1 count: 3.
	handle at: 4 write: bytes startingAt: 4 count: 1.
	self assert: handle size = 4
%

category: 'tests'
method: FileSystemHandleTest
testTruncate
	| out |
	out := #(1 2 3 4 5) asByteArray.
	handle at: 1 write: out startingAt: 1 count: 5.
	handle truncateTo: 3.
	self assert: handle size = 3
%

category: 'tests'
method: FileSystemHandleTest
testWriteStream
	| stream |
	stream := handle binaryWriteStream.
	self assert: (stream respondsTo: #nextPut:)
%

! Class implementation for 'MemoryHandleTest'

!		Instance methods for 'MemoryHandleTest'

category: 'running'
method: MemoryHandleTest
createFileSystem
	^ FileSystem memory
%

! Class implementation for 'FileSystemResolverTest'

!		Class methods for 'FileSystemResolverTest'

category: 'testing'
classmethod: FileSystemResolverTest
isAbstract
	^ self name = #FileSystemResolverTest
%

!		Instance methods for 'FileSystemResolverTest'

category: 'asserting'
method: FileSystemResolverTest
assertOriginResolves: aSymbol
	| reference |
	reference := resolver resolve: aSymbol.
	self assert: (reference isKindOf: FileReference).
	self assert: reference exists.
	self assert: reference isAbsolute.
	^ reference
%

category: 'running'
method: FileSystemResolverTest
createResolver
	self subclassResponsibility 
%

category: 'asserting'
method: FileSystemResolverTest
denyOriginResolves: aSymbol

	| reference |
	reference := resolver resolve: aSymbol.
	self
		assert: reference
		equals: nil
%

category: 'running'
method: FileSystemResolverTest
setUp
	super setUp.
	resolver := self createResolver.
%

! Class implementation for 'EnvironmentResolverTest'

!		Instance methods for 'EnvironmentResolverTest'

category: 'utilities'
method: EnvironmentResolverTest
createResolver

	^EnvironmentResolver new
%

category: 'accessing'
method: EnvironmentResolverTest
envVarName

	^'GS_ERT_TEST_VALUE'
%

category: 'running'
method: EnvironmentResolverTest
tearDown

	System
		gemEnvironmentVariable: self envVarName
		put: nil.
	super tearDown
%

category: 'running'
method: EnvironmentResolverTest
testEnvironmentPath

	| evName evValue |
	evName := 'GS_ERT_TEST_VARIABLE'.
	evValue := '/'.
	self denyOriginResolves: self envVarName.
	System
		gemEnvironmentVariable: self envVarName
		put: evValue.
	self assertOriginResolves: self envVarName
%

! Class implementation for 'PlatformResolverTest'

!		Instance methods for 'PlatformResolverTest'

category: 'running'
method: PlatformResolverTest
createResolver

	^PlatformResolver forCurrentPlatform
%

category: 'tests'
method: PlatformResolverTest
testCache
	| cache |
	cache := self assertOriginResolves: #cache
%

category: 'tests'
method: PlatformResolverTest
testCorrectClass

	| expectedClass |
	expectedClass := (System gemVersionAt: 'osName') = 'Darwin'
		ifTrue: [MacOSResolver]
		ifFalse: [UnixResolver].
	self
		assert: resolver class
		equals: expectedClass
%

category: 'tests'
method: PlatformResolverTest
testHome
	| home |
	home := self assertOriginResolves: #home.
	self assert: home isDirectory
%

! Class implementation for 'SystemResolverTest'

!		Instance methods for 'SystemResolverTest'

category: 'running'
method: SystemResolverTest
createResolver
	^ SystemResolver new
%

category: 'testing'
method: SystemResolverTest
testExtent1
	self assertOriginResolves: #extent1
%

category: 'testing'
method: SystemResolverTest
testExtent1Directory
	self assertOriginResolves: #extent1Directory
%

category: 'testing'
method: SystemResolverTest
testTranlog
  GsSession isSolo ifFalse:[
     self assertOriginResolves: #tranlog
  ]
 
%

! Class implementation for 'FileSystemTest'

!		Class methods for 'FileSystemTest'

category: 'accessing'
classmethod: FileSystemTest
defaultTimeLimit
	^10 seconds
%

category: 'testing'
classmethod: FileSystemTest
isAbstract
	^ self name = #FileSystemTest
%

category: 'accessing'
classmethod: FileSystemTest
packageNamesUnderTest
	^ #('FileSystem')
%

category: 'testing'
classmethod: FileSystemTest
shouldInheritSelectors
	^ true
	
%

!		Instance methods for 'FileSystemTest'

category: 'initialize-release'
method: FileSystemTest
createFileSystem
	self subclassResponsibility 
%

category: 'initialize-release'
method: FileSystemTest
markForCleanup: anObject
	toDelete add: (filesystem resolve: anObject)
%

category: 'running'
method: FileSystemTest
setUp
	super setUp.
	filesystem := self createFileSystem.
	toDelete := OrderedCollection new.
%

category: 'running'
method: FileSystemTest
tearDown
	toDelete
		select: [ :path | filesystem exists: path ]
		thenDo: [ :path | filesystem delete: path ].
	super tearDown	
%

category: 'tests'
method: FileSystemTest
testChildrenSortingRoot
	| directory1 directory2 |
	"self skip."
	
	directory1 := Path * 'plonk1'.
	directory2 := Path * 'plonk2'.
	
	filesystem createDirectory: directory1.
	filesystem createDirectory: directory2.
	
	self markForCleanup: directory1.
	self markForCleanup: directory2.
	
	self assert: filesystem workingDirectory children sort size = filesystem workingDirectory children size
%

category: 'tests'
method: FileSystemTest
testCopy
	| out in contents |
	
	self
		markForCleanup: 'gooly';
		markForCleanup: 'plonk'.
		
	out := (filesystem workingDirectory / 'gooly') writeStream.
	[ out nextPutAll: 'gooly' ] ensure: [ out close ].
	filesystem copy: 'gooly' to: 'plonk'.
	
	in := (filesystem workingDirectory / 'plonk') readStream.
	contents := [ in contents asString ] ensure: [ in close ].
	self assert: contents equals: 'gooly'
%

category: 'tests'
method: FileSystemTest
testCopyAndDelete
	"Check that FileSystem>>copyAndDelete:to: works within a filesystem.
	DiskFileSystemTest>>testMoveMemoryToDisk checks that #copyAndDelete:to: works across filesystems."
	| folder testString f1 f1s f2 |
	
	folder := filesystem workingDirectory.
	testString := 'To be copied and deleted'.

	f1 := folder / 'f1'.
	f1s := f1 writeStream.
	[ f1s nextPutAll: testString ] ensure: [ f1s close ].
	f2 := folder / 'f2'.
	
	"Cleanup after running"
	self 
		markForCleanup: f1;
		markForCleanup: f2.	
	
	filesystem copyAndDelete: f1 to: f2.
	self deny: f1 exists.
	self assert: f2 exists.
	self assert: f2 contents equals: testString.
%

category: 'tests'
method: FileSystemTest
testCopyDestExists
	| out |
	
	self 
		markForCleanup: 'gooly'; 
		markForCleanup: 'plonk'.
		
	out := (filesystem  workingDirectory / 'gooly') writeStream.
	[out nextPutAll: 'gooly'] ensure: [out close].

	(filesystem  workingDirectory / 'plonk') writeStream close.
	
	self 
		should: [filesystem copy: 'gooly' to: 'plonk']
		raise: FileExists
%

category: 'tests'
method: FileSystemTest
testCopySourceDoesntExist
	self 
		should: [filesystem copy: 'plonk' to: 'griffle']
		raise: FileDoesNotExistException
%

category: 'tests'
method: FileSystemTest
testCopyWithCorrectBasename
        | directory |
        self
                markForCleanup: 'gooly';
                markForCleanup: 'plonk'.
        directory := filesystem workingDirectory.
        (directory / 'gooly') ensureCreateFile.
        directory / 'gooly' copyTo: directory / 'plonk'.
        self assert: (directory / 'plonk') exists.
        self assert: (directory childNames includes: 'plonk')
%

category: 'tests'
method: FileSystemTest
testCreateDirectory
	| path directory |
	directory := filesystem workingDirectory.
 	self markForCleanup: directory / 'plonk' / 'griffle'.
	self markForCleanup: directory / 'plonk'.
	path := directory / 'plonk' / 'griffle'.
	(directory / 'plonk') ensureCreateDirectory.
	self shouldnt: [path createDirectory] raise:Error.
	self assert: path exists.
	(directory / 'plonk' ) deleteAll.
%

category: 'tests'
method: FileSystemTest
testCreateDirectoryExists
	| path |
	
	path := Path * 'griffle'.
	self markForCleanup: path.
	
	filesystem createDirectory: path.
	self 
		should: [ filesystem createDirectory: path]
		raise: DirectoryExists.
%

category: 'tests'
method: FileSystemTest
testCreateDirectoryNoParent
	| path |
	path := Path * 'griffle' / 'nurp'.
	self 
		should: [filesystem createDirectory: path]
		raise: DirectoryDoesNotExist.
	
	
%

category: 'tests'
method: FileSystemTest
testCreateDirectoryNotCreateParent
	| path |
	path := filesystem workingDirectory / 'plonk' / 'griffle'.
	self should:[path createDirectory] raise: DirectoryDoesNotExist.
	self assert: path exists not.
%

category: 'tests'
method: FileSystemTest
testCreateFile
	| directory path |
	directory := filesystem workingDirectory.
 	self markForCleanup: directory / 'plonk' / 'griffles'.
	self markForCleanup: directory / 'plonk'.
	path := directory / 'plonk' / 'griffles'.
	(directory / 'plonk') ensureCreateDirectory.
	self shouldnt: [ path createFile] raise:Error.
	self assert:path exists .
	(directory / 'plonk') deleteAll.
%

category: 'tests'
method: FileSystemTest
testCreateFileNotCreateParent
	| path reference |
	path := Path / 'plonk' / 'griffles'.
	reference := FileReference fileSystem: filesystem path: path.
	self should: [ reference openWritable: true ] raise: DirectoryDoesNotExist.
	self assert: reference exists not
%

category: 'tests'
method: FileSystemTest
testDelete
	"Unlike ensureDelete, delete raises an exception if the file does not exist."
	| reference |
	
	reference := filesystem workingDirectory / 'does-not-exist'.
	self deny: reference exists.
	
	self 
		should: [ reference delete ]
		raise: FileDoesNotExistException.
		
		
	reference := ( filesystem workingDirectory / 'file') ensureCreateFile.
	reference delete.
	
	self deny: reference exists. 
		
%

category: 'tests'
method: FileSystemTest
testDelimiter
	self assert: filesystem delimiter isCharacter
%

category: 'tests'
method: FileSystemTest
testDirectory
	| path |
	
	path := Path * 'plonk'.
	self markForCleanup: path.
	
	filesystem createDirectory: path.
	
	self assert: (filesystem exists: path).
	self assert: (filesystem isDirectory: path).
	
	filesystem delete: path.
	self deny: (filesystem isFile: path).
	self deny: (filesystem exists: path)
%

category: 'tests'
method: FileSystemTest
testEnsureDirectory
	| path |
	
	path := Path * 'plonk'.
	self markForCleanup: path.
	
	filesystem ensureCreateDirectory: path.
	self assert: (filesystem isDirectory: path).
%

category: 'tests'
method: FileSystemTest
testEnsureDirectoryCreatesParent
	| path |
	path := Path * 'plonk' / 'griffle'.
	self markForCleanup: path.
	self markForCleanup: path parent.
	filesystem ensureCreateDirectory: path.
	self assert: (filesystem isDirectory: Path * 'plonk').
	self assert: (filesystem isDirectory: path)
%

category: 'tests'
method: FileSystemTest
testEnsureDirectoryExists
	| path |
	path := Path * 'plonk'.
	self markForCleanup: path.
	filesystem createDirectory: path.
	filesystem ensureCreateDirectory: path
%

category: 'tests'
method: FileSystemTest
testFile
	| path |
	
	path := Path * 'gooly'.
	self markForCleanup: path.
	
	(filesystem workingDirectory resolve: path) writeStream close.
	self assert: (filesystem exists: path).
	self deny: (filesystem isDirectory: path).
	self assert: (filesystem isFile: path).
	
	filesystem delete: path.
	self deny: (filesystem exists: path)
%

category: 'tests'
method: FileSystemTest
testFileNames

	| reference |
	#('test one' 'test with two' 'test-Ã¤Ã¶Ã¼' 'test.Ã¤Ã¶Ã¼')
		do: [ :each | 
			reference := filesystem workingDirectory / each.
			self assert: reference basename = each.
			self deny: reference exists.
			reference writeStreamDo: [ :stream | stream nextPutAll: 'gooly' ].
			[ 
			self assert: reference exists.
			self
				assert:
					(filesystem workingDirectory children anySatisfy: [ :ref | ref = reference ]) ]
				ensure: [ reference delete ] ]
%

category: 'tests'
method: FileSystemTest
testMoveTo
	| base file folder |
	
	base := filesystem workingDirectory.
	
	folder := (base / 'folder') ensureCreateDirectory. 
	file := (base / 'file') ensureCreateFile.
	
	"Cleanup after running"
	self 
		markForCleanup: (base / 'folder' / 'newFile');
		markForCleanup: (base / 'folder') ;
		markForCleanup: (base / 'file').	

	file moveTo: (folder / 'newFile').
	self deny: (base / 'file') exists.
	self assert: (folder / 'newFile') exists.
%

category: 'tests'
method: FileSystemTest
testMoveToFailingExistingDestination
	| base file folder |
	
	base := filesystem workingDirectory.
	
	folder := (base / 'folder') ensureCreateDirectory. 
	(folder / 'newFile') ensureCreateFile.
	file := (base / 'file') ensureCreateFile.
	
	"Cleanup after running"
	self 
		markForCleanup: (base / 'folder' / 'newFile');
		markForCleanup: (base / 'folder') ;
		markForCleanup: (base / 'file').	
	
	"Destination exists already"
	self should: [ file moveTo: (folder / 'newFile') ] raise: Error.
	self assert: (base / 'file') exists.
	self assert: (folder / 'newFile') exists.
%

category: 'tests'
method: FileSystemTest
testMoveToFailingMissingDestination
	| base file |
	
	base := filesystem workingDirectory.
	
	file := (base / 'file') ensureCreateFile.
	
	"Cleanup after running"
	self 
		markForCleanup: (base / 'folder' / 'newFile');
		markForCleanup: (base / 'folder') ;
		markForCleanup: (base / 'file').	
	
	"Destination exists already"
	self deny: (base / 'folder') exists.
	self should: [ file moveTo: (base / 'folder' / 'newFile') ] raise: Error.
	self assert: (base / 'file') exists.
	self deny: (base / 'folder' / 'newFile') exists.
%

category: 'tests'
method: FileSystemTest
testMoveToFailingMissingSource
	| base folder |
	
	base := filesystem workingDirectory.
	
	folder := (base / 'folder') ensureCreateDirectory. 
	
	"Cleanup after running"
	self 
		markForCleanup: (base / 'folder' / 'newFile');
		markForCleanup: (base / 'folder').
	
	self deny: (base / 'file') exists.
	"Destination exists already"
	self should: [ (base / 'file') moveTo: (folder / 'newFile') ] raise: Error.
	self deny: (base / 'file') exists.
	self deny: (folder / 'newFile') exists.
%

category: 'tests'
method: FileSystemTest
testNonExistentFileSize
	| base file1 file2 |
	
	base := filesystem workingDirectory.
	file1 := (base / 'file1') ensureCreateFile.
	file2 := (base / 'file2').
	self markForCleanup: base / 'file1'.
	
	self shouldnt: [ file1 size ] raise: FileDoesNotExistException.
	self should: [ file2 size ] raise: FileDoesNotExistException
%

category: 'tests-streams'
method: FileSystemTest
testReadingAfterWriting
	| reference stream |
	self markForCleanup: (reference := filesystem workingDirectory / 'griffle').
	self deny: reference exists.
	reference writeStreamDo: [ :ws | ws nextPutAll: 'griffle' ].
	stream := reference readStream.
	self assert: stream contents equals: 'griffle'.
	stream close
%

category: 'tests-streams'
method: FileSystemTest
testReadStream
	| reference stream |
	self markForCleanup: (reference := filesystem workingDirectory / 'griffle').
	self should: [ reference readStream ] raise: FileDoesNotExistException.
	reference writeStreamDo: [ :ws | ws nextPutAll: 'griffle' ].
	stream := reference readStream.
	self assert: stream contents asString equals: 'griffle'.
	stream close
%

category: 'tests-streams'
method: FileSystemTest
testReadStreamDo
	| reference |
	self markForCleanup: (reference := filesystem workingDirectory / 'griffle').
	self 
		should: [ reference readStreamDo: [ :stream | self assert: false ] ] 
		raise: FileDoesNotExistException.
	reference writeStreamDo: [ :ws | ws nextPutAll: 'griffle' ].
	self assert: (reference readStreamDo: [ :stream | stream contents asString ]) 
		= 'griffle'
%

category: 'tests-streams'
method: FileSystemTest
testReadStreamDoIfAbsent
	| reference |
	self markForCleanup: (reference := filesystem workingDirectory / 'griffle').
	self assert: (reference 
		readStreamDo: [ :stream | false ]
		ifAbsent: [ true ]).
	reference writeStreamDo: [ :ws | ws nextPutAll: 'griffle' ].
	self assert: (reference 
		readStreamDo: [ :stream | stream contents asString = 'griffle' ]
		ifAbsent: [ false ])
%

category: 'tests-streams'
method: FileSystemTest
testReadStreamIfAbsent
	| reference stream |
	self markForCleanup: (reference := filesystem workingDirectory / 'griffle').
	self assert: (reference readStreamIfAbsent: [ true ]).
	reference writeStreamDo: [ :ws | ws nextPutAll: 'griffle' ].
	stream := reference readStreamIfAbsent: [ false ].
	self assert: stream contents asString = 'griffle'.
	stream close
%

category: 'tests'
method: FileSystemTest
testReferenceTo
	|path|
	"use a relative path since absolute path behavior differs on mac, linux vs win native filesystems"
	path := Path * 'a' / 'b'.
	self assert: (filesystem referenceTo: 'a/b') path = path.
%

category: 'tests'
method: FileSystemTest
testRoot
	self assert: filesystem root fileSystem = filesystem.
	self assert: filesystem root path = Path root.
	self assert: filesystem root isRoot.
%

category: 'tests'
method: FileSystemTest
testRootExists
	self assert: (filesystem exists: Path root)
%

category: 'tests'
method: FileSystemTest
testRootIsDirectory
	self assert: (filesystem isDirectory: Path root)
%

category: 'tests'
method: FileSystemTest
testRootIsNotAFile
	self deny: (filesystem isFile: Path root)
%

category: 'tests'
method: FileSystemTest
testWorking
	self assert: filesystem workingDirectory fileSystem = filesystem.
	self assert: filesystem workingDirectory path = filesystem workingDirectoryPath
%

category: 'tests'
method: FileSystemTest
testWorkingDirectory
	self assert: filesystem workingDirectory isRoot
%

category: 'tests-streams'
method: FileSystemTest
testWriteStream
	| reference stream |
	self markForCleanup: (reference := filesystem workingDirectory / 'griffle').
	stream := reference writeStream.
	stream nextPutAll: 'griffle'.
	stream close.
	self assert: (filesystem workingDirectory / 'griffle') isFile.
	stream := reference writeStream.
	stream close
%

category: 'tests-streams'
method: FileSystemTest
testWriteStreamDo
	| reference |
	self markForCleanup: (reference := filesystem workingDirectory / 'griffle').
	self assert: (reference writeStreamDo: [ :stream |
		stream nextPutAll: 'griffle'.
		true ]).
	self assert: (filesystem workingDirectory / 'griffle') isFile.
	self assert: (reference writeStreamDo: [ :stream | true ])
%

! Class implementation for 'FsDiskFileSystemTest'

!		Instance methods for 'FsDiskFileSystemTest'

category: 'initialize-release'
method: FsDiskFileSystemTest
createFileSystem

	^FsDiskFileSystem new
%

category: 'tests'
method: FsDiskFileSystemTest
testEqual
	| other |
	other := self createFileSystem.
	self assert: filesystem = other
%

category: 'tests'
method: FsDiskFileSystemTest
testIsDirectory
	self assert: (filesystem isDirectory: FileLocator workingDirectory resolve path)
%

category: 'tests'
method: FsDiskFileSystemTest
testIsDiskFileSystem
	self assert: filesystem isDiskFileSystem.
	
%

category: 'tests'
method: FsDiskFileSystemTest
testMoveMemoryToDisk
	"Test moving a file from the memory filesystem to the disk filesystem.
	This ensures that the copyAndDelete:to: is called correctly."
	| memfs out testString old new |
	[
		memfs := FileSystem memory.
		old := memfs / 'testMoveMemoryToDisk_old'.
		out := old writeStream.
		testString := 'To be moved to disk'.
		[ out nextPutAll: testString ] ensure: [ out close ].
		
		new := FileLocator workingDirectory / 'testMoveMemoryToDisk_new'.
		old moveTo: new.
		
		self deny: (memfs / 'testMoveMemoryToDisk_old') exists.
		self assert: new exists.
		self assert: new contents equals: testString.
	] ensure: [ 
		old ensureDelete.
		new ensureDelete.
	]
%

category: 'tests'
method: FsDiskFileSystemTest
testWorkingDirectory

	| initialWD tempWD |
	initialWD := filesystem workingDirectory.
	tempWD := initialWD / 'FsDIskFileSystemTest-testWorkingDirectory-Sandbox'.
	tempWD ensureCreateDirectory.
	filesystem setWorkingDirectory: tempWD path.
	[self
		assert: filesystem workingDirectory
		equals: tempWD]
		ensure: [filesystem setWorkingDirectory: initialWD path].
	self
		assert: filesystem workingDirectory
		equals: initialWD
%

! Class implementation for 'FsMemoryFileSystemTest'

!		Instance methods for 'FsMemoryFileSystemTest'

category: 'initialize-release'
method: FsMemoryFileSystemTest
createFileSystem
	^ FileSystem memory
%

category: 'tests'
method: FsMemoryFileSystemTest
lastModificationTimeOf: fileReference
	"DateAndTime primUTCMicrosecondsClock is not precise across all OS so put in slight delay between calling modificationTime"

	^ [ fileReference modificationTime ]
		ensure: [ (Delay forMilliseconds: 100) wait ]
%

category: 'tests'
method: FsMemoryFileSystemTest
testCurrentEqual
	| other another |
	another := FileSystem currentMemoryFileSystem.
	other := FileSystem currentMemoryFileSystem.
	self assert: other equals: another
%

category: 'tests'
method: FsMemoryFileSystemTest
testIsMemoryFileSystem
	self assert: filesystem isMemoryFileSystem.
	
%

category: 'tests'
method: FsMemoryFileSystemTest
testModifiedTimeWhenFileCreated
	self assert: (filesystem / 'file.txt') ensureCreateFile modificationTime notNil
%

category: 'tests'
method: FsMemoryFileSystemTest
testModifiedTimeWhenFileModifiedByWriteStream
	| modifiedTime fileReference |
	fileReference := (filesystem / 'file.txt') ensureCreateFile.
	modifiedTime := self lastModificationTimeOf: fileReference.
	fileReference writeStreamDo: [ :aStream | aStream nextPutAll: 'data' ].
	self assert: modifiedTime notNil.
	self deny: modifiedTime equals: fileReference modificationTime
%

category: 'tests'
method: FsMemoryFileSystemTest
testModifiedTimeWhenFileModifiedWithBinaryWriteStream
	| modifiedTime fileReference data |
	fileReference := (filesystem / 'file.txt') ensureCreateFile.
	modifiedTime := self lastModificationTimeOf: fileReference.
	data := 'some data'.
	fileReference binaryWriteStreamDo: [ :aStream | aStream nextPutAll: data ].
	self assert: modifiedTime notNil.
	self deny: modifiedTime equals: fileReference modificationTime.
	self
		assert: data asByteArray
		equals: (fileReference binaryReadStreamDo: [ :aStream | aStream upToEnd ]).
	self assert: data equals: (fileReference readStreamDo: [ :aStream | aStream contents ])
%

category: 'tests'
method: FsMemoryFileSystemTest
testModifiedTimeWhenFileWrittenTo
	| modifiedTime fileReference |
	fileReference := (filesystem / 'file.txt') ensureCreateFile.
	modifiedTime := self lastModificationTimeOf: fileReference.
	fileReference binaryWriteStreamDo: [ :aStream | aStream nextPutAll: 'data' ].
	self assert: modifiedTime notNil.
	self deny: modifiedTime equals: fileReference modificationTime
%

category: 'tests'
method: FsMemoryFileSystemTest
testModifiedTimeWhenHandleTruncated
	| modifiedTime fileReference handle |
	fileReference := (filesystem / 'file.txt') ensureCreateFile.
	handle := fileReference openWritable: true.
	modifiedTime := self lastModificationTimeOf: fileReference.
	handle truncate.
	self assert: modifiedTime notNil.
	self deny: modifiedTime equals: fileReference modificationTime
%

category: 'tests'
method: FsMemoryFileSystemTest
testNotEqualWhenCreatingNewMemoryFileSystem
	| other |
	other := FileSystem memory.
	self deny: other equals: filesystem
%

category: 'tests'
method: FsMemoryFileSystemTest
testNotEqualWhenRequestingMemoryFileSystem
	| other |
	other := self createFileSystem.
	self deny: other equals: filesystem
%

! Class implementation for 'FsBinaryFileStreamTest'

!		Instance methods for 'FsBinaryFileStreamTest'

category: 'accessing'
method: FsBinaryFileStreamTest
createFile: aString
contents: contentBytes

	| reference |
	reference := sandbox / aString.
	reference parent ensureCreateDirectory.
	reference binaryWriteStreamDo: [:stream | stream nextPutAll: contentBytes].
	self assert: reference isFile.
	^reference
%

category: 'accessing'
method: FsBinaryFileStreamTest
sandboxName

	^'', self class name, '-', self selector, '-Sandbox'
%

category: 'running'
method: FsBinaryFileStreamTest
setUp

	| fileSystem |
	super setUp.
	fileSystem := FileSystem disk.
	sandbox := FileLocator workingDirectory asFileReference / self sandboxName.
	self
		assert: sandbox fileSystem
		equals: fileSystem.
	self deny: sandbox exists.
	sandbox createDirectory
%

category: 'running'
method: FsBinaryFileStreamTest
tearDown

	sandbox deleteAll.
	super tearDown
%

category: 'running'
method: FsBinaryFileStreamTest
testContents

	| contents ref stream |
	contents := #[84 104 101 115 101 32 98 121 116 101 115 32 97 114 101 32 42 100 101 102 105 110 105 116 101 108 121 42 32 114 97 110 100 111 109 108 121 32 103 101 110 101 114 97 116 101 100 46].
	ref := self
		createFile: 'testContents'
		contents: contents.
	stream := ref binaryReadStream.
	[self
		assert: stream next
		equals: 84.
	self
		assert: (stream next: 3)
		equals: #[104 101 115].
	self
		assert: stream contents
		equals: contents]
		ensure: [stream close]
%

category: 'running'
method: FsBinaryFileStreamTest
testNext

	| ref stream |
	ref := self
		createFile: 'testNext'
		contents: ByteArray new.
	stream := ref binaryReadStream.
	[self
		assert: stream next
		equals: nil]
		ensure: [stream close]
%

! Class implementation for 'FsFileDescriptorRegistryTest'

!		Instance methods for 'FsFileDescriptorRegistryTest'

category: 'creating'
method: FsFileDescriptorRegistryTest
createFile: aString

	^self
		createFile: aString
		contents: 'Default file contents'
%

category: 'creating'
method: FsFileDescriptorRegistryTest
createFile: aString
contents: contentsString

	| reference |
	reference := sandbox / aString.
	reference parent ensureCreateDirectory.
	reference writeStreamDo: [:stream | stream nextPutAll: contentsString].
	self assert: reference isFile.
	^reference
%

category: 'accessing'
method: FsFileDescriptorRegistryTest
ephemeronFor: aFileDescriptor

	^self registry _private_test_only_list detect: [:each | each _isSmallInteger not and: [each _private_test_only_fileDescriptor = aFileDescriptor]]
%

category: 'accessing'
method: FsFileDescriptorRegistryTest
maximumReclamation

	System
		_generationScavenge_vmMarkSweep;
		_generationScavenge_vmMarkSweep
%

category: 'accessing'
method: FsFileDescriptorRegistryTest
registry

	^FsFileDescriptorRegistry current
%

category: 'testing'
method: FsFileDescriptorRegistryTest
registryIncludes: anEphemeron

	^anEphemeron _private_test_only_index
		ifNotNil: [:index | (self registry _private_test_only_list at: index) = anEphemeron]
		ifNil: [self registry _private_test_only_list includes: anEphemeron "Ensure we do not include the Ephemeron even if we no longer have an index."]
%

category: 'running'
method: FsFileDescriptorRegistryTest
setUp
	"initialize sandbox"

	super setUp.
	sandbox := FileLocator workingDirectory asFileReference / 'FsFileDescriptorRegistryTest-Sandbox'
%

category: 'running'
method: FsFileDescriptorRegistryTest
tearDown
	"initialize sandbox"

	sandbox deleteAll.
	super tearDown
%

category: 'running'
method: FsFileDescriptorRegistryTest
testClose
	"Ensure the Ephemeron is removed once the file descriptor is closed but not yet garbage collected."

	| ref fd unixFd ephemeron |
	ref := self createFile: 'file-a'.
	fd := ref openOptions: ref defaultOptionsForRead.
	ephemeron := self ephemeronFor: fd.
	self assert: (self registryIncludes: ephemeron).
	fd close.
	self deny: (self registryIncludes: ephemeron).
	self assert: unixFd = unixFd
%

category: 'running'
method: FsFileDescriptorRegistryTest
testMourning
	"Ensure that a FileDescriptor is automatically closed if I release my reference."

	| ref fd unixFd ephemeron |
	ref := self createFile: 'file-a'.
	fd := ref openOptions: ref defaultOptionsForRead.
	ephemeron := self ephemeronFor: fd.
	self assert: (self registryIncludes: ephemeron).
	unixFd := fd _fd.
	fd := nil.
	self maximumReclamation.
	self deny: (self registryIncludes: ephemeron).
	self
		should: [DiskStore current libcStat fstat: unixFd]
		raise: FsEBADF
%

! Class implementation for 'FsFileDescriptorTest'

!		Instance methods for 'FsFileDescriptorTest'

category: 'initializing'
method: FsFileDescriptorTest
setUp
	"Configure the known file descriptors"

	super setUp.
	stdin := FsFileDescriptor stdin.
	stdout := FsFileDescriptor stdout.
	stderr := FsFileDescriptor stderr
%

category: 'BasicTests'
method: FsFileDescriptorTest
testNoNew

	self
		should: [FsFileDescriptor new]
		raise: Error
%

category: 'BasicTests'
method: FsFileDescriptorTest
testOpenStderr

	self
		assert: stderr class equals: FsFileDescriptor;
		assert: stderr _fd equals: 2
%

category: 'BasicTests'
method: FsFileDescriptorTest
testOpenStdin

	self
		assert: stdin class equals: FsFileDescriptor;
		assert: stdin _fd equals: 0
%

category: 'BasicTests'
method: FsFileDescriptorTest
testOpenStdout

	self
		assert: stdout class equals: FsFileDescriptor;
		assert: stdout _fd equals: 1
%

category: 'BasicTests'
method: FsFileDescriptorTest
testPosition

	| id fd size |
	id := DiskStore current libcFcntl open: '/usr/bin/env' flags: 0 mode: 0.
	fd := FsFileDescriptor fd: id.
	self
		assert: fd position
		equals: 0.
	size := fd size.
	fd position: size - 1.
	self
		assert: fd position
		equals: size - 1.
	fd position: size. "Ensure we can go beyond the end of the file."
	self
		assert: fd position
		equals: size.
	self
		should: [fd position: -1]
		raise: OutOfRange.
	self
		assert: fd position
		equals: size
%

category: 'BasicTests'
method: FsFileDescriptorTest
testReadFromUsrBinEnv

	| id fd bytes |
	id := DiskStore current libcFcntl open: '/usr/bin/env' flags: 0 mode: 0.
	fd := FsFileDescriptor fd: id.
	[bytes := fd read: 4] ensure: [fd close].
	self
		assert: bytes size
		equals: 4.
	self
		assert: bytes class
		equals: ByteArray.
	self
		deny: bytes
		equals: #[0 0 0 0]
%

category: 'BasicTests'
method: FsFileDescriptorTest
testWriteStringErrors

	self
		should: [stdout write: 'Hello, World!']
		raise: ArgumentTypeError
%

category: 'BasicTests'
method: FsFileDescriptorTest
testWriteToStderr

	| message count |
	message := Character lf asString, 'Running #testWriteToStderr'.
	count := stderr write: message asByteArray.
	self
		assert: count
		equals: 27
%

category: 'BasicTests'
method: FsFileDescriptorTest
testWriteToStdout

	| message count |
	message := Character lf asString, 'Running #testWriteToStdout'.
	count := stdout write: message asByteArray.
	self
		assert: count
		equals: 27
%

! Class implementation for 'FsGemStoneKernelTests'

!		Instance methods for 'FsGemStoneKernelTests'

category: 'private'
method: FsGemStoneKernelTests
collectionMoreThan1NoDuplicates

	^self collectionWithoutEqualElements
%

category: 'private'
method: FsGemStoneKernelTests
collectionWithoutEqualElements

	^ {1.1. 4.4. 6.5. 2.4. 3.1.}
%

category: 'private'
method: FsGemStoneKernelTests
collectionWithSameAtEndAndBegining

	^ {1.5. 5.5. 1.5 copy}.
%

category: 'private'
method: FsGemStoneKernelTests
elementNotInForIndexAccessing

	^ 9
%

category: 'private'
method: FsGemStoneKernelTests
empty

	^ #().
%

category: 'private'
method: FsGemStoneKernelTests
indexInForCollectionWithoutDuplicates
	^ 2.
%

category: 'private'
method: FsGemStoneKernelTests
indexInNonEmpty
	"Return an index between bounds of 'nonEmpty'"
	
	^ 2
%

category: 'private'
method: FsGemStoneKernelTests
moreThan3Elements

	^ #(1 2 3 4 5) copy.
%

category: 'private'
method: FsGemStoneKernelTests
nonEmpty

	^ self moreThan3Elements
%

category: 'tests'
method: FsGemStoneKernelTests
testAllButFirst

	| abf col |
	col := self moreThan3Elements.
	abf := col allButFirst.
	self deny: abf first = col first.
	self assert: abf size + 1 = col size
%

category: 'tests'
method: FsGemStoneKernelTests
testAllButFirstNElements

	| allButFirst collection |
	collection := self moreThan3Elements.
	allButFirst := collection allButFirst: 2.
	allButFirst withIndexDo: 
		 [:el :i | self assert: el equals: (collection at: i + 2) ].
	self assert: allButFirst size + 2 equals: collection size
%

category: 'tests'
method: FsGemStoneKernelTests
testCopyAfterLast

	| result index collection |
	collection := self collectionWithoutEqualElements .
	index:= self indexInForCollectionWithoutDuplicates .
	result := collection copyAfterLast: (collection  at:index ).
	
	"Verify content"
	result withIndexDo: 
		[:el :i | self assert: (collection at: (i + index )) equals: (result at: i)].

	"Verify size"
	self assert: result size equals: (collection size - index)
%

category: 'tests'
method: FsGemStoneKernelTests
testCopyUpToLast

	| result index collection |
	collection := self collectionWithoutEqualElements.
	index:= self indexInForCollectionWithoutDuplicates.
	result := collection copyUpToLast: (collection at:index).
	
	"Verify content"
	result withIndexDo: [:el :i| self assert: (collection at:i) equals: (result at: i)].
	
	"Verify size"
	self assert: result size equals: (index-1)
%

category: 'tests'
method: FsGemStoneKernelTests
testCopyWithFirst

	| index element result |
	index:= self indexInNonEmpty .
	element:= self nonEmpty at: index.
	
	result := self nonEmpty copyWithFirst: element.	
	
	self assert: result size = (self nonEmpty size + 1).
	self assert: result first = element .
	
	2 to: result size do:
	[ :i |
	self assert: (result at: i) = ( self nonEmpty at: ( i - 1 ))].
%

category: 'tests'
method: FsGemStoneKernelTests
testDifference
	"Answer the set theoretic difference of two collections."
	
	| difference |
	self assert: (self collectionWithoutEqualElements difference: self collectionWithoutEqualElements) isEmpty.
	self assert: (self empty difference: self collectionWithoutEqualElements) isEmpty.
	difference := (self collectionWithoutEqualElements difference: self empty).
	self assert: difference size = self collectionWithoutEqualElements size.
	self collectionWithoutEqualElements do: [ :each |
		self assert: (difference includes: each) ].
%

category: 'tests'
method: FsGemStoneKernelTests
testLastIndexOfIfAbsent

	| element collection |
	collection := self collectionMoreThan1NoDuplicates.
	element := collection first.
	self assert: (collection 
			lastIndexOf: element
			ifAbsent: [ 99 ]) equals: 1.
	self assert: (collection 
			lastIndexOf: self elementNotInForIndexAccessing
			ifAbsent: [ 99 ]) equals: 99
%

category: 'tests'
method: FsGemStoneKernelTests
testLastIndexOfIfAbsentDuplicate

	| collection element |
	collection := self collectionWithSameAtEndAndBegining.
	element := collection first.

	"floatCollectionWithSameAtEndAndBegining first and last elements are equals 
	'lastIndexOf: should return the position of the last occurrence :'"
	self assert: (collection 
			lastIndexOf: element
			ifAbsent: [ 55 ]) equals: collection size
%

category: 'tests'
method: FsGemStoneKernelTests
testLastIndexOfStartingAt

	| element collection |
	collection := self collectionMoreThan1NoDuplicates.
	element := collection last.
	self assert: (collection 
			lastIndexOf: element
			startingAt: collection size
			ifAbsent: [ 99 ]) equals: collection size.
	self assert: (collection 
			lastIndexOf: element
			startingAt: collection size - 1
			ifAbsent: [ 99 ]) equals: 99.
	self assert: (collection 
			lastIndexOf: self elementNotInForIndexAccessing
			startingAt: collection size
			ifAbsent: [ 99 ]) equals: 99
%

category: 'tests'
method: FsGemStoneKernelTests
testLastIndexOfStartingAtDuplicate

	| collection element |
	collection := self collectionWithSameAtEndAndBegining.
	element := collection last.

	" floatCollectionWithSameAtEndAndBegining first and last elements are equals 
	'lastIndexOf:ifAbsent:startingAt: should return the position of the last occurrence :'"
	self assert: (collection 
			lastIndexOf: element
			startingAt: collection size
			ifAbsent: [ 55 ]) equals: collection size.
	self assert: (collection 
			lastIndexOf: element
			startingAt: collection size - 1
			ifAbsent: [ 55 ]) equals: 1
%

! Class implementation for 'FsIntegerExtensionTestCase'

!		Instance methods for 'FsIntegerExtensionTestCase'

category: 'running'
method: FsIntegerExtensionTestCase
testBinaryShiftRight
	"Test >>"

	self
		assert: 137087381899686168693902789234916601184 >> 12
		equals: 33468599096603068528784860653055810.
	self
		assert: -137087381899686168693902789234916601184 >> 12
		equals: -33468599096603068528784860653055811.
	self
		assert: 0 >> 2
		equals: 0.
	self
		should: [3 >> -5]
		raise: Error.
	self
		assert: 12 >> 3
		equals: 1.
	self
		assert: -12 >> 3
		equals: -2
%

! Class implementation for 'FsMemoryOpeningOptionsTest'

!		Instance methods for 'FsMemoryOpeningOptionsTest'

category: 'running'
method: FsMemoryOpeningOptionsTest
testAttemptToConfigureMoreThanOnce

	| options |
	options := FsMemoryFileOpeningOptions readWrite.
	self
		should: [options readOnly]
		raise: ImproperOperation
%

category: 'running'
method: FsMemoryOpeningOptionsTest
testReadOnly

	| options |
	options := FsMemoryFileOpeningOptions readOnly.
	self
		assert: options isReadOnly;
		deny: options isReadWrite;
		deny: options isWriteOnly;
		assert: options isReadable;
		deny: options isWritable
%

category: 'running'
method: FsMemoryOpeningOptionsTest
testReadWrite

	| options |
	options := FsMemoryFileOpeningOptions readWrite.
	self
		deny: options isReadOnly;
		assert: options isReadWrite;
		deny: options isWriteOnly;
		assert: options isReadable;
		assert: options isWritable
%

category: 'running'
method: FsMemoryOpeningOptionsTest
testWriteOnly

	| options |
	options := FsMemoryFileOpeningOptions writeOnly.
	self
		deny: options isReadOnly;
		deny: options isReadWrite;
		assert: options isWriteOnly;
		deny: options isReadable;
		assert: options isWritable
%

! Class implementation for 'FsUnixFileOpeningOptionsTest'

!		Instance methods for 'FsUnixFileOpeningOptionsTest'

category: 'single option adding tests'
method: FsUnixFileOpeningOptionsTest
testAppend
	| instance |
	instance := FsFileOpeningOptions_Linux_x64 writeOnly.
	instance append.
	self
		assert: instance allowsWrite;
		assert: instance isWriteOnly;
		assert: instance isAppend;
		assert: instance flags equals: 8r2001
%

category: 'single option adding tests'
method: FsUnixFileOpeningOptionsTest
testCloseOnExec
	| instance |
	instance := FsFileOpeningOptions_Linux_x64 readOnly.
	instance closeOnExec.
	self
		assert: instance allowsRead;
		assert: instance isReadOnly;
		assert: instance isCloseOnExec;
		assert: instance flags equals: 8r2000000
%

category: 'single option adding tests'
method: FsUnixFileOpeningOptionsTest
testCreate
	| instance |
	instance := FsFileOpeningOptions_Linux_x64 readWrite.
	instance create.
	self
		assert: instance allowsRead;
		assert: instance allowsWrite;
		deny: instance isReadOnly;
		assert: instance isCreate;
		assert: instance flags equals: 8r102
%

category: 'single option adding tests'
method: FsUnixFileOpeningOptionsTest
testDataSync
	| instance |
	instance := FsFileOpeningOptions_Linux_x64 writeOnly.
	instance dataSync.
	self
		deny: instance allowsRead;
		assert: instance allowsWrite;
		assert: instance isWriteOnly;
		assert: instance isDataSync;
		assert: instance flags equals: 8r10001
%

category: 'file creation mode tests'
method: FsUnixFileOpeningOptionsTest
testDefaultCreationMode
	"Mode that is given when no mode has been explicitly specified."

	| instance |
	instance := FsFileOpeningOptions_Linux_x64 writeOnly.
	self assert: instance modeBits equals: 8r666
%

category: 'single option adding tests'
method: FsUnixFileOpeningOptionsTest
testDirectory
	| instance |
	instance := FsFileOpeningOptions_Linux_x64 readOnly.
	instance directory.
	self
		assert: instance allowsRead;
		deny: instance allowsWrite;
		assert: instance isReadOnly;
		assert: instance isDirectory;
		assert: instance flags equals: 8r200000
%

category: 'single option adding tests'
method: FsUnixFileOpeningOptionsTest
testExclusive
	| instance |
	instance := FsFileOpeningOptions_Linux_x64 writeOnly.
	instance exclusive.
	self
		deny: instance allowsRead;
		assert: instance allowsWrite;
		assert: instance isWriteOnly;
		assert: instance isExclusive;
		assert: instance flags equals: 8r201
%

category: 'single option adding tests'
method: FsUnixFileOpeningOptionsTest
testNoFollow
	| instance |
	instance := FsFileOpeningOptions_Linux_x64 readOnly.
	instance noFollow.
	self
		assert: instance allowsRead;
		deny: instance allowsWrite;
		assert: instance isReadOnly;
		assert: instance isNoFollow;
		assert: instance flags equals: 8r400000
%

category: 'instance creation tests'
method: FsUnixFileOpeningOptionsTest
testReadOnly
	| instance |
	instance := FsFileOpeningOptions_Linux_x64 readOnly.
	self
		assert: instance isReadOnly;
		deny: instance isWriteOnly;
		deny: instance isReadWrite;
		deny: instance allowsWrite;
		assert: instance allowsRead;
		assert: instance flags equals: 0.
%

category: 'bad option tests'
method: FsUnixFileOpeningOptionsTest
testReadOnlyPlusTruncate
	"Undefined behavior, prohibit it."

	| instance |
	instance := FsFileOpeningOptions_Linux_x64 readOnly.
	self
		should: [ instance truncate ]
		raise: instance improperOperationExceptionClass
%

category: 'instance creation tests'
method: FsUnixFileOpeningOptionsTest
testReadWrite
	| instance |
	instance := FsFileOpeningOptions_Linux_x64 readWrite.
	self
		deny: instance isWriteOnly;
		assert: instance allowsWrite;
		assert: instance allowsRead;
		deny: instance isReadOnly;
		assert: instance isReadWrite;
		assert: instance flags equals: 2
%

category: 'bad option tests'
method: FsUnixFileOpeningOptionsTest
testSettingAccessModeMultipleTimes
	"Ensure Access Mode is only set once."

	| instance |
	instance := FsFileOpeningOptions_Linux_x64 new.
	instance readOnly.
	self
		should: [instance readWrite]
		raise: ImproperOperation.
	self
		should: [instance writeOnly]
		raise: ImproperOperation.
	instance := FsFileOpeningOptions_Linux_x64 new.
	instance readWrite.
	self
		should: [instance readOnly]
		raise: ImproperOperation.
	self
		should: [instance writeOnly]
		raise: ImproperOperation.
	instance := FsFileOpeningOptions_Linux_x64 new.
	instance writeOnly.
	self
		should: [instance readWrite]
		raise: ImproperOperation.
	self
		should: [instance readOnly]
		raise: ImproperOperation.
%

category: 'single option adding tests'
method: FsUnixFileOpeningOptionsTest
testSync
	| instance |
	instance := FsFileOpeningOptions_Linux_x64 readOnly.
	instance sync.
	self
		assert: instance allowsRead;
		deny: instance allowsWrite;
		assert: instance isReadOnly;
		assert: instance isSync;
		assert: instance flags equals: 8r4010000
%

category: 'single option adding tests'
method: FsUnixFileOpeningOptionsTest
testTruncate
	| instance |
	instance := FsFileOpeningOptions_Linux_x64 readWrite.
	instance truncate.
	self
		assert: instance allowsRead;
		assert: instance allowsWrite;
		assert: instance isReadWrite;
		assert: instance isTruncate;
		assert: instance flags equals: 8r1002
%

category: 'instance creation tests'
method: FsUnixFileOpeningOptionsTest
testWriteOnly
	| instance |
	instance := FsFileOpeningOptions_Linux_x64 writeOnly.
	self
		assert: instance isWriteOnly;
		assert: instance allowsWrite;
		deny: instance allowsRead;
		deny: instance isReadOnly;
		deny: instance isReadWrite;
		assert: instance flags equals: 1
%

! Class implementation for 'FsZincIntegrationTests'

!		Class methods for 'FsZincIntegrationTests'

category: 'testing'
classmethod: FsZincIntegrationTests
isAbstract

	^self == FsZincIntegrationTests
%

!		Instance methods for 'FsZincIntegrationTests'

category: 'support'
method: FsZincIntegrationTests
createFile: aString
contents: contentsString

	| reference |
	reference := sandbox / aString.
	reference parent ensureCreateDirectory.
	reference writeStreamDo: [:stream | stream nextPutAll: contentsString].
	self assert: reference isFile.
	^reference
%

category: 'accessing'
method: FsZincIntegrationTests
sandboxName
	"name of the sandbox directory"

	^self subclassResponsibility
%

category: 'running'
method: FsZincIntegrationTests
testStreamIsEmpty

	| ref |
	ref := self
		createFile: 'testStreamIsEmpty'
		contents: ''.
	ref
		readStreamDo: [:stream | self assert: stream isEmpty];
		writeStreamDo: [:stream | self assert: stream isEmpty];
		writeStreamDo: [:stream | stream nextPutAll: 'Hello'. self deny: stream isEmpty];
		readStreamDo: [:stream | self deny: stream isEmpty]
%

category: 'running'
method: FsZincIntegrationTests
testUTF8EncoderBackOnFileStream

	| ref stream encoder |
	ref := self
		createFile: 'testUTF8EncoderBackOnFileStream'
		contents: 'Les élèves Françaises'.
	stream := ref binaryReadStream. "Create a file-backed read-stream vs a string-backed stream like in ZnCharacterEncoderTests>>#testUTF8Back."
	[encoder := ZnUTF8Encoder new.
	self
		should: [encoder backOnStream: stream]
		raise: Error.
	4 timesRepeat: [ encoder nextFromStream: stream ].
	self
		assert: (encoder nextFromStream: stream)
		equals: $é.
	encoder backOnStream: stream.
	self
		assert: (encoder nextFromStream: stream)
		equals: $é.
	10 timesRepeat: [ encoder nextFromStream: stream ].
	13 timesRepeat: [ encoder backOnStream: stream ].
	self
		assert: (encoder nextFromStream: stream)
		equals: $s]
    ensure: [stream close]
%

! Class implementation for 'FsZincDiskIntegrationTests'

!		Instance methods for 'FsZincDiskIntegrationTests'

category: 'accessing'
method: FsZincDiskIntegrationTests
sandboxName
	"name of the sandbox directory"

	^'FsZincDiskIntegrationTests-Sandbox'
%

category: 'running'
method: FsZincDiskIntegrationTests
setUp

	| fileSystem |
	super setUp.
	fileSystem := FileSystem disk.
	sandbox := FileLocator workingDirectory asFileReference / self sandboxName.
	self
		assert: sandbox fileSystem
		equals: fileSystem.
	self deny: sandbox exists.
	sandbox createDirectory
%

category: 'running'
method: FsZincDiskIntegrationTests
tearDown

	sandbox deleteAll.
	super tearDown
%

! Class implementation for 'FsZincInMemoryIntegrationTests'

!		Instance methods for 'FsZincInMemoryIntegrationTests'

category: 'accessing'
method: FsZincInMemoryIntegrationTests
sandboxName
	"name of the sandbox directory"

	^'FsZincInMemoryIntegrationTests-Sandbox'
%

category: 'running'
method: FsZincInMemoryIntegrationTests
setUp

	super setUp.
	sandbox := FileSystem memory root / self sandboxName.
	self deny: sandbox exists.
	sandbox createDirectory
%

category: 'running'
method: FsZincInMemoryIntegrationTests
tearDown

	sandbox deleteAll.
	super tearDown
%

! Class implementation for 'PathTest'

!		Instance methods for 'PathTest'

category: 'asserting'
method: PathTest
assert: anObject
isKindOf: aClass

	^self assert: (anObject isKindOf: aClass)
%

category: 'tests'
method: PathTest
testAbsolutePath

	| path |

	self assert: (AbsolutePath new isAbsolute).
	self assert: (Path root isAbsolute).
	
	path := AbsolutePath from: 'parent/child/grandChild' delimiter: $/.
	self assert: path size equals: 3.
	self assert: (path at: 1) equals: 'parent'.
	self assert: (path at: 2) equals: 'child'.
	self assert: (path at: 3) equals: 'grandChild'.
	
	path := AbsolutePath from: '/' delimiter: $/.
	self assert: path equals: Path root.
	
%

category: 'tests'
method: PathTest
testAbsolutePrintString
	
	| path actual |
	path := Path / 'plonk' / 'griffle'.
	actual := path printString.
	self assert: actual equals: 'Path / ''plonk'' / ''griffle'''
%

category: 'tests'
method: PathTest
testAbsoluteWithParents
	| path allPaths |
	path := Path / 'plonk' / 'griffle' / 'nurb'.
	allPaths := path withParents.
	
	self assert: allPaths size equals: 4.
	self assert: allPaths first isRoot.
	self assert: allPaths second basename equals: 'plonk'.
	self assert: allPaths second size equals: 1.
	self assert: (allPaths second isChildOf: allPaths first).
	self assert: allPaths third basename equals: 'griffle'.
	self assert: allPaths third size equals: 2.
	self assert: (allPaths third isChildOf: allPaths second).
	self assert: allPaths fourth basename equals: 'nurb'.
	self assert: allPaths fourth size equals: 3.
	self assert: (allPaths fourth isChildOf: allPaths third).
	
	self assert: allPaths fourth equals: path.
	self assert: allPaths fourth == path
%

category: 'tests'
method: PathTest
testAsJson

	| path |
	path := Path / 'absolute' / 'path'.
	self
		assert: path
		isKindOf: AbsolutePath.
	self
		assert: path asJson
		equals: '"/absolute/path"'.
	path := Path * 'relative' / 'path'.
	self
		assert: path
		isKindOf: RelativePath.
	self
		assert: path asJson
		equals: '"relative/path"'
%

category: 'tests'
method: PathTest
testAsReference
	| path reference |
	path := Path * 'plonk'.
	reference := path asFileReference.
	self assert: reference class equals: FileReference.
	self assert: reference path equals: path
%

category: 'tests'
method: PathTest
testAsString

	| root absolute relative |
	root := Path root.
	absolute := Path root / 'some-directory' / 'some-file'.
	relative := absolute relativeToReference: Path root asFileReference.
	self
		assert: root asString
		equals: 'Path root'.
	self assert: absolute isAbsolute.
	self
		assert: absolute asString
		equals: 'Path / ''some-directory'' / ''some-file'''.
	self assert: relative isRelative.
	self
		assert: relative asString
		equals: 'Path * ''some-directory'' / ''some-file'''
%

category: 'tests'
method: PathTest
testBasename
	| path |
	path := Path * 'plonk' / 'griffle'.
	self assert: path basename equals: 'griffle'
%

category: 'tests'
method: PathTest
testBasenameNoParent
	| path |

	path := Path / 'griffle'.
	self assert: path parent basename equals: '/'.

	path := Path * 'griffle'.
	self assert: path parent basename equals: '.'.
%

category: 'tests'
method: PathTest
testBasenameWithoutExtension
	
	| path |
	path := Path * 'plonk' / 'griffle'.
	self assert: path basenameWithoutExtension equals: 'griffle'.
	self assert: (path basenameWithoutExtension: 'griffle') equals: 'griffle'.
	self assert: (path basenameWithoutExtension: 'taz') equals: 'griffle'.
	
	path := Path * 'plonk' / 'griffle.taz'.
	self assert: path basenameWithoutExtension equals: 'griffle'.
	self assert: (path basenameWithoutExtension: 'taz') equals: 'griffle'.
	self assert: (path basenameWithoutExtension: 'griffle.taz') equals: 'griffle.taz'.
	self assert: (path basenameWithoutExtension: 'zork') equals: 'griffle.taz'.
	
	path := Path * 'plonk' / 'griffle.taz.zork'.
	self assert: path basenameWithoutExtension equals: 'griffle.taz'.
	self assert: (path basenameWithoutExtension: 'zork') equals: 'griffle.taz'.
	self assert: (path basenameWithoutExtension: 'taz.zork') equals: 'griffle'.
	self assert: (path basenameWithoutExtension: 'girffle.taz.zork') equals: 'griffle.taz.zork'.
	self assert: (path basenameWithoutExtension: 'taz') equals: 'griffle.taz.zork'.
%

category: 'tests'
method: PathTest
testCanonicalization

	| ref |

	ref := (Path * 'a/b/c') canonicalize.
	self assert: ref segments equals: #('a' 'b' 'c').

	ref := (Path / 'a/b/c') canonicalize.
	self assert: ref segments equals: #('a' 'b' 'c').

	ref := (Path * '../a/b/c') canonicalize.
	self assert: ref segments equals: #('..' 'a' 'b' 'c').

	ref := (Path * 'a/b/c/..') canonicalize.
	self assert: ref segments equals: #('a' 'b').

	ref := (Path / 'a/b/c/..') canonicalize.
	self assert: ref segments equals: #('a' 'b').

	ref := (Path * 'a/b/../c') canonicalize.
	self assert: ref segments equals: #('a' 'c').

	ref := (Path / 'a/b/../c') canonicalize.
	self assert: ref segments equals: #('a' 'c').
%

category: 'tests'
method: PathTest
testCommaAddsExtension
	| path result |
	path := Path * 'plonk' .
	result := path, 'griffle'.
	self assert: result basename equals: 'plonk.griffle'
%

category: 'tests'
method: PathTest
testCommaAddsExtensionAgain
	| path result |
	path := Path * 'plonk.griffle'.
	result := path, 'nurp'.
	self assert: result basename equals: 'plonk.griffle.nurp'
%

category: 'tests'
method: PathTest
testContains
	| ancestor descendent |
	ancestor := Path / 'plonk'.
	descendent := Path / 'plonk' / 'griffle' / 'bork'.
	self assert: (ancestor contains: descendent).
	self deny: (descendent contains: ancestor)
%

category: 'tests'
method: PathTest
testContainsLocator
	| ancestor descendent |
	ancestor := FileLocator workingDirectory resolve path.
	descendent := FileLocator workingDirectory / 'griffle'.
	self deny: (ancestor contains: descendent).
	self deny: (descendent contains: ancestor)
%

category: 'tests'
method: PathTest
testEqual
	| a b |
	a := Path * 'plonk'.
	b := Path * 'plonk'.
	self deny: a == b.
	self assert: a equals: b.
%

category: 'tests'
method: PathTest
testExtendingPath

	| ref |

	self should: [ '/a/b' asPath / '' ] raise: Error.
	self should: [ '/a/b' asPath / nil ] raise: Error.

	ref := '/a/b/c' asPath / 'd/e'.
	self assert: ref segments equals: #('a' 'b' 'c' 'd' 'e').

	ref := '/a/b/c' asPath / 'd/e'.
	self assert: ref parent segments equals: #('a' 'b' 'c' 'd').

	ref := '/a/b/c' asPath / '../d'.
	self assert: ref segments equals:  #('a' 'b' 'c' '..' 'd').

	ref := '/a/b/c' asPath / 'd/..'.
	self assert: ref segments equals: #('a' 'b' 'c' 'd' '..').

	ref := '/a/b/c' asPath / 'd/../e'.
	self assert: ref segments equals: #('a' 'b' 'c' 'd' '..' 'e').

	ref := '/a/b/c' asPath / './d'.
	self assert: (ref segments = #('a' 'b' 'c' 'd')).

	ref := '/a/b/c' asPath / 'd/.'.
	self assert: (ref segments = #('a' 'b' 'c' 'd')).

	ref := '/a/b/c' asPath / 'd/./e'.
	self assert: ref segments equals: #('a' 'b' 'c' 'd' 'e').

%

category: 'tests'
method: PathTest
testExtensions
	self 
		assertCollection: (Path from: 'foo') extensions asArray
		equals: #().
	self
		assertCollection: (Path from: 'foo.tar') extensions asArray
		equals: #( 'tar' ).
	self
		assertCollection: (Path from: 'foo.tar.gz') extensions asArray
		equals: #( 'tar' 'gz').
	self
		assertCollection: (Path from: 'foo.1.tar.gz') extensions asArray
		equals: #( '1' 'tar' 'gz').
%

category: 'tests'
method: PathTest
testFullName

	| path |

	path := (FileSystem workingDirectory / 'book-result' / 'W01-Welcome')
				relativeToReference: FileSystem workingDirectory.
	self assert: path fullName equals: 'book-result/W01-Welcome'
%

category: 'tests'
method: PathTest
testGrandchildOfPath
	| griffle  nurb |
	griffle := Path / 'griffle'.
	nurb := griffle / 'plonk' / 'nurb'.
	self deny: (griffle isChildOf: nurb).
	self deny: (nurb isChildOf: griffle).
%

category: 'tests'
method: PathTest
testIsAbsolute
	self assert: (Path / 'plonk') isAbsolute
%

category: 'tests'
method: PathTest
testIsAbsoluteWindowsPathReturnsFalseWhenNoWindowsAbsolutePathProvided
  
	self deny: (Path isAbsoluteWindowsPath: 'tmp').
	self deny: (Path isAbsoluteWindowsPath: '/tmp').
	self deny: (Path isAbsoluteWindowsPath: '/tmp/test').
%

category: 'tests'
method: PathTest
testIsAbsoluteWindowsPathReturnsTrueWhenWindowsAbsolutePathProvided
  
	self assert: (Path isAbsoluteWindowsPath: 'A:\').
	self assert: (Path isAbsoluteWindowsPath: 'c:\').
	self assert: (Path isAbsoluteWindowsPath: 'c:\test').
%

category: 'tests'
method: PathTest
testIsChildOfPath
	| parent child |
	parent := Path / 'griffle'.
	child := parent / 'nurb'.
	self assert: (child isChildOf: parent).
	self deny: (parent isChildOf: child)
%

category: 'tests'
method: PathTest
testIsChildOfReference
	| parent child |
	parent := Path / 'griffle'.
	child := FileSystem memory referenceTo: parent / 'nurb'.
	self deny: (child isChildOf: parent).
	self deny: (parent isChildOf: child)
%

category: 'tests'
method: PathTest
testIsEmpty
	self assert: (Path workingDirectory) isEmpty
%

category: 'tests'
method: PathTest
testIsNotAbsolute
	self deny: (Path * 'plonk') isAbsolute
%

category: 'tests'
method: PathTest
testIsNotRelative
	self deny: (Path / 'plonk') isRelative
%

category: 'tests'
method: PathTest
testIsNotRoot
	self deny: (Path / 'plonk') isRoot
%

category: 'tests'
method: PathTest
testIsRelative
	self assert: (Path * 'plonk') isRelative
%

category: 'tests'
method: PathTest
testIsRoot
	self assert: Path root isRoot
%

category: 'tests'
method: PathTest
testMakeRelative
	
	| parent child relative |
	parent := Path / 'griffle' / 'bibb'.
	child := Path / 'griffle' / 'plonk' / 'nurp'.
	relative := parent makeRelative: child.
	self assert: relative equals: (Path parent / 'plonk' / 'nurp')
%

category: 'tests'
method: PathTest
testMakeRelativeFrom2RelativePaths
	"Related to issue: 14846 MakeRelative-method-applied-on-two-relative-paths-is-not-working"

	| parent child relative |
	parent := RelativePath new / 'griffle' / 'bibb'.
	child := RelativePath new / 'griffle' / 'plonk' / 'nurp'.
	relative := parent makeRelative: child.
	self assert: relative equals: Path parent / 'plonk' / 'nurp'
%

category: 'tests'
method: PathTest
testParent
	| path parent |
	path := (Path * 'plonk') / 'griffle'.
	parent := path parent.
	self assert: parent isRelative.
	self assert: (parent at: 1) equals: 'plonk'
%

category: 'tests'
method: PathTest
testParentParent
	| path  |
	path := (Path * '..') parent.
	self assert: path size equals: 2.
	self assert: (path at: 1) equals: '..'.
	self assert: (path at: 2) equals: '..'.
%

category: 'tests'
method: PathTest
testParentResolution
	| base relative absolute |
	base := Path / 'plonk' / 'pinto'.
	relative := Path parent / 'griffle' / 'zonk'.
	absolute := base resolve: relative.
	self assert: absolute isAbsolute.
	self assert: absolute segments equals: #('plonk' 'pinto' '..' 'griffle' 'zonk').
%

category: 'tests-class side'
method: PathTest
testParents

	| result |
	result := Path parents: 1.
	self
		assert: result class
		equals: RelativePath.
	self
		assert: result printString
		equals: 'Path * ''..'''
%

category: 'tests'
method: PathTest
testParentUpTo
	| a b c |
	a := Path / 'testParentUpTo' / 'A'.
	b := Path / 'testParentUpTo' / 'A' / 'B'.
	c := Path / 'testParentUpTo' / 'A' / 'B' / 'C'.
	self assert: b equals: (c parentUpTo: 'B').
	self assert: a equals: (c parentUpTo: 'A').
	self assert: Path / 'testParentUpTo' equals: (c parentUpTo: 'testParentUpTo').
	self assert: Path root equals: (c parentUpTo: 'notAParent')
%

category: 'tests'
method: PathTest
testParse

	| path |
	path := Path from: 'parent/child/grandChild' delimiter: $/.
	self assert: path size equals: 3.
	self assert: (path at: 1) equals: 'parent'.
	self assert: (path at: 2) equals: 'child'.
	self assert: (path at: 3) equals: 'grandChild'.
	
%

category: 'tests'
method: PathTest
testParseBogus
	
	| path |
	path := Path from: 'parent?<>~ \child/grandChild' delimiter: $/.
	self assert: path size equals: 2.
	self assert: (path at: 1) equals: 'parent?<>~ \child'.
	self assert: (path at: 2) equals: 'grandChild'.
	
%

category: 'tests'
method: PathTest
testParseTrailingSlash
	| path |
	path := Path from: 'griffle/' delimiter: $/.
	self assert: path size equals: 1.
	self assert: (path at: 1) equals: 'griffle'
%

category: 'tests'
method: PathTest
testPathString

	| path |

	path := (FileSystem workingDirectory / 'book-result' / 'W01-Welcome')
				relativeToReference: FileSystem workingDirectory.
	self assert: path isRelative.
	self assert: path pathString equals: 'book-result/W01-Welcome'
%

category: 'tests'
method: PathTest
testPrintPathOn

	| pathString pathSrc path |

	"Test a Relative path"
	pathSrc := 'one/two/three'.
	path := Path from: pathSrc.
	self assert: path isRelative.
	pathString := String streamContents: [ :stream | path printPathOn: stream ].
	self assert: pathSrc equals: pathString.

	"Test an Absolute path"
	pathSrc := '/one/two/three'.
	path := Path from: pathSrc.
	self assert: path isAbsolute.
	pathString := String streamContents: [ :stream | path printPathOn: stream ].
	self assert: pathSrc equals: pathString
%

category: 'tests'
method: PathTest
testPrintPathOnDelimiter

	| pathString pathSrc path |

	"Test a Relative path"
	"Use an unusal delimiter to check that the default isn't hardcoded anywhere"
	pathSrc := 'one|two|three'.
	path := Path from: pathSrc delimiter: $|.
	self assert: path isRelative.
	pathString := String streamContents: [ :stream | path printPathOn: stream delimiter: $| ].
	self assert: pathSrc equals: pathString.

	"Test an Absolute path"
	"Use an unusal delimiter to check that the default isn't hardcoded anywhere"
	pathSrc := '|one|two|three'.
	path := Path from: pathSrc delimiter: $|.
	self assert: path isAbsolute.
	pathString := String streamContents: [ :stream | path printPathOn: stream delimiter: $| ].
	self assert: pathSrc equals: pathString
%

category: 'tests'
method: PathTest
testPrintRelativeWithParent
	| path |
	path := Path parent / 'foo'.
	self assert: (path printWithDelimiter: $/) equals: '../foo'
%

category: 'tests'
method: PathTest
testPrintWithDelimiter
	| path |
	path := (Path * 'plonk') / 'griffle'.
	self assert: (path printWithDelimiter: $%) equals: 'plonk%griffle'
%

category: 'tests'
method: PathTest
testRedundantSeparators

	| ref |

	ref := '/a/b/c' asPath / 'foo/'.
	self assert: ref segments equals: #('a' 'b' 'c' 'foo').

	ref := '/a/b/c' asPath / 'foo//'.
	self assert: ref segments equals: #('a' 'b' 'c' 'foo').

	ref := '/a/b/c' asPath / 'foo//..'.
	self assert: ref segments equals: #('a' 'b' 'c' 'foo' '..').

	ref := '/a/b/c' asPath / '..//foo'.
	self assert: ref segments equals: #('a' 'b' 'c' '..' 'foo').

	ref := '/a/b/c' asPath / 'foo//..//bar'.
	self assert: ref segments equals: #('a' 'b' 'c' 'foo' '..' 'bar')
%

category: 'tests'
method: PathTest
testRelativeFromString

	| path |
	
	path := Path from: 'plonk/griffle'.
	
	self assert: path isRelative.
	self assert: path size equals: 2.
	self assert: (path at: 1) equals: 'plonk'.
	self assert: (path at: 2) equals: 'griffle'.
%

category: 'tests'
method: PathTest
testRelativeFromStringNormalization

	| path |
	
	path := Path from: 'plonk/../griffle'.
	
	self assert: path isRelative.
	self assert: path size equals: 3.
	self assert: path segments equals: #('plonk' '..' 'griffle').
%

category: 'tests'
method: PathTest
testRelativeFromStringNormalizationParent

	| path |
	
	path := Path from: 'plonk/../../griffle'.
	
	self assert: path isRelative.
	self assert: path size equals: 4.
	self assert: path segments equals: #('plonk' '..' '..' 'griffle')
%

category: 'tests'
method: PathTest
testRelativeFromStringParent

	| path |
	
	path := Path from: '../..'.
	
	self assert: path isRelative.
	self assert: path size equals: 2.
	self assert: (path at: 1) equals: '..'.
	self assert: (path at: 2) equals: '..'.
%

category: 'tests'
method: PathTest
testRelativePrintString
	| path actual |
	path := Path * 'plonk' / 'griffle'.
	actual := path printString.
	self assert: actual equals: 'Path * ''plonk'' / ''griffle'''
%

category: 'tests'
method: PathTest
testRelativeTo
	"aPath relativeTo: aParent returns a new path relative to the parent"
	
	| parent child relative |
	parent := Path / 'griffle'.
	child := Path / 'griffle' / 'plonk' / 'nurp'.
	relative := child relativeTo: parent.
	self assert: relative equals: (Path * 'plonk' / 'nurp')
%

category: 'tests'
method: PathTest
testRelativeToBranch
	| parent child relative |
	parent := Path / 'griffle' / 'bibb'.
	child := Path / 'griffle' / 'plonk' / 'nurp'.
	relative := child relativeTo: parent.
	self assert: relative  equals: (Path parent / 'plonk' / 'nurp')
%

category: 'tests'
method: PathTest
testRelativeWithParents
	| path allPaths |
	path := Path * 'plonk' / 'griffle' / 'nurb'.
	allPaths := path withParents.
	
	self assert: allPaths size equals: 3.
	self assert: allPaths first basename equals: 'plonk'.
	self assert: allPaths first size equals: 1.
	self assert: allPaths second basename equals: 'griffle'.
	self assert: allPaths second size equals: 2.
	self assert: (allPaths second isChildOf: allPaths first).
	self assert: allPaths third basename equals: 'nurb'.
	self assert: allPaths third size equals: 3.
	self assert: (allPaths third isChildOf: allPaths second).
	self assert: allPaths third == path
%

category: 'tests'
method: PathTest
testResolveAbsolute
	| path |
	path := Path / 'griffle'.
	self assert: path resolve == path.
	self assert: path isAbsolute
%

category: 'tests'
method: PathTest
testResolvePath
		
	| path |
	path := Path / 'grandfather' / 'father' / 'child'.
	self 
		assert: (path resolvePath: Path / 'grandfather') 
		equals: (Path / 'grandfather').
	self 
		assert: (path resolvePath: Path / 'child')
		equals: (Path / 'child').
	self
		assert: (path resolvePath: Path * 'grandfather')
		equals: (Path / 'grandfather' / 'father' / 'child' / 'grandfather').
	self
		assert: (path resolvePath: Path * 'child')
		equals: (Path / 'grandfather' / 'father' / 'child' / 'child').
	self
		assert: (path resolvePath: Path * 'grandfather')
		equals: (Path / 'grandfather' / 'father' / 'child' / 'grandfather').
	self
		assert: (path resolvePath: Path * 'child')
		equals: (Path / 'grandfather' / 'father' / 'child' / 'child').
	self
		assert:  (path resolvePath: (Path parent) / '..') canonicalize
		equals: (Path / 'grandfather')
%

category: 'tests'
method: PathTest
testResolveRelative
	| path |
	path := Path * 'griffle'.
	self assert: path resolve == path.
	self assert: path isRelative
%

category: 'tests'
method: PathTest
testResolveString	

	| path result |
	path := Path * 'plonk'.
	result := path resolve: 'griffle'.
	self assert: result class equals: path class.
	self assert: result size equals: 2.
	self assert: (result at: 1) equals: 'plonk'.
	self assert: (result at: 2) equals: 'griffle'.
%

category: 'tests'
method: PathTest
testRootParent
	| root |
	root := Path root.
	self assert: root parent == root
%

category: 'tests'
method: PathTest
testRootPrintString
	| path actual |
	path := Path root.
	actual := path printString.
	self assert: actual equals: 'Path root'
%

category: 'tests'
method: PathTest
testSiblingOfPath
	| griffle  nurb |
	griffle := Path / 'griffle'.
	nurb := Path / 'nurb'.
	self deny: (griffle isChildOf: nurb).
	self deny: (nurb isChildOf: griffle).
%

category: 'tests'
method: PathTest
testSimpleResolution
	| base relative absolute |
	base := Path / 'plonk'.
	relative := (Path * 'griffle') / 'zonk'.
	absolute := base resolve: relative.
	self assert: absolute isAbsolute.
	self assert: (absolute at: 1) equals: 'plonk'.
	self assert: (absolute at: 2) equals: 'griffle'.
	self assert: (absolute at: 3) equals: 'zonk'.
%

category: 'tests'
method: PathTest
testSlash
	| path actual |
	path := Path * 'plonk'.
	actual := path / 'griffle'.
	self assert: actual class equals: path class.
	self assert: (actual printWithDelimiter: $/) equals: 'plonk/griffle'
%

category: 'test-conversion-from-string'
method: PathTest
testStringAsPath
	"Ensure various string classes can be converted to path."

	| strings |
	strings := {
		'/'.
		'/', (Character codePoint: 16r05D0).
		'/', (Character codePoint: 16r2A6A5).
	}.
	String isInUnicodeComparisonMode
		ifTrue:
			[strings
				add: '/' asUnicodeString;
				add: '/' asUnicodeString, (Character codePoint: 16r05D0);
				add: '/' asUnicodeString, (Character codePoint: 16r2A6A5)].
	strings
		do:
			[:string | | path |
			path := string asPath.
			self
				assert: path
				isKindOf: Path.
			self
				assert: path pathString
				equals: string]
%

category: 'tests'
method: PathTest
testUnequalContent
	| a b |
	a := Path * 'plonk'.
	b := Path * 'griffle'.
	self deny: a = b.
%

category: 'tests'
method: PathTest
testUnequalSize
	| a b |
	a := Path * 'plonk'.
	b := (Path * 'plonk') / 'griffle'.
	self deny: a = b.
%

category: 'tests'
method: PathTest
testUnixAbsolutePathName

	self assert: (Path from: '/test') isAbsolute.
	self assert: (Path from: '/etc/bin') isAbsolute.
%

category: 'tests'
method: PathTest
testWindowsAbsolutePathName
  
	self assert: (Path from: 'A:\') isAbsolute.
	self assert: (Path from: 'c:\') isAbsolute.
	self assert: (Path from: 'c:\test') isAbsolute.
%

category: 'tests-class side'
method: PathTest
testWith
	"Ensure we always get a concrete subclass of Path"

	| instance |
	self
		should: [Path with: '/hello/world']
		raise: Error.
	self
		should: [Path with: 'hello/world']
		raise: Error.

	instance := AbsolutePath with: '/hello/world'.
	self
		assert: instance class
		equals: AbsolutePath.
	self
		assert: instance pathString
		equals: '/hello/world'.
	instance := AbsolutePath with: 'hello/world'.
	self
		assert: instance class
		equals: AbsolutePath.
	self
		assert: instance pathString
		equals: '/hello/world'.

	instance := RelativePath with: '/hello/world'.
	self
		assert: instance class
		equals: RelativePath.
	self
		assert: instance pathString
		equals: 'hello/world'.
	instance := RelativePath with: 'hello/world'.
	self
		assert: instance class
		equals: RelativePath.
	self
		assert: instance pathString
		equals: 'hello/world'.
%

category: 'tests-class side'
method: PathTest
testWithAll
	"Ensure we always get a concrete subclass of Path"

	| components instance |
	components := #( 'hello' 'world' ).

	self
		should: [Path withAll: components]
		raise: Error.

	instance := AbsolutePath withAll: components.
	self
		assert: instance class
		equals: AbsolutePath.
	self
		assert: instance pathString
		equals: '/hello/world'.

	instance := RelativePath withAll: components.
	self
		assert: instance class
		equals: RelativePath.
	self
		assert: instance pathString
		equals: 'hello/world'.
%

category: 'tests'
method: PathTest
testWithExtentionAddsExtension
	| path result |
	path := Path * 'plonk'.
	result := path withExtension: 'griffle'.
	self assert: result basename equals: 'plonk.griffle'
%

category: 'tests'
method: PathTest
testWithExtentionReplacesExtension
	| path result |
	path := Path * 'plonk.griffle'.
	result := path withExtension: 'griffle'.
	self assert: result basename equals: 'plonk.griffle'
%

category: 'tests'
method: PathTest
testWorkingDirectoryParent
	| path |
	path := Path workingDirectory parent.
	self assert: path size equals: 1.
	self assert: (path at: 1) equals: '..'
%

category: 'tests'
method: PathTest
testWorkingDirPrintString
	| path actual |
	path := Path workingDirectory. 
	actual := path printString.
	self assert: actual equals: 'Path workingDirectory'
%

! Class implementation for 'ZnAbstractCharacterEncoderTests'

!		Class methods for 'ZnAbstractCharacterEncoderTests'

category: 'accessing'
classmethod: ZnAbstractCharacterEncoderTests
asciiCharacterSource
	^ ($A to: $Z), ($a to: $z), ($0 to: $9), '.-_/*+=|,;?!$&<>^%#', '    '
%

category: 'Testing'
classmethod: ZnAbstractCharacterEncoderTests
isAbstract
  "Override to true if a TestCase subclass is Abstract and should not have
	TestCase instances built from it"

  ^ self sunitName = #'ZnAbstractCharacterEncoderTests'
%

category: 'accessing'
classmethod: ZnAbstractCharacterEncoderTests
latin1CharacterSource
	^ ($A to: $Z), ($a to: $z), ($0 to: $9), '.-_/*+=|,;?!$&<>^%#', '       ', 'éèçüäßñ'
%

category: 'accessing'
classmethod: ZnAbstractCharacterEncoderTests
stringOfSize: size fromSource: source
	"self stringOfSize: 1024 fromSource: self unicodeCharacterSource"
	
	^ String new: size streamContents: [ :out | 
		size timesRepeat: [ out nextPut: source atRandom ] ]
%

category: 'accessing'
classmethod: ZnAbstractCharacterEncoderTests
unicodeCharacterSource
	^ ($A to: $Z), ($a to: $z), ($0 to: $9), '.-_/*+=|,;?!$&<>^%#', '         ', 'éèçüäßñα', '€∏'
%

!		Instance methods for 'ZnAbstractCharacterEncoderTests'

category: 'public'
method: ZnAbstractCharacterEncoderTests
assert: anObject unicodeEquals: otherObj
	"allow comparison of unicode and legacy strings"

	self
		assert: (anObject _unicodeEqual: otherObj)
		description: anObject printString , ' is not equal to ' , otherObj printString.	
%

category: 'public'
method: ZnAbstractCharacterEncoderTests
assertCharacterCollection: anObject equals: otherObj
	"allow comparison between unitcode and legacy strings in legacy mode"

	self
		assert: (anObject isEquivalent: otherObj)
		description: anObject printString , ' is not equal to ' , otherObj printString.
%

category: 'private'
method: ZnAbstractCharacterEncoderTests
decodeBytes: bytes with: encoder
	self subclassResponsibility
%

category: 'private'
method: ZnAbstractCharacterEncoderTests
encodeString: string with: encoder
"
	^ ByteArray streamContents: [ :stream |
		stream nextPutAll: string encodeAsUTF8 ]
"

	^ ByteArray streamContents: [ :stream |
		string do: [ :each |
			encoder nextPut: each toStream: stream ] ]
%

category: 'testing'
method: ZnAbstractCharacterEncoderTests
testCodePointEncodingDecoding
	| encoder input output |
	input := {}.
	'Düsseldorf Königsallee' do: [:each | input add: each codePoint ].
	self assert: input isCollection.
	self assert: (input allSatisfy: [:each | each _isInteger ]).
	#(utf8 ) do: [ :each |
		encoder := each asZnCharacterEncoder.
		output := encoder encodeCodePoints: input.
		self assert: output isCollection.
		self assert: (output allSatisfy: [ :e | e _isInteger and: [ e between: 0 and: 255 ] ] ).
		self assert: (encoder encodedByteCountForCodePoints: input) equals: output size.
		self assert: (encoder decodeAsCodePoints: output) equals: input ]
%

category: 'testing'
method: ZnAbstractCharacterEncoderTests
testConvencienceMethods
	| encoder string |
	encoder := ZnUTF8Encoder new.
	string := 'élève en Français'.
	self assertCharacterCollection: (encoder decodeBytes: (encoder encodeString: string)) equals: string.
	self assert: (encoder encodedByteCountForString: string) = 20.
	
	#( 'ccc' 'ççç' 'c' 'ç' 'çc' 'cç' ) do: [ :each |
		self assertCharacterCollection: (encoder decodeBytes: (encoder encodeString: each)) equals: each ]
%

category: 'testing'
method: ZnAbstractCharacterEncoderTests
testEquality

	| e1 e2 |
	e1 := self _encoder.
	e2 := self _encoder.
	self
		assert: e1
		equals: e2.
	self
		deny: e1
		identical: e2
%

category: 'testing'
method: ZnAbstractCharacterEncoderTests
testFlushOnClose

	| mock stream |
	mock := FsMockStream new.
	stream := ZnCharacterWriteStream
		on: mock
		encoder: self _encoder.
	self assert: mock actionSequence isEmpty.
	stream close.
	self
		assert: mock actionSequence
		equals: { {#flush}. {#close} }
%

category: 'testing'
method: ZnAbstractCharacterEncoderTests
testHash

	| e1 e2 |
	e1 := self _encoder.
	e2 := self _encoder.
	self
		assert: e1 hash
		equals: e2 hash.
	self
		deny: e1
		identical: e2
%

category: 'testing'
method: ZnAbstractCharacterEncoderTests
testKnownEncodingIdentifiers
	| all minimal asciiString |
	all := ZnCharacterEncoder knownEncodingIdentifiers asSet.
	minimal := #(utf8) asSet.
	"make sure at least a minimal set is present"
	self assert: (all  select: [ :each | minimal includes: each ]) equals: minimal.
	asciiString := String withAll: ((($a asciiValue to: $z asciiValue) , 
		($A asciiValue to: $Z asciiValue) , ($0 asciiValue to: $9 asciiValue)) collect: [:each | Character codePoint: each ]).
	"make sure that each identifier can be used to instanciate a decoder,
	and that those decoders at least work on a ASCII string in both directions"
	all do: [ :each |
		| encoder bytes |
		encoder := ZnCharacterEncoder newForEncoding: each.
		bytes := encoder encodeString: asciiString.
		self assert: ((encoder decodeBytes: bytes) isEquivalent: asciiString) ]
%

category: 'testing'
method: ZnAbstractCharacterEncoderTests
testNextPutAllStartingAtToStream
	| encoder |
	encoder := ZnUTF8Encoder new.
	#( 'ccc' 'ççç' 'c' 'ç' 'çc' 'cç' 'çç' ) do: [ :each |
		#( ( '' '' ) ( 'ABC' '' ) ( '' 'ABC' ) ( 'ABC' 'ABC' ) 
			( 'AéC' '' ) ( '' 'AèC' ) ( 'AéC' 'AèC' ) 
			( 'AXC' 'AèC' ) ( 'AéC' 'AXC' ) 
			( 'PRE' 'ç' ) ) do: [ :extra |
				| prefix postfix string bytes |
				prefix := extra first.
				postfix := extra last.
				string := prefix, each, postfix.
				bytes := ByteArray streamContents: [ :out |
					encoder next: each size putAll: string startingAt: prefix size + 1 toStream: out ].
				self assertCharacterCollection: (encoder decodeBytes: bytes) equals: each ] ]
%

category: 'testing'
method: ZnAbstractCharacterEncoderTests
testReadIntoStartingAtCountFromStream
	| encoder |
	encoder := ZnUTF8Encoder new.
	#( 'ccc' 'ççç' 'c' 'ç' 'çc' 'cç' 'çç' ) do: [ :each |
		#( ( '' '' ) ( 'ABC' '' ) ( '' 'ABC' ) ( 'ABC' 'ABC' ) 
			( 'AéC' '' ) ( '' 'AèC' ) ( 'AéC' 'AèC' ) 
			( 'AXC' 'AèC' ) ( 'AéC' 'AXC' ) 
			( 'PRE' 'ç' ) ) do: [ :extra |
				| prefix postfix string bytes buffer read |
				prefix := extra first.
				postfix := extra last.
				string := prefix, each.
				bytes := encoder encodeString: string, postfix.
				buffer := String new: string size.
				read := encoder readInto: buffer startingAt: 1 count: string size fromStream: bytes readStream.
				self assert: buffer equals: string.
				self assert: read equals: string size ] ]
%

category: 'testing'
method: ZnAbstractCharacterEncoderTests
testReadIntoStartingAtCountFromStreamAtEnd
	| input encoder bytes readStream string read |
	encoder := ZnUTF8Encoder new.
	input := 'élève'.
	bytes := encoder encodeString: input.
	readStream := bytes readStream.
	string := (String new: 5) atAllPut: $_; yourself.
	read := encoder readInto: string startingAt: 1 count: 10 fromStream: readStream.
	self assert: string equals: input.
	self assert: read equals: 5
%

category: 'testing'
method: ZnAbstractCharacterEncoderTests
testReadIntoStartingAtCountFromStreamWithOffset
	| input encoder bytes readStream string read |
	encoder := ZnUTF8Encoder new.
	input := '_élève_'.
	bytes := encoder encodeString: input.
	readStream := bytes readStream.
	readStream next.
	string := (String new: 7) atAllPut: $_; yourself.
	read := encoder readInto: string startingAt: 2 count: 5 fromStream: readStream.
	self assertCharacterCollection: string equals: input.
	self assert: read equals: 5.
	input := '_Français_'.
	bytes := encoder encodeString: input.
	readStream := bytes readStream.
	readStream next.
	string := (String new: 10) atAllPut: $_; yourself.
	read := encoder readInto: string startingAt: 2 count: 8 fromStream: readStream.
	self assert: string equals: input.
	self assert: read equals: 8
%

category: 'testing'
method: ZnAbstractCharacterEncoderTests
testStringEncoding
	| encoder string |
	encoder := ZnUTF8Encoder new.
	string := 'élève en Français'.
	self assert: (string encodeWith: encoder) equals: (encoder encodeString: string).
	self assert: (string encodeWith: #utf8) equals: (encoder encodeString: string).
	self assert: string encodeAsUTF8 asByteArray equals: (encoder encodeString: string)
%

category: 'testing'
method: ZnAbstractCharacterEncoderTests
testUTF8Back
	| encoder stream |
	encoder := ZnUTF8Encoder new.
	stream := (encoder encodeString: 'Les élèves Françaises') readStream.
	self should: [ encoder backOnStream: stream ] raise: Error.
	4 timesRepeat: [ encoder nextFromStream: stream ].
	self assert: (encoder nextFromStream: stream) equals: $é.
	encoder backOnStream: stream.
	self assert: (encoder nextFromStream: stream) equals: $é.
	10 timesRepeat: [ encoder nextFromStream: stream ].
	13 timesRepeat: [ encoder backOnStream: stream ].
	self assert: (encoder nextFromStream: stream) equals: $s
%

category: 'testing'
method: ZnAbstractCharacterEncoderTests
testUTF8Boundaries
	"Test encoding and decoding of the characters at the boundaries between 1, 2, 3, and 4 multi-byte sequences.
	Values taken from http://en.wikipedia.org/wiki/Utf8#Description with the new RFC 3629 limit"
	
	| utf8Encoder string encoded |
	utf8Encoder := ZnUTF8Encoder new.
	#( (0 16r7f) 
		(16r80 16r07FF) 
		(16r0800 16rFFFF) 
		(16r10000 16r10FFFF) 
	) doWithIndex: [ :boundaries :byteCount |
		boundaries do: [ :each |
			string := String with: each asCharacter.
			encoded := utf8Encoder encodeString: string. 
			self assertCharacterCollection: (utf8Encoder decodeBytes: encoded) equals: string.
			self assert: encoded size equals: byteCount ] ]
%

category: 'testing'
method: ZnAbstractCharacterEncoderTests
testUTF8Encoder
	"The examples are taken from http://en.wikipedia.org/wiki/UTF-8#Description"
	
	| encoder inputBytes outputBytes inputString outputString |
	encoder := ZnUTF8Encoder new.
	inputString := String with: $$ with: (16r00A2 asCharacter) with: (16r20AC asCharacter) with: (16r024B62 asCharacter).
	inputBytes := #(16r24 16rC2 16rA2 16rE2 16r82 16rAC 16rF0 16rA4 16rAD 16rA2) asByteArray.
	outputBytes := self encodeString: inputString with: encoder.
	self assert: outputBytes = inputBytes.
	outputString := self decodeBytes: inputBytes with: encoder.
	self assertCharacterCollection: outputString equals: inputString
%

category: 'testing'
method: ZnAbstractCharacterEncoderTests
testUTF8EncoderAuto
	| encoder inputString bytes outputString |
	encoder := ZnUTF8Encoder new.
	inputString := String withAll: ((1 to: 3072) collect: [ :each | Character codePoint: each ]).
	bytes := self encodeString: inputString with: encoder. 
	outputString := self decodeBytes: bytes with: encoder.
	self assertCharacterCollection: inputString equals: outputString
%

category: 'testing'
method: ZnAbstractCharacterEncoderTests
testUTF8EncoderByteCount	
	| encoder |
	encoder := ZnUTF8Encoder new.
	self assert: (encoder encodedByteCountFor: $$) = 1.
	self assert: (encoder encodedByteCountFor: (16r00A2 asCharacter)) = 2.
	self assert: (encoder encodedByteCountFor: (16r20AC asCharacter)) = 3.
	self assert: (encoder encodedByteCountFor: (16r024B62 asCharacter)) = 4
%

category: 'testing'
method: ZnAbstractCharacterEncoderTests
testUTF8EncoderWide
	| encoder |
	encoder := ZnUTF8Encoder new.
	{ 'abc'. 'élève en Français'. 'Pra-ská' copy at: 4 put: (Character codePoint: 382); yourself. '' }
		do: [ :each | | bytes |
			bytes := self encodeString: each with: encoder. 
			self assertCharacterCollection: (encoder decodeBytes: bytes) equals: each ]
%

category: 'private'
method: ZnAbstractCharacterEncoderTests
_encoder
	"Return a new instance of the associated encoder."

	self subclassResponsibility
%

category: 'private'
method: ZnAbstractCharacterEncoderTests
_encoderId
		self subclassResponsibility
%

category: 'private'
method: ZnAbstractCharacterEncoderTests
_sourceClass
	^ String isInUnicodeComparisonMode
		ifTrue: [ Unicode7 ]
		ifFalse: [ String ]
%

! Class implementation for 'Zn8BITCharacterEncoderTests'

!		Instance methods for 'Zn8BITCharacterEncoderTests'

category: 'private'
method: Zn8BITCharacterEncoderTests
decodeBytes: bytes with: encoder
	| input |
	input := bytes readStream.
	^ String streamContents: [ :stream |
		[ input atEnd ] whileFalse: [ 
			stream nextPut: (encoder nextFromStream: input) ] ]
%

category: 'testing'
method: Zn8BITCharacterEncoderTests
testByteEncoding
	| encoder bytes string |
	encoder := self _encoder.
	string := '123AbC', (Character codePoint: 128), (Character codePoint: 255), (Character codePoint: 150), (Character codePoint: 192), (Character codePoint: 224).
	bytes := encoder encodeString: string. 
	self assert: (bytes decodeWith: encoder) equals: (encoder decodeBytes: bytes).
	self assert: (bytes decodeWith: self _encoderId) equals: (encoder decodeBytes: bytes).
	self assert: (String withBytes: bytes) equals: string.
	self assert: string asByteArray equals: bytes.
%

category: 'private'
method: Zn8BITCharacterEncoderTests
_encoder
	^ Zn8BITEncoder new stringClass: self _sourceClass
%

category: 'private'
method: Zn8BITCharacterEncoderTests
_encoderId
	^ #'8bit'
%

! Class implementation for 'ZnUTF8CharacterEncoderTests'

!		Instance methods for 'ZnUTF8CharacterEncoderTests'

category: 'private'
method: ZnUTF8CharacterEncoderTests
decodeBytes: bytes with: encoder
	| input |
	input := bytes readStream.
	^ String streamContents: [ :stream |
		[ input atEnd ] whileFalse: [ 
			stream nextPut: (encoder nextFromStream: input) ] ]
%

category: 'private'
method: ZnUTF8CharacterEncoderTests
_encoder
	^ ZnUTF8Encoder new stringClass: self _sourceClass
%

category: 'private'
method: ZnUTF8CharacterEncoderTests
_encoderId
	^ #utf8
%

! Class implementation for 'ZnAbstractCharacterStreamTests'

!		Class methods for 'ZnAbstractCharacterStreamTests'

category: 'Testing'
classmethod: ZnAbstractCharacterStreamTests
isAbstract
  "Override to true if a TestCase subclass is Abstract and should not have
	TestCase instances built from it"

  ^ self sunitName = #'ZnAbstractCharacterStreamTests'
%

!		Instance methods for 'ZnAbstractCharacterStreamTests'

category: 'testing'
method: ZnAbstractCharacterStreamTests
assertUpTo: theArray
	| array encodingStream |
	array := self convertStringsToStringClass: theArray.
	self assert: (array first readStream upTo: array second) equals: array third.
	({String . Unicode7} includes: (array at: 1) class)
		ifTrue: [ 
			encodingStream := self eightBitReadStreamOn: array first.
			self assert: (encodingStream upTo: array second) equals: array third ].
	encodingStream := self utf8ReadStreamOn: array first.
	self assert: (encodingStream upTo: array second) equals: array third
%

category: 'testing'
method: ZnAbstractCharacterStreamTests
assertUpToAll: theArray
	| array encodingStream |
	array := self convertStringsToStringClass: theArray.
	self assert: (array first readStream upToAll: array second) equals: array third.
	({String.
	Unicode7} includes: (array at: 1) class)
		ifTrue: [ 
			encodingStream := self eightBitReadStreamOn: array first.
			self assert: (encodingStream upToAll: array second) equals: array third ].
	encodingStream := self utf8ReadStreamOn: array first.
	self assert: (encodingStream upToAll: array second) equals: array third
%

category: 'private'
method: ZnAbstractCharacterStreamTests
convertStringsToStringClass: theArray
	^ theArray
		collect: [ :str | 
			str class == Character
				ifTrue: [ str ]
				ifFalse: [ 
					self stringClass == Unicode7
						ifTrue: [ (str encodeWith: #utf8) decodeFromUTF8 ]
						ifFalse: [ str asString ] ] ]
%

category: 'private'
method: ZnAbstractCharacterStreamTests
convertStringToStringClass: aString
	^ self stringClass == Unicode7
		ifTrue: [ (aString encodeWith: #utf8) decodeFromUTF8 ]
		ifFalse: [ aString asString ]
%

category: 'testing'
method: ZnAbstractCharacterStreamTests
eightBitReadStreamOn: string
	| bytes stream |
	bytes := Zn8BITEncoder new
		stringClass: self stringClass;
		encodeString: string.
	stream := ZnBufferedReadStream
		on:
			(ZnCharacterReadStream
				on: bytes readStreamPortable
				encoding: #'8bit'
				stringClass: self stringClass).
	stream sizeBuffer: string size.
	^ stream
%

category: 'private'
method: ZnAbstractCharacterStreamTests
stringClass
	^ self subclassResponsibility
%

category: 'testing'
method: ZnAbstractCharacterStreamTests
test8BitEncodingStreamPositionForString
	| string char bytes stream res |
	string := 'eißendeße'.
	char := $ß.
	bytes := Zn8BITEncoder new 
		stringClass: self stringClass;
		encodeString: string.
	stream := ZnCharacterReadStream 
		on: bytes readStreamPortable
		encoding: #'8bit'
		stringClass: self stringClass.
	res := stream next; next; next.
	self assert: res equals: char.
	self assert: stream position equals: 3.
%

category: 'testing'
method: ZnAbstractCharacterStreamTests
testNextLine
	| stream |
	stream := ZnCharacterReadStream on: 'abc' asByteArray readStreamPortable.
	self assert: stream nextLine equals: 'abc'.
	self assert: stream nextLine  equals: nil.
	stream := ZnCharacterReadStream on: '' asByteArray readStreamPortable.
	self assert: stream nextLine equals: nil.
	stream := ZnCharacterReadStream on: (String withAll: { 
		$a. Character cr. 
		$b. Character lf. 
		$c }) asByteArray readStreamPortable.
	self assert: stream nextLine equals: 'a'.
	self assert: stream nextLine equals: 'b'.
	self assert: stream nextLine equals: 'c'.
	self assert: stream nextLine equals: nil.
	stream := ZnCharacterReadStream on: (String withAll:{ 
		$a. Character cr. Character lf.  
		$b. Character cr. Character lf. 
		$c. Character cr. Character lf }) asByteArray readStreamPortable.
	self assert: stream nextLine equals: 'a'.
	self assert: stream nextLine equals: 'b'.
	self assert: stream nextLine equals: 'c'.
	self assert: stream nextLine equals: nil.
	stream := ZnCharacterReadStream on: (String withAll: { 
		$a. Character cr. Character lf.  
		Character cr. Character lf. 
		$c. Character cr. Character lf }) asByteArray readStreamPortable.
	self assert: stream nextLine equals: 'a'.
	self assert: stream nextLine equals: ''.
	self assert: stream nextLine equals: 'c'.
	self assert: stream nextLine equals: nil.
%

category: 'testing'
method: ZnAbstractCharacterStreamTests
testPeek
	| string bytes readStream |
	string := 'élève en Français'.
	bytes := ZnUTF8Encoder new encodeString: string.
	readStream := ZnBufferedReadStream on: (ZnCharacterReadStream on: bytes readStreamPortable).
	self assert: readStream peek equals: 'é' first.
	self assert: readStream peek equals: 'é' first.
	self assert: readStream next equals: 'é' first.
	readStream skip: 'lève ' size.
	self assert: readStream peek equals: $e.
	self assert: (readStream next: 'en Français' size) equals: 'en Français'
%

category: 'testing'
method: ZnAbstractCharacterStreamTests
testReadStream
	| stream |
	stream := ZnBufferedReadStream on: (ZnCharacterReadStream on: 'ABC' asByteArray readStreamPortable).
	stream sizeBuffer: 3.
	self deny: stream atEnd.
	self deny: stream isBinary.
	self assert: stream next = $A.
	self deny: stream atEnd.
	self assert: stream peek = $B.
	self deny: stream atEnd.
	self assert: stream peek = $B.
	self deny: stream atEnd.
	self assert: stream next = $B.
	self deny: stream atEnd.
	self assert: stream next = $C.
	self assert: stream atEnd.
	self assert: stream next isNil.
	self assert: stream peek isNil
%

category: 'testing'
method: ZnAbstractCharacterStreamTests
testReadUpTo
	| string |
	string := self convertStringToStringClass: '0123456789'.
	{(self eightBitReadStreamOn: string).
	(self utf8ReadStreamOn: string)}
		do: [ :stream | 
			self assert: (stream upTo: $5) equals: (self convertStringToStringClass: '01234').
			self assert: stream upToEnd equals: (self convertStringToStringClass: '6789').
			self assert: stream atEnd ]
%

category: 'testing'
method: ZnAbstractCharacterStreamTests
testSimpleUTF8ReadStream
	| string bytes stream |
	string := 'élève en Français'.
	bytes := ZnUTF8Encoder new encodeString: string.
	stream := ZnBufferedReadStream on: (ZnCharacterReadStream on: bytes readStreamPortable).
	stream sizeBuffer: string size.
	self 
		assert:stream upToEnd
		equals: string
%

category: 'testing'
method: ZnAbstractCharacterStreamTests
testSimpleUTF8WriteStream
	| string bytes stream |
	string := 'élève en Français'.
	bytes := ZnUTF8Encoder new encodeString: string.
	stream := (ZnCharacterWriteStream on: ByteArray new writeStreamPortable).
	stream nextPutAll: string.
	self 
		assert: stream wrappedStream contents
		equals: bytes asByteArray
%

category: 'testing'
method: ZnAbstractCharacterStreamTests
testUpTo
	| char1 char2 string1 string2 |
	char1 := (Character codePoint: 257). 
	string1 := self convertStringToStringClass:  '', char1. "DoubleByteString"
	char2 := (Character codePoint:16rffff1).
	string2 :=  self convertStringToStringClass: '', char2. "QuadByteString"
	{
		"extended ASCII String"
		{''     . $ß . ''   } .
		{'ß'    . $ß . ''   } .
		{'ße'   . $ß . ''   } .
		{'ß'    . $e . 'ß'  } .
		{'ße'   . $e . 'ß'  } .
		{'ßen'  . $e . 'ß'  } .
		{'ißen' . $e . 'iß' } .
		{'iß'   . $ß . 'i'  } .
		{'iße'  . $ß . 'i'  } .

		"DoubleByteString"
		{''                 . char1 . ''           } .
		{string1            . char1 . ''           } .
		{(string1, 'e')     . char1 . ''           } .
		{string1            . $e    . string1      } .
		{(string1, 'e')     . $e    . string1      } .
		{(string1, 'en')    . $e    . string1      } .
		{'i', string1, 'en' . $e    . 'i', string1 } .
		{'i', string1       . char1 . 'i'          } .
		{'i', string1, 'e'  . char1 . 'i'          } .

		"QuadByteString"
		{''                 . char2 . ''           } .
		{string2            . char2 . ''           } .
		{(string2, 'e')     . char2 . ''           } .
		{string2            . $e    . string2      } .
		{(string2, 'e')     . $e    . string2      } .
		{(string2, 'en')    . $e    . string2      } .
		{'i', string2, 'en' . $e    . 'i', string2 }.
		{'i', string2       . char2 . 'i'          } .
		{'i', string2, 'e'  . char2 . 'i'          } .

		"ASCII String"
		{'a'   . $a . ''    } .
		{'a'   . $b . 'a'   } .
		{'ab'  . $a . ''    } .
		{'ab'  . $b . 'a'   } .
		{'ab'  . $c . 'ab'  } .
		{'abc' . $a . ''    } .
		{'abc' . $b . 'a'   } .
		{'abc' . $c . 'ab'  } .
		{'abc' . $d . 'abc' } .
	} do: [ :array | self assertUpTo: array ]
%

category: 'testing'
method: ZnAbstractCharacterStreamTests
testUpToAll
	#(
		('' '' '')
		('a' '' '')
		('a' 'a' '')
		('a' 'b' 'a')
		('ab' '' '')
		('ab' 'a' '')
		('ab' 'b' 'a')
		('ab' 'c' 'ab')
		('ab' 'ab' '')
		('abc' '' '')
		('abc' 'a' '')
		('abc' 'b' 'a')
		('abc' 'c' 'ab')
		('abc' 'd' 'abc')
		('abc' 'ab' '')
		('abc' 'bc' 'a')
		('abc' 'cd' 'abc')
		('' 'ß' '')
		('' 'ße' '')
		('ß' '' '')
		('ße' '' '')
		('ß' 'ß' '')
		('ße' 'ß' '')
		('ß' 'ße' 'ß')
		('ß' 'e' 'ß')
		('ße' 'e' 'ß')
		('ßen' 'e' 'ß')
		('ßen' 'en' 'ß')
		('ßend' 'en' 'ß')
		('iße' 'e' 'iß')
		('ißen' 'e' 'iß')
		('ißen' 'en' 'iß')
		('ißend' 'en' 'iß')
		('iß' 'ß' 'i')
		('iße' 'ß' 'i')
		('eißen' 'ße' 'ei')
		('eißen' 'ßend' 'eißen')
		('eißendeße' 'ße' 'ei')
		('abcdefgh' 'cd' 'ab')
	) do: [ :array | self assertUpToAll: array ]
%

category: 'testing'
method: ZnAbstractCharacterStreamTests
testUpToAllTwice
	| string utf8Stream stream eightBitStream a b use8BitStream |

	string := self convertStringToStringClass: 'eißendeße'.
	use8BitStream := {String . Unicode7} includes: string class.

	stream :=  string readStreamPortable.
	use8BitStream ifTrue: [ eightBitStream := self eightBitReadStreamOn: string ].
	utf8Stream := self utf8ReadStreamOn: string.

	self assert: (stream upToAll: (self convertStringToStringClass: 'ße')) equals: (self convertStringToStringClass: 'ei').
	use8BitStream ifTrue: [ self assert: (eightBitStream upToAll: (self convertStringToStringClass: 'ße')) equals: (self convertStringToStringClass: 'ei') ].
	self assert: (utf8Stream upToAll: (self convertStringToStringClass:'ße')) equals: (self convertStringToStringClass: 'ei').

	self assert: (stream upToAll: (self convertStringToStringClass:'ße')) equals: (self convertStringToStringClass: 'nde').
	use8BitStream ifTrue: [ self assert: (eightBitStream upToAll: (self convertStringToStringClass:'ße')) equals: (self convertStringToStringClass: 'nde') ].
	self assert: (utf8Stream upToAll: (self convertStringToStringClass:'ße')) equals: (self convertStringToStringClass: 'nde').

  self stringClass == Unicode7
    ifFalse:
      [a := (self convertStringToStringClass: 'ABC'), (Character codePoint: 128), (Character codePoint: 255).
      b := (self convertStringToStringClass: ''), (Character codePoint: 150), (Character codePoint: 192), (Character codePoint: 224).
      eightBitStream := self eightBitReadStreamOn: ( a, (self convertStringToStringClass: '123'), b, (self convertStringToStringClass: '123')).
      self assert: (eightBitStream upToAll: (self convertStringToStringClass: '123')) equals: a.
      self assert: (eightBitStream upToAll: (self convertStringToStringClass: '123')) equals: b].
%

category: 'testing'
method: ZnAbstractCharacterStreamTests
testUTF8ReadStreamReadInto
	| string bytes stream buffer |
	string := 'élève en Français'.
	bytes := ZnUTF8Encoder new encodeString: string.
	stream := ZnBufferedReadStream on: (ZnCharacterReadStream on: bytes readStreamPortable).
	stream sizeBuffer: string size.
	buffer := String new: string size.
	stream next: string size into: buffer. 
	self assert: buffer equals: string.
	self assert: stream atEnd.
	string := 'Czech in Czech is ', 269 asCharacter asString ,'e', 353 asCharacter asString , 'tina.'.
	bytes := ZnUTF8Encoder new encodeString: string.
	stream := ZnBufferedReadStream on: (ZnCharacterReadStream on: bytes readStreamPortable).
	stream sizeBuffer: string size.
	buffer := String new: string size.
	stream next: string size into: buffer. 
	self assert: buffer equals: string.
	self assert: stream atEnd
%

category: 'testing'
method: ZnAbstractCharacterStreamTests
utf8ReadStreamOn: string
	| bytes stream |
	bytes := ZnUTF8Encoder new
		stringClass: self stringClass;
		encodeString: string.
	stream := ZnBufferedReadStream
		on:
			(ZnCharacterReadStream
				on: bytes readStreamPortable
				encoding: #'utf8'
				stringClass: self stringClass).
	stream sizeBuffer: string size.
	^ stream
%

! Class implementation for 'ZnLegacyCharacterStreamTests'

!		Instance methods for 'ZnLegacyCharacterStreamTests'

category: 'private'
method: ZnLegacyCharacterStreamTests
stringClass
	^ String
%

! Class implementation for 'ZnUnicodeCharacterStreamTests'

!		Instance methods for 'ZnUnicodeCharacterStreamTests'

category: 'private'
method: ZnUnicodeCharacterStreamTests
stringClass
	^ Unicode7
%

! Class implementation for 'ZnBufferedReadStreamTests'

!		Instance methods for 'ZnBufferedReadStreamTests'

category: 'testing'
method: ZnBufferedReadStreamTests
testBuffering
	| stream |
	stream := ZnBufferedReadStream on: '01234567890123456789' readStreamPortable.
	stream sizeBuffer: 8.
	self deny: stream atEnd.
	self assert: (stream next: 10) equals: '0123456789'.
	self deny: stream atEnd.
	self assert: (stream next: 10) equals: '0123456789'.
	self assert: stream atEnd	
%

category: 'testing'
method: ZnBufferedReadStreamTests
testPeek
	| stream |
	stream := ZnBufferedReadStream on: '0123456789' readStreamPortable.
	stream sizeBuffer: 8.
	'0123456789' do: [ :each |
		self deny: stream atEnd.
		self assert: stream peek equals: each.
		self assert: stream next equals: each ].
	self assert: stream atEnd.
	self assert: stream peek isNil.
	self assert: stream next isNil
%

category: 'testing'
method: ZnBufferedReadStreamTests
testReadInto
	| stream buffer count |
	stream := ZnBufferedReadStream on: '0123456789' readStreamPortable.
	stream sizeBuffer: 8.
	buffer := (String new: 6) atAllPut: Character space; yourself.
	stream skip: 1.
	stream readInto: buffer startingAt: 4 count: 3.
	self assert: buffer equals: '   123'.
	stream readInto: buffer startingAt: 1 count: 3.
	self assert: buffer equals: '456123'.
	count := stream readInto: buffer startingAt: 1 count: 100.
	self assert: count equals: 3.
	self assert: buffer equals: '789123'	 
%

category: 'testing'
method: ZnBufferedReadStreamTests
testReadIntoLarger
	| stream buffer count |
	stream := ZnBufferedReadStream on: '0123456789' readStreamPortable.
	stream sizeBuffer: 4.
	buffer := String new: 10.
	count := stream readInto: buffer startingAt: 1 count: 10.
	self assert: count equals: 10.
	self assert: buffer equals: '0123456789'	 
%

category: 'testing'
method: ZnBufferedReadStreamTests
testReadUpTo
	| stream |
	stream := ZnBufferedReadStream on: '0123456789' readStreamPortable.
	stream sizeBuffer: 8.
	self assert: (stream upTo: $5) equals: '01234'.
	self assert: stream upToEnd equals: '6789'.
	self assert: stream atEnd
%

category: 'testing'
method: ZnBufferedReadStreamTests
testReadUpToEnd
	| stream |
	stream := ZnBufferedReadStream on: '0123456789' readStreamPortable.
	stream sizeBuffer: 4.
	stream next: 2.
	self assert: stream upToEnd equals: '23456789'.
	self assert: stream atEnd
%

! Class implementation for 'ZnBufferedReadWriteStreamTests'

!		Instance methods for 'ZnBufferedReadWriteStreamTests'

category: 'tests'
method: ZnBufferedReadWriteStreamTests
testBuffering
	| stream |
	stream := ZnBufferedReadWriteStream on: '01234567890123456789' readStreamPortable.
	stream sizeBuffer: 8.
	self deny: stream atEnd.
	self assert: (stream next: 10) equals: '0123456789'.
	self deny: stream atEnd.
	self assert: (stream next: 10) equals: '0123456789'.
	self assert: stream atEnd
%

category: 'tests'
method: ZnBufferedReadWriteStreamTests
testNextPutAllStartingAt
	| string |
	string := String streamContents: [ :stringStream | 
		ZnBufferedReadWriteStream on: stringStream do: [ : bufferedStream |
			bufferedStream sizeBuffer: 8.
			bufferedStream next: 5 putAll: '--012345--' startingAt: 3.
			bufferedStream next: 5 putAll: '0123456789XX' startingAt: 6. 
			bufferedStream next: 5 putAll: '--012345--' startingAt: 3.
			bufferedStream next: 5 putAll: '0123456789XX' startingAt: 6.] ].
	self assert: string equals: '01234567890123456789'
%

category: 'tests'
method: ZnBufferedReadWriteStreamTests
testPeek
	| stream |
	stream := ZnBufferedReadWriteStream on: '0123456789' readStreamPortable.
	stream sizeBuffer: 8.
	'0123456789' do: [ :each |
		self deny: stream atEnd.
		self assert: stream peek equals: each.
		self assert: stream next equals: each ].
	self assert: stream atEnd.
	self assert: stream peek isNil.
	self assert: stream next isNil
%

category: 'tests'
method: ZnBufferedReadWriteStreamTests
testReadInto
	| stream buffer count |
	stream := ZnBufferedReadWriteStream on: '0123456789' readStreamPortable.
	stream sizeBuffer: 8.
	buffer := (String new: 6) atAllPut: Character space; yourself.
	stream skip: 1.
	stream readInto: buffer startingAt: 4 count: 3.
	self assert: buffer equals: '   123'.
	stream readInto: buffer startingAt: 1 count: 3.
	self assert: buffer equals: '456123'.
	count := stream readInto: buffer startingAt: 1 count: 100.
	self assert: count equals: 3.
	self assert: buffer equals: '789123'	 
%

category: 'tests'
method: ZnBufferedReadWriteStreamTests
testReadIntoLarger
	| stream buffer count |
	stream := ZnBufferedReadWriteStream on: '0123456789' readStreamPortable.
	stream sizeBuffer: 4.
	buffer := String new: 10.
	count := stream readInto: buffer startingAt: 1 count: 10.
	self assert: count equals: 10.
	self assert: buffer equals: '0123456789'	 
%

category: 'tests'
method: ZnBufferedReadWriteStreamTests
testReadThenWrite
	| stream stringStream |
	
	stringStream := ReadWriteStreamPortable with: '0123456789' copy.
	stringStream reset.
	stream := ZnBufferedReadWriteStream on: stringStream.
	stream sizeBuffer: 8.
	
	stream next: 4.
	self assert: stream position equals: 4.
	
	stream nextPutAll: 'ABCD'.
	self assert: stream position equals: 8.
		
	self assert: stream peek equals: $8. 
	self assert: stream upToEnd equals: '89'.
	self assert: stream atEnd.
	
	self assert: stringStream contents equals: '0123ABCD89'
%

category: 'tests'
method: ZnBufferedReadWriteStreamTests
testReadUpTo
	| stream |
	stream := ZnBufferedReadWriteStream on: '0123456789' readStreamPortable.
	stream sizeBuffer: 8.
	self assert: (stream upTo: $5) equals: '01234'.
	self assert: stream upToEnd equals: '6789'.
	self assert: stream atEnd
%

category: 'tests'
method: ZnBufferedReadWriteStreamTests
testReadUpToEnd
	| stream |
	stream := ZnBufferedReadWriteStream on: '0123456789' readStreamPortable.
	stream sizeBuffer: 4.
	stream next: 2.
	self assert: stream upToEnd equals: '23456789'.
	self assert: stream atEnd
%

category: 'tests'
method: ZnBufferedReadWriteStreamTests
testWriteThenRead
	| stream stringStream |
	
	stringStream := ReadWriteStreamPortable with: '0123456789' copy.
	stringStream reset.
	stream := ZnBufferedReadWriteStream on: stringStream.
	stream sizeBuffer: 8.
	
	stream nextPutAll: 'ABCD'.
	
	self assert: stream peek equals: $4. 
	self assert: stream position equals: 4.
	self assert: stream upToEnd equals: '456789'.
	self assert: stream position equals: 10.
	self assert: stream atEnd.
	
	self assert: stringStream contents equals: 'ABCD456789'
%

category: 'tests'
method: ZnBufferedReadWriteStreamTests
testWriting
	| string |
	string := String streamContents: [ :stringStream | | bufferedStream |
		bufferedStream := ZnBufferedReadWriteStream on: stringStream.
		0 to: 9 do: [ :each | bufferedStream nextPut: (Character digitValue: each) ].
		bufferedStream flush ].
	self assert: string = '0123456789'
%

category: 'tests'
method: ZnBufferedReadWriteStreamTests
testWritingOverflow
	| string |
	string := String streamContents: [ :stringStream | | bufferedStream |
		bufferedStream := ZnBufferedReadWriteStream on: stringStream.
		bufferedStream sizeBuffer: 8.
		0 to: 9 do: [ :each | bufferedStream nextPut: (Character digitValue: each) ].
		bufferedStream nextPutAll: '0123'; nextPutAll: '4567'; nextPutAll: '89'.
		bufferedStream nextPutAll: '0123456789'; nextPutAll: '0123456789'.
		bufferedStream flush ].
	self assert: string = '0123456789012345678901234567890123456789'
%

! Class implementation for 'ZnBufferedStreamByteTests'

!		Instance methods for 'ZnBufferedStreamByteTests'

category: 'accessing'
method: ZnBufferedStreamByteTests
integerEncodingSpec
	^ #(
"<hex-bytes> <integer> <u|s> <be|le> unsigned|signed big-endian|little-endian"
('00' 0 u be)
('00' 0 s be)
('01' 1 u be)
('01' 1 s be)
('FF' -1 s be)
('FF' 255 u be)
('7B' 123 u be)
('7B' 123 s be)
('85' -123 s be)
('7F' 127 u be)
('7F' 127 s be)
('80' -128 s be)
('00' 0 u le)
('00' 0 s le)
('01' 1 u le)
('01' 1 s le)
('FF' -1 s le)
('FF' 255 u le)
('7B' 123 u le)
('7B' 123 s le)
('85' -123 s le)
('7F' 127 u le)
('7F' 127 s le)
('80' -128 s le)
('00000000' 0 u be)
('00000000' 0 s be)
('00000000' 0 u le)
('00000000' 0 s le)
('00000001' 1 u be)
('00000001' 1 s be)
('01000000' 1 u le)
('01000000' 1 s le)
('FFFFFFFF' -1 s be)
('FFFFFFFF' -1 s le)
('000004D2' 1234 u be)
('000004D2' 1234 s be)
('FFFFFB2E' -1234 s be)
('D2040000' 1234 u le)
('D2040000' 1234 s le)
('2EFBFFFF' -1234 s le)
('FFFFFFFF' 4294967295 u be)
('FFFFFFFF' 4294967295 u le)
('7FFFFFFF' 2147483647 u be)
('7FFFFFFF' 2147483647 s be)
('80000000' -2147483648 s be)
('FFFFFF7F' 2147483647 s le)
('00000080' -2147483648 s le)
('499602D2' 1234567890 u be)
('499602D2' 1234567890 s be)
('B669FD2E' -1234567890 s be)
('D2029649' 1234567890 u le)
('D2029649' 1234567890 s le)
('2EFD69B6' -1234567890 s le)
)
%

category: 'testing'
method: ZnBufferedStreamByteTests
testInt16Aliases
	| input writer |
	writer := [ :block | 
		ByteArray streamContents: [ :out | 
			ZnBufferedWriteStream on: out do: block ] ].
	input := ByteArray readHexFrom: '04D2'.
	self assert: (ZnBufferedReadStream on: input readStreamPortable) int16 equals: 1234.
	self assert: (ZnBufferedReadStream on: input readStreamPortable) uint16 equals: 1234.
	self assert: (ZnBufferedReadStream on: input readStreamPortable) nextWord equals: 1234.
	self assert: ((ZnBufferedReadStream on: input readStreamPortable) nextNumber: 2) equals: 1234.
	self assert: ((ZnBufferedReadStream on: input reversed readStreamPortable) nextLittleEndianNumber: 2) equals: 1234.	
	self assert: (writer value: [ :out | out int16: 1234 ]) equals: input.
	self assert: (writer value: [ :out | out uint16: 1234 ]) equals: input.
	self assert: (writer value: [ :out | out nextWordPut: 1234 ]) equals: input.
	self assert: (writer value: [ :out | out nextNumber: 2 put: 1234 ]) equals: input.
	self assert: (writer value: [ :out | out nextLittleEndianNumber: 2 put: 1234 ]) equals: input reversed.
	input := ByteArray readHexFrom: 'FB2E'.
	self assert: (ZnBufferedReadStream on: input readStreamPortable) int16 equals: -1234.
	self assert: (writer value: [ :out | out int16: -1234 ]) equals: input
%

category: 'testing'
method: ZnBufferedStreamByteTests
testInt32Aliases
	| input writer |
	writer := [ :block | 
		ByteArray streamContents: [ :out | 
			ZnBufferedWriteStream on: out do: block ] ].
	input := ByteArray readHexFrom: '499602D2'.
	self assert: (ZnBufferedReadStream on: input readStreamPortable) int32 equals: 1234567890.
	self assert: (ZnBufferedReadStream on: input readStreamPortable) uint32 equals: 1234567890.
	self assert: (ZnBufferedReadStream on: input readStreamPortable) nextInt32 equals: 1234567890.
	self assert: ((ZnBufferedReadStream on: input readStreamPortable) nextNumber: 4) equals: 1234567890.
	self assert: ((ZnBufferedReadStream on: input reversed readStreamPortable) nextLittleEndianNumber: 4) equals: 1234567890.	
	self assert: (writer value: [ :out | out int32: 1234567890 ]) equals: input.
	self assert: (writer value: [ :out | out uint32: 1234567890 ]) equals: input.
	self assert: (writer value: [ :out | out nextInt32Put: 1234567890 ]) equals: input.
	self assert: (writer value: [ :out | out nextNumber: 4 put: 1234567890 ]) equals: input.
	self assert: (writer value: [ :out | out nextLittleEndianNumber: 4 put: 1234567890 ]) equals: input reversed.
	input := ByteArray readHexFrom: 'B669FD2E'.
	self assert: (ZnBufferedReadStream on: input readStreamPortable) int32 equals: -1234567890.
	self assert: (ZnBufferedReadStream on: input readStreamPortable) nextInt32 equals: -1234567890.
	self assert: (writer value: [ :out | out int32: -1234567890 ]) equals: input.
	self assert: (writer value: [ :out | out nextInt32Put: -1234567890 ]) equals: input
%

category: 'testing'
method: ZnBufferedStreamByteTests
testInt8
	| bytes readStream |
	bytes := ByteArray streamContents: [ :out |
		ZnBufferedWriteStream on: out do: [ :bout |
			bout int8: 123; uint8: 123; int8: -123 ] ].
	readStream := ZnBufferedReadStream on: bytes readStreamPortable.
	self assert: readStream peek equals: 123.
	self assert: readStream int8 equals: 123.
	self assert: readStream peek equals: 123.
	self assert: readStream uint8 equals: 123.
	self deny: readStream peek = 123.
	self deny: readStream peek = -123.
	self assert: readStream int8 equals: -123
%

category: 'testing'
method: ZnBufferedStreamByteTests
testNextIntegerOfSizeSignedBigEndian
	self integerEncodingSpec do: [ :spec |
		| input integer |
		input := ByteArray readHexFrom: spec first.
		integer := (ZnBufferedReadStream on: input readStreamPortable) 
			nextIntegerOfSize: input 
			size signed: spec third = #s 
			bigEndian: spec fourth = #be.
		self assert: integer equals: spec second ]
%

category: 'testing'
method: ZnBufferedStreamByteTests
testNextIntegerOfSizeSignedBigEndianPut
	self integerEncodingSpec do: [ :spec |
		| input output |
		input := ByteArray readHexFrom: spec first.
		output := ByteArray streamContents: [ :out |
			ZnBufferedWriteStream on: out do: [ :bout | 
				bout 
					nextIntegerOfSize: input size 
					signed: spec third = #s 
					bigEndian: spec fourth = #be 
					put: spec second ] ].
		self assert: output equals: input ]
%

! Class implementation for 'ZnBufferedWriteStreamTests'

!		Instance methods for 'ZnBufferedWriteStreamTests'

category: 'testing'
method: ZnBufferedWriteStreamTests
testNextPutAllStartingAt
	| string |
	string := String streamContents: [ :stringStream | 
		ZnBufferedWriteStream on: stringStream do: [ : bufferedStream |
			bufferedStream sizeBuffer: 8.
			bufferedStream next: 5 putAll: '--012345--' startingAt: 3.
			bufferedStream next: 5 putAll: '0123456789XX' startingAt: 6. 
			bufferedStream next: 5 putAll: '--012345--' startingAt: 3.
			bufferedStream next: 5 putAll: '0123456789XX' startingAt: 6.] ].
	self assert: string equals: '01234567890123456789'
%

category: 'testing'
method: ZnBufferedWriteStreamTests
testWriting
	| string |
	string := String streamContents: [ :stringStream | | bufferedStream |
		bufferedStream := ZnBufferedWriteStream on: stringStream.
		0 to: 9 do: [ :each | bufferedStream nextPut: (Character digitValue: each) ].
		bufferedStream flush ].
	self assert: string = '0123456789'
%

category: 'testing'
method: ZnBufferedWriteStreamTests
testWritingOverflow
	| string |
	string := String streamContents: [ :stringStream | | bufferedStream |
		bufferedStream := ZnBufferedWriteStream on: stringStream.
		bufferedStream sizeBuffer: 8.
		0 to: 9 do: [ :each | bufferedStream nextPut: (Character digitValue: each) ].
		bufferedStream nextPutAll: '0123'; nextPutAll: '4567'; nextPutAll: '89'.
		bufferedStream nextPutAll: '0123456789'; nextPutAll: '0123456789'.
		bufferedStream flush ].
	self assert: string = '0123456789012345678901234567890123456789'
%

! Class implementation for 'FsMockStream'

!		Class methods for 'FsMockStream'

category: 'instance creation'
classmethod: FsMockStream
new

	^super new initialize
%

!		Instance methods for 'FsMockStream'

category: 'accessing'
method: FsMockStream
actionSequence
	"Return the sequence of actions performed on the receiver."

	^actionSequence
%

category: 'stream-behavior'
method: FsMockStream
close
	"Record stream close"

	actionSequence add: {#close}
%

category: 'stream-behavior'
method: FsMockStream
flush
	"Record stream flush"

	actionSequence add: {#flush}
%

category: 'initialize-release'
method: FsMockStream
initialize

	super initialize.
	actionSequence := Array new
%

category: 'stream-behavior'
method: FsMockStream
isStream
	"Record #isStream was asked. Answer true to ensure correct behavior of user."

	actionSequence add: {#isStream}.
	^true
%

category: 'stream-behavior'
method: FsMockStream
nextPut: anElement
	"Record stream element writting"

	actionSequence add: {#nextPut:. anElement}
%

category: 'stream-behavior'
method: FsMockStream
nextPutAll: elements
	"Record stream elements writing"

	actionSequence add: {#nextPutAll:. elements}
%

! Class extensions for 'FsDiskFileSystemTest'

!		Instance methods for 'FsDiskFileSystemTest'

category: '*filesystem-tests-gemstone'
method: FsDiskFileSystemTest
testGsDeleteDirectoryOnError

	| path |
	path := Path * 'plonk' / 'griffle'.
	self markForCleanup: path.
	self markForCleanup: path parent.
	filesystem ensureCreateDirectory: path.
	self assert: (filesystem isDirectory: Path * 'plonk').
	self assert: (filesystem isDirectory: path).

	self should: [ filesystem delete: path parent ] raise: Error.
%

